/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ICall.c>	2005-03-13,18:26

*/

#include "ICall.h"



/************************************************************/
/* MediaChannelState member
*/
/* new_MediaChannelState */
HS_RESULT new_MediaChannelState(MediaChannelState *pObj)
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	pObj->sAudio = HS_NO;
	pObj->rAudio = HS_NO;
	pObj->sVideo = HS_NO;
	pObj->rVideo = HS_NO;
	pObj->sData = HS_NO;
	pObj->rData = HS_NO;
	return HS_OK;
}


/* delete_MediaChannelState */
HS_RESULT delete_MediaChannelState(MediaChannelState *pObj)
{
	return HS_OK;
}



/************************************************************/
/* H245State member
*/
/* new_H245State */
HS_RESULT new_H245State( H245State *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	pObj->session = HS_NO;

	pObj->msdValue = 0;
	pObj->mss = e_MasterSlaveState_Idle;
	
	pObj->sendTCS = FALSE;	pObj->recvTCSack = FALSE;
	pObj->sendMSD = FALSE;	pObj->recvMSDack = FALSE;
	pObj->sendOLC = FALSE;	pObj->recvOLCack = FALSE;
	pObj->sendCLC = FALSE;	pObj->recvCLCack = FALSE;

	pObj->recvTCS = FALSE;	pObj->sendTCSack = FALSE;
	pObj->recvMSD = FALSE;	pObj->sendMSDack = FALSE;
	pObj->recvOLC = FALSE;	pObj->sendOLCack = FALSE;
	pObj->recvCLC = FALSE;	pObj->sendCLCack = FALSE;

	pObj->tcsSN = 0;
	return HS_OK;
}


/* delete_H245State */
HS_RESULT delete_H245State( H245State *pObj )
{
	return HS_OK;
}


/* H245State_MakeTCSSequenceNumber */
HS_UINT H245State_MakeTCSSequenceNumber( H245State *pObj )
{
	if( pObj == HS_NULL ) return HS_UINT_MAX;
	return pObj->tcsSN++;
}



/**********************************************************/
/* OpenLogicalChannelSet member
*/
HS_RESULT new_OpenLogicalChannelSet( OpenLogicalChannelSet *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	pObj->isOpen = HS_NO;
	pObj->olcMsg = HS_NULL;
	return HS_OK;
}
HS_RESULT delete_OpenLogicalChannelSet( OpenLogicalChannelSet *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->olcMsg != HS_NULL )
	{
		delete_ControlMsg(pObj->olcMsg);
		HSFree(pObj->olcMsg);
	}

	return HS_OK;
}
HS_RESULT NoLockList_AttachOpenLogicalChannelSet( NoLockList *pList, ControlMsg *pOlcMsg )
{
	OpenLogicalChannelSet *tOlcSet = HS_NULL;
	if( pList == HS_NULL || pOlcMsg == HS_NULL ) return HS_ERR_NULL_PARAM;

	if( (tOlcSet=(OpenLogicalChannelSet*)HSMalloc(sizeof(OpenLogicalChannelSet))) == HS_NULL )
		return HS_ERR_H323_MALLOC;
	if( new_OpenLogicalChannelSet(tOlcSet) != HS_OK )
	{
		HSFree(tOlcSet);
		return HS_ERR_H323;
	}
	if( NoLockList_AttachData(pList,tOlcSet) != HS_OK )
	{
		delete_OpenLogicalChannelSet(tOlcSet);
		HSFree(tOlcSet);
		return HS_ERR_H323;
	}

	tOlcSet->olcMsg = pOlcMsg;
	return HS_OK;
}
ChainUnit *NoLockList_FindOpenLogicalChannelSetByChannelNumber(NoLockList *pList, HS_UINT pChannelNumber)
{
	HS_UINT i;
	ChainUnit *rounder = HS_NULL;
	OpenLogicalChannelSet *tOlcSet = HS_NULL;
	ASNH245RequestMessage *tRequest = HS_NULL;
	ASNH245OpenLogicalChannel *tOlc = HS_NULL;

	if(pList == HS_NULL) return HS_NULL;
	if(pList->size == 0) return HS_NULL;

	rounder = pList->units;
	for( i=0; i<pList->size; i++ )
	{
		if( rounder == HS_NULL ) return HS_NULL;
		if( rounder->data == HS_NULL ) return HS_NULL;

		tOlcSet = (OpenLogicalChannelSet*)(rounder->data);
		if( (tRequest=(ASNH245RequestMessage*)(tOlcSet->olcMsg->alter)) != HS_NULL )
		{
			if( (tOlc=(ASNH245OpenLogicalChannel*)(tRequest->alter)) != HS_NULL )
			{
				if( tOlc->m_forwardLogicalChannelNumber.inheritance.value == pChannelNumber )
					return rounder;
			}
		}

		rounder = rounder->next;
	}

	return HS_NULL;
}



/**********************************************************/
/* ICall member
*/
/* new_ICall */
HS_RESULT new_ICall( ICall *pObj, BOOL pIsAnswerCall )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	pObj->isAdmission = FALSE;
	pObj->routeState = e_RouteState_Idle;
	pObj->q931State = e_Q931State_Idle;
	new_H245State( &(pObj->h245State) );

	pObj->crv = 0;
	memset(pObj->confId,0,16);
	memset(pObj->callId,0,16);

	pObj->canMapAlias = HS_YES;
	new_NoLockList( &(pObj->sourceAliases), delete_ASNH225AliasAddress );
	new_NoLockList( &(pObj->destAliases), delete_ASNH225AliasAddress );
	new_NoLockList( &(pObj->destExtraCallInfo), delete_ASNH225AliasAddress );
	new_NoLockList( &(pObj->remoteExtensionAddress), delete_ASNH225AliasAddress );
	memset(pObj->callingParty,0,HS_MAX_DIGIT);
	memset(pObj->calledParty,0,HS_MAX_DIGIT);

	new_ASNH225TransportAddress( &(pObj->scsaTsap) );
	ASNH225TransportAddress_MakeMold( &(pObj->scsaTsap) );
	new_ASNH225TransportAddress( &(pObj->dcsaTsap) );
	ASNH225TransportAddress_MakeMold( &(pObj->dcsaTsap) );

	pObj->bandwidth = HS_BANDWIDTH_DEFAULT;
	pObj->isAnswerCall = pIsAnswerCall;
	pObj->isFastStart = FALSE;
	pObj->isTunneling = FALSE;

	pObj->irrFrequency = 0;
	pObj->callModel = e_ASNH225CallModelChoice_direct;
	new_ASNH225UUIEsRequested(&(pObj->uuiesRequested));
	pObj->uuiesRequested.m_setup.value = HS_NO;
	pObj->uuiesRequested.m_callProceeding.value = HS_NO;
	pObj->uuiesRequested.m_connect.value = HS_NO;
	pObj->uuiesRequested.m_alerting.value = HS_NO;
	pObj->uuiesRequested.m_information.value = HS_NO;
	pObj->uuiesRequested.m_releaseComplete.value = HS_NO;
	pObj->uuiesRequested.m_facility.value = HS_NO;
	pObj->uuiesRequested.m_progress.value = HS_NO;
	pObj->uuiesRequested.m_empty.value = HS_NO;
	pObj->uuiesRequested.m_status.value = HS_NO;
	pObj->uuiesRequested.m_statusInquiry.value = HS_NO;
	pObj->uuiesRequested.m_setupAcknowledge.value = HS_NO;
	pObj->uuiesRequested.m_notify.value = HS_NO;

	pObj->fastStartPoint = e_FastStartResponsePoint_Connect;
	new_NoLockList(&(pObj->fsList), delete_ASNH245OpenLogicalChannel);
	pObj->fsActive = HS_NO;

	new_NoLockList( &(pObj->h245Charge), delete_ControlMsg );
	pObj->h245ListenPoint = e_H245ListenPoint_Connect;
	pObj->h245ListenPort = HS_INVALID_PORT;
	pObj->rtpListenPort = HS_INVALID_PORT;

	new_NoLockList( &(pObj->capabilities), delete_ICapability );
	pObj->remoteTCS = HS_NULL;
	new_NoLockList( &(pObj->sendedOlcSetList), delete_OpenLogicalChannelSet );
	new_NoLockList( &(pObj->receivedOlcSetList), delete_OpenLogicalChannelSet );

	pObj->aRtpIn.sin_family = AF_MAX;
	pObj->vRtpIn.sin_family = AF_MAX;
	pObj->dRtpIn.sin_family = AF_MAX;
	pObj->aRtcpIn.sin_family = AF_MAX;
	pObj->vRtcpIn.sin_family = AF_MAX;
	pObj->dRtcpIn.sin_family = AF_MAX;

	pObj->logicalChannelNumber = HS_INVALID_LOGICAL_CHANNEL_NUMBER;
	pObj->handle = HS_INVALID_CALL_HANDLE;

	return HS_OK;
}


/* delete_ICall */
HS_RESULT delete_ICall( ICall *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	delete_H245State( &(pObj->h245State) );

	delete_NoLockList( &(pObj->sourceAliases) );
	delete_NoLockList( &(pObj->destAliases) );

	delete_ASNH225TransportAddress( &(pObj->scsaTsap) );
	delete_ASNH225TransportAddress( &(pObj->dcsaTsap) );

	delete_NoLockList( &(pObj->fsList) );
	delete_NoLockList( &(pObj->h245Charge) );

	delete_NoLockList( &(pObj->capabilities) );
	if( pObj->remoteTCS != HS_NULL )
	{
		delete_ControlMsg(pObj->remoteTCS);
		HSFree(pObj->remoteTCS);
	}
	delete_NoLockList( &(pObj->sendedOlcSetList) );
	delete_NoLockList( &(pObj->receivedOlcSetList) );

	return HS_OK;
}


/* ICall_Make */
HS_RESULT ICall_Make( ICall *pObj, IEndpoint *pEndpoint )
{
	HS_RESULT tRet = HS_OK;

	if( pObj == HS_NULL || pEndpoint == HS_NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->isAnswerCall == HS_NO )
	{
		if( (tRet=IEndpoint_MakeIdentifierOfCall(pEndpoint, pObj->callId, pObj->confId)) != HS_OK )
			return tRet;
		pObj->crv = (HS_USHORT)rand();
	}

	pObj->h245ListenPort = IEndpoint_MakeH245ListenPort( pEndpoint );
	pObj->rtpListenPort = IEndpoint_MakeRTPListenPort( pEndpoint );

	return HS_OK;
}


/* ICall_MakeOLCChannelNumber */
HS_USHORT ICall_MakeOLCChannelNumber( ICall *pObj )
{
	if( pObj == HS_NULL ) return HS_INVALID_LOGICAL_CHANNEL_NUMBER;

	pObj->logicalChannelNumber++;
	if( pObj->logicalChannelNumber == HS_INVALID_LOGICAL_CHANNEL_NUMBER )
		pObj->logicalChannelNumber++;

	return pObj->logicalChannelNumber;
}



/******************************************************************/
/* NoLockList member
*/
/* finding call by call conferenceId
*/
ChainUnit *NoLockList_FindCallByConferenceId( NoLockList *pObj, HS_UCHAR *pId )
{
	HS_UINT i;
	ChainUnit *tRet = HS_NULL;
	ICall *tCall = HS_NULL;

	if( pObj == HS_NULL || pId == HS_NULL ) return HS_NULL;
	if( pObj->size == 0 ) return HS_NULL;

	tRet = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( tRet == HS_NULL ) return HS_NULL;
		if( tRet->data == HS_NULL ) return HS_NULL;

		tCall = (ICall*)(tRet->data);
		if( ! memcmp(tCall->confId, pId, 16) )
			return tRet;

		tRet = tRet->next;
	}

	return HS_NULL;
}
/* finding call by call CRV
*/
ChainUnit *NoLockList_FindCallByCRV(NoLockList *pObj, HS_USHORT pCrv)
{
	HS_UINT i;
	ChainUnit *tRet = HS_NULL;
	ICall *tCall = HS_NULL;

	if( pObj == HS_NULL ) return HS_NULL;
	if( pObj->size == 0 ) return HS_NULL;

	tRet = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( tRet == HS_NULL ) return HS_NULL;
		if( tRet->data == HS_NULL ) return HS_NULL;

		tCall = (ICall*)(tRet->data);
		if( tCall->crv == pCrv )
			return tRet;

		tRet = tRet->next;
	}

	return HS_NULL;
}
/* finding call by call handle
*/
ChainUnit *NoLockList_FindCallByHandle( NoLockList *pObj, HS_CALL_HANDLE pHandle )
{
	HS_UINT i;
	ChainUnit *tRet = HS_NULL;
	ICall *tCall = HS_NULL;

	if( pObj == HS_NULL ) return HS_NULL;
	if( pObj->size == 0 ) return HS_NULL;

	tRet = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( tRet == HS_NULL ) return HS_NULL;
		if( tRet->data == HS_NULL ) return HS_NULL;

		tCall = (ICall*)(tRet->data);
		if( tCall->handle == pHandle )
			return tRet;

		tRet = tRet->next;
	}

	return HS_NULL;
}


HS_RESULT NoLockList_DeleteCallByHandle( NoLockList *pObj, HS_CALL_HANDLE pHandle )
{
	return
	NoLockList_DeleteChain(
		pObj,
		NoLockList_FindCallByHandle(pObj,pHandle)
	);
}



/**********************************************************************************/
/* Capsulation for Application User Protection
*/
HS_UINT ICall_GetFastStartListSize(void *pCapsule)
{
	ICall *tCall = (ICall*)pCapsule;
	if( tCall == HS_NULL ) return 0;
	return tCall->fsList.size;
}