/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<iCapability.h>		2005-03-13,16:20

*/

#ifndef __2005_03_13__16_20__ICAPABILITY_H__
#define __2005_03_13__16_20__ICAPABILITY_H__



#include "H323Define.h"
#include "EpDefine.h"
#include "H323Utility.h"



/***********************/
/* Capability
*/
typedef struct
{
	HS_UINT				simul;
	ASNH245Capability	capability;
} ICapability;
HS_RESULT new_ICapability( ICapability *pObj );
HS_RESULT delete_ICapability( ICapability *pObj );



/***********************/
/* Capabilities
*/
#define		ICapabilities			NoLockList
HS_RESULT	ICapabilities_MakeTCS( NoLockList *pObj, ASNH245TerminalCapabilitySet *tcs );



/**********************************************************************/
/* Compare Functions
*/
BOOL CompareCapability( ASNH245Capability *pCapa1, ASNH245Capability *pCapa2 );
BOOL CompareCapabilityWithDataType( ASNH245Capability *pCapa, ASNH245DataType *pType );
BOOL CompareAudioCapability( ASNH245AudioCapability *pAudio1, ASNH245AudioCapability *pAudio2 );
BOOL CompareVideoCapability( ASNH245VideoCapability *pVideo1, ASNH245VideoCapability *pVideo2 );
BOOL CompareDataApplicationCapability(
	ASNH245DataApplicationCapability *pData1,
	ASNH245DataApplicationCapability *pData2
);



/*set capabilities of endpoint
*/
/*
	Integer Factor Audio Codec List
	===============================
	g711Alaw64k		g711Alaw56k
	g711Ulaw64k		g711Ulaw56k
	g722-64k		g722-56k
	g722-48k		g728
	g729			g729AnnexA
	g729wAnnexB		g729AnnexAwAnnexB
*/
typedef enum
{
	e_IntegerFactor_g711Alaw64k,
	e_IntegerFactor_g711Alaw56k,
	e_IntegerFactor_g711Ulaw64k,
	e_IntegerFactor_g711Ulaw56k,
	e_IntegerFactor_g722_64k,
	e_IntegerFactor_g722_56k,
	e_IntegerFactor_g722_48k,
	e_IntegerFactor_g728,
	e_IntegerFactor_g729,
	e_IntegerFactor_g729AnnexA,
	e_IntegerFactor_g729wAnnexB,
	e_IntegerFactor_g729AnnexAwAnnexB
} IntegerFactor;
HS_RESULT  ICapabilities_AddIntegerFactor	( NoLockList *pObj, HS_UINT pSimul, IntegerFactor pFactor, HS_UCHAR pValue );
ChainUnit *ICapabilities_FindIntegerFactor	( NoLockList *pObj, HS_UINT pSimul, IntegerFactor pFactor );
HS_RESULT  ICapabilities_DeleteIntegerFactor( NoLockList *pObj, HS_UINT pSimul, IntegerFactor pFactor );
/*
	G.7231 Audio Codec
*/
HS_RESULT  ICapabilities_AddG7231( NoLockList *pObj, HS_UINT pSimul, HS_UCHAR pMaxAl, BOOL pSilence );


#endif/*__2005_03_13__16_20__ICAPABILITY_H__*/


