/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<IGatekeeper.c>		2005-03-13,14:45

*/

#include "IGatekeeper.h"


/*****************************************************************************/
/* Registrar member
*/
HS_RESULT new_Registrar( Registrar *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	memset(pObj->target,0,256);
	pObj->registed = FALSE;
	pObj->sn = HS_INVALID_RAS_SEQUENCE_NUMBER;

	return HS_OK;
}


HS_RESULT delete_Registrar( Registrar *pObj )
{
	return HS_OK;
}



/*****************************************************************************/
/* IGatekeeper member
*/
/* new_IGatekeeper */
HS_RESULT new_IGatekeeper( IGatekeeper *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	new_ASNH225EndpointIdentifier( &(pObj->endpointIdentifier) );
	new_ASNH225GatekeeperIdentifier( &(pObj->gatekeeperIdentifier) );

	pObj->registrar = HS_NULL;

	pObj->isGRQ = FALSE;
	pObj->isUseLightRRQ = FALSE;

	pObj->attemptTime = 10;
	pObj->ttl = HS_TTL_DEFAULT;
	pObj->ttlForce = FALSE;

	return HS_OK;
}


/* delete_IGatekeeper */
HS_RESULT delete_IGatekeeper( IGatekeeper *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	delete_ASNH225EndpointIdentifier( &(pObj->endpointIdentifier) );
	delete_ASNH225GatekeeperIdentifier( &(pObj->gatekeeperIdentifier) );

	if( pObj->registrar != HS_NULL )
	{
		delete_Registrar( pObj->registrar );
		HSFree( pObj->registrar );
	}

	return HS_OK;
}


BOOL IGatekeeper_IsRegisted( IGatekeeper *pObj )
{
	if( pObj == HS_NULL ) return FALSE;
	if( pObj->registrar == HS_NULL ) return FALSE;
	return pObj->registrar->registed;
}


