/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<MessageHandler.h>		2005-03-20,11:08

*/

#ifndef __2005_03_20__11_08__MESSAGEHANDLER_H__
#define __2005_03_20__11_08__MESSAGEHANDLER_H__



#include "H323Define.h"
#include "EpDefine.h"
#include "RasMessageMaker.h"
#include "CallClose.h"



/* RAS process utility functions
*/
HS_RESULT TryRegistration(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits, BOOL isFoundGk );
HS_RESULT TryUnregistration(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits );
HS_RESULT CallProcessing(StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, ICall *pCall );


/* RAS message handler
*/
/* RAS response message handler
*/
HS_RESULT GCFHandler( ASNH225GatekeeperConfirm *gcf,	StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits );
HS_RESULT GRJHandler( ASNH225GatekeeperReject *grj,		StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits );
HS_RESULT RCFHandler( ASNH225RegistrationConfirm *rcf,	StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits );
HS_RESULT RRJHandler( ASNH225RegistrationReject *rrj,	StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits );
HS_RESULT UCFHandler( ASNH225UnregistrationConfirm *ucf,IEndpoint *pEndpoint, NoLockList *pWaits );
HS_RESULT URJHandler( ASNH225UnregistrationReject *urj, IEndpoint *pEndpoint, NoLockList *pWaits );
HS_RESULT ACFHandler( ASNH225AdmissionConfirm *acf,		StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits );
HS_RESULT ARJHandler( ASNH225AdmissionReject *arj,		StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits );
HS_RESULT BCFHandler( ASNH225BandwidthConfirm *bcf,		IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits );
HS_RESULT BRJHandler( ASNH225BandwidthReject *brj,		IEndpoint *pEndpoint, NoLockList *pWaits );
HS_RESULT DCFHandler( ASNH225DisengageConfirm *dcf,		IEndpoint *pEndpoint, NoLockList *pWaits );
HS_RESULT DRJHandler( ASNH225DisengageReject *drj,		IEndpoint *pEndpoint, NoLockList *pWaits );
/* RAS request message handler
*/
HS_RESULT URQHandler( ASNH225UnregistrationRequest *urq,StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits );
HS_RESULT BRQHandler( ASNH225BandwidthRequest *brq,		StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits );
HS_RESULT DRQHandler( ASNH225DisengageRequest *drq,		StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits );
HS_RESULT IRQHandler( ASNH225InfoRequest *irq,			StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits );
/* RAS unknown message handler
*/
HS_RESULT UnknownRASHandler( RasMsg *pMsg, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits );


/* Q931 Message Handler */
HS_RESULT SetupHandler				(Q931Message *pQ931, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, ICall *pCall);
HS_RESULT CallProceedHandler		(Q931Message *pQ931, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, ICall *pCall);
HS_RESULT ConnectHandler			(Q931Message *pQ931, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, ICall *pCall);
HS_RESULT AlertHandler				(Q931Message *pQ931, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, ICall *pCall);
HS_RESULT InformationHandler		(Q931Message *pQ931);
HS_RESULT ReleaseCompleteHandler	(Q931Message *pQ931, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, ICall *pCall);
HS_RESULT FacilityHandler			(Q931Message *pQ931, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, ICall *pCall);
HS_RESULT ProgressHandler			(Q931Message *pQ931);
HS_RESULT EmptyHandler				(Q931Message *pQ931);
HS_RESULT StatusHandler				(Q931Message *pQ931);
HS_RESULT StatusInquiryHandler		(Q931Message *pQ931);
HS_RESULT SetupAcknowledgeHandler	(Q931Message *pQ931);
HS_RESULT NotifyHandler				(Q931Message *pQ931);


/* H245 Message Handler */
HS_RESULT H245RequestHandler(ASNH245RequestMessage *pRequest, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, ICall *pCall);
HS_RESULT H245ResponseHandler(ASNH245ResponseMessage *pResponse, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, ICall *pCall);
HS_RESULT H245CommandHandler(ASNH245CommandMessage *pCommand, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, ICall *pCall);
HS_RESULT H245IndicationHandler(ASNH245IndicationMessage *pIndication, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits, ICall *pCall);



#endif/*__2005_03_20__11_08__MESSAGEHANDLER_H__*/


