/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<RasWaitSet.c>	2005-03-13,15:26

*/

#include "RasWaitSet.h"



/******************************************************************/
/* RasWaitSet member
*/
/* new_RasWaitSet */
HS_RESULT new_RasWaitSet( RasWaitSet *pObj, HS_CALL_HANDLE pHandle, HS_USHORT pSN, HS_UCHAR *pRaw, int pLen )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	pObj->sequenceNumber = pSN;
	pObj->retryCount = HS_RAS_RETRY_COUNT;
	pObj->handle = pHandle;

	pObj->raw = HS_NULL;
	pObj->len = 0;

	if( pRaw != HS_NULL && pLen != 0 )
	{
		pObj->raw = (HS_UCHAR*)HSMalloc(pLen);
		if( pObj->raw != HS_NULL )
		{
			memcpy( pObj->raw, pRaw, pLen );
			pObj->len = pLen;
		}
	}

	return HS_OK;
}


/* delete_RasWaitSet */
HS_RESULT delete_RasWaitSet( RasWaitSet *pObj )
{
	if( pObj != HS_NULL )
	{
		if(pObj->raw != HS_NULL)
		{
			HSFree(pObj->raw);
			pObj->raw = HS_NULL;
			pObj->len = 0;
		}
	}
	
	return HS_OK;
}



/******************************************************************/
/* NoLockList member
*/
/* NoLockList_FindRasWaitSetBySequenceNumber */
ChainUnit *NoLockList_FindRasWaitSetBySequenceNumber( NoLockList *pObj, HS_USHORT pSN )
{
	HS_UINT i;
	ChainUnit *ret = HS_NULL;
	RasWaitSet *tWaitSet = HS_NULL;

	if( pObj == HS_NULL ) return HS_NULL;
	if( pObj->size == 0 ) return HS_NULL;

	ret = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( ret == HS_NULL ) return HS_NULL;
		if( ret->data == HS_NULL ) return HS_NULL;

		tWaitSet = (RasWaitSet*)(ret->data);
		if( tWaitSet->sequenceNumber == pSN )
			return ret;

		ret = ret->next;
	}

	return HS_NULL;
}


HS_RESULT NoLockList_DeleteRasWaitSetBySequenceNumber( NoLockList *pObj, HS_USHORT pSN )
{
	ChainUnit *tChain;

	if( pObj==HS_NULL || pSN==HS_INVALID_RAS_SEQUENCE_NUMBER ) return HS_ERR_NULL_PARAM;
	
	if( (tChain=NoLockList_FindRasWaitSetBySequenceNumber(pObj,pSN)) != HS_NULL )
		return NoLockList_DeleteChain(pObj,tChain);

	return HS_ERR_H323_NOTFOUND;
}