/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SocketSet.h>	2005-03-13,13:59

*/

#ifndef __2005_03_13__13_59__SOCKETSET_H__
#define __2005_03_13__13_59__SOCKETSET_H__


#include "H323Define.h"
#include "EpDefine.h"
#include "QMessage.h"



#define HS_TPKT_HEADER_SIZE		4

typedef struct
{
	unsigned char *buffer;
	HS_UINT maxLen;
	HS_UINT nowLen;
} TpktBuffer;

HS_RESULT new_TpktBuffer( TpktBuffer *pObj );
HS_RESULT delete_TpktBuffer( TpktBuffer *pObj );
HS_UCHAR *TpktBuffer_Check(
	TpktBuffer *pObj,
	HS_UCHAR *pBuffer, int pLen,
	HS_UINT *pPos, int *pSize
);


typedef struct
{
	HS_SOCKET	q931;
	HS_SOCKET	h245;
	HS_SOCKET	h245Listen;

	TpktBuffer	q931Buffer;
	TpktBuffer	h245Buffer;

	HS_CALL_HANDLE	handle;
} H323SocketSet;

HS_RESULT new_H323SocketSet( H323SocketSet *pObj, HS_CALL_HANDLE pHandle );
HS_RESULT delete_H323SocketSet( H323SocketSet *pObj );
HS_RESULT H323SocketSet_FdSet( H323SocketSet *pObj, fd_set *pSet, unsigned int *pMax );
HS_RESULT H323SocketSet_FdIsSet( H323SocketSet *pObj, fd_set *pSet, HS_QID pDestQ, unsigned char *pBuffer, int pLen );


#define H323SocketList		NoLockList

ChainUnit *NoLockList_FindH323SocketSetByHandle( NoLockList *pObj, HS_CALL_HANDLE pHandle );
HS_RESULT NoLockList_FdSet( NoLockList *pObj, fd_set *pSet, unsigned int *pMax );
HS_RESULT NoLockList_FdIsSet( NoLockList *pObj, fd_set *pSet, HS_QID pH323DemonMessageQ, unsigned char *pBuffer, int pLen );



#endif/*__2005_03_13__13_59__SOCKETSET_H__*/


