/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<guid.c>	2005-05-15,14:11

*/

#include "guid.h"



HS_RESULT GetGloballyUniqueID( HS_UCHAR *pGuid )
{
	HS_USHORT	tUshort;
	HS_INT64	tNanoTime;
	HS_INT64	tExtraTime;

#ifdef _WIN32
	SYSTEMTIME tSysTime;
#elif defined(HS_OS_VXWORKS)
	struct timespec tSysTime;
#else
	struct timeval tSysTime;
#endif

	if( pGuid == HS_NULL ) return HS_ERR_NULL_PARAM;

	/* calculate extra time
	*/
	tExtraTime = (HS_INT64)(10000000)*24*60*60*(/*nano second*/
		77+/*extra days of 1583*/
#ifdef _WIN32
		(1601-1583)*365+/*whole days of years*/(1601-1583)/4/*leap days of years*/
#else
		(1970-1583)*365+/*whole days of years*/(1970-1583)/4/*leap days of years*/-3/*no leap day in 1700,1800,1900*/
#endif
	);

	/* calculate nano time
	*/
#ifdef _WIN32
	GetSystemTime(&tSysTime);
	SystemTimeToFileTime(&tSysTime, (LPFILETIME)&tNanoTime);
#elif defined(HS_OS_VXWORKS)
	clock_gettime(0,&tSysTime);
	tNanoTime = (tSysTime.tv_sec*(HS_INT64)1000000 + tSysTime.tv_nsec*1000)*10;
#else
	gettimeofday(&tSysTime, NULL);
	tNanoTime = (tSysTime.tv_sec*(HS_INT64)1000000 + tSysTime.tv_usec)*10;
#endif

	tNanoTime += tExtraTime;

	pGuid[0] = (HS_UCHAR)  (tNanoTime&0xff);
	pGuid[1] = (HS_UCHAR) ((tNanoTime>>8)&0xff);
	pGuid[2] = (HS_UCHAR) ((tNanoTime>>16)&0xff);
	pGuid[3] = (HS_UCHAR) ((tNanoTime>>24)&0xff);
	pGuid[4] = (HS_UCHAR) ((tNanoTime>>32)&0xff);
	pGuid[5] = (HS_UCHAR) ((tNanoTime>>40)&0xff);
	pGuid[6] = (HS_UCHAR) ((tNanoTime>>48)&0xff);
	pGuid[7] = (HS_UCHAR)(((tNanoTime>>56)&0x0f) + 0x10);	/*Version 1*/

	/* clock sequence
	*/
	tUshort = (HS_USHORT)rand();
	pGuid[8] = (HS_UCHAR)(((tUshort>>8)&0x1f) | 0x80);	/*DCE compatible <100x xxxx>*/
	pGuid[9] = (HS_UCHAR)tUshort;

	/* no use IEEE 802 node
	*/
	tUshort = (HS_USHORT)rand();
	pGuid[10] = (HS_UCHAR)((tUshort|0x80)&0xff);	/*IEEE 802 unicast/multicast bit*/
	pGuid[11] = (HS_UCHAR)((tUshort>>8)&0xff);
	tUshort = (HS_USHORT)rand();
	pGuid[12] = (HS_UCHAR)(tUshort&0xff);
	pGuid[13] = (HS_UCHAR)((tUshort>>8)&0xff);
	tUshort = (HS_USHORT)rand();
	pGuid[14] = (HS_UCHAR)(tUshort&0xff);
	pGuid[15] = (HS_UCHAR)((tUshort>>8)&0xff);

	return HS_OK;
}

