/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<RtpDemon.h>	2006-01-11,22:01

*/

#ifndef __2006_01_11__22_01__RTPDEMON_H__
#define __2006_01_11__22_01__RTPDEMON_H__





#include <winsock.h>

#include "RtpDefine.h"
#include "RtpSpeakerout.h"





/* struct for RFC 2833 outbound dtmf profile.
*/
#define HS_RFC2833_TYPE			0x65
#define HS_RFC2833_COUNT_MAX	6

typedef struct
{
	HS_UCHAR	mSignal;
	HS_USHORT	mDuration;
	HS_UINT		mCount;
	HS_UINT		mCountMax;
} IRfc2833;

/* pSignal is decimal value with DTMF signal not a charactor.
*/
HS_RESULT new_IRfc2833(void *pObject,HS_UCHAR pSignal);
IRfc2833 *newm_IRfc2833(HS_UCHAR pSignal);
HS_RESULT delete_IRfc2833(void *pObject);
HS_RESULT deletem_IRfc2833(void *pObject);

HS_RESULT IRfc2833_Encode(void *pObject,HS_UINT pInterval,HS_UCHAR *pData);





/* send to network get from MIC-in
*/
typedef struct
{
	SOCKET				mSocket;
	struct sockaddr_in	mRemoteIn;

	HS_QID				mMyQ;

	HS_UINT				mHertz;
	RtpPayloadType		mType;
	HS_UINT				mFpp;
	HS_UINT				mSleep;
	HS_UINT				mSeqNum;
	HS_UINT				mTimeStamp;
	HS_UINT				mSsrc;
	UcharRing			mRing;

	IRfc2833			*mRfc2833;
	NoLockList			mRfc2833s;
	RtpDtmf				*mDtmfInband;
	NoLockList			mDtmfInbands;

	BOOL				mHold;

#ifdef _WIN32_WCE
	void*				m729Handle;
#endif
	void*				mGsm;
	void*				mIlbc;
} RtpSnder;

HS_RESULT new_RtpSnder(void *pObject,HS_UINT pHertz,HS_UINT pFpp);
RtpSnder *newm_RtpSnder(HS_UINT pHertz,HS_UINT pFpp);
HS_RESULT delete_RtpSnder(void *pObject);
HS_RESULT deletem_RtpSnder(void *pObject);

HS_RESULT RtpSnder_OpenCodec(void *pObject);
HS_RESULT RtpSnder_CloseCodec(void *pObject);
HS_UINT RtpSnder_GetPcmSize(void *pObject);
HS_RESULT RtpSnder_MakeRtpHeader(void *pObject,HS_UCHAR *pHeader);
HS_UINT RtpSnder_Encode(void *pObject,HS_UCHAR *pOut,HS_UCHAR *pIn,HS_UINT pSize);

HS_RESULT RtpSnder_CheckDtmfInband(void *pObject,HS_UCHAR *pData,HS_UINT pSize);
HS_RESULT RtpSnder_CheckDtmfRfc2833(void *pObject,HS_UCHAR *pBuffer);

/* thread
*/
void RtpSnder_Demon(void *pObject);
unsigned __stdcall RtpSnder_Thread(void* pArg);

HS_QID RtpSnder_Start(void *pObject);
HS_RESULT RtpSnder_Stop(void *pObject);

HS_RESULT RtpSnder_Send(void *pObject,HS_UCHAR *pBuffer,HS_UINT pSize);

HS_RESULT RtpSnder_AddDtmfInband(void *pObject,HS_UCHAR pSignal,HS_UINT pVolume);
HS_RESULT RtpSnder_AddDtmfRfc2833(void *pObject,HS_UCHAR pSignal);
HS_RESULT RtpSnder_Hold(void *pObject);
HS_RESULT RtpSnder_Resume(void *pObject);

HS_RESULT RtpSnder_Check(void *pObject);





#endif/*__2006_01_11__22_01__RTPDEMON_H__*/