/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<RtpSpeakerout.c>		2006-01-11,21:38

*/

#ifndef _WIN32_WCE
#include <process.h>
#endif

#include "RtpSpeakerout.h"





/*
 *
 * RtpSpeakerout member functions
 *
 */
HS_RESULT new_RtpSpeakerout(void *pObject,int mHertz)
{
	RtpSpeakerout *pObj = (RtpSpeakerout*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	memset(&(pObj->mFormat),0,sizeof(pObj->mFormat));
	pObj->mFormat.wFormatTag = WAVE_FORMAT_PCM;
	pObj->mFormat.nChannels = 1;
	pObj->mFormat.wBitsPerSample = 16;
	pObj->mFormat.cbSize = 0;
	pObj->mFormat.nSamplesPerSec = mHertz;
	pObj->mFormat.nAvgBytesPerSec = 
		(pObj->mFormat.nSamplesPerSec) * (pObj->mFormat.wBitsPerSample/8);
	pObj->mFormat.nBlockAlign = 
		(pObj->mFormat.wBitsPerSample/8) * pObj->mFormat.nChannels;

	pObj->mStopping = FALSE;
	pObj->mDevOpened = FALSE;
	pObj->mWaveHeaderNumber = 0;

	pObj->mHandle = NULL;
	pObj->mMyQ = HS_INVALID_QID;
	new_UcharRing(&(pObj->mRing),HS_RING_SIZE);
	pObj->mCpt = NULL;
	return HS_OK;
}


RtpSpeakerout *newm_RtpSpeakerout(int mHertz)
{
	RtpSpeakerout *tResult = NULL;

	if( (tResult=(RtpSpeakerout*)HSMalloc(sizeof(RtpSpeakerout)))==NULL )
		return NULL;
	if( new_RtpSpeakerout(tResult,mHertz) != HS_OK )
	{
		HSFree(tResult);
		return NULL;
	}

	return tResult;
}


HS_RESULT delete_RtpSpeakerout(void *pObject)
{
	RtpSpeakerout *pObj = (RtpSpeakerout*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mHandle = NULL;
	pObj->mMyQ = HS_INVALID_QID;
	delete_UcharRing(&pObj->mRing);
	
	if( pObj->mCpt != NULL )
	{
		deletem_RtpDtmf(pObj->mCpt);
		pObj->mCpt = NULL;
	}
	return HS_OK;
}


HS_RESULT deletem_RtpSpeakerout(void *pObject)
{
	RtpSpeakerout *pObj = (RtpSpeakerout*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	delete_RtpSpeakerout(pObj);
	HSFree(pObj);
	return HS_OK;
}


HS_RESULT RtpSpeakerout_PutPcmToSpeaker(void *pObject,HS_UINT pReadSize)
{
	HS_UCHAR *tRead = NULL;
	WAVEHDR* tWaveHeader = NULL;
	MMRESULT tRes = MMSYSERR_NOERROR;
	RtpSpeakerout *pObj = (RtpSpeakerout*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	/* tone generation
	*/
	if( pObj->mCpt != NULL )
	{
		if( (tWaveHeader=CreateWaveHeader(pReadSize)) == NULL )
			return HS_ERR_MALLOC;

		RtpDtmf_Generate(pObj->mCpt,tWaveHeader->lpData,tWaveHeader->dwBufferLength);

		if( (tRes=waveOutPrepareHeader(pObj->mHandle,tWaveHeader,sizeof(WAVEHDR))) == MMSYSERR_NOERROR )
		{
			waveOutWrite(pObj->mHandle,tWaveHeader,sizeof(WAVEHDR));
			pObj->mWaveHeaderNumber++;
			return HS_OK;
		}
		else
		{
			DestroyWaveHeader(tWaveHeader);
			return HS_ERR;
		}
	}

	/* get new PCM data
	*/
	if( (tRead=UcharRing_Get(&(pObj->mRing),pReadSize)) == NULL )
		return HS_OK;

	if( (tWaveHeader=(WAVEHDR*)HSMalloc(sizeof(WAVEHDR))) == NULL )
	{
		HSFree(tRead);
		tRead = NULL;
		return HS_ERR_MALLOC;
	}

	memset(tWaveHeader,0,sizeof(WAVEHDR));
	tWaveHeader->dwBufferLength = pReadSize;
	tWaveHeader->lpData = tRead;

	if( (tRes=waveOutPrepareHeader(pObj->mHandle,tWaveHeader,sizeof(WAVEHDR))) != MMSYSERR_NOERROR )
	{
		DestroyWaveHeader(tWaveHeader);
		return HS_ERR;
	}

	waveOutWrite(pObj->mHandle,tWaveHeader,sizeof(WAVEHDR));
	pObj->mWaveHeaderNumber++;
	return HS_OK;
}


static HS_RESULT RtpSpeakerout_HandleToneStart(void *pObject,RtpDtmf *pDtmf,HS_UINT pReadSize)
{
	WAVEHDR* tWaveHeader = NULL;
	MMRESULT tRes = MMSYSERR_NOERROR;
	RtpSpeakerout *pObj = (RtpSpeakerout*)pObject;

	if( pDtmf==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj==NULL )
	{
		deletem_RtpDtmf(pDtmf);
		return HS_ERR_INVALID_PARAM;
	}

	if( pObj->mCpt != NULL )
		deletem_RtpDtmf(pObj->mCpt);
	pObj->mCpt = pDtmf;

	while(pObj->mWaveHeaderNumber<2)
	{
		if( (tWaveHeader=CreateWaveHeader(pReadSize)) != NULL )
		{
			RtpDtmf_Generate(pObj->mCpt,tWaveHeader->lpData,tWaveHeader->dwBufferLength);
			if( (tRes=waveOutPrepareHeader(pObj->mHandle,tWaveHeader,sizeof(WAVEHDR))) != MMSYSERR_NOERROR )
			{
				DestroyWaveHeader(tWaveHeader);
				HSPrint("\n [RTP] err:MIC_DEV:1");
				return HS_ERR;
			}

			pObj->mWaveHeaderNumber++;
			waveOutWrite(pObj->mHandle,tWaveHeader,sizeof(WAVEHDR));
		}
	}

	return HS_OK;
}





/*
 *
 * RtpSpeakerout thread member functions
 *
 */
void RtpSpeakerout_Demon(void *pObject)
{
	MSG tQmsg;
	BOOL tThreadOut = FALSE;
	RtpSpeakerout *pObj = (RtpSpeakerout*)pObject;

	HS_UINT tReadSize = 0;
	HS_UCHAR *tRead = NULL;
	MMRESULT tRes = MMSYSERR_NOERROR;
	HS_RESULT tRet = HS_OK;
	WAVEHDR* tWaveHeader = NULL;

	if( pObj==NULL ) return;
	tReadSize = pObj->mFormat.nChannels * pObj->mFormat.wBitsPerSample * pObj->mFormat.nBlockAlign * 100;

	while(tThreadOut==FALSE)
	{
		if( GetMessage(&tQmsg,NULL,MM_WOM_OPEN-1,HS_QM_RTP_MAX) )
		{
            switch(tQmsg.message)
			{
				case HS_QM_STOP:
					pObj->mStopping = TRUE;
					if( pObj->mWaveHeaderNumber==0 )
						tThreadOut = TRUE;
					break;
				case HS_QM_CHECK:
					HSPrint("\nthread checking> RtpSpker-live:size(%u)",pObj->mWaveHeaderNumber);
					break;

				case HS_QM_RTP:
					if( (tRead=(HS_UCHAR*)(tQmsg.lParam))==NULL )
						break;
					UcharRing_ForcePut(&(pObj->mRing),tRead,(HS_UINT)(tQmsg.wParam));
					HSFree(tRead);
					tRead = NULL;

					if( pObj->mWaveHeaderNumber < 2 )
					{
						if( (tRet=RtpSpeakerout_PutPcmToSpeaker(pObj,tReadSize)) != HS_OK )
						{
							HSPrint("\n [RTP] err:MIC_DEV:%d",tRet);
							return;
						}
					}
					break;

				/* Call-Progress-Tone/DTMF-Tone Control
				*/
				case HS_QM_TONE_START:
					RtpSpeakerout_HandleToneStart(pObj,(RtpDtmf*)(tQmsg.lParam),tReadSize);
					break;
				case HS_QM_TONE_STOP:
					if( pObj->mCpt==NULL )
						break;
					deletem_RtpDtmf(pObj->mCpt);
					pObj->mCpt = NULL;
					break;

				case MM_WOM_DONE:
					if( pObj->mDevOpened==FALSE ) break;
					if( (tWaveHeader=(WAVEHDR*)(tQmsg.lParam))==NULL ) break;

					waveOutUnprepareHeader(pObj->mHandle,tWaveHeader,sizeof(WAVEHDR));
					DestroyWaveHeader(tWaveHeader);
					if( pObj->mWaveHeaderNumber != 0 )
						pObj->mWaveHeaderNumber--;

					if( pObj->mStopping==TRUE )
					{
						tThreadOut = TRUE;
						break;
					}

					if( (tRet=RtpSpeakerout_PutPcmToSpeaker(pObj,tReadSize)) != HS_OK )
					{
						HSPrint("\n [RTP] err:MIC_DEV:%d",tRet);
						return;
					}
					break;

				case MM_WOM_OPEN:
					pObj->mDevOpened = TRUE;
					break;

				case MM_WOM_CLOSE:
				default:
					break;
			}
		}
	}

	return;
}





unsigned __stdcall RtpSpeakerout_Thread(void* pArg)
{
	MMRESULT tRes;
	RtpSpeakerout *pObj = (RtpSpeakerout*)pArg;

	if( pObj == NULL )
	{
#ifdef _WIN32_WCE
		ExitThread(0);
#else
		_endthreadex(0);
#endif
		return 0;
	}

	if( waveOutOpen(
		&(pObj->mHandle),WAVE_MAPPER,&(pObj->mFormat),
		pObj->mMyQ,0,CALLBACK_THREAD
	))
	{
#ifdef _WIN32_WCE
		ExitThread(0);
#else
		_endthreadex(0);
#endif
		return 0;
	}

	/* demon
	*/
	RtpSpeakerout_Demon(pObj);

	Sleep(500);
	tRes = waveOutReset(pObj->mHandle);

	Sleep(200);
	if(!tRes)
		waveOutClose(pObj->mHandle);

	deletem_RtpSpeakerout(pObj);
	HSPrint("\nRtpSpker-End");

#ifdef _WIN32_WCE
	ExitThread(0);
#else
	_endthreadex(0);
#endif
	return 0;
}


HS_QID RtpSpeakerout_Start(void *pObject)
{
	RtpSpeakerout *pObj = (RtpSpeakerout*)pObject;
	if( pObj==NULL ) return HS_INVALID_QID;

#ifdef _WIN32_WCE
	CreateThread(NULL,0,&RtpSpeakerout_Thread,pObj,0,&(pObj->mMyQ));
#else
	_beginthreadex(NULL,0,&RtpSpeakerout_Thread,pObj,0,&(pObj->mMyQ));
#endif

	/* give to speaker thread some time for starting.
	*/
	Sleep(200);

	return pObj->mMyQ;
}


HS_RESULT RtpSpeakerout_Stop(void *pObject)
{
	RtpSpeakerout *pObj = (RtpSpeakerout*)pObject;
	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mMyQ == HS_INVALID_QID ) return HS_ERR;

	PostThreadMessage(pObj->mMyQ,HS_QM_STOP,(WPARAM)0,(LPARAM)NULL);
	return HS_OK;
}


HS_RESULT RtpSpeakerout_Check(void *pObject)
{
	RtpSpeakerout *pObj = (RtpSpeakerout*)pObject;
	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mMyQ == HS_INVALID_QID ) return HS_ERR;

	PostThreadMessage(pObj->mMyQ,HS_QM_CHECK,(WPARAM)0,(LPARAM)NULL);
	return HS_OK;
}


/* Call-Progress-Tone/DTMF-Tone control
*/
HS_RESULT RtpSpeakerout_StartTone(void *pObject,RtpDtmf *pDtmf)
{
	RtpSpeakerout *pObj = (RtpSpeakerout*)pObject;
	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mMyQ == HS_INVALID_QID ) return HS_ERR;

	PostThreadMessage(pObj->mMyQ,HS_QM_TONE_START,(WPARAM)0,(LPARAM)pDtmf);
	return HS_OK;
}


HS_RESULT RtpSpeakerout_StopTone(void *pObject)
{
	RtpSpeakerout *pObj = (RtpSpeakerout*)pObject;
	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mMyQ == HS_INVALID_QID ) return HS_ERR;

	PostThreadMessage(pObj->mMyQ,HS_QM_TONE_STOP,(WPARAM)0,(LPARAM)NULL);
	return HS_OK;
}



