/*

	<desText.c>		2005-12-06,21:54

*/

#include <stdio.h>
#include <memory.h>

#include "des.h"





void PrintBytes(const char *pDescription, unsigned char *pData, unsigned int pLen)
{
	unsigned int i;

	if( pData==NULL || pLen==0 ) return;

	if( pDescription != NULL )
		printf("%s",pDescription);

	for(i=0; i<pLen; i++)
	{
		if( (i%8)==0 ) printf("   ");
		if( (i%16)==0 ) printf("\n");
		printf("%02x ",pData[i]);
	}
}





/* DES test vector from 'securitytechnet'
*/
/* ECB 0
*/
static unsigned char gEcbKey[8] = {0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF};
static char			*gEcbPlain  = "Now is the time for all ";
static unsigned char gEcbEnc[24]=
	{0x3F,0xA4,0x0E,0x8A,0x98,0x4D,0x48,0x15,
	 0x6A,0x27,0x17,0x87,0xAB,0x88,0x83,0xF9,
	 0x89,0x3D,0x51,0xEC,0x4B,0x56,0x3B,0x53};
/* CBC 0
*/
static unsigned char gCbcKey[8] = {0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF};
static unsigned char gCbcIv[8]  = {0x12,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF};
static char			*gCbcPlain  = "Now is the time for all ";
static unsigned char gCbcEnc[24]=
	{0xE5,0xC7,0xCD,0xDE,0x87,0x2B,0xF2,0x7C,
	 0x43,0xE9,0x34,0x00,0x8C,0x38,0x9C,0x0F,
	 0x68,0x37,0x88,0x49,0x9A,0x7C,0x05,0xF6};
/* OFB 0
*/
static unsigned char gOfbKey[8] = {0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF};
static unsigned char gOfbIv[8]  = {0x12,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF};
static char			*gOfbPlain  = "Now is the time for all ";
static unsigned char gOfbEnc[24]=
	{0xF3,0x09,0x62,0x49,0xC7,0xF4,0x6E,0x51,
	 0x35,0xF2,0x4A,0x24,0x2E,0xEB,0x3D,0x3F,
	 0x3D,0x6D,0x5B,0xE3,0x25,0x5A,0xF8,0xC3};
/* CFB 0
*/
static unsigned char gCfbKey[8] = {0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF};
static unsigned char gCfbIv[8]  = {0x12,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF};
static char			*gCfbPlain  = "Now";
static unsigned char gCfbEnc[3] = {0xF3,0x09,0x62};
/* ECB 1
*/
static unsigned char gEcbKey2[8]   = {0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF};
static unsigned char gEcbPlain2[32]=
	{0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x20,
	 0x4E,0x6F,0x77,0x20,0x69,0x73,0x20,0x74,
	 0x68,0x65,0x20,0x74,0x69,0x6D,0x65,0x20,
	 0x66,0x6F,0x72,0x20,0x00,0x00,0x00,0x00};
static unsigned char gEcbEnc2[32]  =
	{0x21,0xFB,0x19,0x36,0x93,0xA1,0x6C,0x28,
	 0x3F,0xA4,0x0E,0x8A,0x98,0x4D,0x48,0x15,
	 0x6A,0x27,0x17,0x87,0xAB,0x88,0x83,0xF9,
	 0x32,0x87,0x62,0x45,0xE9,0x2B,0xF2,0x29};
/* CBC 1
*/
static unsigned char gCbcKey2[8]   = {0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF};
static unsigned char gCbcIv2[8]    = {0,0,0,0,0,0,0,0};
static unsigned char gCbcPlain2[32]=
	{0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x20,
	 0x4E,0x6F,0x77,0x20,0x69,0x73,0x20,0x74,
	 0x68,0x65,0x20,0x74,0x69,0x6D,0x65,0x20,
	 0x66,0x6F,0x72,0x20,0x00,0x00,0x00,0x00};
static unsigned char gCbcEnc2[32]  =
	{0x21,0xFB,0x19,0x36,0x93,0xA1,0x6C,0x28,
	 0x6C,0x46,0x3F,0x0C,0xB7,0x16,0x7A,0x6F,
	 0x95,0x6E,0xE8,0x91,0xE8,0x89,0xD9,0x1E,
	 0xF1,0xD3,0x0F,0x68,0x49,0x31,0x2C,0xA4};
/* we consider that padding is API user's job.
static unsigned char gCbcPadKey[8] = {0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF};
static unsigned char gCbcPadIv[8]  = {0x12,0x34,0x56,0x78,0x90,0xAB,0xCD,0xEF};
static char			*gCbcPadPlain  = "Now is the time for all ";
static unsigned char gCbcPadEnc[32]=
	{0xE5,0xC7,0xCD,0xDE,0x87,0x2B,0xF2,0x7C,
	 0x43,0xE9,0x34,0x00,0x8C,0x38,0x9C,0x0F,
	 0x68,0x37,0x88,0x49,0x9A,0x7C,0x05,0xF6,
	 0x62,0xC1,0x6A,0x27,0xE4,0xFC,0xF2,0x77};
*/
static unsigned char gOfbKey2[8] = {0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF};
static unsigned char gOfbIv2[8]  = {0,0,0,0,0,0,0,0};
static char			*gOfbPlain2  = "7654321 Now is the time for ";
static unsigned char gOfbEnc2[28]=
	{0xE2,0xE2,0x7A,0xC3,0x13,0x5A,0x0C,0x2D,
	 0x18,0x0E,0x9E,0xA0,0x26,0x9B,0x5B,0x03,
	 0xF2,0x88,0x10,0xCF,0x48,0xF2,0xBF,0xB1,
	 0xE1,0x47,0xB2,0x95};

static unsigned char gCfbKey2[8] = {0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF};
static unsigned char gCfbIv2[8]  = {0,0,0,0,0,0,0,0};
static char			*gCfbPlain2  = "7654321 Now is the time for ";
static unsigned char gCfbEnc2[28]=
	{0xE2,0xE2,0x7A,0xC3,0x13,0x5A,0x0C,0x2D,
	 0x25,0x95,0x36,0x18,0xA5,0xFB,0x7D,0xB7,
	 0xB6,0x02,0x8F,0x98,0x47,0xC4,0x8C,0x70,
	 0x7B,0x89,0x1A,0xD1};





void DesTest()
{
	unsigned int len;
	DesContext	tDesCtx;
	unsigned char *tResult = NULL;

	new_DesContext(&tDesCtx);

	/* ECB 0
	*/
	DesContext_SetKey(&tDesCtx,gEcbKey);
	DesContext_EncryptEcb(&tDesCtx,gEcbPlain,24);
	tResult=DesContext_GetResult(&tDesCtx,&len);
	if( tResult==NULL || len==0 )
		printf( "\n\nDES:ECB:Error\n" );
	else
	{
		PrintBytes("\n\n   DES:ECB:Success\n PlainText",gEcbPlain,24);
		PrintBytes("\n EncryptText",tResult,len);
		PrintBytes("\n ShouldText",gEcbEnc,24);
		DesContext_DecryptEcb(&tDesCtx,tResult,len);
		printf("\n%s", !memcmp(tResult,gEcbEnc,24)? "OK":"NOK");
		HSFree(tResult);
		tResult=DesContext_GetResult(&tDesCtx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(tResult,gEcbPlain,24)? "OK":"NOK");
		HSFree(tResult);
	}
	/* CBC 0
	*/
	DesContext_SetKey(&tDesCtx,gCbcKey);
	DesContext_EncryptCbc(&tDesCtx,gCbcIv,gCbcPlain,24);
	tResult=DesContext_GetResult(&tDesCtx,&len);
	if( tResult==NULL || len==0 )
		printf( "\n\nDES:CBC:Error\n" );
	else
	{
		PrintBytes("\n\n   DES:CBC:Success\n PlainText",gCbcPlain,24);
		PrintBytes("\n EncryptText",tResult,len);
		PrintBytes("\n ShouldText",gCbcEnc,24);
		DesContext_DecryptCbc(&tDesCtx,gCbcIv,tResult,len);
		printf("\n%s", !memcmp(tResult,gCbcEnc,24)? "OK":"NOK");
		HSFree(tResult);
		tResult=DesContext_GetResult(&tDesCtx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(tResult,gCbcPlain,24)? "OK":"NOK");
		HSFree(tResult);
	}
	/* OFB 0
	*/
	DesContext_SetKey(&tDesCtx,gOfbKey);
	DesContext_EncryptOfb(&tDesCtx,gOfbIv,gOfbPlain,24);
	tResult=DesContext_GetResult(&tDesCtx,&len);
	if( tResult==NULL || len==0 )
		printf( "\n\nDES:OFB:Error\n" );
	else
	{
		PrintBytes("\n\n   DES:OFB:Success\n PlainText",gOfbPlain,24);
		PrintBytes("\n EncryptText",tResult,len);
		PrintBytes("\n ShouldText",gOfbEnc,24);
		DesContext_DecryptOfb(&tDesCtx,gOfbIv,tResult,len);
		printf("\n%s", !memcmp(tResult,gOfbEnc,24)? "OK":"NOK");
		HSFree(tResult);
		tResult=DesContext_GetResult(&tDesCtx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(tResult,gOfbPlain,24)? "OK":"NOK");
		HSFree(tResult);
	}
	/* CFB 0
	*/
	DesContext_SetKey(&tDesCtx,gCfbKey);
	DesContext_EncryptCfb(&tDesCtx,gCfbIv,gCfbPlain,3);
	tResult=DesContext_GetResult(&tDesCtx,&len);
	if( tResult==NULL || len==0 )
		printf( "\n\nDES:CFB:Error\n" );
	else
	{
		PrintBytes("\n\n   DES:CFB:Success\n PlainText",gCfbPlain,3);
		PrintBytes("\n EncryptText",tResult,len);
		PrintBytes("\n ShouldText",gCfbEnc,3);
		DesContext_DecryptCfb(&tDesCtx,gCfbIv,tResult,len);
		printf("\n%s", !memcmp(tResult,gCfbEnc,3)? "OK":"NOK");
		HSFree(tResult);
		tResult=DesContext_GetResult(&tDesCtx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(tResult,gCfbPlain,3)? "OK":"NOK");
		HSFree(tResult);
	}
	/* ECB 1
	*/
	DesContext_SetKey(&tDesCtx,gEcbKey2);
	DesContext_EncryptEcb(&tDesCtx,gEcbPlain2,32);
	tResult=DesContext_GetResult(&tDesCtx,&len);
	if( tResult==NULL || len==0 )
		printf( "\n\nDES:ECB:Error\n" );
	else
	{
		PrintBytes("\n\n   DES:ECB:Success\n PlainText",gEcbPlain2,32);
		PrintBytes("\n EncryptText",tResult,len);
		PrintBytes("\n ShouldText",gEcbEnc2,32);
		DesContext_DecryptEcb(&tDesCtx,tResult,len);
		printf("\n%s", !memcmp(tResult,gEcbEnc2,32)? "OK":"NOK");
		HSFree(tResult);
		tResult=DesContext_GetResult(&tDesCtx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(tResult,gEcbPlain2,32)? "OK":"NOK");
		HSFree(tResult);
	}
	/* CBC 1
	*/
	DesContext_SetKey(&tDesCtx,gCbcKey2);
	DesContext_EncryptCbc(&tDesCtx,gCbcIv2,gCbcPlain2,32);
	tResult=DesContext_GetResult(&tDesCtx,&len);
	if( tResult==NULL || len==0 )
		printf( "\n\nDES:CBC:Error\n" );
	else
	{
		PrintBytes("\n\n   DES:CBC:Success\n PlainText",gCbcPlain2,32);
		PrintBytes("\n EncryptText",tResult,len);
		PrintBytes("\n ShouldText",gCbcEnc2,32);
		DesContext_DecryptCbc(&tDesCtx,gCbcIv2,tResult,len);
		printf("\n%s", !memcmp(tResult,gCbcEnc2,32)? "OK":"NOK");
		HSFree(tResult);
		tResult=DesContext_GetResult(&tDesCtx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(tResult,gCbcPlain2,32)? "OK":"NOK");
		HSFree(tResult);
	}
	/* OFB 1
	*/
	DesContext_SetKey(&tDesCtx,gOfbKey2);
	DesContext_EncryptOfb(&tDesCtx,gOfbIv2,gOfbPlain2,28);
	tResult=DesContext_GetResult(&tDesCtx,&len);
	if( tResult==NULL || len==0 )
		printf( "\n\nDES:OFB:Error\n" );
	else
	{
		PrintBytes("\n\n   DES:OFB:Success\n PlainText",gOfbPlain2,28);
		PrintBytes("\n EncryptText",tResult,len);
		PrintBytes("\n ShouldText",gOfbEnc2,28);
		DesContext_DecryptOfb(&tDesCtx,gOfbIv2,tResult,len);
		printf("\n%s", !memcmp(tResult,gOfbEnc2,28)? "OK":"NOK");
		HSFree(tResult);
		tResult=DesContext_GetResult(&tDesCtx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(tResult,gOfbPlain2,28)? "OK":"NOK");
		HSFree(tResult);
	}
	/* CFB 1
	*/
	DesContext_SetKey(&tDesCtx,gCfbKey2);
	DesContext_EncryptCfb(&tDesCtx,gCfbIv2,gCfbPlain2,28);
	tResult=DesContext_GetResult(&tDesCtx,&len);
	if( tResult==NULL || len==0 )
		printf( "\n\nDES:CFB:Error\n" );
	else
	{
		PrintBytes("\n\n   DES:CFB:Success\n PlainText",gCfbPlain2,28);
		PrintBytes("\n EncryptText",tResult,len);
		PrintBytes("\n ShouldText",gCfbEnc2,28);
		DesContext_DecryptCfb(&tDesCtx,gCfbIv2,tResult,len);
		printf("\n%s", !memcmp(tResult,gCfbEnc2,28)? "OK":"NOK");
		HSFree(tResult);
		tResult=DesContext_GetResult(&tDesCtx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(tResult,gCfbPlain2,28)? "OK":"NOK");
		HSFree(tResult);
	}

	delete_DesContext(&tDesCtx);
}







/* Triple-DES test vector from 'securitytechnet'
*/
/* ECB 0
*/
static unsigned char g3EcbKey[24]   =
	{0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF,
	 0xf0,0xe1,0xd2,0xc3,0xb4,0xa5,0x96,0x87,
	 0xfe,0xdc,0xba,0x98,0x76,0x54,0x32,0x10};
static unsigned char g3EcbPlain[32] =
	{0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x20,
	 0x4E,0x6F,0x77,0x20,0x69,0x73,0x20,0x74,
	 0x68,0x65,0x20,0x74,0x69,0x6D,0x65,0x20,
	 0x66,0x6F,0x72,0x20,0x00,0x00,0x00,0x00};
static unsigned char g3EcbEnc[32]   =
	{0x62,0xC1,0x0C,0xC9,0xEF,0xBF,0x15,0xAA,
	 0xA5,0xAE,0x2E,0x48,0x7B,0x69,0x0E,0x56,
	 0xD8,0xB1,0xDF,0xB8,0xF5,0xC5,0xB2,0x93,
	 0x85,0x5E,0x77,0xDD,0x90,0x24,0xB1,0xB1};
/* CBC 0
*/
static unsigned char g3CbcKey[24]   =
	{0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF,
	 0xf0,0xe1,0xd2,0xc3,0xb4,0xa5,0x96,0x87,
	 0xfe,0xdc,0xba,0x98,0x76,0x54,0x32,0x10};
static unsigned char g3CbcIv[8]     = {0,0,0,0,0,0,0,0};
static unsigned char g3CbcPlain[32] =
	{0x37,0x36,0x35,0x34,0x33,0x32,0x31,0x20,
	 0x4E,0x6F,0x77,0x20,0x69,0x73,0x20,0x74,
	 0x68,0x65,0x20,0x74,0x69,0x6D,0x65,0x20,
	 0x66,0x6F,0x72,0x20,0x00,0x00,0x00,0x00};
static unsigned char g3CbcEnc[32]   =
	{0x62,0xC1,0x0C,0xC9,0xEF,0xBF,0x15,0xAA,
	 0x15,0xEE,0xA1,0xEE,0xC4,0x84,0x42,0x93,
	 0x8D,0x6F,0x78,0x06,0x47,0x0E,0x7C,0xD3,
	 0x33,0x66,0xF2,0x80,0xCC,0x60,0x02,0x64};
/* we consider that padding is API user's job.
static unsigned char g3CbcPadKey[24] =
	{0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF,
	 0xf0,0xe1,0xd2,0xc3,0xb4,0xa5,0x96,0x87,
	 0xfe,0xdc,0xba,0x98,0x76,0x54,0x32,0x10},
static unsigned char g3CbcPadIv[8]   = {0xFE,0xDC,0xBA,0x98,0x76,0x54,0x32,0x10};
static char			*g3CbcPadPlain   = "7654321 Now is the time for ";
static unsigned char g3CbcPadEnc[32] =
	{0x3F,0xE3,0x01,0xC9,0x62,0xAC,0x01,0xD0,
	 0x22,0x13,0x76,0x3C,0x1C,0xBD,0x4C,0xDC,
	 0x79,0x96,0x57,0xC0,0x64,0xEC,0xF5,0xD4,
	 0x14,0xC2,0x05,0x05,0x04,0x45,0x70,0x37};
*/
/* OFB 0
*/
static unsigned char g3OfbKey[24] =
	{0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF,
	 0xf0,0xe1,0xd2,0xc3,0xb4,0xa5,0x96,0x87,
	 0xfe,0xdc,0xba,0x98,0x76,0x54,0x32,0x10};
static unsigned char g3OfbIv[8]   = {0,0,0,0,0,0,0,0};
static char			*g3OfbPlain   = "7654321 Now is the time for ";
static unsigned char g3OfbEnc[28] =
	{0x95,0x2B,0xD1,0x53,0x2E,0x77,0x50,0x18,
	 0xAA,0x24,0xCF,0x50,0x02,0xC1,0xE4,0x12,
	 0x2A,0xAC,0xAE,0x06,0x99,0xB8,0xF5,0x8C,
	 0xCD,0x67,0x39,0xC6};
/* CFB
*/
static unsigned char g3CfbKey[24] =
	{0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF,
	 0xf0,0xe1,0xd2,0xc3,0xb4,0xa5,0x96,0x87,
	 0xfe,0xdc,0xba,0x98,0x76,0x54,0x32,0x10};
static unsigned char g3CfbIv[8]   = {0,0,0,0,0,0,0,0};
static char			*g3CfbPlain   = "7654321 Now is the time for ";
static unsigned char g3CfbEnc[28] =
	{0x95,0x2B,0xD1,0x53,0x2E,0x77,0x50,0x18,
	 0x9A,0xE4,0x15,0x19,0x90,0xB9,0x45,0xD9,
	 0x30,0x6E,0x84,0x70,0x4C,0x03,0xAC,0x7A,
	 0x9D,0x86,0x74,0x90};





void Des3Test()
{
	unsigned int len;
	Des3Context	tDes3Ctx;
	unsigned char *tResult = NULL;

	new_Des3Context(&tDes3Ctx);

	/* ECB 1
	*/
	Des3Context_SetKey(&tDes3Ctx,g3EcbKey,g3EcbKey+8,g3EcbKey+16);
	Des3Context_EncryptEcb(&tDes3Ctx,g3EcbPlain,32);
	tResult=Des3Context_GetResult(&tDes3Ctx,&len);
	if( tResult==NULL || len==0 )
		printf( "\n\n3DES:ECB:Error\n" );
	else
	{
		PrintBytes("\n\n   3DES:ECB:Success\n PlainText",g3EcbPlain,32);
		PrintBytes("\n EncryptText",tResult,len);
		PrintBytes("\n ShouldText",g3EcbEnc,32);
		Des3Context_DecryptEcb(&tDes3Ctx,tResult,len);
		printf("\n%s", !memcmp(tResult,g3EcbEnc,32)? "OK":"NOK");
		HSFree(tResult);
		tResult=Des3Context_GetResult(&tDes3Ctx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(tResult,g3EcbPlain,32)? "OK":"NOK");
		HSFree(tResult);
	}
	/* CBC 1
	*/
	Des3Context_SetKey(&tDes3Ctx,g3CbcKey,g3CbcKey+8,g3CbcKey+16);
	Des3Context_EncryptCbc(&tDes3Ctx,g3CbcIv,g3CbcPlain,32);
	tResult=Des3Context_GetResult(&tDes3Ctx,&len);
	if( tResult==NULL || len==0 )
		printf( "\n\n3DES:CBC:Error\n" );
	else
	{
		PrintBytes("\n\n   3DES:CBC:Success\n PlainText",g3CbcPlain,32);
		PrintBytes("\n EncryptText",tResult,len);
		PrintBytes("\n ShouldText",g3CbcEnc,32);
		Des3Context_DecryptCbc(&tDes3Ctx,g3CbcIv,tResult,len);
		printf("\n%s", !memcmp(tResult,g3CbcEnc,32)? "OK":"NOK");
		HSFree(tResult);
		tResult=Des3Context_GetResult(&tDes3Ctx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(tResult,g3CbcPlain,32)? "OK":"NOK");
		HSFree(tResult);
	}
	/* OFB 1
	*/
	Des3Context_SetKey(&tDes3Ctx,g3OfbKey,g3OfbKey+8,g3OfbKey+16);
	Des3Context_EncryptOfb(&tDes3Ctx,g3OfbIv,g3OfbPlain,28);
	tResult=Des3Context_GetResult(&tDes3Ctx,&len);
	if( tResult==NULL || len==0 )
		printf( "\n\n3DES:OFB:Error\n" );
	else
	{
		PrintBytes("\n\n   3DES:OFB:Success\n PlainText",g3OfbPlain,28);
		PrintBytes("\n EncryptText",tResult,len);
		PrintBytes("\n ShouldText",g3OfbEnc,28);
		Des3Context_DecryptOfb(&tDes3Ctx,g3OfbIv,tResult,len);
		printf("\n%s", !memcmp(tResult,g3OfbEnc,28)? "OK":"NOK");
		HSFree(tResult);
		tResult=Des3Context_GetResult(&tDes3Ctx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(tResult,g3OfbPlain,28)? "OK":"NOK");
		HSFree(tResult);
	}
	/* CFB 1
	*/
	Des3Context_SetKey(&tDes3Ctx,g3CfbKey,g3CfbKey+8,g3CfbKey+16);
	Des3Context_EncryptCfb(&tDes3Ctx,g3CfbIv,g3CfbPlain,28);
	tResult=Des3Context_GetResult(&tDes3Ctx,&len);
	if( tResult==NULL || len==0 )
		printf( "\n\n3DES:CFB:Error\n" );
	else
	{
		PrintBytes("\n\n   3DES:CFB:Success\n PlainText",g3CfbPlain,28);
		PrintBytes("\n EncryptText",tResult,len);
		PrintBytes("\n ShouldText",g3CfbEnc,28);
		Des3Context_DecryptCfb(&tDes3Ctx,g3CfbIv,tResult,len);
		printf("\n%s", !memcmp(tResult,g3CfbEnc,28)? "OK":"NOK");
		HSFree(tResult);
		tResult=Des3Context_GetResult(&tDes3Ctx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(tResult,g3CfbPlain,28)? "OK":"NOK");
		HSFree(tResult);
	}

	delete_Des3Context(&tDes3Ctx);
}





int main()
{
	DesTest();
	Des3Test();
}



