/*

	<rc2Test.c>		2005-12-06,23:03

*/

#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include "rc2.h"





void PrintBytes(const char *pDescription, unsigned char *pData, unsigned int pLen)
{
	unsigned int i;

	if( pData==NULL || pLen==0 ) return;

	if( pDescription != NULL )
		printf("%s",pDescription);

	for(i=0; i<pLen; i++)
	{
		if( (i%8)==0 ) printf("   ");
		if( (i%16)==0 ) printf("\n");
		printf("%02x ",pData[i]);
	}
}





/* RC2 test vector from RFC 2268 'A Description of the RC2(r) Encryption Algorithm'
*/
#define MAX_TEST_VECTOR_SIZE		8
typedef struct
{
	unsigned int mKeyLen;
	unsigned int mEffectiveKeyLen;
	unsigned int mTextLen;
	unsigned char mKey[RC2_KEY_SIZE];
	unsigned char mPlain[64];
	unsigned char mChiper[64];
} Rc2TestVector;

static Rc2TestVector	gTestVector[8] =
{
	{8,	63,	8,
		{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0xeb,0xb7,0x73,0xf9,0x93,0x27,0x8e,0xff}
	},
	{8,	64,	8,
		{0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
		{0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
		{0x27,0x8b,0x27,0xe4,0x2e,0x2f,0x0d,0x49}
	},
	{8,	64, 8,
		{0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x01},
		{0x30,0x64,0x9e,0xdf,0x9b,0xe7,0xd2,0xc2}
	},
	{1,	64,	8,
		{0x88},
		{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x61,0xa8,0xa2,0x44,0xad,0xac,0xcc,0xf0}
	},
	{7,	64,	8,
		{0x88,0xbc,0xa9,0x0e,0x90,0x87,0x5a},
		{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x6c,0xcf,0x43,0x08,0x97,0x4c,0x26,0x7f}
	},
	{16,	64,	8,
		{0x88,0xbc,0xa9,0x0e,0x90,0x87,0x5a,0x7f,
		 0x0f,0x79,0xc3,0x84,0x62,0x7b,0xaf,0xb2},
		{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x1a,0x80,0x7d,0x27,0x2b,0xbe,0x5d,0xb1}
	},
	{16,	128,	8,
		{0x88,0xbc,0xa9,0x0e,0x90,0x87,0x5a,0x7f,
		 0x0f,0x79,0xc3,0x84,0x62,0x7b,0xaf,0xb2},
		{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x22,0x69,0x55,0x2a,0xb0,0xf8,0x5c,0xa6}
	},
	{33,	129,	8,
		{0x88,0xbc,0xa9,0x0e,0x90,0x87,0x5a,0x7f,
		 0x0f,0x79,0xc3,0x84,0x62,0x7b,0xaf,0xb2,
		 0x16,0xf8,0x0a,0x6f,0x85,0x92,0x05,0x84,
		 0xc4,0x2f,0xce,0xb0,0xbe,0x25,0x5d,0xaf,
		 0x1e},
		{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		{0x5b,0x78,0xd3,0xa4,0x3d,0xff,0xf1,0xf1}
	}
};
/* RC2 test vector for CBC,OFB,CFB mode.
   we just check the equivalance between PLAIN_TEXT and ENCODED_DECODED_TEXT
*/
static char			*gModeKey = "19760124sunnykim";
static char			*gModeIv  = "19771120";
static unsigned int gModeKeyLen = 16;
static unsigned int gModeKeyEffective = 100;
static char			*gModePlain = "http://www.voiper.co.kr/SecuredVoip";





void Rc2Test()
{
	unsigned int i, len;
	Rc2Context tRc2Ctx;
	unsigned char *tResult = NULL;

	new_Rc2Context(&tRc2Ctx);


	for(i=0; i<MAX_TEST_VECTOR_SIZE; i++)
	{
		printf("\n\n  RC2Test %d",i);
		Rc2Context_SetKey(&tRc2Ctx,gTestVector[i].mKey,gTestVector[i].mKeyLen,gTestVector[i].mEffectiveKeyLen);
		Rc2Context_EncryptEcb(&tRc2Ctx,gTestVector[i].mPlain,gTestVector[i].mTextLen);
		tResult = Rc2Context_GetResult(&tRc2Ctx,&len);
		if( tResult == NULL || len == 0 )
			printf( "Fail\n\n" );
		else
		{
			PrintBytes(":Success\n PlainText",gTestVector[i].mPlain,gTestVector[i].mTextLen);
			PrintBytes("\n ChiperText",tResult,len);
			PrintBytes("\n ShouldText",gTestVector[i].mChiper,gTestVector[i].mTextLen);
			Rc2Context_DecryptEcb(&tRc2Ctx,tResult,len);
			printf("\n%s", !memcmp(tResult,gTestVector[i].mChiper,gTestVector[i].mTextLen)? "<OK>":"<NOK>");
			HSFree(tResult);
			tResult=Rc2Context_GetResult(&tRc2Ctx,&len);
			PrintBytes("\n DecryptText",tResult,len);
			printf("\n%s", !memcmp(tResult,gTestVector[i].mPlain,gTestVector[i].mTextLen)? "<OK>":"<NOK>");
			HSFree(tResult);
		}
	}

	/* ECB check
	*/
	printf("\n\n  RC2:EBC");
	Rc2Context_SetKey(&tRc2Ctx,gModeKey,gModeKeyLen,gModeKeyEffective);
	Rc2Context_EncryptEcb(&tRc2Ctx,gModePlain,32);
	tResult = Rc2Context_GetResult(&tRc2Ctx,&len);
	if( tResult == NULL || len == 0 )
		printf( ":Fail\n\n" );
	else
	{
		PrintBytes(":Success\n PlainText",gModePlain,32);
		PrintBytes("\n ChiperText",tResult,len);
		Rc2Context_DecryptEcb(&tRc2Ctx,tResult,len);
		HSFree(tResult);
		tResult=Rc2Context_GetResult(&tRc2Ctx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(gModePlain,tResult,len)? "<OK>":"<NOK>");
		HSFree(tResult);
	}
	/* CBC check
	*/
	printf("\n\n  RC2:CBC");
	Rc2Context_SetKey(&tRc2Ctx,gModeKey,gModeKeyLen,gModeKeyEffective);
	Rc2Context_EncryptCbc(&tRc2Ctx,gModeIv,gModePlain,32);
	tResult = Rc2Context_GetResult(&tRc2Ctx,&len);
	if( tResult == NULL || len == 0 )
		printf( ":Fail\n\n" );
	else
	{
		PrintBytes(":Success\n PlainText",gModePlain,32);
		PrintBytes("\n ChiperText",tResult,len);
		Rc2Context_DecryptCbc(&tRc2Ctx,gModeIv,tResult,len);
		HSFree(tResult);
		tResult=Rc2Context_GetResult(&tRc2Ctx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(gModePlain,tResult,len)? "<OK>":"<NOK>");
		HSFree(tResult);
	}
	/* OFB check
	*/
	printf("\n\n  RC2:OFB");
	Rc2Context_SetKey(&tRc2Ctx,gModeKey,gModeKeyLen,gModeKeyEffective);
	Rc2Context_EncryptOfb(&tRc2Ctx,gModeIv,gModePlain,strlen(gModePlain));
	tResult = Rc2Context_GetResult(&tRc2Ctx,&len);
	if( tResult == NULL || len == 0 )
		printf( ":Fail\n\n" );
	else
	{
		PrintBytes(":Success\n PlainText",gModePlain,strlen(gModePlain));
		PrintBytes("\n ChiperText",tResult,len);
		Rc2Context_DecryptOfb(&tRc2Ctx,gModeIv,tResult,len);
		HSFree(tResult);
		tResult=Rc2Context_GetResult(&tRc2Ctx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(gModePlain,tResult,len)? "<OK>":"<NOK>");
		HSFree(tResult);
	}
	/* CFB check
	*/
	printf("\n\n  RC2:CFB");
	Rc2Context_SetKey(&tRc2Ctx,gModeKey,gModeKeyLen,gModeKeyEffective);
	Rc2Context_EncryptCfb(&tRc2Ctx,gModeIv,gModePlain,strlen(gModePlain));
	tResult = Rc2Context_GetResult(&tRc2Ctx,&len);
	if( tResult == NULL || len == 0 )
		printf( ":Fail\n\n" );
	else
	{
		PrintBytes(":Success\n PlainText",gModePlain,strlen(gModePlain));
		PrintBytes("\n ChiperText",tResult,len);
		Rc2Context_DecryptCfb(&tRc2Ctx,gModeIv,tResult,len);
		HSFree(tResult);
		tResult=Rc2Context_GetResult(&tRc2Ctx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(gModePlain,tResult,len)? "<OK>":"<NOK>");
		HSFree(tResult);
	}

	delete_Rc2Context(&tRc2Ctx);
}





int main()
{
	Rc2Test();
	return 0;
}