/*

	<seedEx.c>		2005-12-07,22:54

*/

#include "SeedEx.h"





#define SEEDXor(out,in1,in2)																\
{																						\
	((unsigned int*)(out))[0] = ((unsigned int*)(in1))[0] ^ ((unsigned int*)(in2))[0];	\
	((unsigned int*)(out))[1] = ((unsigned int*)(in1))[1] ^ ((unsigned int*)(in2))[1];	\
	((unsigned int*)(out))[2] = ((unsigned int*)(in1))[2] ^ ((unsigned int*)(in2))[2];	\
	((unsigned int*)(out))[3] = ((unsigned int*)(in1))[3] ^ ((unsigned int*)(in2))[3];	\
}





/* DesContext member functions.
*/
int new_SeedContext(void *pObject)
{
	SeedContext *pObj = (SeedContext*)pObject;

	if( pObj==NULL ) return 2/*null param*/;

	memset((unsigned char*)(pObj->mRoundKey),0,128);
	pObj->mResult = NULL;
	pObj->mResultLen = 0;

	return 0/*ok*/;
}


SeedContext *newm_SeedContext()
{
	SeedContext *tResult = NULL;

	if( (tResult=(SeedContext*)HSMalloc(sizeof(SeedContext)))==NULL )
		return NULL;

	if( new_SeedContext(tResult) != 0 )
	{
		HSFree(tResult);
		return NULL;
	}

	return tResult;
}


int delete_SeedContext(void *pObject)
{
	SeedContext *pObj = (SeedContext*)pObject;

	if( pObj==NULL ) return 2/*null param*/;

	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	pObj->mResultLen = 0;

	return 0;
}


int deletem_SeedContext(void *pObject)
{
	int tRet;

	if( (tRet=delete_SeedContext(pObject)) != 0 ) return tRet;

	HSFree(pObject);
	return 0;
}


int SeedContext_SetKey(void *pObject, unsigned char *pKey)
{
	int tRet = 0;
	SeedContext *pObj = (SeedContext*)pObject;

	if( pObj==NULL || pKey==NULL ) return 2/*null param*/;

	SeedEncRoundKey(pObj->mRoundKey,pKey);
	return 0;
}


/* input, output is a 16 byte data.
*/
static void SeedEncryptEcb(void *pOutput, const void *pInput, void *pRoundKey)
{
	memcpy(pOutput,pInput,16);
	SeedEncrypt(pOutput,pRoundKey);
}
static void SeedDecryptEcb(void *pOutput, const void *pInput, void *pRoundKey)
{
	memcpy(pOutput,pInput,16);
	SeedDecrypt(pOutput,pRoundKey);
}


int SeedContext_EncryptEcb(void *pObject, unsigned char *pData, unsigned int pLen)
{
	unsigned int i, tBlockSize, tRemainLen;
	SeedContext *pObj = (SeedContext*)pObject;

	if( pObj==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/16);
	tRemainLen = (unsigned int)(pLen%16);

	for(i=0; i<tBlockSize; i++)
		SeedEncryptEcb(pObj->mResult+i*16,pData+i*16,pObj->mRoundKey);

	/* do not encrypt remain bytes.
	   remain bytes will be treated by API user.
	*/
	if( tRemainLen != 0 )
		memcpy(pObj->mResult+i*16,pData+i*16,tRemainLen);

	return 0;
}


int SeedContext_DecryptEcb(void *pObject, unsigned char *pData, unsigned int pLen)
{
	unsigned int i, tBlockSize, tRemainLen;
	SeedContext *pObj = (SeedContext*)pObject;

	if( pObj==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/16);
	tRemainLen = (unsigned int)(pLen%16);

	for(i=0; i<tBlockSize; i++)
		SeedDecryptEcb(pObj->mResult+i*16,pData+i*16,pObj->mRoundKey);

	/* do not decrypt remain bytes.
	   remain bytes will be treated by API user.
	*/
	if( tRemainLen != 0 )
		memcpy(pObj->mResult+i*16,pData+i*16,tRemainLen);

	return 0;
}


int SeedContext_EncryptCbc(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[16];
	unsigned int i, tBlockSize, tRemainLen;
	SeedContext *pObj = (SeedContext*)pObject;
	
	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/16);
	tRemainLen = (unsigned int)(pLen%16);

	memcpy(tXorer,pIv,16);
	for(i=0; i<tBlockSize; i++)
	{
		SEEDXor(pObj->mResult+i*16,pData+i*16,tXorer);
		SeedEncryptEcb(pObj->mResult+i*16,pObj->mResult+i*16,pObj->mRoundKey);
		memcpy(tXorer,pObj->mResult+i*16,16);
	}

	/* do not encrypt remain bytes.
	   remain bytes will be treated by API user.
	*/
	if( tRemainLen != 0 )
		memcpy(pObj->mResult+i*16,pData+i*16,tRemainLen);

	return 0;
}


int SeedContext_DecryptCbc(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[16];
	unsigned int i, tBlockSize, tRemainLen;
	SeedContext *pObj = (SeedContext*)pObject;

	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/16);
	tRemainLen = (unsigned int)(pLen%16);

	memcpy(tXorer,pIv,16);
	for(i=0; i<tBlockSize; i++)
	{
		SeedDecryptEcb(pObj->mResult+i*16,pData+i*16,pObj->mRoundKey);
		SEEDXor(pObj->mResult+i*16,pObj->mResult+i*16,tXorer);
		memcpy(tXorer,pData+i*16,16);
	}

	/* do not encrypt remain bytes.
	   remain bytes will be treated by API user.
	*/
	if( tRemainLen != 0 )
		memcpy(pObj->mResult+i*16,pData+i*16,tRemainLen);

	return 0;
}


int SeedContext_EncryptOfb(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[16];
	unsigned int i, j, tBlockSize, tRemainLen;
	SeedContext *pObj = (SeedContext*)pObject;
	
	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/16);
	tRemainLen = (unsigned int)(pLen%16);

	memcpy(tXorer,pIv,16);
	for(i=0; i<tBlockSize; i++)
	{
		SeedEncryptEcb(tXorer,tXorer,pObj->mRoundKey);
		SEEDXor(pObj->mResult+i*16,pData+i*16,tXorer);
	}

	if( tRemainLen != 0 )
	{
		SeedEncryptEcb(tXorer,tXorer,pObj->mRoundKey);
		for(j=0; j<tRemainLen; j++)
			pObj->mResult[i*16+j] = pData[i*16+j] ^ tXorer[j];
	}

	return 0;
}


int SeedContext_DecryptOfb(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	return SeedContext_EncryptOfb(pObject,pIv,pData,pLen);
}


int SeedContext_EncryptCfb(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[16];
	unsigned int i, j, tBlockSize, tRemainLen;
	SeedContext *pObj = (SeedContext*)pObject;
	
	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/16);
	tRemainLen = (unsigned int)(pLen%16);

	memcpy(tXorer,pIv,16);
	for(i=0; i<tBlockSize; i++)
	{
		SeedEncryptEcb(tXorer,tXorer,pObj->mRoundKey);
		SEEDXor(pObj->mResult+i*16,pData+i*16,tXorer);
		memcpy(tXorer,pObj->mResult+i*16,16);
	}

	if( tRemainLen != 0 )
	{
		SeedEncryptEcb(tXorer,tXorer,pObj->mRoundKey);
		for(j=0; j<tRemainLen; j++)
			pObj->mResult[i*16+j] = pData[i*16+j] ^ tXorer[j];
	}

	return 0;
}


int SeedContext_DecryptCfb(void *pObject, unsigned char *pIv, unsigned char *pData, unsigned int pLen)
{
	unsigned char tXorer[16];
	unsigned int i, j, tBlockSize, tRemainLen;
	SeedContext *pObj = (SeedContext*)pObject;
	
	if( pObj==NULL || pIv==NULL || pData==NULL || pLen==0 ) return 2/*null param*/;
	if( pObj->mResult != NULL )
	{
		HSFree(pObj->mResult);
		pObj->mResult = NULL;
	}
	if( (pObj->mResult=(unsigned char*)HSMalloc(pLen))==NULL ) return 3/*err HSMalloc*/;
	pObj->mResultLen = pLen;

	tBlockSize = (unsigned int)(pLen/16);
	tRemainLen = (unsigned int)(pLen%16);

	memcpy(tXorer,pIv,16);
	for(i=0; i<tBlockSize; i++)
	{
		SeedEncryptEcb(tXorer,tXorer,pObj->mRoundKey);
		SEEDXor(pObj->mResult+i*16,pData+i*16,tXorer);
		memcpy(tXorer,pData+i*16,16);
	}

	if( tRemainLen != 0 )
	{
		SeedEncryptEcb(tXorer,tXorer,pObj->mRoundKey);
		for(j=0; j<tRemainLen; j++)
			pObj->mResult[i*16+j] = pData[i*16+j] ^ tXorer[j];
	}

	return 0;
}


unsigned char *SeedContext_GetResult(void *pObject, unsigned int *pLen)
{
	unsigned char *tResult = NULL;
	SeedContext *pObj = (SeedContext*)pObject;

	if( pObj==NULL ) return NULL;

	tResult = pObj->mResult;
	pObj->mResult = NULL;
	*pLen = pObj->mResultLen;
	pObj->mResultLen = 0;
	return tResult;
}