/*

	<seedTest.c>	2005-12-07,23:08

*/

#include "SeedEx.h"





void PrintBytes(const char *pDescription, unsigned char *pData, unsigned int pLen)
{
	unsigned int i;

	if( pData==NULL || pLen==0 ) return;

	if( pDescription != NULL )
		printf("%s",pDescription);

	for(i=0; i<pLen; i++)
	{
		if( (i%8)==0 ) printf("   ");
		if( (i%16)==0 ) printf("\n");
		printf("%02x ",pData[i]);
	}
}





/* SEED test vector from the RFC 4009 'The SEED Encryption Algorithm'
*/
#define MAX_TEST_VECTOR_SIZE	4
typedef struct
{
	unsigned char mKey[16];
	unsigned char mPlain[16];
	unsigned char mChiper[16];
} SeedTestVector;

static SeedTestVector	gTestVector[4] =
{
	{
		{0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00},
		{0x00 ,0x01 ,0x02 ,0x03 ,0x04 ,0x05 ,0x06 ,0x07 ,0x08 ,0x09 ,0x0A ,0x0B ,0x0C ,0x0D ,0x0E ,0x0F},
		{0x5E ,0xBA ,0xC6 ,0xE0 ,0x05 ,0x4E ,0x16 ,0x68 ,0x19 ,0xAF ,0xF1 ,0xCC ,0x6D ,0x34 ,0x6C ,0xDB}
	},
	{
		{0x00 ,0x01 ,0x02 ,0x03 ,0x04 ,0x05 ,0x06 ,0x07 ,0x08 ,0x09 ,0x0A ,0x0B ,0x0C ,0x0D ,0x0E ,0x0F},
		{0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00},
		{0xC1 ,0x1F ,0x22 ,0xF2 ,0x01 ,0x40 ,0x50 ,0x50 ,0x84 ,0x48 ,0x35 ,0x97 ,0xE4 ,0x37 ,0x0F ,0x43}
	},
	{
		{0x47 ,0x06 ,0x48 ,0x08 ,0x51 ,0xE6 ,0x1B ,0xE8 ,0x5D ,0x74 ,0xBF ,0xB3 ,0xFD ,0x95 ,0x61 ,0x85},
		{0x83 ,0xA2 ,0xF8 ,0xA2 ,0x88 ,0x64 ,0x1F ,0xB9 ,0xA4 ,0xE9 ,0xA5 ,0xCC ,0x2F ,0x13 ,0x1C ,0x7D},
		{0xEE ,0x54 ,0xD1 ,0x3E ,0xBC ,0xAE ,0x70 ,0x6D ,0x22 ,0x6B ,0xC3 ,0x14 ,0x2C ,0xD4 ,0x0D ,0x4A}
	},
	{
		{0x28 ,0xDB ,0xC3 ,0xBC ,0x49 ,0xFF ,0xD8 ,0x7D ,0xCF ,0xA5 ,0x09 ,0xB1 ,0x1D ,0x42 ,0x2B ,0xE7},
		{0xB4 ,0x1E ,0x6B ,0xE2 ,0xEB ,0xA8 ,0x4A ,0x14 ,0x8E ,0x2E ,0xED ,0x84 ,0x59 ,0x3C ,0x5E ,0xC7},
		{0x9B ,0x9B ,0x7B ,0xFC ,0xD1 ,0x81 ,0x3C ,0xB9 ,0x5D ,0x0B ,0x36 ,0x18 ,0xF4 ,0x0F ,0x51 ,0x22}
	}
};
/* SEED test vector for CBC,OFB,CFB mode.
   we just check the equivalance between PLAIN_TEXT and ENCODED_DECODED_TEXT
*/
static char	*gModeKey = "19760124sunnykim";
static char	*gModeIv  = "19771120";
static char	*gModePlain = "http://www.voiper.co.kr/SecuredVoip";





void SeedTest()
{
	unsigned int i, len;
	SeedContext tSeedCtx;
	unsigned char *tResult = NULL;

	new_SeedContext(&tSeedCtx);


	for(i=0; i<MAX_TEST_VECTOR_SIZE; i++)
	{
		printf("\n\n  SEED Test %d",i);
		SeedContext_SetKey(&tSeedCtx,gTestVector[i].mKey);
		SeedContext_EncryptEcb(&tSeedCtx,gTestVector[i].mPlain,16);
		tResult = SeedContext_GetResult(&tSeedCtx,&len);
		if( tResult == NULL || len == 0 )
			printf( "Fail\n\n" );
		else
		{
			PrintBytes(":Success\n PlainText",gTestVector[i].mPlain,16);
			PrintBytes("\n ChiperText",tResult,len);
			PrintBytes("\n ShouldText",gTestVector[i].mChiper,16);
			SeedContext_DecryptEcb(&tSeedCtx,tResult,len);
			printf("\n%s", !memcmp(tResult,gTestVector[i].mChiper,16)? "<OK>":"<NOK>");
			HSFree(tResult);
			tResult=SeedContext_GetResult(&tSeedCtx,&len);
			PrintBytes("\n DecryptText",tResult,len);
			printf("\n%s", !memcmp(tResult,gTestVector[i].mPlain,16)? "<OK>":"<NOK>");
			HSFree(tResult);
		}
	}

	/* ECB check
	*/
	printf("\n\n  RC2:EBC");
	SeedContext_SetKey(&tSeedCtx,gModeKey);
	SeedContext_EncryptEcb(&tSeedCtx,gModePlain,32);
	tResult = SeedContext_GetResult(&tSeedCtx,&len);
	if( tResult == NULL || len == 0 )
		printf( ":Fail\n\n" );
	else
	{
		PrintBytes(":Success\n PlainText",gModePlain,32);
		PrintBytes("\n ChiperText",tResult,len);
		SeedContext_DecryptEcb(&tSeedCtx,tResult,len);
		HSFree(tResult);
		tResult=SeedContext_GetResult(&tSeedCtx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(gModePlain,tResult,len)? "<OK>":"<NOK>");
		HSFree(tResult);
	}
	/* CBC check
	*/
	printf("\n\n  RC2:CBC");
	SeedContext_SetKey(&tSeedCtx,gModeKey);
	SeedContext_EncryptCbc(&tSeedCtx,gModeIv,gModePlain,32);
	tResult = SeedContext_GetResult(&tSeedCtx,&len);
	if( tResult == NULL || len == 0 )
		printf( ":Fail\n\n" );
	else
	{
		PrintBytes(":Success\n PlainText",gModePlain,32);
		PrintBytes("\n ChiperText",tResult,len);
		SeedContext_DecryptCbc(&tSeedCtx,gModeIv,tResult,len);
		HSFree(tResult);
		tResult=SeedContext_GetResult(&tSeedCtx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(gModePlain,tResult,len)? "<OK>":"<NOK>");
		HSFree(tResult);
	}
	/* OFB check
	*/
	printf("\n\n  RC2:OFB");
	SeedContext_SetKey(&tSeedCtx,gModeKey);
	SeedContext_EncryptOfb(&tSeedCtx,gModeIv,gModePlain,strlen(gModePlain));
	tResult = SeedContext_GetResult(&tSeedCtx,&len);
	if( tResult == NULL || len == 0 )
		printf( ":Fail\n\n" );
	else
	{
		PrintBytes(":Success\n PlainText",gModePlain,strlen(gModePlain));
		PrintBytes("\n ChiperText",tResult,len);
		SeedContext_DecryptOfb(&tSeedCtx,gModeIv,tResult,len);
		HSFree(tResult);
		tResult=SeedContext_GetResult(&tSeedCtx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(gModePlain,tResult,len)? "<OK>":"<NOK>");
		HSFree(tResult);
	}
	/* CFB check
	*/
	printf("\n\n  RC2:CFB");
	SeedContext_SetKey(&tSeedCtx,gModeKey);
	SeedContext_EncryptCfb(&tSeedCtx,gModeIv,gModePlain,strlen(gModePlain));
	tResult = SeedContext_GetResult(&tSeedCtx,&len);
	if( tResult == NULL || len == 0 )
		printf( ":Fail\n\n" );
	else
	{
		PrintBytes(":Success\n PlainText",gModePlain,strlen(gModePlain));
		PrintBytes("\n ChiperText",tResult,len);
		SeedContext_DecryptCfb(&tSeedCtx,gModeIv,tResult,len);
		HSFree(tResult);
		tResult=SeedContext_GetResult(&tSeedCtx,&len);
		PrintBytes("\n DecryptText",tResult,len);
		printf("\n%s", !memcmp(gModePlain,tResult,len)? "<OK>":"<NOK>");
		HSFree(tResult);
	}

	delete_SeedContext(&tSeedCtx);
}





int main()
{
	SeedTest();
}

