/*

	<HashMacTest.c>		2005-12-07,23:57

*/

#include <stdio.h>

#include "HashMac.h"




/* Test for Radius
*/
static unsigned char gRadiusMessage[]=
{
 0x02 ,0x00 ,0x00 ,0x26 
,0x0f ,0x40 ,0x3f ,0x94 ,0x73 ,0x97 ,0x80 ,0x57 
,0xbd ,0x83 ,0xd5 ,0xcb ,0x98 ,0xf4 ,0x22 ,0x7a
,0x06 ,0x06 ,0x00 ,0x00 ,0x00 ,0x01 ,0x0f ,0x06 
,0x00 ,0x00 ,0x00 ,0x00 ,0x0e ,0x06 ,0xc0 ,0xa8
,0x01 ,0x03
};
static char *gRadiusSecret = "xyzzy5461";
static char *gRadiusPasswd = "arctangent";




void PrintBytes(const char *pDescription, unsigned char *pData, unsigned int pLen)
{
	unsigned int i;

	if( pData==NULL || pLen==0 ) return;

	if( pDescription != NULL )
		printf("%s",pDescription);

	for(i=0; i<pLen; i++)
	{
		if( (i%8)==0 ) printf("   ");
		if( (i%16)==0 ) printf("\n");
		printf("%02x ",pData[i]);
	}
}





void Md5Test()
{
	unsigned char tHash[16];

	printf("\n\n MD5 TEST\n==========\n");

	Md5Hash(tHash,"",0);
	printf("\nMD5 Test1 (%s)"
		"\n%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
		"\nd41d8cd98f00b204e9800998ecf8427e\n","",
		tHash[0],tHash[1],tHash[2],tHash[3],tHash[4],tHash[5],tHash[6],tHash[7],
		tHash[8],tHash[9],tHash[10],tHash[11],tHash[12],tHash[13],tHash[14],tHash[15]
	);
	Md5Hash(tHash,"a",1);
	printf("\nMD5 Test2 (%s)"
		"\n%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
		"\n0cc175b9c0f1b6a831c399e269772661\n","a",
		tHash[0],tHash[1],tHash[2],tHash[3],tHash[4],tHash[5],tHash[6],tHash[7],
		tHash[8],tHash[9],tHash[10],tHash[11],tHash[12],tHash[13],tHash[14],tHash[15]
	);
	Md5Hash(tHash,"abc",3);
	printf("\nMD5 Test3 (%s)"
		"\n%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
		"\n900150983cd24fb0d6963f7d28e17f72\n","abc",
		tHash[0],tHash[1],tHash[2],tHash[3],tHash[4],tHash[5],tHash[6],tHash[7],
		tHash[8],tHash[9],tHash[10],tHash[11],tHash[12],tHash[13],tHash[14],tHash[15]
	);
	Md5Hash(tHash,"message digest",14);
	printf("\nMD5 Test4 (%s)"
		"\n%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
		"\nf96b697d7cb7938d525a2f31aaf161d0\n","message digest",
		tHash[0],tHash[1],tHash[2],tHash[3],tHash[4],tHash[5],tHash[6],tHash[7],
		tHash[8],tHash[9],tHash[10],tHash[11],tHash[12],tHash[13],tHash[14],tHash[15]
	);
	Md5Hash(tHash,"abcdefghijklmnopqrstuvwxyz",26);
	printf("\nMD5 Test5 (%s)"
		"\n%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
		"\nc3fcd3d76192e4007dfb496cca67e13b\n","abcdefghijklmnopqrstuvwxyz",
		tHash[0],tHash[1],tHash[2],tHash[3],tHash[4],tHash[5],tHash[6],tHash[7],
		tHash[8],tHash[9],tHash[10],tHash[11],tHash[12],tHash[13],tHash[14],tHash[15]
	);
	Md5Hash(tHash,"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",62);
	printf("\nMD5 Test6 (%s)"
		"\n%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
		"\nd174ab98d277d9f5a5611c2c9f419d9f\n","ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",
		tHash[0],tHash[1],tHash[2],tHash[3],tHash[4],tHash[5],tHash[6],tHash[7],
		tHash[8],tHash[9],tHash[10],tHash[11],tHash[12],tHash[13],tHash[14],tHash[15]
	);
	Md5Hash(tHash,"12345678901234567890123456789012345678901234567890123456789012345678901234567890",80);
	printf("\nMD5 Test7 (%s)"
		"\n%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
		"\n57edf4a22be3c955ac49da2e2107b67a\n","12345678901234567890123456789012345678901234567890123456789012345678901234567890",
		tHash[0],tHash[1],tHash[2],tHash[3],tHash[4],tHash[5],tHash[6],tHash[7],
		tHash[8],tHash[9],tHash[10],tHash[11],tHash[12],tHash[13],tHash[14],tHash[15]
	);

	{
		/* Test For Radius
		*/
		char tRadius[128];

		memcpy(tRadius,gRadiusMessage,gRadiusMessage[3]);
		memcpy(tRadius+gRadiusMessage[3],gRadiusSecret,strlen(gRadiusSecret));
		Md5Hash(tHash,tRadius,gRadiusMessage[3]+strlen(gRadiusSecret));
		printf("\nMD5 Test Radius()"
			"\n%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
			"\n86fe220e7624ba2a1005f6bf9b55e0b2\n",
			tHash[0],tHash[1],tHash[2],tHash[3],tHash[4],tHash[5],tHash[6],tHash[7],
			tHash[8],tHash[9],tHash[10],tHash[11],tHash[12],tHash[13],tHash[14],tHash[15]
		);
	}
}
void Sha1Test()
{
	unsigned char tHash[20];

	printf("\n\n SHA1 TEST\n===========\n");

	Sha1Hash(tHash,"abc",3);
	printf("\nSHA1 Test1 (%s)"
		"\n%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
		"\na9993e364706816aba3e25717850c26c9cd0d89d\n","abc",
		tHash[0],tHash[1],tHash[2],tHash[3],tHash[4],tHash[5],tHash[6],tHash[7],tHash[8],tHash[9],
		tHash[10],tHash[11],tHash[12],tHash[13],tHash[14],tHash[15],tHash[16],tHash[17],tHash[18],tHash[19]
	);
	Sha1Hash(tHash,"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq",56);
	printf("\nSHA1 Test2 (%s)"
		"\n%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
		"\n84983e441c3bd26ebaae4aa1f95129e5e54670f1\n","abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq",
		tHash[0],tHash[1],tHash[2],tHash[3],tHash[4],tHash[5],tHash[6],tHash[7],tHash[8],tHash[9],
		tHash[10],tHash[11],tHash[12],tHash[13],tHash[14],tHash[15],tHash[16],tHash[17],tHash[18],tHash[19]
	);
}





/* test vectors for HMAC on RFC 2104 Appendix, RFC 2202.
*/
/* 1.
*/
static unsigned char gHmacKey1[] =
	{0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	 0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b};
static unsigned int gHmacMd5KeyLen1 = 16;
static unsigned int gHmacSha1KeyLen1 = 20;
static char			*gHmacData1 = "Hi There";
static unsigned int gHmacDataLen1 = 8;
static unsigned char gHmacMd5Hash1[] =
	{0x92,0x94,0x72,0x7a,0x36,0x38,0xbb,0x1c,
	 0x13,0xf4,0x8e,0xf8,0x15,0x8b,0xfc,0x9d};
static unsigned char gHmacSha1Hash1[] =
	{0xb6,0x17,0x31,0x86,0x55,0x05,0x72,0x64,0xe2,0x8b,
	 0xc0,0xb6,0xfb,0x37,0x8c,0x8e,0xf1,0x46,0xbe,0x00};
/* 2.
*/
static unsigned char gHmacKey2[] = {'J','e','f','e'};
static unsigned int gHmacMd5KeyLen2 = 4;
static unsigned int gHmacSha1KeyLen2 = 4;
static char			*gHmacData2 = "what do ya want for nothing?";
static unsigned int gHmacDataLen2 = 28;
static unsigned char gHmacMd5Hash2[] =
	{0x75,0x0c,0x78,0x3e,0x6a,0xb0,0xb5,0x03,
	 0xea,0xa8,0x6e,0x31,0x0a,0x5d,0xb7,0x38};
static unsigned char gHmacSha1Hash2[] =
	{0xef,0xfc,0xdf,0x6a,0xe5,0xeb,0x2f,0xa2,0xd2,0x74,
	 0x16,0xd5,0xf1,0x84,0xdf,0x9c,0x25,0x9a,0x7c,0x79};
/* 3.
*/
static unsigned char gHmacKey3[] = 
	{0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
	 0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA};
static unsigned int gHmacMd5KeyLen3 = 16;
static unsigned int gHmacSha1KeyLen3 = 20;
static unsigned char gHmacData3[] =
	{0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
	 0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
	 0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
	 0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
	 0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd};
static unsigned int gHmacDataLen3 = 50;
static unsigned char gHmacMd5Hash3[] =
	{0x56,0xbe,0x34,0x52,0x1d,0x14,0x4c,0x88,
	 0xdb,0xb8,0xc7,0x33,0xf0,0xe8,0xb3,0xf6};
static unsigned char gHmacSha1Hash3[] =
	{0x12,0x5d,0x73,0x42,0xb9,0xac,0x11,0xcd,0x91,0xa3,
	 0x9a,0xf4,0x8a,0xa1,0x7b,0x4f,0x63,0xf1,0x75,0xd3};




void HmacMd5Test()
{
	unsigned char tMac[16];
	printf("\n\n MD5 HMAC TEST\n===============\n");

	Md5Hmac(tMac,gHmacKey1,gHmacMd5KeyLen1,gHmacData1,gHmacDataLen1);
	PrintBytes(  "  Result",tMac,16);
	PrintBytes("\n  Should",gHmacMd5Hash1,16);
	Md5Hmac(tMac,gHmacKey2,gHmacMd5KeyLen2,gHmacData2,gHmacDataLen2);
	PrintBytes("\n\n  Result",tMac,16);
	PrintBytes(  "\n  Should",gHmacMd5Hash2,16);
	Md5Hmac(tMac,gHmacKey3,gHmacMd5KeyLen3,gHmacData3,gHmacDataLen3);
	PrintBytes("\n\n  Result",tMac,16);
	PrintBytes(  "\n  Should",gHmacMd5Hash3,16);
}
void HmacSha1Test()
{
	unsigned char tMac[20];
	printf("\n\n MD5 HMAC TEST\n===============\n");

	Sha1Hmac(tMac,gHmacKey1,gHmacSha1KeyLen1,gHmacData1,gHmacDataLen1);
	PrintBytes(  "  Result",tMac,20);
	PrintBytes("\n  Should",gHmacSha1Hash1,20);
	Sha1Hmac(tMac,gHmacKey2,gHmacSha1KeyLen2,gHmacData2,gHmacDataLen2);
	PrintBytes("\n\n  Result",tMac,20);
	PrintBytes(  "\n  Should",gHmacSha1Hash2,20);
	Sha1Hmac(tMac,gHmacKey3,gHmacSha1KeyLen3,gHmacData3,gHmacDataLen3);
	PrintBytes("\n\n  Result",tMac,20);
	PrintBytes(  "\n  Should",gHmacSha1Hash3,20);
}





int main()
{
	Md5Test();
	Sha1Test();
	HmacMd5Test();
	HmacSha1Test();
	return 0;
}