/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipHeader.h>	2005-10-13,23:00

*/

#ifndef __2005_10_13__23_00__SIPHEADER_H__
#define __2005_10_13__23_00__SIPHEADER_H__



#include "SipDefine.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>





#define HS_SIP_END_OF_LINE				"\r\n"





#define HS_SAME_STRUCT(tOld,tNew)													\
typedef tOld		tNew;															\
tNew *newm_##tNew();																\
HS_RESULT new_##tNew(void *pObject);												\
HS_RESULT delete_##tNew(void *pObject);												\
HS_RESULT tNew##_Encode(void *pObject, char *pData, HS_UINT pMax);					\
HS_RESULT tNew##_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);	\
HS_RESULT tNew##_Decode(void *pObject, char *pData, HS_UINT pMax);					\
HS_RESULT tNew##_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);

#define HS_SAME_STRUCT_EX(tOld,tNew)												\
typedef tOld		tNew;															\
tNew *newm_##tNew();																\
HS_RESULT new_##tNew(void *pObject);												\
HS_RESULT delete_##tNew(void *pObject);												\
HS_RESULT tNew##_Encode(void *pObject, char *pData, HS_UINT pMax, BOOL pIsRequest);	\
HS_RESULT tNew##_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax, BOOL pIsRequest);	\
HS_RESULT tNew##_Decode(void *pObject, char *pData, HS_UINT pMax);					\
HS_RESULT tNew##_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);





/*
 *
 * Utility Functions
 *
 */
int SipRand(int mModulus);
char *SipStringAlloc(char *pString);
char *SipStringAllocEx(char *pString, HS_UINT pSize);
char *SipUintAlloc(HS_UINT pUint);
HS_UINT SipFindEndOfLine(char *pData, HS_UINT pPos, HS_UINT pMax);
HS_UINT SipFindNextToken(char *pData, HS_UINT pPos, HS_UINT pMax, char pToken);
HS_UINT SipFindNextToken2(char *pData, HS_UINT pPos, HS_UINT pMax, char pToken1, char pToken2);
HS_UINT SipFindNextToken3(char *pData, HS_UINT pPos, HS_UINT pMax, char pToken1, char pToken2, char pToken3);
HS_UINT SipFindNextToken4(char *pData, HS_UINT pPos, HS_UINT pMax, char pToken1, char pToken2, char pToken3, char pToken4);
HS_UINT SipFindNextTokenEx(char *pData, HS_UINT pPos, HS_UINT pMax, char *pToken);
HS_UINT SipFindNextTokenOnly(char *pData, HS_UINT pPos, HS_UINT pMax, char pToken);
HS_UINT SipFindNextTokenOnlyEx(char *pData, HS_UINT pPos, HS_UINT pMax, char *pToken);
HS_UINT SipFindEndOfClause(char *pData, HS_UINT pPos, HS_UINT pMax);
HS_UINT SipFindStartOfClause(char *pData, HS_UINT pPos, HS_UINT pMax);





/*
 *
 * SIP Message Structures
 *
 */
typedef struct
{
	char		*mVersion;			/*2.0*/
	char		*mTransactionType;	/*udp,tcp,tls..*/
	char		*mProtocol;			/*sip,sips..*/
	char		*mUserName;
	char		*mAddress;			/*ip,dns..*/
	char		*mBranch;
	char		*mReceived;
	char		*mTtl;
	char		*mMaddr;
	char		*mSubject;
	char		*mPort;
	BOOL		mLooseRoute;

	BOOL		mIsVia;				/*Headline, Via header are TRUE*/
} SipUri;


HS_RESULT new_SipUri(void *pObject);
HS_RESULT delete_SipUri(void *pObject);





typedef enum
{
	e_SipMethod_Register,
	e_SipMethod_Invite,
	e_SipMethod_Cancel,
	e_SipMethod_Bye,
	e_SipMethod_Ack,
	e_SipMethod_Refer,
	e_SipMethod_Notify,
	e_SipMethod_Options,
	e_SipMethod_Info,
	e_SipMethod_Prack,
	e_SipMethod_Update,
	e_SipMethod_Subscribe,

	e_SipMethod_Message,
	e_SipMethodMax
} SipMethod;

typedef enum
{
	e_SipResponse_Request=0,
	/*provisional 1xx*/
	e_SipResponse_Trying=100,
	e_SipResponse_Ringing=180,
	e_SipResponse_SessionProgress=183,
	/*successful 2xx*/
	e_SipResponse_Ok=200,
	/*redirection 3xx*/
	e_SipResponse_MultipleChoice=300,
	e_SipResponse_MovedPermanently=301,
	e_SipResponse_MovedTemporary=302,
	e_SipResponse_UseProxy=305,
	e_SipResponse_AlternativeService=380,
	/*request failure 4xx*/
	e_SipResponse_BadRequest=400,
	e_SipResponse_Unauthorized=401,
	e_SipResponse_PaymentRequired=402,
	e_SipResponse_Forbidden=403,
	e_SipResponse_NotFound=404,
	e_SipResponse_MethodNotAllowed=405,
	e_SipResponse_NotAcceptable=406,
	e_SipResponse_ProxyAuthenticationRequired=407,
	e_SipResponse_RequestTimeOut=408,
	e_SipResponse_Gone=410,
	e_SipResponse_RequestEntityTooLarge=413,
	e_SipResponse_Request_URITooLong=414,
	e_SipResponse_UnsupportedMediaType=415,
	e_SipResponse_UnsupportedURIScheme=416,
	e_SipResponse_BadExtension=420,
	e_SipResponse_ExtensionRequired=421,
	e_SipResponse_IntervalTooBrief=423,
	e_SipResponse_TemporarilyUnavailable=480,
	e_SipResponse_CallDoesNotExist=481,
	e_SipResponse_LoopDetected=482,
	e_SipResponse_TooManyHops=483,
	e_SipResponse_AddressIncomplete=484,
	e_SipResponse_Ambiguous=485,
	e_SipResponse_BusyHere=486,
	e_SipResponse_RequestTerminated=487,
	e_SipResponse_NotAcceptableHere=488,
	e_SipResponse_RequestPending=491,
	e_SipResponse_Undechiperable=493,
	/*server failure 5xx*/
	e_SipResponse_ServerInternalError=500,
	e_SipResponse_NotImplemented=501,
	e_SipResponse_BadGateway=502,
	e_SipResponse_ServiceUnavailable=503,
	e_SipResponse_ServerTime_Out=504,
	e_SipResponse_VersionNotSupported=505,
	e_SipResponse_MessageTooLarge=513,
	/*global failure 6xx*/
	e_SipResponse_BusyEverywhere=600,
	e_SipResponse_Decline=603,
	e_SipResponse_DoesNotExistAnywhere=604,
	e_SipResponse_NotAcceptableEx=606,
	e_SipResponseMax
} SipResponse;


typedef struct
{
	SipResponse	mResponseValue;
	char		*mMethod;
	SipUri		mUri;
} SipHeadLine;


HS_RESULT new_SipHeadLine(void *pObject, SipResponse pResponseValue);
HS_RESULT delete_SipHeadLine(void *pObject);
HS_RESULT SipHeadLine_Encode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipHeadLine_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);
HS_RESULT SipHeadLine_Decode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipHeadLine_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);





/* Not Support Header
*/
typedef struct
{
	char mHeaderName[MAX_HEADER_NAME_SIZE];
	char mCompactHeader;
	char *mInfo;
} SipHeader;


SipHeader *newm_SipHeader();
HS_RESULT new_SipHeader(void *pObject);
HS_RESULT delete_SipHeader(void *pObject);
HS_RESULT SipHeader_Encode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipHeader_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);
HS_RESULT SipHeader_Decode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipHeader_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);





/* RFC 3261 20.1 Accept header
*/
#define HS_ACCEPT_HEADER			"Accept"
#define IS_ACCEPT_HEADER(data,pos)	if( !memcmp(data+pos,HS_ACCEPT_HEADER,strlen(HS_ACCEPT_HEADER)) )
typedef struct
{
	char mHeaderName[MAX_HEADER_NAME_SIZE];
	char mCompactHeader;
	NoLockList mList;	/*char pointer list*/
} SipAccept;


SipAccept *newm_SipAccept();
HS_RESULT new_SipAccept(void *pObject);
HS_RESULT delete_SipAccept(void *pObject);
HS_RESULT SipAccept_Encode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipAccept_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);
HS_RESULT SipAccept_Decode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipAccept_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);





/* RFC 3261 20.2 Accept-Encoding header
*/
#define HS_ACCEPT_ENCODING_HEADER			"Accept-Encoding"
#define IS_ACCEPT_ENCODING_HEADER(data,pos)	if( !memcmp(data+pos,HS_ACCEPT_ENCODING_HEADER,strlen(HS_ACCEPT_ENCODING_HEADER)) )
HS_SAME_STRUCT(SipAccept,SipAcceptEncoding)

/* RFC 3261 20.3 Accept-Language header
*/
#define HS_ACCEPT_LANGUAGE_HEADER		"Accept-Language"
#define IS_ACCEPT_LANGUAGE_HEADER(data,pos)	if( !memcmp(data+pos,HS_ACCEPT_LANGUAGE_HEADER,strlen(HS_ACCEPT_LANGUAGE_HEADER)) )
HS_SAME_STRUCT(SipAccept,SipAcceptLanguage)


/* RFC 3261 20.4 Alert-Info header
*/
#define HS_ALERT_INFO_HEADER			"Alert-Info"
#define IS_ALERT_INFO_HEADER(data,pos)	if( !memcmp(data+pos,HS_ALERT_INFO_HEADER,strlen(HS_ALERT_INFO_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipAlertInfo)


/* RFC 3261 20.5 Allow header
*/
#define HS_ALLOW_HEADER				"Allow"
#define IS_ALLOW_HEADER(data,pos)	if( !memcmp(data+pos,HS_ALLOW_HEADER,strlen(HS_ALLOW_HEADER)) )
HS_SAME_STRUCT(SipAccept,SipAllow)


/* RFC 3261 20.6 Authentication-Info header
*/
#define HS_AUTHENTICATION_INFO_HEADER			"Authentication-Info"
#define IS_AUTHENTICATION_INFO_HEADER(data,pos)	if( !memcmp(data+pos,HS_AUTHENTICATION_INFO_HEADER,strlen(HS_AUTHENTICATION_INFO_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipAuthenticationInfo)





/* RFC 3261 20.7 Authorization header
*/
#define HS_AUTHORIZATION_HEADER				"Authorization"
#define IS_AUTHORIZATION_HEADER(data,pos)	if( !memcmp(data+pos,HS_AUTHORIZATION_HEADER,strlen(HS_AUTHORIZATION_HEADER)) )
typedef struct
{
	char mHeaderName[MAX_HEADER_NAME_SIZE];
	char mCompactHeader;
	char *mType;
	char *mUserName;
	char *mRealm;
	char *mQop;
	char *mNc;
	char *mCnonce;
	char *mNonce;
	char *mOpaque;
	char *mUri;
	char *mResponse;
	char *mStale;
	char *mAlgorithm;
} SipAuthorization;


SipAuthorization *newm_SipAuthorization();
HS_RESULT new_SipAuthorization(void *pObject);
HS_RESULT deletem_SipAuthorization(void *pObject);
HS_RESULT delete_SipAuthorization(void *pObject);
HS_RESULT SipAuthorization_Encode(void *pObject, char *pData, HS_UINT pMax, BOOL pIsRequest);
HS_RESULT SipAuthorization_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax, BOOL pIsRequest);
HS_RESULT SipAuthorization_Decode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipAuthorization_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);





/* RFC 3261 20.8 Call-ID header
*/
#define HS_CALL_ID_HEADER			"Call-ID"
#define IS_CALL_ID_HEADER(data,pos)	if( (data[pos]=='i'&&(data[pos+1]==':'||data[pos+1]==' '||data[pos+1]=='\t')) || !memcmp(data+pos,HS_CALL_ID_HEADER,strlen(HS_CALL_ID_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipCallId)


/* RFC 3261 20.9 Call-Info header
   : Not Supported Yet.
*/
#define HS_CALL_INFO_HEADER				"Call-Info"
#define IS_CALL_INFO_HEADER(data,pos)	if( !memcmp(data+pos,HS_CALL_INFO_HEADER,strlen(HS_CALL_INFO_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipCallInfo)





/* RFC 3261 20.10 Contact header
*/
#define HS_CONTACT_HEADER			"Contact"
#define IS_CONTACT_HEADER(data,pos)	if( (data[pos]=='m'&&(data[pos+1]==':'||data[pos+1]==' '||data[pos+1]=='\t')) || !memcmp(data+pos,HS_CONTACT_HEADER,strlen(HS_CONTACT_HEADER)) )
typedef struct
{
	char		*mDisplayName;
	SipUri		mUri;
	char		*mTag;
	char		*mQ;
	char		*mExpire;
} SipContactUnit;


SipContactUnit *newm_SipContactUnit(BOOL pIsVia);
HS_RESULT new_SipContactUnit(void *pObject, BOOL pIsVia);
HS_RESULT delete_SipContactUnit(void *pObject);
HS_RESULT SipContactUnit_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);
HS_RESULT SipContactUnit_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);


typedef struct
{
	char		mHeaderName[MAX_HEADER_NAME_SIZE];
	char		mCompactHeader;
	BOOL		mIsStar;/* [ Contact: * ] */
	NoLockList	mContactUnits;
} SipContact;


SipContact *newm_SipContact();
HS_RESULT new_SipContact(void *pObject);
HS_RESULT delete_SipContact(void *pObject);
HS_RESULT SipContact_Encode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipContact_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);
HS_RESULT SipContact_Decode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipContact_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);
SipContactUnit* SipContact_GetPrimeContactUnit(void *pObject);
SipContactUnit* SipContacts_GetPrimeContactUnit(NoLockList *pList);





/* RFC 3261 20.11 Content-Disposition header
   : Not Supported Yet.
*/
#define HS_CONTENT_DISPOSITION_HEADER			"Content-Disposition"
#define IS_CONTENT_DISPOSITION_HEADER(data,pos)	if( !memcmp(data+pos,HS_CONTENT_DISPOSITION_HEADER,strlen(HS_CONTENT_DISPOSITION_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipContentDisposition)


/* RFC 3261 20.12 Content-Encoding header
   : Not Supported Yet.
*/
#define HS_CONTENT_ENCODING_HEADER				"Content-Encoding"
#define IS_CONTENT_ENCODING_HEADER(data,pos)	if( (data[pos]=='e'&&(data[pos+1]==':'||data[pos+1]==' '||data[pos+1]=='\t')) || !memcmp(data+pos,HS_CONTENT_ENCODING_HEADER,strlen(HS_CONTENT_ENCODING_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipContentEncoding)


/* RFC 3261 20.13 Content-Language header
   : Not Supported Yet.
*/
#define HS_CONTENT_LANGUAGE_HEADER				"Content-Language"
#define IS_CONTENT_LANGUAGE_HEADER(data,pos)	if( !memcmp(data+pos,HS_CONTENT_LANGUAGE_HEADER,strlen(HS_CONTENT_LANGUAGE_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipContentLanguage)


/* RFC 3261 20.14 Content-Length header
*/
#define HS_CONTENT_LENGTH_HEADER			"Content-Length"
#define IS_CONTENT_LENGTH_HEADER(data,pos)	if( (data[pos]=='l'&&(data[pos+1]==':'||data[pos+1]==' '||data[pos+1]=='\t')) || !memcmp(data+pos,HS_CONTENT_LENGTH_HEADER,strlen(HS_CONTENT_LENGTH_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipContentLength)


/* RFC 3261 20.15 Content-Type header
*/
#define HS_CONTENT_TYPE_HEADER			"Content-Type"
#define IS_CONTENT_TYPE_HEADER(data,pos)	if( (data[pos]=='c'&&(data[pos+1]==':'||data[pos+1]==' '||data[pos+1]=='\t')) || !memcmp(data+pos,HS_CONTENT_TYPE_HEADER,strlen(HS_CONTENT_TYPE_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipContentType)





/* RFC 3261 20.16 CSeq header
*/
#define HS_CSEQ_HEADER				"CSeq"
#define IS_CSEQ_HEADER(data,pos)	if( !memcmp(data+pos,HS_CSEQ_HEADER,strlen(HS_CSEQ_HEADER)) )
typedef struct
{
	char		mHeaderName[MAX_HEADER_NAME_SIZE];
	char		mCompactHeader;
	char		*mNumber;
	char		*mMethod;
} SipCSeq;


SipCSeq *newm_SipCSeq();
HS_RESULT new_SipCSeq(void *pObject);
HS_RESULT delete_SipCSeq(void *pObject);
HS_RESULT SipCSeq_Encode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipCSeq_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);
HS_RESULT SipCSeq_Decode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipCSeq_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);





/* RFC 3261 20.17 Date header
*/
#define HS_DATE_HEADER			"Date"
#define IS_DATE_HEADER(data,pos)	if( !memcmp(data+pos,HS_DATE_HEADER,strlen(HS_DATE_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipDate)


/* RFC 3261 20.18 Error-Info header
   : Not Support Yet.
*/
#define HS_ERROR_INFO_HEADER			"Error-Info"
#define IS_ERROR_INFO_HEADER(data,pos)	if( !memcmp(data+pos,HS_ERROR_INFO_HEADER,strlen(HS_ERROR_INFO_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipErrorInfo)


/* RFC 3261 20.19 Expires header
*/
#define HS_EXPIRES_HEADER			"Expires"
#define IS_EXPIRES_HEADER(data,pos)	if( !memcmp(data+pos,HS_EXPIRES_HEADER,strlen(HS_EXPIRES_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipExpires)


/* RFC 3261 20.20 From header
*/
#define HS_FROM_HEADER				"From"
#define IS_FROM_HEADER(data,pos)	if( (data[pos]=='f'&&(data[pos+1]==':'||data[pos+1]==' '||data[pos+1]=='\t')) || !memcmp(data+pos,HS_FROM_HEADER,strlen(HS_FROM_HEADER)) )
HS_SAME_STRUCT(SipContact,SipFrom)
SipContactUnit *SipFrom_GetPrimeContactUnit(void *pObject);


/* RFC 3261 20.21 In-Reply-To header
   : Not Support Yet
*/
#define HS_IN_REPLY_TO_HEADER			"In-Reply-To"
#define IS_IN_REPLY_TO_HEADER(data,pos)	if( !memcmp(data+pos,HS_IN_REPLY_TO_HEADER,strlen(HS_IN_REPLY_TO_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipInReplyTo)


/* RFC 3261 20.22 Max-Forwards header
*/
#define HS_MAX_FORWARDS_HEADER				"Max-Forwards"
#define IS_MAX_FORWARDS_HEADER(data,pos)	if( !memcmp(data+pos,HS_MAX_FORWARDS_HEADER,strlen(HS_MAX_FORWARDS_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipMaxForwards)


/* RFC 3261 20.23 Min-Expires header
*/
#define HS_MIN_EXPIRES_HEADER			"Min-Expires"
#define IS_MIN_EXPIRES_HEADER(data,pos)	if( !memcmp(data+pos,HS_MIN_EXPIRES_HEADER,strlen(HS_MIN_EXPIRES_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipMinExpires)


/* RFC 3261 20.24 MIME-Version header
*/
#define HS_MIME_VERSION_HEADER				"MIME-Version"
#define IS_MIME_VERSION_HEADER(data,pos)	if( !memcmp(data+pos,HS_MIME_VERSION_HEADER,strlen(HS_MIME_VERSION_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipMIMEVersion)


/* RFC 3261 20.25 Organization header
*/
#define HS_ORGANIZATION_HEADER				"Organization"
#define IS_ORGANIZATION_HEADER(data,pos)	if( !memcmp(data+pos,HS_ORGANIZATION_HEADER,strlen(HS_ORGANIZATION_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipOrganization)


/* RFC 3261 20.26 Priority header
*/
#define HS_PRIORITY_HEADER				"Priority"
#define IS_PRIORITY_HEADER(data,pos)	if( !memcmp(data+pos,HS_PRIORITY_HEADER,strlen(HS_PRIORITY_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipPriority)


/* RFC 3261 20.27 Proxy-Authenticate header
*/
#define HS_PROXY_AUTHENTICATE_HEADER			"Proxy-Authenticate"
#define IS_PROXY_AUTHENTICATE_HEADER(data,pos)	if( !memcmp(data+pos,HS_PROXY_AUTHENTICATE_HEADER,strlen(HS_PROXY_AUTHENTICATE_HEADER)) )
HS_SAME_STRUCT_EX(SipAuthorization,SipProxyAuthenticate)


/* RFC 3261 20.28 Proxy-Authorization header
*/
#define HS_PROXY_AUTHORIZATION_HEADER			"Proxy-Authorization"
#define IS_PROXY_AUTHORIZATION_HEADER(data,pos)	if( !memcmp(data+pos,HS_PROXY_AUTHORIZATION_HEADER,strlen(HS_PROXY_AUTHORIZATION_HEADER)) )
HS_SAME_STRUCT_EX(SipAuthorization,SipProxyAuthorization)


/* RFC 3261 20.29 Proxy-Require header
*/
#define HS_PROXY_REQUIRE_HEADER				"Proxy-Require"
#define IS_PROXY_REQUIRE_HEADER(data,pos)	if( !memcmp(data+pos,HS_PROXY_REQUIRE_HEADER,strlen(HS_PROXY_REQUIRE_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipProxyRequire)


/* RFC 3261 20.30 Record-Route header
*/
#define HS_RECORD_ROUTE_HEADER				"Record-Route"
#define IS_RECORD_ROUTE_HEADER(data,pos)	if( !memcmp(data+pos,HS_RECORD_ROUTE_HEADER,strlen(HS_RECORD_ROUTE_HEADER)) )
HS_SAME_STRUCT(SipContact,SipRecordRoute)
SipContactUnit *SipRecordRoute_GetPrimeContactUnit(void *pObject);
SipContactUnit *SipRecordRoutes_GetPrimeContactUnit(NoLockList *pList);


/* RFC 3261 20.31 Reply-To header
*/
#define HS_REPLY_TO_HEADER				"Reply-To"
#define IS_REPLY_TO_HEADER(data,pos)	if( !memcmp(data+pos,HS_REPLY_TO_HEADER,strlen(HS_REPLY_TO_HEADER)) )
HS_SAME_STRUCT(SipContact,SipReplyTo)


/* RFC 3261 20.32 Require header
*/
#define HS_REQUIRE_HEADER				"Require"
#define IS_REQUIRE_HEADER(data,pos)		if( !memcmp(data+pos,HS_REQUIRE_HEADER,strlen(HS_REQUIRE_HEADER)) )
HS_SAME_STRUCT(SipAccept,SipRequire)


/* RFC 3261 20.33 Retry-After header
   : Not Supported Yet
*/
#define HS_RETRY_AFTER_HEADER			"Retry-After"
#define IS_RETRY_AFTER_HEADER(data,pos)	if( !memcmp(data+pos,HS_RETRY_AFTER_HEADER,strlen(HS_RETRY_AFTER_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipRetryAfter)


/* RFC 3261 20.34 Route header
   : Not Supported Yet
*/
#define HS_ROUTE_HEADER				"Route"
#define IS_ROUTE_HEADER(data,pos)	if( !memcmp(data+pos,HS_ROUTE_HEADER,strlen(HS_ROUTE_HEADER)) )
HS_SAME_STRUCT(SipContact,SipRoute)


/* RFC 3261 20.35 Server header
   : Not Supported Yet
*/
#define HS_SERVER_HEADER			"Server"
#define IS_SERVER_HEADER(data,pos)	if( !memcmp(data+pos,HS_SERVER_HEADER,strlen(HS_SERVER_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipServer)


/* RFC 3261 20.36 Subject header
   : Not Supported Yet
*/
#define HS_SUBJECT_HEADER			"Subject"
#define IS_SUBJECT_HEADER(data,pos)	if( (data[pos]=='s'&&(data[pos+1]==':'||data[pos+1]==' '||data[pos+1]=='\t')) || !memcmp(data+pos,HS_SERVER_HEADER,strlen(HS_SERVER_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipSubject)


/* RFC 3261 20.37 Supported header
   : Not Supported Yet
*/
#define HS_SUPPORTED_HEADER				"Supported"
#define IS_SUPPORTED_HEADER(data,pos)	if( !memcmp(data+pos,HS_SUPPORTED_HEADER,strlen(HS_SUPPORTED_HEADER)) )
HS_SAME_STRUCT(SipAccept,SipSupported)


/* RFC 3261 20.38 TimeStamp header
*/
#define HS_TIMESTAMP_HEADER				"Timestamp"
#define IS_TIMESTAMP_HEADER(data,pos)	if( !memcmp(data+pos,HS_TIMESTAMP_HEADER,strlen(HS_TIMESTAMP_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipTimestamp)


/* RFC 3261 20.39 To header
*/
#define HS_TO_HEADER					"To"
#define IS_TO_HEADER(data,pos)	if( (data[pos]=='t'&&(data[pos+1]==':'||data[pos+1]==' '||data[pos+1]=='\t')) || !memcmp(data+pos,HS_TO_HEADER,strlen(HS_TO_HEADER)) )
HS_SAME_STRUCT(SipContact,SipTo)
SipContactUnit *SipTo_GetPrimeContactUnit(void *pObject);


/* RFC 3261 20.40 Unsupported header
*/
#define HS_UNSUPPORTED_HEADER			"Unsupported"
#define IS_UNSUPPORTED_HEADER(data,pos)	if( !memcmp(data+pos,HS_UNSUPPORTED_HEADER,strlen(HS_UNSUPPORTED_HEADER)) )
HS_SAME_STRUCT(SipAccept,SipUnsupported)


/* RFC 3261 20.41 User-Agent header
*/
#define HS_USER_AGENT_HEADER			"User-Agent"
#define IS_USER_AGENT_HEADER(data,pos)	if( !memcmp(data+pos,HS_USER_AGENT_HEADER,strlen(HS_USER_AGENT_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipUserAgent)


/* RFC 3261 20.42 Via header
*/
#define HS_VIA_HEADER			"Via"
#define IS_VIA_HEADER(data,pos)	if( (data[pos]=='v'&&(data[pos+1]==':'||data[pos+1]==' '||data[pos+1]=='\t')) || !memcmp(data+pos,HS_VIA_HEADER,strlen(HS_VIA_HEADER)) )
HS_SAME_STRUCT(SipContact,SipVia)


/* RFC 3261 20.43 Warning header
*/
#define HS_WARNING_HEADER		"Warning"
#define IS_WARNING_HEADER(data,pos)	if( !memcmp(data+pos,HS_WARNING_HEADER,strlen(HS_WARNING_HEADER)) )
HS_SAME_STRUCT(SipHeader,SipWarning)


/* RFC 3261 20.44 WWW-Authenticate header
*/
#define HS_WWW_AUTHENTICATE_HEADER	"WWW-Authenticate"
#define IS_WWW_AUTHENTICATE_HEADER(data,pos)	if( !memcmp(data+pos,HS_WWW_AUTHENTICATE_HEADER,strlen(HS_WWW_AUTHENTICATE_HEADER)) )
HS_SAME_STRUCT_EX(SipAuthorization,SipWWWAuthenticate)





#endif/*__2005_10_13__23_00__SIPHEADER_H__*/

