/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipMessage.c>		2005-10-19,00:13

*/

#include "SipMessage.h"





SipMessage *newm_SipMessage()
{
	SipMessage *pObj = NULL;

	if( (pObj=(SipMessage*)HSMalloc(sizeof(SipMessage)))==NULL ) return NULL;
	if( new_SipMessage(pObj) != HS_OK )
	{
		HSFree(pObj);
		return NULL;
	}
	return pObj;
}


HS_RESULT new_SipMessage(void *pObject)
{
	SipMessage *pObj = (SipMessage*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	new_SipHeadLine(&(pObj->mHeadLine),e_SipResponseMax);
	pObj->mAllow = NULL;
	pObj->mAuthenticationInfo = NULL;
	pObj->mAuthorization = NULL;
	pObj->mCallId = NULL;
	new_NoLockList(&(pObj->mContacts),delete_SipContact);
	pObj->mContentEncoding = NULL;
	pObj->mContentLanguage = NULL;
	pObj->mContentLength = NULL;
	pObj->mCSeq = NULL;
	pObj->mExpires = NULL;
	pObj->mFrom = NULL;
	pObj->mMaxForwards = NULL;
	pObj->mMinExpires = NULL;
	pObj->mProxyAuthenticate = NULL;
	pObj->mProxyAuthorization = NULL;
	new_NoLockList(&(pObj->mRecordRoutes),delete_SipRecordRoute);
	pObj->mReplyTo = NULL;
	new_NoLockList(&(pObj->mRoutes),delete_SipRoute);
	pObj->mTo = NULL;
	pObj->mUserAgent = NULL;
	new_NoLockList(&(pObj->mVias),delete_SipVia);
	pObj->mWWWAuthenticate = NULL;
	pObj->mContentType = NULL;
	pObj->mSupported = NULL;

#ifdef HS_SIP_ALL_HEADER
	pObj->mAccept = NULL;
	pObj->mAcceptEncoding = NULL;
	pObj->mAcceptLanguage = NULL;
	pObj->mAlertInfo = NULL;
	pObj->mCallInfo = NULL;
	pObj->mContentDisposition = NULL;
	pObj->mDate = NULL;
	pObj->mErrorInfo = NULL;
	pObj->mInReplyTo = NULL;
	pObj->mMIMEVersion = NULL;
	pObj->mOrganization = NULL;
	pObj->mPriority = NULL;
	pObj->mProxyRequire = NULL;
	pObj->mRequire = NULL;
	pObj->mRetryAfter = NULL;
	pObj->mServer = NULL;
	pObj->mSubject = NULL;
	pObj->mTimestamp = NULL;
	pObj->mUnsupported = NULL;
	pObj->mWarning = NULL;
#endif/*HS_SIP_ALL_HEADER*/

	pObj->mBody = NULL;
	pObj->mBodyLen = 0;
	return HS_OK;
}


BOOL SipMessage_IsRequest(void *pObject)
{
	SipMessage *pObj = (SipMessage*)pObject;

	if( pObj==NULL ) return FALSE;

	if( pObj->mHeadLine.mResponseValue == e_SipResponse_Request )
		return TRUE;
	return FALSE;
}


char *SipMessage_GetBranchId(void *pObject)
{
	ChainUnit *tChain = NULL;
	SipContactUnit *tUnit =NULL;
	SipVia *tVia = NULL;

	SipMessage *pObj = (SipMessage*)pObject;

	if( pObj==NULL ) return FALSE;

	if( pObj->mVias.size == 0 ) return NULL;
	tChain = pObj->mVias.units;
	if( tChain==NULL ) return NULL;
	if( (tVia=(SipVia*)(tChain->data))==NULL ) return NULL;

	if( tVia->mContactUnits.size == 0 ) return NULL;
	tChain = tVia->mContactUnits.units;
	if( tChain==NULL ) return NULL;
	if( (tUnit=(SipContactUnit*)(tChain->data))==NULL ) return NULL;

	return tUnit->mUri.mBranch;
}


#define DELETE_SIPHEADER(header)				\
	if( pObj->m##header != NULL )				\
	{											\
		delete_Sip##header(pObj->m##header);	\
		HSFree(pObj->m##header);					\
		pObj->m##header;						\
	}

HS_RESULT delete_SipMessage(void *pObject)
{
	SipMessage *pObj = (SipMessage*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	delete_SipHeadLine(&(pObj->mHeadLine));
	DELETE_SIPHEADER(Allow)
	DELETE_SIPHEADER(AuthenticationInfo)
	DELETE_SIPHEADER(Authorization)
	DELETE_SIPHEADER(CallId)
	delete_NoLockList(&(pObj->mContacts));
	DELETE_SIPHEADER(ContentEncoding)
	DELETE_SIPHEADER(ContentLanguage)
	DELETE_SIPHEADER(ContentLength)
	DELETE_SIPHEADER(CSeq)
	DELETE_SIPHEADER(Expires)
	DELETE_SIPHEADER(From)
	DELETE_SIPHEADER(MaxForwards)
	DELETE_SIPHEADER(MinExpires)
	DELETE_SIPHEADER(ProxyAuthenticate)
	DELETE_SIPHEADER(ProxyAuthorization)
	delete_NoLockList(&(pObj->mRecordRoutes));
	DELETE_SIPHEADER(ReplyTo)
	delete_NoLockList(&(pObj->mRoutes));
	DELETE_SIPHEADER(To)
	DELETE_SIPHEADER(UserAgent)
	delete_NoLockList(&(pObj->mVias));
	DELETE_SIPHEADER(WWWAuthenticate)
	DELETE_SIPHEADER(ContentType)
	DELETE_SIPHEADER(Supported)

#ifdef HS_SIP_ALL_HEADER
	DELETE_SIPHEADER(Accept)
	DELETE_SIPHEADER(AcceptEncoding)
	DELETE_SIPHEADER(AcceptLanguage)
	DELETE_SIPHEADER(AlertInfo)
	DELETE_SIPHEADER(CallInfo)
	DELETE_SIPHEADER(ContentDisposition)
	DELETE_SIPHEADER(Date)
	DELETE_SIPHEADER(ErrorInfo)
	DELETE_SIPHEADER(InReplyTo)
	DELETE_SIPHEADER(MIMEVersion)
	DELETE_SIPHEADER(Organization)
	DELETE_SIPHEADER(Priority)
	DELETE_SIPHEADER(ProxyRequire)
	DELETE_SIPHEADER(Require)
	DELETE_SIPHEADER(RetryAfter)
	DELETE_SIPHEADER(Server)
	DELETE_SIPHEADER(Subject)
	DELETE_SIPHEADER(Timestamp)
	DELETE_SIPHEADER(Unsupported)
	DELETE_SIPHEADER(Warning)
#endif/*HS_SIP_ALL_HEADER*/

	if( pObj->mBody != NULL )	{	HSFree(pObj->mBody);	pObj->mBody=NULL;			}
	pObj->mBodyLen = 0;
	return HS_OK;
}


HS_RESULT SipMessage_Encode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipMessage_EncodeEx(pObject,pData,&tPos,pMax);
}


HS_RESULT SipMessage_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipMessage *pObj = (SipMessage*)pObject;
	HS_UINT i;
	HS_RESULT tRet;
	BOOL tIsRequest = TRUE;
	ChainUnit *tChain = NULL;
	SipVia *tVia = NULL;
	SipRoute *tRoute = NULL;
	SipRecordRoute *tRecordRoute = NULL;
	SipContact *tContact = NULL;


	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;

	tIsRequest = SipMessage_IsRequest(pObj);

	HS_TRY( SipHeadLine_EncodeEx(&(pObj->mHeadLine),pData,pPos,pMax) );

	tChain = pObj->mVias.units;
	for( i=0; i<pObj->mVias.size; i++ )
	{
		if( tChain==NULL )
			return HS_ERR_CONFLICT;
		if( (tVia=(SipVia*)(tChain->data))==NULL )
			return HS_ERR_CONFLICT;

		HS_TRY( SipVia_EncodeEx(tVia,pData,pPos,pMax) );
		tChain = (ChainUnit*)(tChain->next);
	}
	if( pObj->mMaxForwards != NULL )
	{
		HS_TRY( SipMaxForwards_EncodeEx(pObj->mMaxForwards,pData,pPos,pMax) );
	}
	if( pObj->mMinExpires != NULL )
	{
		HS_TRY( SipMinExpires_EncodeEx(pObj->mMinExpires,pData,pPos,pMax) );
	}

	tChain = pObj->mRoutes.units;
	for( i=0; i<pObj->mRoutes.size; i++ )
	{
		if( tChain==NULL )
			return HS_ERR_CONFLICT;
		if( (tRoute=(SipRoute*)(tChain->data))==NULL )
			return HS_ERR_CONFLICT;

		HS_TRY( SipRoute_EncodeEx(tRoute,pData,pPos,pMax) );
		tChain = (ChainUnit*)(tChain->next);
	}

	tChain = pObj->mRecordRoutes.units;
	for( i=0; i<pObj->mRecordRoutes.size; i++ )
	{
		if( tChain==NULL )
			return HS_ERR_CONFLICT;
		if( (tRecordRoute=(SipRecordRoute*)(tChain->data))==NULL )
			return HS_ERR_CONFLICT;

		HS_TRY( SipRecordRoute_EncodeEx(tRecordRoute,pData,pPos,pMax) );
		tChain = (ChainUnit*)(tChain->data);
	}

	if( pObj->mFrom != NULL )
	{
		HS_TRY( SipFrom_EncodeEx(pObj->mFrom,pData,pPos,pMax) );
	}
	if( pObj->mTo != NULL )
	{
		HS_TRY( SipTo_EncodeEx(pObj->mTo,pData,pPos,pMax) );
	}
	if( pObj->mReplyTo != NULL )
	{
		HS_TRY( SipReplyTo_EncodeEx(pObj->mReplyTo,pData,pPos,pMax) );
	}
	if( pObj->mCallId != NULL )
	{
		HS_TRY( SipCallId_EncodeEx(pObj->mCallId,pData,pPos,pMax) );
	}
	if( pObj->mCSeq != NULL )
	{
		HS_TRY( SipCSeq_EncodeEx(pObj->mCSeq,pData,pPos,pMax) );
	}

	tChain = pObj->mContacts.units;
	for( i=0; i<pObj->mContacts.size; i++ )
	{
		if( tChain==NULL )
			return HS_ERR_CONFLICT;
		if( (tContact=(SipContact*)(tChain->data))==NULL )
			return HS_ERR_CONFLICT;

		HS_TRY( SipContact_EncodeEx(tContact,pData,pPos,pMax) );
		tChain = (ChainUnit*)(tChain->next);
	}

	if( pObj->mExpires != NULL )
	{
		HS_TRY( SipExpires_EncodeEx(pObj->mExpires,pData,pPos,pMax) );
	}
	if( pObj->mUserAgent != NULL )
	{
		HS_TRY( SipUserAgent_EncodeEx(pObj->mUserAgent,pData,pPos,pMax) );
	}
	if( pObj->mAllow != NULL )
	{
		HS_TRY( SipAllow_EncodeEx(pObj->mAllow,pData,pPos,pMax) );
	}
	if( pObj->mSupported != NULL )
	{
		HS_TRY( SipSupported_EncodeEx(pObj->mSupported,pData,pPos,pMax) );
	}
	if( pObj->mAuthenticationInfo != NULL )
	{
		HS_TRY( SipAuthenticationInfo_EncodeEx(pObj->mAuthenticationInfo,pData,pPos,pMax) );
	}
	if( pObj->mProxyAuthenticate != NULL )
	{
		HS_TRY( SipProxyAuthenticate_EncodeEx(pObj->mProxyAuthenticate,pData,pPos,pMax,tIsRequest) );
	}
	if( pObj->mProxyAuthorization != NULL )
	{
		HS_TRY( SipProxyAuthorization_EncodeEx(pObj->mProxyAuthorization,pData,pPos,pMax,tIsRequest) );
	}
	if( pObj->mWWWAuthenticate != NULL )
	{
		HS_TRY( SipWWWAuthenticate_EncodeEx(pObj->mWWWAuthenticate,pData,pPos,pMax,tIsRequest) );
	}
	if( pObj->mAuthorization != NULL )
	{
		HS_TRY( SipAuthorization_EncodeEx(pObj->mAuthorization,pData,pPos,pMax,tIsRequest) );
	}

#ifdef HS_SIP_ALL_HEADER
	if( pObj->mAccept != NULL )
	{
		HS_TRY( SipAccept_EncodeEx(pObj->mAccept,pData,pPos,pMax) );
	}
	if( pObj->mAcceptEncoding != NULL )
	{
		HS_TRY( SipAcceptEncoding_EncodeEx(pObj->mAcceptEncoding,pData,pPos,pMax) );
	}
	if( pObj->mAcceptLanguage != NULL )
	{
		HS_TRY( SipAcceptLanguage_EncodeEx(pObj->mAcceptLanguage,pData,pPos,pMax) );
	}
	if( pObj->mAlertInfo != NULL )
	{
		HS_TRY( SipAlertInfo_EncodeEx(pObj->mAlertInfo,pData,pPos,pMax) );
	}
	if( pObj->mCallInfo != NULL )
	{
		HS_TRY( SipCallInfo_EncodeEx(pObj->mCallInfo,pData,pPos,pMax) );
	}
	if( pObj->mContentDisposition != NULL )
	{
		HS_TRY( SipContentDisposition_EncodeEx(pObj->mContentDisposition,pData,pPos,pMax) );
	}
	if( pObj->mDate != NULL )
	{
		HS_TRY( SipDate_EncodeEx(pObj->mDate,pData,pPos,pMax) );
	}
	if( pObj->mErrorInfo != NULL )
	{
		HS_TRY( SipErrorInfo_EncodeEx(pObj->mErrorInfo,pData,pPos,pMax) );
	}
	if( pObj->mInReplyTo != NULL )
	{
		HS_TRY( SipInReplyTo_EncodeEx(pObj->mInReplyTo,pData,pPos,pMax) );
	}
	if( pObj->mMIMEVersion != NULL )
	{
		HS_TRY( SipMIMEVersion_EncodeEx(pObj->mMIMEVersion,pData,pPos,pMax) );
	}
	if( pObj->mOrganization != NULL )
	{
		HS_TRY( SipOrganization_EncodeEx(pObj->mOrganization,pData,pPos,pMax) );
	}
	if( pObj->mPriority != NULL )
	{
		HS_TRY( SipPriority_EncodeEx(pObj->mPriority,pData,pPos,pMax) );
	}
	if( pObj->mProxyRequire != NULL )
	{
		HS_TRY( SipProxyRequire_EncodeEx(pObj->mProxyRequire,pData,pPos,pMax) );
	}
	if( pObj->mRequire != NULL )
	{
		HS_TRY( SipRequire_EncodeEx(pObj->mRequire,pData,pPos,pMax) );
	}
	if( pObj->mRetryAfter != NULL )
	{
		HS_TRY( SipRetryAfter_EncodeEx(pObj->mRetryAfter,pData,pPos,pMax) );
	}
	if( pObj->mServer != NULL )
	{
		HS_TRY( SipServer_EncodeEx(pObj->mServer,pData,pPos,pMax) );
	}
	if( pObj->mSubject != NULL )
	{
		HS_TRY( SipSubject_EncodeEx(pObj->mSubject,pData,pPos,pMax) );
	}
	if( pObj->mTimestamp != NULL )
	{
		HS_TRY( SipTimestamp_EncodeEx(pObj->mTimestamp,pData,pPos,pMax) );
	}
	if( pObj->mUnsupported != NULL )
	{
		HS_TRY( SipUnsupported_EncodeEx(pObj->mUnsupported,pData,pPos,pMax) );
	}
	if( pObj->mWarning != NULL )
	{
		HS_TRY( SipWarning_EncodeEx(pObj->mWarning,pData,pPos,pMax) );
	}
#endif/*HS_SIP_ALL_HEADER*/

	if( pObj->mContentEncoding != NULL )
	{
		HS_TRY( SipContentEncoding_EncodeEx(pObj->mContentEncoding,pData,pPos,pMax) );
	}
	if( pObj->mContentLanguage != NULL )
	{
		HS_TRY( SipContentLanguage_EncodeEx(pObj->mContentLanguage,pData,pPos,pMax) );
	}
	if( pObj->mContentType != NULL )
	{
		HS_TRY( SipContentType_EncodeEx(pObj->mContentType,pData,pPos,pMax) );
	}
	if( pObj->mContentLength != NULL )
	{
		HS_TRY( SipContentLength_EncodeEx(pObj->mContentLength,pData,pPos,pMax) );
	}

	HS_CHECK_OVER(*pPos,2,pMax);
	strcpy(pData+(*pPos),HS_SIP_END_OF_LINE);
	*pPos += 2;

	if( pObj->mBody != NULL && pObj->mBodyLen != 0 )
	{
		HS_CHECK_OVER(*pPos,pObj->mBodyLen,pMax);
		memcpy(pData+*pPos,pObj->mBody,pObj->mBodyLen);
		*pPos += pObj->mBodyLen;
	}
	return HS_OK;
}


HS_RESULT SipMessage_Decode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SipMessage_DecodeEx(pObject,pData,&tPos,pMax);
}


#define HS_SIP_DECODE(tName)														\
{																					\
	if( (pObj->m##tName=(Sip##tName*)HSMalloc(sizeof(Sip##tName)))==NULL )			\
		return HS_ERR_MALLOC;														\
	new_Sip##tName(pObj->m##tName);													\
	if( (tRet=Sip##tName##_DecodeEx(pObj->m##tName,pData,pPos,tEndLinePos))!=HS_OK )\
		return tRet;																\
}

HS_RESULT SipMessage_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	SipMessage *pObj = (SipMessage*)pObject;
	HS_RESULT tRet;
	HS_UINT tEndLinePos=0;
	SipVia *tVia = NULL;
	SipRoute *tRoute = NULL;
	SipRecordRoute *tRecordRoute = NULL;
	SipContact *tContact = NULL;


	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;

	/* headline decode
	*/
	if( (tEndLinePos=SipFindEndOfLine(pData,*pPos,pMax)) == HS_INVALID_POS )
		return HS_ERR_SIP;
	tEndLinePos += (*pPos+2);
	if( tEndLinePos>pMax ) return HS_ERR_SIP;

	HS_TRY( SipHeadLine_DecodeEx(&(pObj->mHeadLine),pData,pPos,tEndLinePos) );

	/* header decode
	*/
	while(*pPos<pMax)
	{
		if( (tEndLinePos=SipFindEndOfLine(pData,*pPos,pMax)) == HS_INVALID_POS )
			return HS_ERR_SIP;
		tEndLinePos += (*pPos+2);
		if( tEndLinePos>pMax ) return HS_ERR_SIP;

		IS_VIA_HEADER(pData,*pPos)
		{
			if( (tVia=(SipVia*)HSMalloc(sizeof(SipVia)))==NULL )
				return HS_ERR_MALLOC;
			new_SipVia(tVia);
			if( (tRet=SipVia_DecodeEx(tVia,pData,pPos,pMax)) != HS_OK )
			{
				delete_SipVia(tVia);
				HSFree(tVia);
				return tRet;
			}
			NoLockList_AttachData(&(pObj->mVias),tVia);
		}

		else IS_MAX_FORWARDS_HEADER(pData,*pPos)
			HS_SIP_DECODE(MaxForwards)
		else IS_MIN_EXPIRES_HEADER(pData,*pPos)
			HS_SIP_DECODE(MinExpires)

		else IS_ROUTE_HEADER(pData,*pPos)
		{
			if( (tRoute=(SipRoute*)HSMalloc(sizeof(SipRoute)))==NULL )
				return HS_ERR_MALLOC;
			new_SipRoute(tRoute);
			if( (tRet=SipRoute_DecodeEx(tRoute,pData,pPos,pMax)) != HS_OK )
			{
				delete_SipRoute(tRoute);
				HSFree(tRoute);
				return tRet;
			}
			NoLockList_AttachData(&(pObj->mRoutes),tRoute);
		}
		else IS_RECORD_ROUTE_HEADER(pData,*pPos)
		{
			if( (tRecordRoute=(SipRecordRoute*)HSMalloc(sizeof(SipRecordRoute)))==NULL )
				return HS_ERR_MALLOC;
			new_SipRecordRoute(tRecordRoute);
			if( (tRet=SipRecordRoute_DecodeEx(tRecordRoute,pData,pPos,pMax)) != HS_OK )
			{
				delete_SipRecordRoute(tRecordRoute);
				HSFree(tRecordRoute);
				return tRet;
			}
			NoLockList_AttachData(&(pObj->mRecordRoutes),tRecordRoute);
		}

		else IS_FROM_HEADER(pData,*pPos)
			HS_SIP_DECODE(From)
		else IS_TO_HEADER(pData,*pPos)
			HS_SIP_DECODE(To)
		else IS_REPLY_TO_HEADER(pData,*pPos)
			HS_SIP_DECODE(ReplyTo)
		else IS_CALL_ID_HEADER(pData,*pPos)
			HS_SIP_DECODE(CallId)
		else IS_CSEQ_HEADER(pData,*pPos)
			HS_SIP_DECODE(CSeq)

		else IS_CONTACT_HEADER(pData,*pPos)
		{
			if( (tContact=(SipContact*)HSMalloc(sizeof(SipContact)))==NULL )
				return HS_ERR_MALLOC;
			new_SipContact(tContact);
			if( (tRet=SipContact_DecodeEx(tContact,pData,pPos,pMax)) != HS_OK )
			{
				delete_SipContact(tContact);
				HSFree(tContact);
				return tRet;
			}
			NoLockList_AttachData(&(pObj->mContacts),tContact);
		}

		else IS_EXPIRES_HEADER(pData,*pPos)
			HS_SIP_DECODE(Expires)
		else IS_USER_AGENT_HEADER(pData,*pPos)
			HS_SIP_DECODE(UserAgent)
		else IS_ALLOW_HEADER(pData,*pPos)
			HS_SIP_DECODE(Allow)
		else IS_SUPPORTED_HEADER(pData,*pPos)
			HS_SIP_DECODE(Supported)
		else IS_AUTHENTICATION_INFO_HEADER(pData,*pPos)
			HS_SIP_DECODE(AuthenticationInfo)
		else IS_PROXY_AUTHENTICATE_HEADER(pData,*pPos)
			HS_SIP_DECODE(ProxyAuthenticate)
		else IS_PROXY_AUTHORIZATION_HEADER(pData,*pPos)
			HS_SIP_DECODE(ProxyAuthorization)
		else IS_WWW_AUTHENTICATE_HEADER(pData,*pPos)
			HS_SIP_DECODE(WWWAuthenticate)
		else IS_AUTHORIZATION_HEADER(pData,*pPos)
			HS_SIP_DECODE(Authorization)

#ifdef HS_SIP_ALL_HEADER
		else IS_ACCEPT_HEADER(pData,*pPos)
			HS_SIP_DECODE(Accept)
		else IS_ACCEPT_ENCODING_HEADER(pData,*pPos)
			HS_SIP_DECODE(AcceptEncoding)
		else IS_ACCEPT_LANGUAGE_HEADER(pData,*pPos)
			HS_SIP_DECODE(AcceptLanguage)
		else IS_ALERT_INFO_HEADER(pData,*pPos)
			HS_SIP_DECODE(AlertInfo)
		else IS_CALL_INFO_HEADER(pData,*pPos)
			HS_SIP_DECODE(CallInfo)

		else IS_CONTENT_DISPOSITION_HEADER(pData,*pPos)
			HS_SIP_DECODE(ContentDisposition)
		else IS_DATE_HEADER(pData,*pPos)
			HS_SIP_DECODE(Date)
		else IS_ERROR_INFO_HEADER(pData,*pPos)
			HS_SIP_DECODE(ErrorInfo)
		else IS_IN_REPLY_TO_HEADER(pData,*pPos)
			HS_SIP_DECODE(InReplyTo)
		
		else IS_MIME_VERSION_HEADER(pData,*pPos)
			HS_SIP_DECODE(MIMEVersion)
		else IS_ORGANIZATION_HEADER(pData,*pPos)
			HS_SIP_DECODE(Organization)
		else IS_PRIORITY_HEADER(pData,*pPos)
			HS_SIP_DECODE(Priority)
		else IS_PROXY_REQUIRE_HEADER(pData,*pPos)
			HS_SIP_DECODE(ProxyRequire)
		else IS_REQUIRE_HEADER(pData,*pPos)
			HS_SIP_DECODE(Require)
		
		else IS_RETRY_AFTER_HEADER(pData,*pPos)
			HS_SIP_DECODE(RetryAfter)
		else IS_SERVER_HEADER(pData,*pPos)
			HS_SIP_DECODE(Server)
		else IS_SUBJECT_HEADER(pData,*pPos)
			HS_SIP_DECODE(Subject)
		else IS_TIMESTAMP_HEADER(pData,*pPos)
			HS_SIP_DECODE(Timestamp)
		else IS_UNSUPPORTED_HEADER(pData,*pPos)
			HS_SIP_DECODE(Unsupported)
		else IS_WARNING_HEADER(pData,*pPos)
			HS_SIP_DECODE(Warning)
#endif/*HS_SIP_ALL_HEADER*/
		else IS_CONTENT_ENCODING_HEADER(pData,*pPos)
			HS_SIP_DECODE(ContentEncoding)
		else IS_CONTENT_LANGUAGE_HEADER(pData,*pPos)
			HS_SIP_DECODE(ContentLanguage)
		else IS_CONTENT_TYPE_HEADER(pData,*pPos)
			HS_SIP_DECODE(ContentType)
		else IS_CONTENT_LENGTH_HEADER(pData,*pPos)
			HS_SIP_DECODE(ContentLength)
		else
			*pPos = tEndLinePos;

		if( !memcmp(pData+*pPos,HS_SIP_END_OF_LINE,2) )
		{
			int tContentLength;
			*pPos += 2;

			if( pObj->mContentLength != NULL )
			{
				if( pObj->mContentLength->mInfo != NULL )
				{
					tContentLength = atoi(pObj->mContentLength->mInfo);
					HS_CHECK_OVER(*pPos,tContentLength,pMax);
					if( (pObj->mBody=(char*)HSMalloc(tContentLength+1)) == NULL )
						return HS_ERR_MALLOC;
					memcpy(pObj->mBody,pData+*pPos,tContentLength);
					pObj->mBody[tContentLength] = '\0';
					*pPos += tContentLength;
					pObj->mBodyLen = tContentLength;
				}
			}
			return HS_OK;
		}
	}

	return HS_ERR;
}


HS_UINT SipMessage_GetExpires(void *pObject)
{
	HS_UINT i, j;
	ChainUnit *tChain_i = NULL;
	ChainUnit *tChain_j = NULL;
	SipContact *tContact = NULL;
	SipContactUnit *tContactUnit = NULL;
	SipMessage *pObj = (SipMessage*)pObject;

	if( pObj==NULL ) return 0;

	if( pObj->mExpires != NULL )
	{
		if( pObj->mExpires->mInfo==NULL )
			return 0;
		return (HS_UINT)atoi(pObj->mExpires->mInfo);
	}

	tChain_i = pObj->mContacts.units;
	for( i=0; i<pObj->mContacts.size; i++ )
	{
		if( tChain_i==NULL ) return 0;
		if( (tContact=(SipContact*)(tChain_i->data))==NULL ) return 0;

		tChain_j = tContact->mContactUnits.units;
		for( j=0; j<tContact->mContactUnits.size; j++ )
		{
			if( tChain_j==NULL ) return 0;
			if( (tContactUnit=(SipContactUnit*)(tChain_j->data))==NULL ) return 0;
			if( tContactUnit->mExpire != NULL )
				return (HS_UINT)atoi(tContactUnit->mExpire);

			tChain_j = (ChainUnit*)(tChain_j->next);
		}

		tChain_i = (ChainUnit*)(tChain_i->next);
	}

	return 0;
}


HS_UINT SipMessage_GetMinExpires(void *pObject)
{
	SipMessage *pObj = (SipMessage*)pObject;

	if( pObj==NULL ) return 0;
	if( pObj->mMinExpires==NULL ) return 0;
	if( pObj->mMinExpires->mInfo==NULL ) return 0;

	return (HS_UINT)atoi(pObj->mMinExpires->mInfo);
}


