/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipMessage.h>		2005-10-20,00:11

*/

#ifndef __2005_10_19__00_11__SIPMESSAGE_H__
#define __2005_10_19__00_11__SIPMESSAGE_H__



#include "SipDefine.h"
#include "SipHeader.h"



typedef struct
{
	SipHeadLine				mHeadLine;

	SipAllow				*mAllow;
	SipAuthenticationInfo	*mAuthenticationInfo;
	SipAuthorization		*mAuthorization;
	SipCallId				*mCallId;
	NoLockList				mContacts;
	SipContentEncoding		*mContentEncoding;
	SipContentLanguage		*mContentLanguage;
	SipContentLength		*mContentLength;
	SipCSeq					*mCSeq;
	SipExpires				*mExpires;
	SipFrom					*mFrom;
	SipMaxForwards			*mMaxForwards;
	SipMinExpires			*mMinExpires;
	SipProxyAuthenticate	*mProxyAuthenticate;
	SipProxyAuthorization	*mProxyAuthorization;
	NoLockList				mRecordRoutes;
	SipReplyTo				*mReplyTo;
	NoLockList				mRoutes;
	SipTo					*mTo;
	SipUserAgent			*mUserAgent;
	NoLockList				mVias;
	SipWWWAuthenticate		*mWWWAuthenticate;
	SipContentType			*mContentType;
	SipSupported			*mSupported;

#ifdef HS_SIP_ALL_HEADER
	SipAccept				*mAccept;
	SipAcceptEncoding		*mAcceptEncoding;
	SipAcceptLanguage		*mAcceptLanguage;
	SipAlertInfo			*mAlertInfo;
	SipCallInfo				*mCallInfo;
	SipContentDisposition	*mContentDisposition;
	SipDate					*mDate;
	SipErrorInfo			*mErrorInfo;
	SipInReplyTo			*mInReplyTo;
	SipMIMEVersion			*mMIMEVersion;
	SipOrganization			*mOrganization;
	SipPriority				*mPriority;
	SipProxyRequire			*mProxyRequire;
	SipRequire				*mRequire;
	SipRetryAfter			*mRetryAfter;
	SipServer				*mServer;
	SipSubject				*mSubject;
	SipTimestamp			*mTimestamp;
	SipUnsupported			*mUnsupported;
	SipWarning				*mWarning;
#endif/*HS_SIP_ALL_HEADER*/

	char					*mBody;
	HS_UINT					mBodyLen;
} SipMessage;


SipMessage *newm_SipMessage();
HS_RESULT new_SipMessage(void *pObject);
HS_RESULT delete_SipMessage(void *pObject);

BOOL SipMessage_IsRequest(void *pObject);
char *SipMessage_GetBranchId(void *pObject);

HS_RESULT SipMessage_Encode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipMessage_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);
HS_RESULT SipMessage_Decode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SipMessage_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);

HS_UINT SipMessage_GetExpires(void *pObject);
HS_UINT SipMessage_GetMinExpires(void *pObject);





#endif/*__2005_10_19__00_11__SIPMESSAGE_H__*/


