/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipSdp.h>		2005-10-24,23:18

*/

#ifndef __2005_10_24__23_18__SIPSDP_H__
#define __2005_10_24__23_18__SIPSDP_H__



#include "SipDefine.h"
#include "SipHeader.h"





#ifndef HS_DEFINITION_PAYLOADTYPE
#define HS_DEFINITION_PAYLOADTYPE
/* RFC 3551 Section 6.
*/
typedef enum
{
	/*audio*/
	e_RtpPayloadType_Pcmu=0,
	e_RtpPayloadTypeReserve1=1,
	e_RtpPayloadTypeReserve2=2,
	e_RtpPayloadType_Gsm=3,
	e_RtpPayloadType_G723=4,
	e_RtpPayloadType_Dvi4_8000=5,
	e_RtpPayloadType_Dvi4_16000=6,
	e_RtpPayloadType_Lpc=7,
	e_RtpPayloadType_Pcma=8,
	e_RtpPayloadType_G722=9,
	e_RtpPayloadType_L16_2ch=10,
	e_RtpPayloadType_L16_1ch=11,
	e_RtpPayloadType_Qcelp=12,
	e_RtpPayloadType_Cn=13,
	e_RtpPayloadType_Mpa=14,
	e_RtpPayloadType_G728=15,
	e_RtpPayloadType_Dvi4_11025=16,
	e_RtpPayloadType_Dvi4_22050=17,
	e_RtpPayloadType_G729=18,
	e_RtpPayloadTypeReserve3=19,
	e_RtpPayloadTypeUnassigned1=20,
	e_RtpPayloadTypeUnassigned2=21,
	e_RtpPayloadTypeUnassigned3=22,
	e_RtpPayloadTypeUnassigned4=23,
	/*video*/
	e_RtpPayloadTypeUnassigned5=24,
	e_RtpPayloadType_CelB=25,
	e_RtpPayloadType_Jpeg=26,
	e_RtpPayloadTypeUnassigned6=27,
	e_RtpPayloadType_nv=28,
	e_RtpPayloadTypeUnassigned7=29,
	e_RtpPayloadTypeUnassigned8=30,
	e_RtpPayloadType_H261=31,
	e_RtpPayloadType_Mpv=32,
	e_RtpPayloadType_Mp2t=33,
	e_RtpPayloadType_H263=34,
	/*<nonStandard*/
	/* 35-71   unassigned
	   72-76   reserved
	   77-95   unassigned
	   96-127  dynamic
	 */
	e_RtpPayloadType_Speex=97,
	e_RtpPayloadType_iLbc=98,
	/*nonStandard>*/
	e_RtpPayloadType_Rfc2833=101,
	e_RtpPayloadTypeMax=128
} RtpPayloadType;
#endif/*HS_DEFINITION_PAYLOADTYPE*/



typedef struct
{
	char *mAttrName;
	char *mAttrNumber;
	char *mAttrValue;
	char *mAttrRate;
} SdpAttribute;

HS_RESULT new_SdpAttribute(void *pObject);
HS_RESULT delete_SdpAttribute(void *pObject);

HS_RESULT SdpAttribute_SetAttrNumber(void *pObject, HS_UINT pNumber);





#define HS_SDP_INTEREST_VERSION				"v="
#define HS_SDP_INTEREST_OWNER				"o="
#define HS_SDP_INTEREST_SESSION_NAME		"s="
#define HS_SDP_INTEREST_CONNECTION			"c="
#define HS_SDP_INTEREST_MEDIA_DESCRIPTION	"m="
#define HS_SDP_INTEREST_ATTRIBUTE			"a="



typedef struct
{
	char *mNetworkType;
	char *mAddrType;
	char *mAddr;
} SdpConnection;

HS_RESULT new_SdpConnection(void *pObject);
HS_RESULT delete_SdpConnection(void *pObject);



typedef NoLockList		SdpAttributes;
typedef struct
{
	char			*mMediaType;
	char			*mTsapPort;
	SdpAttributes	mAttributes;
} SdpMediaDescription;

HS_RESULT new_SdpMediaDescription(void *pObject);
HS_RESULT delete_SdpMediaDescription(void *pObject);

SdpAttribute *SdpMediaDescription_FindAttribute(void *pObject, char *pNumber, HS_UINT pSize);



typedef NoLockList			SdpMediaDescriptions;
typedef struct
{
	char					*mVersion;
	char					*mOwner;
	char					*mSessionName;
	SdpConnection			mConnection;
	SdpMediaDescriptions	mDescriptions;
} SdpMessage;

HS_RESULT new_SdpMessage(void *pObject);
HS_RESULT delete_SdpMessage(void *pObject);

SdpAttribute *SdpMessage_FindAttribute(void *pObject, char *pNumber, HS_UINT pSize);
SdpMediaDescription *SdpMessage_FindAudioDescription(void *pObject);
SdpMediaDescription *SdpMessage_FindVideoDescription(void *pObject);
SdpMediaDescription *SdpMessage_FindMediaDescription(void *pObject, char *pType);

HS_RESULT SdpMessage_Encode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SdpMessage_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);
HS_RESULT SdpMessage_Decode(void *pObject, char *pData, HS_UINT pMax);
HS_RESULT SdpMessage_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax);





#endif/*__2005_10_24__23_18__SIPSDP_H__*/


