/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<IStack.c>	2005-10-01,16:28

*/

#include "IStack.h"

/* reference header
*/
#include "IUa.h"





/* IStack members
*/
HS_RESULT new_IStack(void *pObject, char *pLocalIp, char *pUserAgentName)
{
	IStack *pObj = (IStack*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mMaxForward = HS_UA_DEFAULT_MAX_FORWARD;
	pObj->mProtocol = SipStringAlloc("sip");
	pObj->mVersion = SipStringAlloc("2.0");
	pObj->mLocalIp = SipStringAlloc(pLocalIp);
	pObj->mUserAgentName = SipStringAlloc(pUserAgentName);

	pObj->mUdpPort = HS_DEFAULT_UDP_LISTEN_PORT;
	pObj->mTcpPort = HS_DEFAULT_TCP_LISTEN_PORT;

	pObj->mMediaTsapMin = HS_DEFAULT_MEDIA_TSAP_MIN;
	pObj->mMediaTsapMax = HS_DEFAULT_MEDIA_TSAP_MAX;
	pObj->mMediaTsapSeed = HS_INVALID_TSAP_PORT;

	pObj->mCallHandleSeed = HS_INVALID_HANDLE;
	pObj->mUaHandleSeed = HS_INVALID_HANDLE;
	pObj->mTrHandleSeed = HS_INVALID_HANDLE;

	pObj->mNetQ = HS_INVALID_QID;
	pObj->mSipQ = HS_INVALID_QID;

	pObj->CallbackStackError = NULL;
	pObj->CallbackReceiveRawData = NULL;
	pObj->CallbackReceiveMessageToResponse = NULL;
	pObj->CallbackReceiveMessage = NULL;
	pObj->CallbackSendMessage = NULL;
	pObj->CallbackSendRawData = NULL;
	pObj->CallbackBnfDecodingError = NULL;
	pObj->CallbackCallIncoming = NULL;
	pObj->CallbackCallEnded = NULL;
	pObj->CallbackCallRemoved = NULL;
	pObj->CallbackCallToRemove = NULL;
	pObj->CallbackOutbandDtmf = NULL;
	pObj->CallbackInstantMessage = NULL;
	pObj->CallbackCheckSdp = NULL;
	pObj->CallbackOpenMedia = NULL;
	pObj->CallbackCloseMedia = NULL;
	pObj->CallbackRegisted = NULL;
	pObj->CallbackRegisterFail = NULL;
	pObj->CallbackUaRemoved = NULL;
	pObj->CallbackStackInformation = NULL;

	new_NoLockList(&(pObj->mUas),delete_IUa);
	return HS_OK;
}


HS_RESULT delete_IStack(void *pObject)
{
	IStack *pObj = (IStack*)pObject;

	if( pObj == NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mProtocol != NULL )
	{
		HSFree(pObj->mProtocol);
		pObj->mProtocol = NULL;
	}
	if( pObj->mVersion != NULL )
	{
		HSFree(pObj->mVersion);
		pObj->mVersion = NULL;
	}
	if( pObj->mLocalIp != NULL )
	{
		HSFree(pObj->mLocalIp);
		pObj->mLocalIp = NULL;
	}
	if( pObj->mUserAgentName != NULL )
	{
		HSFree(pObj->mUserAgentName);
		pObj->mUserAgentName = NULL;
	}
	delete_NoLockList(&(pObj->mUas));
	return HS_OK;
}


HS_USHORT IStack_MakeMediaTsapPort(void *pObject)
{
	HS_USHORT tResult;
	IStack *pObj = (IStack*)pObject;

	if( pObj==NULL ) return HS_INVALID_TSAP_PORT;

	if( pObj->mMediaTsapSeed==HS_INVALID_TSAP_PORT || pObj->mMediaTsapSeed > (pObj->mMediaTsapMax-1) )
		pObj->mMediaTsapSeed = pObj->mMediaTsapMin;

	tResult = pObj->mMediaTsapSeed;
	pObj->mMediaTsapSeed += HS_DEFAULT_MEDIA_TSAP_GAP;

	return tResult;
}


HS_CALL_HANDLE IStack_MakeDialogueHandle(void *pObject)
{
	HS_CALL_HANDLE tResult;
	IStack *pObj = (IStack*)pObject;

	if( pObj==NULL ) return HS_INVALID_HANDLE;

	if( pObj->mCallHandleSeed==HS_INVALID_HANDLE || pObj->mCallHandleSeed > (HS_CALL_HANDLE_MAX-1) )
		pObj->mCallHandleSeed = HS_CALL_HANDLE_MIN;

	tResult = pObj->mCallHandleSeed;
	pObj->mCallHandleSeed += 2;

	return tResult;
}


HS_UA_HANDLE IStack_MakeUaHandle(void *pObject)
{
	HS_UA_HANDLE tResult;
	IStack *pObj = (IStack*)pObject;

	if( pObj==NULL ) return HS_INVALID_HANDLE;

	if( pObj->mUaHandleSeed==HS_INVALID_HANDLE || pObj->mUaHandleSeed > (HS_UA_HANDLE_MAX-1) )
		pObj->mUaHandleSeed = HS_UA_HANDLE_MIN;

	tResult = pObj->mUaHandleSeed;
	pObj->mUaHandleSeed += 2;

	return tResult;
}


HS_TR_HANDLE IStack_MakeTransactionHandle(void *pObject)
{
	HS_TR_HANDLE tResult;
	IStack *pObj = (IStack*)pObject;

	if( pObj==NULL ) return HS_INVALID_HANDLE;

	if( pObj->mTrHandleSeed==HS_INVALID_HANDLE || pObj->mMediaTsapSeed > (HS_TR_HANDLE_MAX-1) )
		pObj->mTrHandleSeed = HS_TR_HANDLE_MIN;

	tResult = pObj->mTrHandleSeed;
	pObj->mTrHandleSeed += 2;

	return tResult;
}





/* finding functions
*/
ChainUnit *IStack_FindUaChainByUserName(void *pObject, char *pUserName)
{
	HS_UINT i;
	ChainUnit *tChain = NULL;
	IUa *tResult = NULL;
	SipContactUnit *tContactUnit = NULL;
	IStack *pObj = (IStack*)pObject;

	if( pObj==NULL || pUserName==NULL ) return NULL;

	tChain = pObj->mUas.units;
	for( i=0; i<pObj->mUas.size; i++ )
	{
		if( tChain==NULL ) return NULL;
		if( (tResult=(IUa*)(tChain->data))==NULL ) return NULL;
		if( (tContactUnit=IUa_GetPrimeContactUnit(tResult))!=NULL )
		{
			if( !strcmp(pUserName,tContactUnit->mUri.mUserName) )
				return tChain;
		}
		
		tChain = (ChainUnit*)(tChain->next);
	}

	return NULL;
}


ChainUnit *IStack_FindUaChainByHandle(void *pObject, HS_UA_HANDLE pHandle)
{
	HS_UINT i;
	ChainUnit *tChain = NULL;
	IUa *tResult = NULL;
	SipContactUnit *tContactUnit = NULL;
	IStack *pObj = (IStack*)pObject;

	if( pObj==NULL || pHandle==HS_INVALID_HANDLE ) return NULL;

	tChain = pObj->mUas.units;
	for( i=0; i<pObj->mUas.size; i++ )
	{
		if( tChain==NULL ) return NULL;
		if( (tResult=(IUa*)(tChain->data))==NULL ) return NULL;
		if( tResult->mHandle==pHandle) return tChain;
		
		tChain = (ChainUnit*)(tChain->next);
	}

	return NULL;
}


void *IStack_FindUaByUserName(void *pObject, char *pUserName)
{
	ChainUnit *tChain = IStack_FindUaChainByUserName(pObject,pUserName);

	if( tChain==NULL ) return NULL;
	return (tChain->data);
}


void *IStack_FindUaByHandle(void *pObject, HS_UA_HANDLE pHandle)
{
	ChainUnit *tChain = IStack_FindUaChainByHandle(pObject,pHandle);

	if( tChain==NULL ) return NULL;
	return (tChain->data);
}


HS_RESULT IStack_DeleteUa(void *pObject, HS_UA_HANDLE pHandle)
{
	IStack *pObj = (IStack*)pObject;
	IUa *tUa = NULL;
	ChainUnit *tChain = IStack_FindUaChainByHandle(pObject,pHandle);

	if( tChain==NULL ) return HS_ERR_SIP_NO_EXIST;

	if( (tUa=(IUa*)(tChain->data))!=NULL )
	{
		if( pObj->CallbackUaRemoved != NULL )
			pObj->CallbackUaRemoved(tUa->mHandle);
	}

	return NoLockList_DeleteChain(&(pObj->mUas),tChain);
}





ChainUnit *IStack_FindDialogueChainByHandle(void *pObject, HS_CALL_HANDLE pHandle)
{
	HS_UINT i;
	ChainUnit *tChain = NULL;
	IUa *tUa = NULL;
	ChainUnit *tCallChain = NULL;
	IStack *pObj = (IStack*)pObject;

	if( pObj==NULL || pHandle==HS_INVALID_HANDLE ) return NULL;

	tChain = pObj->mUas.units;
	for( i=0; i<pObj->mUas.size; i++ )
	{
		if( tChain==NULL ) return NULL;
		if( (tUa=(IUa*)(tChain->data))==NULL ) return NULL;
		if( (tCallChain=IUa_FindDialogueChainByHandle(tUa,pHandle)) != NULL )
			return tCallChain;

		tChain = (ChainUnit*)(tChain->next);
	}

	return NULL;
}


void *IStack_FindDialogueById(void *pObject, char *pCallId)
{
	HS_UINT i;
	ChainUnit *tChain = NULL;
	IUa *tUa = NULL;
	ChainUnit *tCallChain = NULL;
	IStack *pObj = (IStack*)pObject;

	if( pObj==NULL || pCallId==NULL ) return NULL;

	tChain = pObj->mUas.units;
	for( i=0; i<pObj->mUas.size; i++ )
	{
		if( tChain==NULL ) return NULL;
		if( (tUa=(IUa*)(tChain->data))==NULL ) return NULL;
		if( (tCallChain=IUa_FindDialogueById(tUa,pCallId)) != NULL )
			return tCallChain;

		tChain = (ChainUnit*)(tChain->next);
	}

	return NULL;
}


void *IStack_FindDialogueByHandle(void *pObject, HS_CALL_HANDLE pHandle)
{
	ChainUnit *tChain = IStack_FindDialogueChainByHandle(pObject,pHandle);

	if( tChain==NULL ) return NULL;
	return (tChain->data);
}


void *IStack_FindTransactionByHandle(void *pObject, HS_TR_HANDLE pHandle)
{
	HS_UINT i;
	IUa *tUnit = NULL;
	void *tResult = NULL;
	ChainUnit *tChain = NULL;
	IStack *pObj = (IStack*)pObject;

	if( pObj==NULL ) return NULL;

	tChain = pObj->mUas.units;
	for( i=0; i<pObj->mUas.size; i++ )
	{
		if( tChain==NULL ) return NULL;
		if( (tUnit=(IUa*)(tChain->data))==NULL ) return NULL;
		if( (tResult=IUa_FindTransactionByHandle(tUnit,pHandle))!=NULL )
			return tResult;

		tChain = (ChainUnit*)(tChain->next);
	}

	return NULL;
}


