/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<IStack.h>		2005-10-01,16:21

*/

#ifndef __2005_10_01__16_21__ISTACK_H__
#define __2005_10_01__16_21__ISTACK_H__





#include "SipDefine.h"
#include "UaDefine.h"





#define HS_UA_DEFAULT_MAX_FORWARD			70
#define HS_DEFAULT_MEDIA_TSAP_MIN			30000
#define HS_DEFAULT_MEDIA_TSAP_MAX			40000
#define HS_DEFAULT_MEDIA_TSAP_GAP			4



#define HS_UA_HANDLE_MIN					10000
#define HS_UA_HANDLE_MAX					20000
/* even handle is made by stack
   odd handle is made by user
*/
#define HS_CALL_HANDLE_MIN					20000
#define HS_CALL_HANDLE_MAX					30000
/* even handle is made by stack
   odd handle is made by network thread
*/
#define HS_TR_HANDLE_MIN					30000
#define HS_TR_HANDLE_MAX					40000


#ifndef HS_STACK_HANDLE
#define HS_STACK_HANDLE void*
#endif
#ifndef HS_INVALID_STACK_HANDLE
#define HS_INVALID_STACK_HANDLE NULL
#endif





typedef enum
{
	e_RemoveReason_Bye,
	e_RemoveReason_Cancel,
	e_RemoveReason_Reject,
	e_RemoveReason_Permission,
	e_RemoveReason_Timeout
} RemoveReason;



typedef struct
{
	HS_UINT		mMaxForward;
	char		*mProtocol;
	char		*mVersion;
	char		*mLocalIp;
	char		*mUserAgentName;

	HS_USHORT	mUdpPort;
	HS_USHORT	mTcpPort;

	HS_USHORT	mMediaTsapMin;
	HS_USHORT	mMediaTsapMax;
	HS_USHORT	mMediaTsapSeed;

	HS_UINT		mCallHandleSeed;
	HS_UINT		mUaHandleSeed;
	HS_UINT		mTrHandleSeed;

	/* Message Queues
	*/
	HS_QID		mNetQ;
	HS_QID		mSipQ;

	/*
	 * callback functions
	*/
	void (*CallbackStackError)(HS_STACK_HANDLE,int pReason);
	BOOL (*CallbackReceiveRawData)(HS_UCHAR*,int);
	/* request messages except ACK,PRACK
	   return value, SipResponse is selected response about request by programer user
	   if it is a e_SipResponseMax, stack do process by his decision
	*/
	SipResponse (*CallbackReceiveMessageToResponse) (HS_UA_HANDLE,HS_CALL_HANDLE,SipMessage*);
	BOOL (*CallbackReceiveMessage) (HS_UA_HANDLE,HS_CALL_HANDLE,SipMessage*);
	BOOL (*CallbackSendMessage) (HS_UA_HANDLE,HS_CALL_HANDLE,SipMessage*);
	BOOL (*CallbackSendRawData) (HS_UA_HANDLE,HS_CALL_HANDLE,HS_UCHAR*,int);

	void (*CallbackBnfDecodingError) (HS_UCHAR*,int);

	void (*CallbackCallIncoming) (HS_STACK_HANDLE,void*);	/*IDialogue object pointer*/
	void (*CallbackCallEnded) (HS_UA_HANDLE,HS_CALL_HANDLE,SipResponse);
	void (*CallbackCallRemoved) (HS_UA_HANDLE,HS_CALL_HANDLE);
	BOOL (*CallbackCallToRemove) (HS_UA_HANDLE,HS_CALL_HANDLE,RemoveReason);

	void (*CallbackOutbandDtmf) (HS_UA_HANDLE,HS_CALL_HANDLE,char*,char*,HS_UINT);		/*by INFO method*/
	void (*CallbackInstantMessage) (HS_UA_HANDLE,HS_CALL_HANDLE,char*,char*,HS_UINT);	/*by MESSAGE method*/

	HS_RESULT (*CallbackCheckSdp) (void*,SdpMessage*);	/*IDialogue object pointer*/
	void (*CallbackOpenMedia) (HS_CALL_HANDLE,void*);	/*MediaInfo object pointer*/
	void (*CallbackCloseMedia) (HS_CALL_HANDLE,void*);	/*MediaInfo object pointer*/

	void (*CallbackRegisted) (HS_UA_HANDLE);
	void (*CallbackRegisterFail) (HS_UA_HANDLE);
	void (*CallbackUaRemoved) (HS_UA_HANDLE);
	void (*CallbackStackInformation) (HS_STACK_HANDLE);

	NoLockList	mUas;
} IStack;

HS_RESULT new_IStack(void *pObject, char *pLocalIp, char *pUserAgentName);
HS_RESULT delete_IStack(void *pObject);

HS_USHORT IStack_MakeMediaTsapPort(void *pObject);
HS_CALL_HANDLE IStack_MakeDialogueHandle(void *pObject);
HS_UA_HANDLE IStack_MakeUaHandle(void *pObject);
HS_TR_HANDLE IStack_MakeTransactionHandle(void *pObject);

/* finding functions
*/
ChainUnit*	IStack_FindUaChainByUserName(void *pObject, char *pUserName);
ChainUnit*	IStack_FindUaChainByHandle(void *pObject, HS_UA_HANDLE pHandle);
void*		IStack_FindUaByUserName(void *pObject, char *pUserName);
void*		IStack_FindUaByHandle(void *pObject, HS_UA_HANDLE pHandle);
HS_RESULT	IStack_DeleteUa(void *pObject, HS_UA_HANDLE pHandle);

ChainUnit*	IStack_FindDialogueChainByHandle(void *pObject, HS_CALL_HANDLE pHandle);
void*		IStack_FindDialogueById(void *pObject, char *pCallId);
void*		IStack_FindDialogueByHandle(void *pObject, HS_CALL_HANDLE pHandle);

void*		IStack_FindTransactionByHandle(void *pObject, HS_TR_HANDLE pHandle);





#endif/*__2005_10_01__16_21__ISTACK_H__*/


