/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipEnetDemon.c>	2005-11-01,24:11

*/

#include "SipEnetDemon.h"





/* transaction id deliverer
*/
HS_TR_HANDLE gTrServerHandleSeed = HS_TR_HANDLE_MIN+1;
HS_TR_HANDLE GetTransactionHandleInEnetDemon()
{
	HS_TR_HANDLE tResult;

	if( gTrServerHandleSeed > HS_TR_HANDLE_MAX )
		gTrServerHandleSeed = HS_TR_HANDLE_MIN+1;

	tResult = gTrServerHandleSeed;
	gTrServerHandleSeed+=2;
	return tResult;
}





/* thread object
*/
SipEnetDemon *newm_SipEnetDemon(HS_USHORT pUdpPort,HS_USHORT pTcpPort)
{
	SipEnetDemon *tResult = NULL;

	if( (tResult=(SipEnetDemon*)HSMalloc(sizeof(SipEnetDemon)))==NULL )
		return NULL;

	HS_THREAD_INIT(tResult,"SipEnetDemon");

	tResult->mSipQ = HS_INVALID_QID;
	tResult->mUdpPort = pUdpPort;
	tResult->mTcpPort = pTcpPort;
	return tResult;
}


HS_RESULT deletem_SipEnetDemon(void *pObject)
{
	SipEnetDemon *pObj = (SipEnetDemon*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	HSFree(pObj);
	return HS_OK;
}





/* thread main function
*/
HS_RESULT SipEnetDemon_MainEx(HS_TQ pQ,SipEnetDemon *pObj,SOCKET pUdpSocket,SOCKET pTcpSocket)
{
	HSQmsg tQmsg;
	HS_RESULT tRet = HS_OK;

	int tLen, tInLen;
	HS_UCHAR tBuffer[4096];
	struct sockaddr_in tSenderAddrIn;
	struct sockaddr_in tAcceptAddrIn;

	HS_UINT	tMaxFd;
	fd_set	tSipFdSet;

	struct timeval	tv;
	SipSocketList tSockList;

	HSSrand();

	if( pObj==NULL )
		return HS_ERR_NULL_PARAM;
	if( pUdpSocket==INVALID_SOCKET || pTcpSocket==INVALID_SOCKET )
	{
		deletem_SipEnetDemon(pObj);
		return HS_ERR_NULL_PARAM;
	}

	tv.tv_sec  = 0;
	tv.tv_usec = 50000;
	new_NoLockList(&tSockList, delete_SipSocketSet);


	pObj->mActive = TRUE;
	while(pObj->mActive)
	{
		if( HSThreadGetMessage(pQ,&tQmsg,HS_QM,HS_QM_MAX,FALSE)==HS_OK )
		{
			switch(tQmsg.message)
			{
				case HS_QM_STOP:
					pObj->mActive = FALSE;
					break;
				case HS_QM_CHECK:
					HSPrint("\n%s alive.",pObj->mName);
					break;
				case HS_QM_ENET_MESSAGE:
					HSPrint( "\n[+] ENET->ENET_MESSAGE" );
					tRet=SipEnetDemonEventEnetMessage((QmEnetMessage*)(tQmsg.lParam),pUdpSocket,&tSockList,pObj->mQid);
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
				case HS_QM_CHANGE_LISTEN_PORT:
					HSPrint( "\n[+] ENET->CHANGE_LISTEN_PORT" );
					if( tQmsg.lParam==0 )
					{
						if( tQmsg.wParam==pObj->mUdpPort )
							tRet = HS_ERR;
						else
						{
							if( (tRet=SipEnetDemonEventChangeListenPort(&pUdpSocket,&pTcpSocket,(HS_USHORT)(tQmsg.wParam),(HS_USHORT)(tQmsg.lParam)))==HS_OK )
								pObj->mUdpPort = tQmsg.wParam;
						}
					}
					else
					{
						if( tQmsg.wParam==pObj->mTcpPort )
							tRet = HS_ERR;
						else
						{
							if( (tRet=SipEnetDemonEventChangeListenPort(&pUdpSocket,&pTcpSocket,(HS_USHORT)(tQmsg.wParam),(HS_USHORT)(tQmsg.lParam)))==HS_OK )
								pObj->mTcpPort = tQmsg.wParam;
						}
					}
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
				case HS_QM_REMOVE_SOCKET_SET:
					HSPrint( "\n[+] ENET->REMOVE_SOCKET_SET" );
					tRet=SipEnetDemonEventRemoveSocketSet(&tSockList,(HS_TR_HANDLE)(tQmsg.lParam));
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
				case HS_QM_CONNECTED:
					HSPrint( "\n[+] ENET->CONNECTED" );
					tRet=SipEnetDemonEventConnected(&tSockList,(TcpConnected*)(tQmsg.lParam),pObj->mSipQ);
					HSPrint( "\n[-] ENET:%u", tRet );
					break;
			}
		}

		if( HS_THREAD_IS_ACTIVE(pObj)==FALSE ) continue;

		/* check network event
		*/
		FD_ZERO(&tSipFdSet);

		FD_SET(pTcpSocket,&tSipFdSet);
		tMaxFd = pTcpSocket;

		FD_SET(pUdpSocket,&tSipFdSet);
		if( pUdpSocket > tMaxFd ) tMaxFd = pUdpSocket;
		NoLockList_SipFdSet(&tSockList, &tSipFdSet, &tMaxFd);
		tMaxFd++;

		if( select(tMaxFd+1,&tSipFdSet,NULL,NULL,&tv) < 1 ) continue;

		/* TCP Accept
		*/
		if( FD_ISSET(pTcpSocket,&tSipFdSet) )
		{
			SOCKET	tSocket;
			
			tInLen = sizeof(tAcceptAddrIn);
			tSocket = accept(pTcpSocket,(struct sockaddr *)(&(tAcceptAddrIn)),&(tInLen));

			if( tSocket < 0 )
				tSocket = accept(pTcpSocket,(struct sockaddr *)(&(tAcceptAddrIn)), &(tInLen));

			if( tSocket >= 0 )
			{
				SipSocketSet *tSocketSet = NULL;

				if( (tSocketSet=(SipSocketSet*)HSMalloc(sizeof(SipSocketSet)))!=NULL )
				{
					new_SipSocketSet(tSocketSet, GetTransactionHandleInEnetDemon());
					tSocketSet->mSocket = tSocket;

					NoLockList_AttachData(&tSockList,tSocketSet);
				}
				else
					closesocket(tSocket);
			}
#ifdef HS_DEBUG_SIPENETDEMON
			else
			{
				HSPrint( "\n <EnetDemon> Q931 Accept Error" );
			}
#endif
		}
		/* UDP Packet
		*/
		if( FD_ISSET(pUdpSocket,&tSipFdSet) )
		{
			QmEnetMessage *tEnetMessage = NULL;
			tInLen = sizeof(tSenderAddrIn);

			if( (tLen=recvfrom(pUdpSocket, (char*)tBuffer, 4096, 0, (SOCKADDR*)&tSenderAddrIn, &tInLen)) > 0 )
			{
				HSResponseVendorCheckPacket(tBuffer,tLen,pUdpSocket,tSenderAddrIn);

				if( (tEnetMessage=newm_QmEnetMessage(tBuffer,tLen,HS_INVALID_HANDLE,tSenderAddrIn))!=NULL )
					_HSThreadSendMessage(pObj->mSipQ,HS_QM_ENET_MESSAGE,0,(LPARAM)tEnetMessage);
			}
		}
		/* SocketList packet
		*/
		NoLockList_SipFdIsSet(&tSockList, &tSipFdSet, pObj->mSipQ, tBuffer, 4096);
	}

	deletem_SipEnetDemon(pObj);
	delete_NoLockList(&tSockList);
	return HS_OK;
}


HS_RESULT SipEnetDemon_Main(HS_TQ pQ,void *pObject,void *pArg)
{
	HS_RESULT tRet = HS_OK;
	SOCKET tUdpSocket, tTcpSocket;
	struct sockaddr_in tAddrIn;
	SipEnetDemon *pObj = (SipEnetDemon*)pObject;

	if( pObj==NULL )
		return HSExitThread(pQ,HS_ERR_NULL_PARAM);

	/* get sockets
	*/
	if( (tTcpSocket=socket(AF_INET,SOCK_STREAM,0))==INVALID_SOCKET )
	{
		deletem_SipEnetDemon(pObj);
		return HSExitThread(pQ,HS_ERR_NET_SOCKET);
	}
	if( (tUdpSocket=socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP))==INVALID_SOCKET )
	{
		deletem_SipEnetDemon(pObj);
		closesocket(tTcpSocket);
		return HSExitThread(pQ,HS_ERR_NET_SOCKET);
	}

	/* binding udp socket
	*/
	memset(&tAddrIn,0,sizeof(tAddrIn));
    tAddrIn.sin_family		= AF_INET;
	tAddrIn.sin_port		= htons(pObj->mUdpPort);
    tAddrIn.sin_addr.s_addr	= htonl(INADDR_ANY);
	if( bind(tUdpSocket,(struct sockaddr*)&tAddrIn,sizeof(tAddrIn)) != 0 )
	{
		deletem_SipEnetDemon(pObj);
		closesocket(tUdpSocket);
		closesocket(tTcpSocket);
		return HSExitThread(pQ,HS_ERR_NET_BIND);
	}

	/* binding tcp socket
	*/
	memset(&tAddrIn,0,sizeof(tAddrIn));
    tAddrIn.sin_family		= AF_INET;
	tAddrIn.sin_port		= htons(pObj->mTcpPort);
    tAddrIn.sin_addr.s_addr	= htonl(INADDR_ANY);
	if( bind(tTcpSocket,(struct sockaddr*)&tAddrIn,sizeof(tAddrIn)) != 0 )
	{
		deletem_SipEnetDemon(pObj);
		closesocket(tUdpSocket);
		closesocket(tTcpSocket);
		return HSExitThread(pQ,HS_ERR_NET_BIND);
	}
	if( listen(tTcpSocket,3) != 0 )
	{
		deletem_SipEnetDemon(pObj);
		closesocket(tUdpSocket);
		closesocket(tTcpSocket);
		return HSExitThread(pQ,HS_ERR_NET_BIND);
	}

	tRet = SipEnetDemon_MainEx(pQ,pObj,tUdpSocket,tTcpSocket);
	return HSExitThread(pQ,tRet);
}



