/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipEnetDemonHandler.c>		2005-10-31,23:27

*/

#include "SipEnetDemonHandler.h"





HS_RESULT SipEnetDemonEventEnetMessage(QmEnetMessage *pMessage, SOCKET pUdpSocket, SipSocketList *pSets, HS_QID pNetQ)
{
	ChainUnit *tChain = NULL;
	SipSocketSet *tSet = NULL;

	if( pMessage==NULL ) return HS_ERR_NULL_PARAM;
	if( pSets==NULL )
	{
		deletem_QmEnetMessage(pMessage);
		return HS_ERR_INVALID_PARAM;
	}

	if( pMessage->mHandle != HS_INVALID_HANDLE )
	{
		if( (tChain=NoLockList_FindSipSocketSetByHandle(pSets,pMessage->mHandle))==NULL )
		{
			HS_UCHAR tIp[4];

			if( (tSet=(SipSocketSet*)HSMalloc(sizeof(SipSocketSet)))==NULL )
			{
				deletem_QmEnetMessage(pMessage);
				return HS_ERR_MALLOC;
			}
			new_SipSocketSet(tSet,pMessage->mHandle);
			tSet->mReady = pMessage;

			Uint2Uchar(tIp,&(pMessage->mAddr.sin_addr.s_addr));
			HSConnectEx(tIp,pMessage->mAddr.sin_port,pNetQ,pMessage->mHandle);
			return NoLockList_AttachData(pSets,tSet);
		}
		if( (tSet=(SipSocketSet*)(tChain->data))==NULL )
		{
			deletem_QmEnetMessage(pMessage);
			return HS_ERR_CONFLICT;
		}
		send(tSet->mSocket,pMessage->mRaw,pMessage->mLen,0);
		deletem_QmEnetMessage(pMessage);
		return HS_OK;
	}

	sendto(pUdpSocket,pMessage->mRaw,pMessage->mLen,0,(SOCKADDR*)(&(pMessage->mAddr)),sizeof(pMessage->mAddr));
	deletem_QmEnetMessage(pMessage);
	return HS_OK;
}


HS_RESULT SipEnetDemonEventChangeListenPort(SOCKET *pUdp, SOCKET *pTcp, HS_USHORT pPort, HS_UINT pType)
{
	SOCKET tSocket = INVALID_SOCKET;
	struct sockaddr_in tAddrIn;

	if( pUdp==NULL || pTcp==NULL ) return HS_ERR_NULL_PARAM;
	
	if( pType==0/*udp*/ )
	{
		if( (tSocket=socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP))==INVALID_SOCKET )
			return HS_ERR_SIP;

		memset(&tAddrIn,0,sizeof(tAddrIn));
		tAddrIn.sin_family		= AF_INET;
		tAddrIn.sin_addr.s_addr	= htonl( INADDR_ANY );
		tAddrIn.sin_port		= htons( pPort );
		if( bind(tSocket,(const SOCKADDR*)(&tAddrIn),sizeof(tAddrIn)) != 0 )
		{
			closesocket(tSocket);
			return HS_ERR_SIP;
		}

		closesocket(*pUdp);
		*pUdp = tSocket;
		return HS_OK;
	}

	if( (tSocket=socket(AF_INET,SOCK_STREAM,0))==INVALID_SOCKET )
		return HS_ERR_SIP;

	memset(&tAddrIn,0,sizeof(tAddrIn));
	tAddrIn.sin_family		= AF_INET;
	tAddrIn.sin_addr.s_addr	= htonl( INADDR_ANY );
	tAddrIn.sin_port		= htons( pPort );
	if( bind(tSocket,(const SOCKADDR*)(&tAddrIn),sizeof(tAddrIn)) != 0 )
	{
		closesocket(tSocket);
		return HS_ERR_SIP;
	}

	closesocket(*pTcp);
	*pTcp = tSocket;
	return HS_OK;
}


HS_RESULT SipEnetDemonEventRemoveSocketSet(SipSocketList *pSets, HS_TR_HANDLE pHandle)
{
	ChainUnit *tChain = NULL;

	if( pSets==NULL ) return HS_ERR_NULL_PARAM;

	if( (tChain=NoLockList_FindSipSocketSetByHandle(pSets,pHandle))==NULL )
		return HS_ERR_SIP_NO_EXIST;

	return NoLockList_DeleteChain(pSets,tChain);
}


HS_RESULT SipEnetDemonEventConnected(SipSocketList *pSets, TcpConnected *pConnected, HS_QID pStackQ)
{
	ChainUnit *tChain = NULL;
	SipSocketSet *tSet = NULL;

	if( pConnected==NULL ) return HS_ERR_NULL_PARAM;
	if( pSets==NULL )
	{
		deletem_TcpConnected(pConnected);
		return HS_ERR_INVALID_PARAM;
	}
	if( (tChain=NoLockList_FindSipSocketSetByHandle(pSets,pConnected->mHandle))==NULL )
	{
		deletem_TcpConnected(pConnected);
		return HS_ERR_SIP_NO_EXIST;
	}

	if( pConnected->mSocket==INVALID_SOCKET )
	{
		_HSThreadSendMessage(pStackQ,HS_QM_REMOVE_SOCKET_SET,0,(LPARAM)(pConnected->mHandle));
		deletem_TcpConnected(pConnected);
		return NoLockList_DeleteChain(pSets,tChain);
	}

	if( (tSet=(SipSocketSet*)(tChain->data))==NULL )
	{
		_HSThreadSendMessage(pStackQ,HS_QM_REMOVE_SOCKET_SET,0,(LPARAM)(pConnected->mHandle));
		deletem_TcpConnected(pConnected);
		NoLockList_DeleteChain(pSets,tChain);
		return HS_ERR_CONFLICT;
	}

	tSet->mSocket = pConnected->mSocket;
	deletem_TcpConnected(pConnected);

	if( tSet->mReady != NULL )
	{
		send(tSet->mSocket,tSet->mReady->mRaw,tSet->mReady->mLen,0);
		deletem_QmEnetMessage(tSet->mReady);
		tSet->mReady = NULL;
	}
	return HS_OK;
}




