/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipTimerHandler.c>		2005-10-31,21:45

*/

#include "SipTimerHandler.h"




HS_RESULT HandleSipTimer(IStack *pStack, HSTimerEvent *pEvent)
{
	IUa *tUa = NULL;
	IDialogue *tDialogue = NULL;
	ITransaction *tTransaction = NULL;

	QmEnetMessage *tEnetMessage = NULL;

	if( pStack==NULL || pEvent==NULL ) return HS_ERR_NULL_PARAM;
	if( pEvent->mTid >= HS_TID_SIP_TIMER_MAX ) return HS_ERR_INVALID_PARAM;

	if( (tTransaction=IStack_FindTransactionByHandle(pStack,pEvent->mSub))==NULL )
		return HS_ERR_SIP_NO_EXIST;
	if( tTransaction->mDialogue==NULL ) return HS_ERR;
	tDialogue = tTransaction->mDialogue;
	if( tDialogue->mUa==NULL ) return HS_ERR;
	tUa = tDialogue->mUa;

	switch(tTransaction->mState)
	{
		case e_TransactionState_Calling:
			if( pEvent->mTid == HS_TID_SIP_TIMER_B )
			{
				HSKillTimer(HS_TID_SIP_TIMER_A,tTransaction->mHandle);
				IDialogue_DeleteTransaction(tDialogue,tTransaction->mHandle);
				if( tDialogue->mState==e_DialogueState_KillMe && tDialogue->mTransactions.size==0 )
				{
					IUa_DeleteDialogue(tUa,tDialogue->mHandle);
					if( tUa->mState==e_UaState_KillMe && tUa->mDialogues.size==0 )
						IStack_DeleteUa(pStack,tUa->mHandle);
				}
				return HS_OK;
			}
			else if( pEvent->mTid == HS_TID_SIP_TIMER_A )
			{
				if( tTransaction->mLingerMessage == NULL )
					return HS_ERR_SIP_NO_EXIST;
				if( (tEnetMessage=MakeQmEnetMessage(tTransaction,tTransaction->mLingerMessage,tTransaction->mLingerLen)) == NULL )
					return HS_ERR_MALLOC;
				tTransaction->mTimer = (tTransaction->mTimer)*2;
				HSSetTimer(tTransaction->mTimer,pStack->mSipQ,HS_TID_SIP_TIMER_A,tTransaction->mHandle,e_TimerType_Once);
				_HSThreadSendMessage(pStack->mNetQ,HS_QM_ENET_MESSAGE,0,(LPARAM)tEnetMessage);
				return HS_OK;
			}
			return HS_ERR_CONFLICT;

		case e_TransactionState_Trying:
		case e_TransactionState_Proceeding:
			if( tTransaction->mIsClient==FALSE )
				return HS_ERR_CONFLICT;
			if( pEvent->mTid == HS_TID_SIP_TIMER_F )
			{
				HSKillTimer(HS_TID_SIP_TIMER_E,tTransaction->mHandle);
				if( !strcmp(tTransaction->mMethod,"REGISTER") )
				{
					if( pStack->CallbackRegisterFail != NULL )
						pStack->CallbackRegisterFail(tUa->mHandle);
				}

				IDialogue_DeleteTransaction(tDialogue,tTransaction->mHandle);
				if( tDialogue->mState==e_DialogueStateMax && tUa->mState==e_UaState_KillMe && tUa->mDialogues.size==0 )
					IStack_DeleteUa(pStack,tUa->mHandle);
				if( tDialogue->mState==e_DialogueState_KillMe && tDialogue->mTransactions.size==0 )
				{
					IUa_DeleteDialogue(tUa,tDialogue->mHandle);
					if( tUa->mState==e_UaState_KillMe && tUa->mDialogues.size==0 )
						IStack_DeleteUa(pStack,tUa->mHandle);
				}
				return HS_OK;
			}
			if( pEvent->mTid == HS_TID_SIP_TIMER_E )
			{
				if( tTransaction->mLingerMessage == NULL )
					return HS_ERR_SIP_NO_EXIST;
				if( (tEnetMessage=MakeQmEnetMessage(tTransaction,tTransaction->mLingerMessage,tTransaction->mLingerLen)) == NULL )
					return HS_ERR_MALLOC;
				tTransaction->mTimer = (tTransaction->mTimer)*2;
				HSSetTimer(tTransaction->mTimer,pStack->mSipQ,HS_TID_SIP_TIMER_E,tTransaction->mHandle,e_TimerType_Once);
				_HSThreadSendMessage(pStack->mNetQ,HS_QM_ENET_MESSAGE,0,(LPARAM)tEnetMessage);
				return HS_OK;
			}
			return HS_ERR_CONFLICT;

		case e_TransactionState_Completed:
			if( pEvent->mTid == HS_TID_SIP_TIMER_D ||
				pEvent->mTid == HS_TID_SIP_TIMER_J
			)
			{
				IDialogue_DeleteTransaction(tDialogue,tTransaction->mHandle);
				if( tDialogue->mState==e_DialogueStateMax && tUa->mState==e_UaState_KillMe && tUa->mDialogues.size==0 )
					IStack_DeleteUa(pStack,tUa->mHandle);
				if( tDialogue->mState==e_DialogueState_KillMe && tDialogue->mTransactions.size==0 )
				{
					IUa_DeleteDialogue(tUa,tDialogue->mHandle);
					if( tUa->mState==e_UaState_KillMe && tUa->mDialogues.size==0 )
						IStack_DeleteUa(pStack,tUa->mHandle);
				}
				return HS_OK;			
			}
			if( pEvent->mTid == HS_TID_SIP_TIMER_H )
			{
				/* XStack modify confirm->timerH->terminated flow in the INVITE server model of RFC 3261
				              to confirm->timerH-> remove transaction.
				HSKillTimer(HS_TID_SIP_TIMER_G,tTransaction->mHandle);
				tTransaction->mState = e_TransactionState_Terminated;
				HSSetTimer(HS_SIP_TIMER_K,pStack->mSipQ,HS_TID_SIP_TIMER_K,tTransaction->mHandle,e_TimerType_Once);
				*/
				IDialogue_DeleteTransaction(tDialogue,tTransaction->mHandle);
				IUa_DeleteDialogue(tUa,tDialogue->mHandle);
				if( tUa->mState==e_UaState_KillMe && tUa->mDialogues.size==0 )
					IStack_DeleteUa(pStack,tUa->mHandle);
				return HS_OK;
			}
			if( pEvent->mTid == HS_TID_SIP_TIMER_G )
			{
				if( tTransaction->mLingerMessage == NULL )
					return HS_ERR_SIP_NO_EXIST;
				if( (tEnetMessage=MakeQmEnetMessage(tTransaction,tTransaction->mLingerMessage,tTransaction->mLingerLen)) == NULL )
					return HS_ERR_MALLOC;
				tTransaction->mTimer = (tTransaction->mTimer)*2;
				HSSetTimer(tTransaction->mTimer,pStack->mSipQ,HS_TID_SIP_TIMER_G,tTransaction->mHandle,e_TimerType_Once);
				_HSThreadSendMessage(pStack->mNetQ,HS_QM_ENET_MESSAGE,0,(LPARAM)tEnetMessage);
				return HS_OK;
			}
			/* XStack dont implement completed state in the non-INVITE client model of RFC 3261
			if( pEvent->timerId == HS_TID_SIP_TIMER_K )
			*/
			return HS_ERR_CONFLICT;

		case e_TransactionState_Confirmed:
			/* XStack dont implement confirm state in the INVITE server model of RFC 3261
			*/return HS_ERR_CONFLICT;

		/* XStack make new state, terminated on INVITE server model
		   for receiving ACK message about 200 OK of INVITE.
		   of course, ACK message about 200 OK of INVITE is not included in 'transaction' flow,
		   BUT FOR EASY IMPLEMETATION, XStack suppose that it included in 'transaction' flow.
		   so, XStack Set SIP Timer K and wait ACK message about 200 OK of INVITE.
		*/
		case e_TransactionState_Terminated:
			if( pEvent->mTid != HS_TID_SIP_TIMER_K )
				return HS_ERR_CONFLICT;
			IDialogue_DeleteTransaction(tDialogue,tTransaction->mHandle);
			if( tDialogue->mState==e_DialogueStateMax && tUa->mState==e_UaState_KillMe && tUa->mDialogues.size==0 )
				IStack_DeleteUa(pStack,tUa->mHandle);
			if( tDialogue->mState==e_DialogueState_KillMe && tDialogue->mTransactions.size==0 )
			{
				IUa_DeleteDialogue(tUa,tDialogue->mHandle);
				if( tUa->mState==e_UaState_KillMe && tUa->mDialogues.size==0 )
					IStack_DeleteUa(pStack,tUa->mHandle);
			}
			return HS_OK;

		case e_TransactionStateMax:
		default:
			return HS_ERR_CONFLICT;
	}

	/* warning protection
	*/
	return HS_ERR;
}



