/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipUI.h>	2005-11-01,24:12

*/

#ifndef __2005_11_01__24_12__SIPUI_H__
#define __2005_11_01__24_12__SIPUI_H__





#include "SipDefine.h"
#include "UaDefine.h"
#include "SipDemon.h"
#include "SipEnetDemon.h"





#define HS_THREAD_STARTING_TIME		500
#define HS_THREAD_ENDING_TIME		500





/* check SIP UA licence time
*/
HS_RESULT SipUaCheckLicenceTime();





/* IStack setting functions
*/
HS_STACK_HANDLE SapiMakeStackHandle(char *pLocalIp, char *pUserAgentName);
HS_RESULT SapiRemoveStackHandle(HS_STACK_HANDLE pHandle);
HS_RESULT SapiStartStack(HS_STACK_HANDLE pHandle, HS_USHORT pUdpPort, HS_USHORT pTcpPort);
HS_RESULT SapiStopStack(HS_STACK_HANDLE pHandle);





/* IUa setting functions
*/
IUa *SapiMakeUa(
	char *pProxy,
	char *pOutBoundProxy,
	HS_USHORT pProxyPort,
	HS_UINT pExpires
);
HS_RESULT SapiRemoveUa(IUa *pUa);
HS_RESULT SapiAddContactToUa(
	HS_STACK_HANDLE pHandle,
	IUa *pUa,
	char *pDisplayName,
	char *pUserName,
	char *pLocal,
	HS_USHORT pLocalPort,
	HS_UINT pExpires
);
HS_RESULT SapiSetPasswordToUa(IUa *pUa, char *pPassword);
HS_RESULT SapiSetAuthUserToUa(IUa *pUa, char *pAuthUser);





/* Dialogue setting functions
*/
IDialogue *SapiMakeDialogue(
	char *pDisplayName,
	char *pUserName,
	char *pAddress,
	HS_USHORT pPort,
	BOOL pIsTcp
);
HS_RESULT SapiRemoveDialogue(IDialogue *pDialouge);
HS_CALL_HANDLE SapiGetDialogueHandle(IDialogue *pDialogue);





/* media capability setting functions
*/
HS_RESULT SapiAddMediaCapabilityToDialogue(
	HS_STACK_HANDLE pHandle,
	IDialogue *pDialogue,
	char *pType,
	HS_UINT pRtpIndex
);





/*
 *
 * user command APIs
 *
 */
HS_UA_HANDLE	SapiCommandAddUa(HS_STACK_HANDLE pHandle, IUa *pUa);
HS_RESULT		SapiCommandRegistUa(HS_STACK_HANDLE pStackHandle, HS_UA_HANDLE pUaHandle);
HS_RESULT		SapiCommandRemoveUa(HS_STACK_HANDLE pStackHandle, HS_UA_HANDLE pUaHandle);

HS_CALL_HANDLE	SapiCommandMakeCall(HS_STACK_HANDLE pStackHandle, HS_UA_HANDLE pUaHandle, IDialogue *pDialogue);
HS_RESULT		SapiCommandAcceptCall(HS_STACK_HANDLE pStackHandle, HS_CALL_HANDLE pCallHandle);
/* not implemented yet
HS_RESULT		SapiCommandRemodelCall(HS_STACK_HANDLE pStackHandle, HS_CALL_HANDLE pCallHandle, IDialogue *pDialogue);
*/
HS_RESULT		SapiCommandRemoveCall(HS_STACK_HANDLE pStackHandle, HS_CALL_HANDLE pCallHandle, SipResponse pReason);

/* supplementary message sending commands
*/
HS_RESULT		SapiCommandSendINFO(HS_STACK_HANDLE pStackHandle, HS_CALL_HANDLE pCallHandle, char *pType, char *pBody);
HS_RESULT		SapiCommandSendMESSAGE(HS_STACK_HANDLE pStackHandle, HS_CALL_HANDLE pCallHandle, char *pType, char *pBody);

HS_RESULT		SapiCommandChangeListenPort(HS_STACK_HANDLE pStackHandle, BOOL pIsUdp, HS_USHORT pPort);





#endif/*__2005_11_01__24_12__SIPUI_H__*/


