/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<TcpConnect.c>		2005-03-27,16:42

*/

#include "TcpConnect.h"



unsigned __stdcall ConnectThread(void* pArg)
{
	HS_UINT				lDest;
	SOCKET				tSock;
	struct sockaddr_in	tSockIn;

	QmTcpTry	*tRequest = NULL;
	QmConnected *tConnected = NULL;

	if( (tRequest=(QmTcpTry*)pArg) == NULL )
	{
#ifdef _WIN32_WCE
		ExitThread(0);
#else
		_endthreadex(0);
#endif
		return 0;
	}

	if( (tSock=socket(AF_INET,SOCK_STREAM,0)) == INVALID_SOCKET )
		tConnected = newm_QmConnected(INVALID_SOCKET,tRequest->mHandle);
	else
	{
#if 0
		Uchar2Uint(&lDest, tRequest->mIp);
#else
		lDest = MAKELONG(
			MAKEWORD(tRequest->mIp[3],tRequest->mIp[2]),
			MAKEWORD(tRequest->mIp[1],tRequest->mIp[0])
		);
#endif
		memset( &tSockIn, 0, sizeof(tSockIn) );
		tSockIn.sin_family		= AF_INET;
		tSockIn.sin_addr.s_addr	= htonl( lDest );
		tSockIn.sin_port		= htons( tRequest->mPort );

		if( connect(tSock,(struct sockaddr*)(&tSockIn),sizeof(tSockIn)) == 0 )
			tConnected = newm_QmConnected(tSock,tRequest->mHandle);
		else
			tConnected = newm_QmConnected(INVALID_SOCKET,tRequest->mHandle);
	}

	_HSThreadSendMessage(tRequest->mReturnQ, HS_QM_CONNECTED, NULL, (LPARAM)tConnected );
	deletem_QmTcpTry(tRequest);
#ifdef _WIN32_WCE
	ExitThread(0);
#else
	_endthreadex( 0 );
#endif
	return 0;
}



HS_RESULT HSConnect( HS_UCHAR *pDest, HS_USHORT pPort, HS_QID pQ, HS_TR_HANDLE pHandle )
{
	HS_QID tQ;
	QmTcpTry *tRequest = NULL;

	if( pDest == NULL ) return HS_ERR_NULL_PARAM;
	if( (tRequest=newm_QmTcpTry(pDest,pPort,pQ,pHandle)) == NULL ) return HS_ERR_MALLOC;

#ifdef _WIN32_WCE
	CreateThread(NULL,0,&ConnectThread,tRequest,0,&(tQ) );
#else
	_beginthreadex(NULL,0,&ConnectThread,tRequest,0,&(tQ) );
#endif
	return HS_OK;
}



HS_RESULT HSConnectEx(QmTcpTry *pTry)
{
	HS_QID tQ;

	if( pTry==NULL ) return HS_ERR_NULL_PARAM;

#ifdef _WIN32_WCE
	CreateThread(NULL,0,&ConnectThread,pTry,0,&(tQ));
#else
	_beginthreadex(NULL,0,&ConnectThread,pTry,0,&(tQ));
#endif
	return HS_OK;
}
