/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ppCbH323.h>	2006-03-07,22:14

  : callback functions for H.323 Endpoint Stack.
*/

#ifndef __2006_03_07__22_14__PPCBH323_H__
#define __2006_03_07__22_14__PPCBH323_H__





//#define HS_DEBUG_H323_MSG





#include "ppDefine.h"
#include "ppHandle.h"





void AppOnException(HSException pException, HS_RESULT pRet);
void AppOnAsnDecodingError(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm);

void AppOnCallIncoming(HS_STACK_HANDLE pStack, void* pCall);
void AppOnCallRemoved(HS_CALL_HANDLE pHandle, CallCloseReason pReason, Q931CauseType pCause);

void AppOnRegistrationTimeout(HS_STACK_HANDLE pStack);
void AppOnRasMessageTimeout(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, ASNH225RasMessageChoice pType, HS_USHORT pSN);

BOOL AppOnReceiveRasRawData(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm);
BOOL AppOnReceiveRasMessage(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, RasMsg *pMsg);
BOOL AppOnReceiveQ931RawData(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm);
BOOL AppOnReceiveQ931Message(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, Q931Message *pMsg);
BOOL AppOnReceiveH245RawData(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm);
BOOL AppOnReceiveH245Message(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, ControlMsg *pMsg);

BOOL AppOnSendRasMessage(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, RasMsg *pMsg);
BOOL AppOnSendRasRawData(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm);
BOOL AppOnSendQ931Message(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, Q931Message *pMsg);
BOOL AppOnSendQ931RawData(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm);
BOOL AppOnSendH245Message(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, ControlMsg *pMsg);
BOOL AppOnSendH245RawData(HS_STACK_HANDLE pStack, HS_CALL_HANDLE pCall, AsnStream *pStrm);

HS_RESULT AppOnCheckFastStart(AsnSequenceOf *pOctetString, NoLockList *pCapabilities, void *pCall);
HS_RESULT AppOnCheckTerminalCapabilitySet(HS_STACK_HANDLE pStack, void *pEndpoint, void *pCall, ASNH245TerminalCapabilitySet* pTcs);

void AppOnOpenReceiveMedia(HS_CALL_HANDLE pCall,HS_USHORT pRtpPort,HS_USHORT pRtcpPort,ASNH245DataType *pType);
void AppOnOpenSendMedia(HS_CALL_HANDLE pCall,struct sockaddr_in pRtpIn,struct sockaddr_in pRtcpIn,ASNH245DataType *pType);
void AppOnCloseReceiveMedia(HS_CALL_HANDLE pCall, ASNH245DataType *pType);
void AppOnCloseSendMedia(HS_CALL_HANDLE pCall, ASNH245DataType *pType);





#endif/*__2006_03_07__22_14__PPCBH323_H__*/