/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ppCbSip.c>		2006-03-07,22:20

*/

#include "ppCbSip.h"





/*
 *
 * callback functions
 *
 */
BOOL AppCallbackReceiveRawData(HS_UCHAR *pRaw, int pLen)
{
#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:bc-: rcv sip raw");
#ifdef HS_DEBUG_SIP_MSG
	if( pRaw != NULL ) HSPrint("\n\n%s",pRaw);
#endif
#endif

	return TRUE;
}
/* request messages except ACK,PRACK
   return value, SipResponse is selected response about request by programer user
   if it is a e_SipResponseMax, stack do process by his decision
*/
SipResponse AppCallbackReceiveMessageToResponse(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,SipMessage *pMessage)
{
	HS_QID tQid;
	SipContactUnit *tFrom = NULL;

#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: rcv req msg,ua(%u),call(%u)",pUa,pCall);
#endif

	if( pMessage==NULL ) return e_SipResponse_BadRequest;
	if( pMessage->mHeadLine.mMethod==NULL ) return e_SipResponse_BadRequest;

#ifdef HS_DEBUG_SIP
	HSPrint(",msg(%s)",pMessage->mHeadLine.mMethod);
#endif

	if( !strcmp(pMessage->mHeadLine.mMethod,"INVITE") )
	{
		if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return e_SipResponse_Ringing;
		if( pMessage->mFrom==NULL ) return e_SipResponse_Ringing;
		if( (tFrom=SipFrom_GetPrimeContactUnit(pMessage->mFrom))==NULL ) return e_SipResponse_Ringing;
		_HSThreadSendMessage(tQid,HS_QM_PP_CID,0,(HS_UINT)HSStringAlloc(tFrom->mUri.mUserName));

		return e_SipResponse_Ringing;
	}
	return e_SipResponse_Ok;
}
/* response message and ACK,PRACK request message event
*/
BOOL AppCallbackReceiveMessage(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,SipMessage *pMessage)
{
	HS_QID tQid;

#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: rcv rsp msg,ua(%u),call(%u)",pUa,pCall);
#endif

	if( pMessage==NULL ) return FALSE;

#ifdef HS_DEBUG_SIP
	if( pMessage->mHeadLine.mMethod != NULL )
		HSPrint("msg(%s)",pMessage->mHeadLine.mMethod);
	else
		HSPrint(",msg(%d)",pMessage->mHeadLine.mResponseValue);
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return TRUE;
	switch(pMessage->mHeadLine.mResponseValue)
	{
		case e_SipResponse_Ringing:
			_HSThreadSendMessage(tQid,HS_QM_PP_RING_BACK,0,(HS_UINT)pCall);
			break;
		case e_SipResponse_Ok:
			if( pMessage->mCSeq==NULL ) break;
			if( pMessage->mCSeq->mMethod==NULL ) break;
			if( strcmp(pMessage->mCSeq->mMethod,"INVITE") ) break;
			
			_HSThreadSendMessage(tQid,HS_QM_PP_CONNECTED,0,(HS_UINT)pCall);
			break;
	}

	return TRUE;
}


BOOL AppCallbackSendMessage(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,SipMessage *pMessage)
{
	HS_QID tQid;

#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: snd sip msg,ua(%u),call(%u)",pUa,pCall);
#endif

	if( pMessage==NULL ) return FALSE;

#ifdef HS_DEBUG_SIP
	if( pMessage->mHeadLine.mMethod != NULL )
		HSPrint("msg(%s)",pMessage->mHeadLine.mMethod);
	else
		HSPrint("msg(%d)",pMessage->mHeadLine.mResponseValue);
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return TRUE;
	switch(pMessage->mHeadLine.mResponseValue)
	{
		case e_SipResponse_Ok:
			if( pMessage->mCSeq==NULL ) break;
			if( pMessage->mCSeq->mMethod==NULL ) break;
			if( strcmp(pMessage->mCSeq->mMethod,"INVITE") ) break;

			_HSThreadSendMessage(tQid,HS_QM_PP_CONNECTED,0,(HS_UINT)pCall);
			break;
	}
	
	return TRUE;
}


BOOL AppCallbackSendRawData(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,HS_UCHAR *pRaw,int pLen)
{
#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: snd sip raw,ua(%u),call(%u)",pUa,pCall);
#ifdef HS_DEBUG_SIP_MSG
	if( pRaw != NULL ) HSPrint("\n\n%s",pRaw);
#endif
#endif

	return TRUE;
}


void AppCallbackBnfDecodingError(HS_UCHAR* pData,int pLen)
{
#ifdef HS_DEBUG_SIP
	{
	int i;
	HSPrint("\n :err:sip:cb-: BNF decode error");
	for(i=0;i<pLen;i++)
	{
		switch(pData[i])
		{
			case '\r': HSPrint("\\r");	break;
			case '\n': HSPrint("\\n");	break;
			case '\t': HSPrint("\\t");	break;
			case '\0': HSPrint("\\0");	break;
		}
		HSPrint("%c",pData[i]);
	}
	}
#endif
}


void AppCallbackCallIncoming(HS_STACK_HANDLE pHandle,void* pCall)
{
	HS_QID tQid;
	HS_CALL_HANDLE tHandle;
	PPOption tOption;
	IDialogue *tCall = (IDialogue*)pCall;

#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: incoming call");
#endif

	if( tCall==NULL ) return;
	if( (tHandle=SapiGetDialogueHandle(tCall))==HS_INVALID_HANDLE ) return;

#ifdef HS_DEBUG_SIP
	HSPrint(",call(%u)",tHandle);
#endif

	/* send incoming to pp
	*/
	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID )
	{
		SapiCommandRemoveCall(pHandle,tHandle,e_SipResponseMax);
		return;
	}
	_HSThreadSendMessage(tQid,HS_QM_PP_INCOMING,0,(HS_UINT)tHandle);

	/* codec setting
	*/
	if( ppHandle_GetOption(&tOption) != HS_OK )
	{
		SapiCommandRemoveCall(pHandle,tHandle,e_SipResponseMax);
		return;
	}
	if( PP_INCLUDE_G711A(tOption.mGeneral.mCodec) )
		SapiAddMediaCapabilityToDialogue(pHandle,tCall,"audio",e_RtpPayloadType_Pcma);
	if( PP_INCLUDE_G711U(tOption.mGeneral.mCodec) )
		SapiAddMediaCapabilityToDialogue(pHandle,tCall,"audio",e_RtpPayloadType_Pcmu);
	if( PP_INCLUDE_G729(tOption.mGeneral.mCodec)  )
		SapiAddMediaCapabilityToDialogue(pHandle,tCall,"audio",e_RtpPayloadType_G729);
	if( PP_INCLUDE_MSGSM(tOption.mGeneral.mCodec) )
		SapiAddMediaCapabilityToDialogue(pHandle,tCall,"audio",e_RtpPayloadType_Gsm);
	if( PP_INCLUDE_ILBC(tOption.mGeneral.mCodec)  )
		SapiAddMediaCapabilityToDialogue(pHandle,tCall,"audio",e_RtpPayloadType_iLbc);

	return;
}


void AppCallbackCallEnded(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,SipResponse pResponse)
{
	HS_QID tQid;
	QmCallEnd *tQm = NULL;

#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: call ended,ua(%u),call(%u)",pUa,pCall);
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;
	if( (tQm=newm_QmCallEnd(pCall,pResponse))==NULL ) return;

	_HSThreadSendMessage(tQid,HS_QM_PP_CALL_END,0,(HS_UINT)tQm);
}


void AppCallbackCallRemoved(HS_UA_HANDLE pUa, HS_CALL_HANDLE pCall)
{
	HS_QID tQid;
	QmCallEnd *tQm = NULL;

#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: call removed,ua(%u),call(%u)",pUa,pCall);
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;
	if( (tQm=newm_QmCallEnd(pCall,200))==NULL ) return;

	_HSThreadSendMessage(tQid,HS_QM_PP_CALL_END,0,(HS_UINT)tQm);
}


BOOL AppCallbackCallToRemove(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,RemoveReason pReason)
{
	HS_QID tQid;
	QmCallEnd *tQm = NULL;

#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: call to remove,ua(%u),call(%u)",pUa,pCall);
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return TRUE;
	if( (tQm=newm_QmCallEnd(pCall,200))==NULL ) return TRUE;

	_HSThreadSendMessage(tQid,HS_QM_PP_CALL_END,0,(HS_UINT)tQm);
	return TRUE;
}


void AppCallbackOutbandDtmf(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,char *pType,char *pBody,HS_UINT pBodyLen)
{
	HS_QID tQid;
	QmSipContext *tQm = NULL;

#ifdef HS_DEBUG_SIP
	HSPrint( "\n :inf:sip:cb-: outband dtmf,ua(%u),call(%u),type(%s),body(%s)",pUa,pCall,
		(pType==NULL)?	"null":pType,
		(pBody==NULL)?  "null":pBody
	);
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;
	if( (tQm=newm_QmSipContext(pCall,pType,pBody,pBodyLen))==NULL ) return;
	_HSThreadSendMessage(tQid,HS_QM_PP_OUT_DTMF,0,(HS_UINT)tQm);
}


void AppCallbackInstantMessage(HS_UA_HANDLE pUa,HS_CALL_HANDLE pCall,char *pType,char *pBody,HS_UINT pBodyLen)
{
	HS_QID tQid;
	QmSipContext *tQm = NULL;

#ifdef HS_DEBUG_SIP
	HSPrint( "\n :inf:sip:cb-: instant message,ua(%u),call(%u),type(%s),body(%s)",pUa,pCall,
		(pType==NULL)?	"null":pType,
		(pBody==NULL)?  "null":pBody
	);
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;
	if( (tQm=newm_QmSipContext(pCall,pType,pBody,pBodyLen))==NULL ) return;
	_HSThreadSendMessage(tQid,HS_QM_PP_INSTANT_MSG,0,(HS_UINT)tQm);
}


HS_RESULT AppCallbackCheckSdp(void* pCall,SdpMessage* pSdp)
{
#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: check sdp,call(%u)",SapiGetDialogueHandle((IDialogue*)pCall));
#endif

	return HS_ERR;
}


void AppCallbackOpenMedia(HS_CALL_HANDLE pCall,void* pMediaInfo)
{
	HS_QID tQid;
	HS_UINT tFpp = 1;
	MediaInfo *tInfo = (MediaInfo*)pMediaInfo;
	QmMediaInfo *tQmInfo = NULL;
	struct sockaddr_in tAddrIn;

#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: open media,call(%u)",pCall);
#endif

	if( tInfo==NULL ) return;
	if( tInfo->mType==NULL ) return;
	if( tInfo->mRemoteRtpAddr==NULL ) return;

#ifdef HS_DEBUG_SIP
	HSPrint(",remote(%s:%u),local(%s,%u),codec(%s)",
		tInfo->mRemoteRtpAddr, tInfo->mRemoteRtpPort,
		(tInfo->mLocalRtpAddr==NULL)? "NULL":tInfo->mLocalRtpAddr, tInfo->mLocalRtpPort,
		AppGetCodecName((RtpPayloadType)(tInfo->mNumber))
	);
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;

	switch((RtpPayloadType)(tInfo->mNumber))
	{
		case e_RtpPayloadType_Pcma:
		case e_RtpPayloadType_Pcmu:
			tFpp = 4;
			break;
		case e_RtpPayloadType_G729:
			tFpp = 2;
			break;
	}

	/* talking
	*/
	tAddrIn.sin_family = AF_INET;
	tAddrIn.sin_addr.s_addr = inet_addr(tInfo->mRemoteRtpAddr);
	tAddrIn.sin_port = htons(tInfo->mRemoteRtpPort);
	if( (tQmInfo=newm_QmMediaInfo(tAddrIn,HS_USHORT_MAX,(RtpPayloadType)(tInfo->mNumber),tFpp)) !=NULL )
		_HSThreadSendMessage(tQid,HS_QM_PP_SESSION,0,(HS_UINT)tQmInfo);

	/* hearing
	*/
	tAddrIn.sin_family = AF_MAX;
	if( (tQmInfo=newm_QmMediaInfo(tAddrIn,tInfo->mLocalRtpPort,(RtpPayloadType)(tInfo->mNumber),tFpp)) !=NULL )
		_HSThreadSendMessage(tQid,HS_QM_PP_SESSION,0,(HS_UINT)tQmInfo);
}


void AppCallbackCloseMedia(HS_CALL_HANDLE pCall,void* pMediaInfo)
{
	HS_QID tQid;

#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: close media,call(%u)",pCall);
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;
	_HSThreadSendMessage(tQid,HS_QM_PP_UNSESSION,0,e_PPDirection_Reverse);
	_HSThreadSendMessage(tQid,HS_QM_PP_UNSESSION,0,e_PPDirection_Forward);
}


void AppCallbackRegisted(HS_UA_HANDLE pUa)
{
	HS_QID tQid;

#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: regist success");
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;

	_HSThreadSendMessage(tQid,HS_QM_PP_REGIST_SUCC,0,(HS_UINT)pUa);
}


void AppCallbackRegisterFail(HS_UA_HANDLE pUa)
{
	HS_QID tQid;

#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: regist fail");
#endif

	if( (tQid=ppHandle_GetCoreQid())==HS_INVALID_QID ) return;

	_HSThreadSendMessage(tQid,HS_QM_PP_REGIST_FAIL,0,(HS_UINT)pUa);
}


void AppCallbackUaRemoved(HS_UA_HANDLE pUa)
{
#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: ua removed,ua(%u)",pUa);
#endif
}


void AppCallbackStackInformation(HS_STACK_HANDLE pHStack)
{
#ifdef HS_DEBUG_SIP
	HSPrint("\n :inf:sip:cb-: stack information");
#endif
}






