/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ppHandle.h>	2006-03-14,20:59

*/

#ifndef __2006_03_14__20_59__PPHANDLE_H__
#define __2006_03_14__20_59__PPHANDLE_H__





#include "ppDefine.h"
#include "ppUtilH323.h"
#include "ppUtilSip.h"
#include "ppMedia.h"





typedef enum
{
	e_PPState_Idle,
	e_PPState_DialTone,
	e_PPState_Dialing,
	e_PPState_Proceed,
	e_PPState_RingbackTone,
	e_PPState_FailTone,
	e_PPState_Powerring,
	e_PPState_Connect,
	e_PPStateMax
} PPState;





typedef struct
{
	HS_STACK_HANDLE mStack;
	BOOL			mIsPrime;
	BOOL			mIsRegisted;
	HS_CALL_HANDLE	mCall;
} H323Core;

HS_RESULT new_H323Core(void *pObject);
HS_RESULT delete_H323Core(void *pObject);





typedef struct
{
	HS_STACK_HANDLE	mStack;
	HS_UA_HANDLE	mUaPrime;
	HS_UA_HANDLE	mUaSecond;
	BOOL			mIsPrime;
	BOOL			mIsRegistedPrime;
	BOOL			mIsRegistedSecond;
	HS_CALL_HANDLE	mCall;
} SipCore;

HS_RESULT new_SipCore(void *pObject);
HS_RESULT delete_SipCore(void *pObject);





typedef struct
_thread_struct
(
	HWND			mHwnd;
	PPState			mState;
	PPOption		mOption;

	HS_QID			mRtp;
	H323Core		mH323;
	SipCore			mSip;

	HS_UCHAR		mLocalIp[4];
	char			mDial[128];
	HS_UINT			mDialPos;
) PPCore;

HS_RESULT new_PPCore(void *pObject,HWND pHwnd,HS_UCHAR *pLocalIp,PPOption pOption);
PPCore *newm_PPCore(HWND pHwnd,HS_UCHAR *pLocalIp,PPOption pOption);
HS_RESULT delete_PPCore(void *pObject);
HS_RESULT deletem_PPCore(void *pObject);





HS_RESULT	ppHandle_GetOption(PPOption *pOption);
void		ppHandle_SetOption(PPOption pOption);
HS_QID		ppHandle_GetCoreQid();
void		ppHandle_SetCoreQid(HS_QID pQid);





/*
 *
 * H.323 stack wrapping functions
 *
 */
HS_STACK_HANDLE PPStartH323Stack(PPOption *pOption,HS_UCHAR *pLocalIp);
HS_CALL_HANDLE PPStartH323Call(PPOption *pOption,HS_STACK_HANDLE pHandle,HS_UCHAR *pLocalIp,char *pDest);
HS_RESULT PPH323ChangeEndpointAlias(HS_STACK_HANDLE pHandle,PPOption *pOption);
HS_RESULT PPH323DtmfSignalByH245(HS_STACK_HANDLE pStackHandle,HS_CALL_HANDLE pCallHandle,char pDtmf,HS_USHORT pDur);





/*
 *
 * sip stack wrapping functions
 *
 */
HS_STACK_HANDLE PPStartSipStack(PPOption *pOption,HS_UCHAR *pLocalIp);
static HS_UA_HANDLE PPAddSipUaEx(
	HS_STACK_HANDLE pHandle,
	char *pProxy,char *pOutboundProxy,HS_USHORT pProxyPort,HS_UINT pExpires,
	char *pDisplayName,char *pUserName,HS_UCHAR *pLocalIp,HS_USHORT pLocalPort,
	char *pAuthUser,char *pPassword
);
HS_UA_HANDLE PPAddSipUa(PPOption *pOption,HS_STACK_HANDLE pHandle,HS_UCHAR *pLocalIp,BOOL pIsPrime);
HS_CALL_HANDLE PPStartSipCall(PPOption *pOption,HS_STACK_HANDLE pHandle,HS_UA_HANDLE pUa,char *pDest);
HS_CALL_HANDLE PPStartSipCallDirect(
	PPOption *pOption,
	HS_STACK_HANDLE pHandle,
	char *pSource,
	HS_UCHAR *pSourceIp,
	HS_USHORT pSourcePort,
	char *pDest,
	char *pDestIp,
	HS_USHORT pDestPort
);
HS_RESULT PPSipChangeListenPort(HS_STACK_HANDLE pHandle,BOOL pIsUdp,HS_USHORT pPort);
HS_RESULT PPSipSendInstantMessage(HS_STACK_HANDLE pHandle,HS_CALL_HANDLE pCall,char *pIM);
HS_RESULT PPSipSendINFO(HS_STACK_HANDLE pHandle,HS_CALL_HANDLE pCall,char pDtmf);





/*
 *
 * handlers
 *
 */

HS_RESULT PPCore_Initialize(void *pObject);
HS_RESULT PPCore_HandleOption(PPCore *pObj,PPOption* pOption);
HS_RESULT PPCore_HandleRegistCheck(PPCore *pObj);


/* event from user interface to PP
*/
HS_RESULT PPCore_HandleHookOff(PPCore *pObj);
HS_RESULT PPCore_HandleHookOn(PPCore *pObj);
HS_RESULT PPCore_HandleDtmf(PPCore *pObj,BOOL pIsSound,char pDtmf);
HS_RESULT PPCore_HandleDtmfCancel(PPCore *pObj);
HS_RESULT PPCore_HandleDtmfClear(PPCore *pObj);
HS_RESULT PPCore_HandleMakeCall(PPCore *pObj,HS_UINT pProtocol,char* pDest/*(if it's null,try by DTMF signal buffer)*/);
HS_RESULT PPCore_HandleRtpHold(PPCore *pObj,PPDirection pDirection);
HS_RESULT PPCore_HandleRtpResume(PPCore *pObj,PPDirection pDirection);
HS_RESULT PPCore_HandleSndInstantMessage(PPCore *pObj,char* pMsg);


/* event from callback to PP
*/
HS_RESULT PPCore_HandleCid(PPCore *pObj,HS_UINT pProtocol,char *pCid);
HS_RESULT PPCore_HandleIncomingCall(PPCore *pObj,HS_UINT pProtocol,HS_CALL_HANDLE pHandle);
HS_RESULT PPCore_HandleRingback(PPCore *pObj,HS_UINT pProtocol,HS_CALL_HANDLE pHandle);
HS_RESULT PPCore_HandleSession(PPCore *pObj,QmMediaInfo* pMedia);
HS_RESULT PPCore_HandleUnsession(PPCore *pObj,PPDirection pDirection);
HS_RESULT PPCore_HandleConnected(PPCore *pObj,HS_UINT pProtocol,HS_CALL_HANDLE pHandle);
HS_RESULT PPCore_HandleOutDtmf(PPCore *pObj,QmSipContext* pContext);
HS_RESULT PPCore_HandleRcvInstantMessage(PPCore *pObj,QmSipContext* pContext);
HS_RESULT PPCore_HandleCallEnd(PPCore *pObj,HS_UINT pProtocol,QmCallEnd* pEnd);
HS_RESULT PPCore_HandleRegistSuccess(PPCore *pObj,HS_UINT pProtocol,HS_UINT pHandle);
HS_RESULT PPCore_HandleRegistFail(PPCore *pObj,HS_UINT pProtocol,HS_UINT pHandle);





#endif/*__2006_03_14__20_59__PPHANDLE_H__*/