/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ppMedia.c>		2006-03-14,21:27

*/

#include "ppMedia.h"





/*
 *
 * static functions
 *
 */
static HS_RESULT PPMedia_HandleStartTone(PPMedia *pObj,DtmfSignal pSignal)
{
	if( pObj==NULL || pSignal>=e_DtmfSignalMax ) return HS_ERR_NULL_PARAM;
	if( pObj->mTone==HS_INVALID_RTP_HANDLE ) return HS_ERR_CONFLICT;

	switch(pObj->mState)
	{
		case e_PPMediaState_Tone:
			break;

		case e_PPMediaState_Forward:
		case e_PPMediaState_Reverse:
		case e_PPMediaState_Both:
		case e_PPMediaState_Silence:
			if( pObj->mHandle != HS_INVALID_RTP_HANDLE )
			{
				CloseRtp(pObj->mHandle);
				pObj->mHandle = HS_INVALID_RTP_HANDLE;
			}
			break;

		case e_PPMediaStateMax:
		default:
			return HS_ERR;
	}

	pObj->mState = e_PPMediaState_Tone;
	return StartCptTone(pObj->mTone,pSignal,PPMEDIA_TONE_VOL);
}


static HS_RESULT PPMedia_HandleStopTone(PPMedia *pObj)
{
	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mTone==HS_INVALID_RTP_HANDLE ) return HS_ERR_CONFLICT;

	switch(pObj->mState)
	{
		case e_PPMediaState_Tone:
			StopCptTone(pObj->mTone);
			break;

		case e_PPMediaState_Forward:
		case e_PPMediaState_Reverse:
		case e_PPMediaState_Both:
		case e_PPMediaState_Silence:
			if( pObj->mHandle != HS_INVALID_RTP_HANDLE )
			{
				CloseRtp(pObj->mHandle);
				pObj->mHandle = HS_INVALID_RTP_HANDLE;
			}
			break;

		case e_PPMediaStateMax:
		default:
			return HS_ERR;
	}

	pObj->mState = e_PPMediaState_Silence;
	return HS_OK;
}


static HS_RESULT PPMedia_HandleForwardMedia(PPMedia *pObj,QmMediaInfo *pInfo)
{
	BOOL tIsBoth = FALSE;
	HS_RESULT tRet = HS_OK;

	if( pInfo==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj==NULL )
	{
		deletem_QmMediaInfo(pInfo);
		return HS_ERR_NULL_PARAM;
	}

	switch(pObj->mState)
	{
		case e_PPMediaState_Silence:
			if( pObj->mHandle != HS_INVALID_RTP_HANDLE )
			{
				deletem_QmMediaInfo(pInfo);
				return HS_ERR_CONFLICT;
			}
			if( (pObj->mHandle=OpenRtp())==HS_INVALID_RTP_HANDLE )
			{
				deletem_QmMediaInfo(pInfo);
				return HS_ERR_MALLOC;
			}
			break;

		case e_PPMediaState_Tone:
			if( pObj->mTone != NULL )
				StopCptTone(pObj->mTone);
			break;

		case e_PPMediaState_Reverse:
			tIsBoth = TRUE;
			break;

		case e_PPMediaState_Forward:
		case e_PPMediaState_Both:
		case e_PPMediaStateMax:
		default:
			return HS_ERR;
	}

	if( (tRet=StartForwardRtpEx(pObj->mHandle,pInfo->mType,pInfo->mAddrIn,pInfo->mFpp))==HS_OK )
	{
		if( tIsBoth==TRUE ) pObj->mState = e_PPMediaState_Both;
		else				pObj->mState = e_PPMediaState_Forward;
	}

	deletem_QmMediaInfo(pInfo);
	return tRet;
}


static HS_RESULT PPMedia_HandleReverseMedia(PPMedia *pObj,QmMediaInfo *pInfo)
{
	BOOL tIsBoth = FALSE;
	HS_RESULT tRet = HS_OK;

	if( pInfo==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj==NULL )
	{
		deletem_QmMediaInfo(pInfo);
		return HS_ERR_NULL_PARAM;
	}

	switch(pObj->mState)
	{
		case e_PPMediaState_Silence:
			if( pObj->mHandle != HS_INVALID_RTP_HANDLE )
			{
				deletem_QmMediaInfo(pInfo);
				return HS_ERR_CONFLICT;
			}
			if( (pObj->mHandle=OpenRtp())==HS_INVALID_RTP_HANDLE )
			{
				deletem_QmMediaInfo(pInfo);
				return HS_ERR_MALLOC;
			}
			break;

		case e_PPMediaState_Tone:
			if( pObj->mTone != NULL )
				StopCptTone(pObj->mTone);
			break;

		case e_PPMediaState_Forward:
			tIsBoth = TRUE;
			break;

		case e_PPMediaState_Reverse:
		case e_PPMediaState_Both:
		case e_PPMediaStateMax:
		default:
			return HS_ERR;
	}

	if( (tRet=StartReverseRtp(pObj->mHandle,pInfo->mType,pInfo->mPort))==HS_OK )
	{
		if( tIsBoth==TRUE ) pObj->mState = e_PPMediaState_Both;
		else				pObj->mState = e_PPMediaState_Reverse;
	}

	deletem_QmMediaInfo(pInfo);
	return tRet;
}


static HS_RESULT PPMedia_HandleStopMedia(PPMedia *pObj)
{
	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	switch(pObj->mState)
	{
		case e_PPMediaState_Forward:
		case e_PPMediaState_Reverse:
		case e_PPMediaState_Both:
			if( pObj->mHandle==HS_INVALID_RTP_HANDLE )
				return HS_ERR_CONFLICT;
			CloseRtp(pObj->mHandle);
			pObj->mHandle = HS_INVALID_RTP_HANDLE;
			break;

		case e_PPMediaState_Tone:
		case e_PPMediaState_Silence:
		case e_PPMediaStateMax:
		default:
			return HS_ERR;
	}

	pObj->mState = e_PPMediaState_Silence;
	return HS_OK;
}


static HS_RESULT PPMedia_HandleHoldResume(PPMedia *pObj,PPDirection pDir,PPHold pHold)
{
	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mHandle==HS_INVALID_RTP_HANDLE ) return HS_ERR_CONFLICT;

	if( pDir==e_PPDirection_Forward )
	{
		if		( pHold==e_PPHold_Hold ) return HoldForwardRtp(pObj->mHandle);
		else if	( pHold==e_PPHold_Resume ) return ResumeForwardRtp(pObj->mHandle);
	}
	else if( pDir==e_PPDirection_Reverse )
	{
		if		( pHold==e_PPHold_Hold ) return HoldReverseRtp(pObj->mHandle);
		else if	( pHold==e_PPHold_Resume ) return ResumeReverseRtp(pObj->mHandle);
	}

	return HS_ERR;
}


static HS_RESULT PPMedia_HandleAddDtmfInband(PPMedia *pObj,char pDtmf)
{
	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	switch(pObj->mState)
	{
		case e_PPMediaState_Forward:
		case e_PPMediaState_Both:
			if( pObj->mHandle==HS_INVALID_RTP_HANDLE )
				return HS_ERR_CONFLICT;
			RtpCommandAddDtmfInband(pObj->mHandle,pDtmf,10);
			break;

		case e_PPMediaState_Reverse:
		case e_PPMediaState_Tone:
		case e_PPMediaState_Silence:
		case e_PPMediaStateMax:
		default:
			return HS_ERR;
	}

	return HS_OK;
}


static HS_RESULT PPMedia_HandleAddDtmfRfc2833(PPMedia *pObj,char pDtmf)
{
	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	switch(pObj->mState)
	{
		case e_PPMediaState_Forward:
		case e_PPMediaState_Both:
			if( pObj->mHandle==HS_INVALID_RTP_HANDLE )
				return HS_ERR_CONFLICT;
			RtpCommandAddDtmfRfc2833(pObj->mHandle,pDtmf);
			break;

		case e_PPMediaState_Reverse:
		case e_PPMediaState_Tone:
		case e_PPMediaState_Silence:
		case e_PPMediaStateMax:
		default:
			return HS_ERR;
	}

	return HS_OK;
}





/*
 *
 * PPMedia member functions
 *
 */
HS_RESULT new_PPMedia(void *pObject)
{
	PPMedia *pObj = (PPMedia*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	HS_THREAD_INIT(pObj,"PPMedia");
	pObj->mHandle = HS_INVALID_RTP_HANDLE;
	pObj->mTone = OpenToneHandle();
	pObj->mState = e_PPMediaState_Silence;
	return HS_OK;
}


PPMedia *newm_PPMedia()
{
	PPMedia *tResult = NULL;

	if( (tResult=(PPMedia*)HSMalloc(sizeof(PPMedia)))==NULL )
		return NULL;
	if( new_PPMedia(tResult) != HS_OK )
	{
		HSFree(tResult);
		return NULL;
	}

	return tResult;
}


HS_RESULT delete_PPMedia(void *pObject)
{
	PPMedia *pObj = (PPMedia*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mHandle != HS_INVALID_RTP_HANDLE )
	{
		pObj->mHandle = HS_INVALID_RTP_HANDLE;
		CloseRtp(pObj->mHandle);
	}
	pObj->mState = e_PPMediaState_Silence;
	if( pObj->mTone != NULL )
	{
		CloseToneHandle(pObj->mTone);
		pObj->mTone = NULL;
	}
	pObj->mQid = HS_INVALID_QID;

	return HS_OK;
}


HS_RESULT deletem_PPMedia(void *pObject)
{
	PPMedia *pObj = (PPMedia*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	delete_PPMedia(pObj);
	HSFree(pObj);
	return HS_OK;
}





/*
 *
 * PPMedia thread member functions
 *
 */
static HS_RESULT PPMedia_Main(HS_TQ pQ,void *pObject,void *pArg)
{
	HSQmsg tQmsg;
	PPMedia *pObj = (PPMedia*)pObject;

	if( pObj==NULL || pQ==HS_INVALID_TQ ) return HSExitThread(pQ,HS_ERR_NULL_PARAM);

	pObj->mActive = TRUE;
	while(pObj->mActive)
	{
		if( HSThreadGetMessage(pQ,&tQmsg,HS_QM,HS_QM_PP_MAX,TRUE)==HS_OK )
		{
            switch(tQmsg.message)
			{
				case HS_QM_STOP:
					if( pObj->mHandle!=HS_INVALID_RTP_HANDLE )
					{
						CloseRtp(pObj->mHandle);
						pObj->mHandle = HS_INVALID_RTP_HANDLE;
					}
					pObj->mActive = FALSE;
					break;
				case HS_QM_MM_START_TONE:
					PPMedia_HandleStartTone(pObj,(DtmfSignal)(tQmsg.lParam));
					break;
				case HS_QM_MM_STOP_TONE:
					PPMedia_HandleStopTone(pObj);
					break;
				case HS_QM_MM_FWRD_MEDIA:
					PPMedia_HandleForwardMedia(pObj,(QmMediaInfo*)(tQmsg.lParam));
					break;
				case HS_QM_MM_RVRS_MEDIA:
					PPMedia_HandleReverseMedia(pObj,(QmMediaInfo*)(tQmsg.lParam));
					break;
				case HS_QM_MM_STOP_MEDIA:
					PPMedia_HandleStopMedia(pObj);
					break;
				case HS_QM_MM_HOLD_RESUME:
					PPMedia_HandleHoldResume(pObj,(PPDirection)(tQmsg.wParam),(PPHold)(tQmsg.lParam));
					break;
				case HS_QM_MM_ADD_DTMF:
					PPMedia_HandleAddDtmfInband(pObj,(char)(tQmsg.lParam));
					break;
				case HS_QM_MM_ADD_DTMF_2833:
					PPMedia_HandleAddDtmfRfc2833(pObj,(char)(tQmsg.lParam));
					break;
			}
		}
	}

	deletem_PPMedia(pObj);
	return HSExitThread(pQ,HS_OK);
}





HS_QID PPMedia_Start(void *pObject)
{
	PPMedia *pObj = (PPMedia*)pObject;

	if( pObj==NULL ) return HS_INVALID_QID;
	return HSThreadStart(pObj,NULL,PPMedia_Main);
}


HS_RESULT PPMedia_Stop(HS_QID pQid)
{
	if( pQid==HS_INVALID_QID ) return HS_ERR_INVALID_PARAM;
	return _HSThreadStop(pQid);
}





HS_RESULT PPMedia_StartTone(HS_QID pQid,DtmfSignal pSignal)
{
	if( pQid==HS_INVALID_QID ) return HS_ERR_INVALID_PARAM;
	return _HSThreadSendMessage(pQid,HS_QM_MM_START_TONE,(WPARAM)0,(LPARAM)pSignal);
}


HS_RESULT PPMedia_StopTone(HS_QID pQid)
{
	if( pQid==HS_INVALID_QID ) return HS_ERR_INVALID_PARAM;
	return _HSThreadSendMessage(pQid,HS_QM_MM_STOP_TONE,(WPARAM)0,(LPARAM)NULL);
}


HS_RESULT PPMedia_ForwardMedia(HS_QID pQid,QmMediaInfo *pInfo)
{
	if( pQid==HS_INVALID_QID ) return HS_ERR_INVALID_PARAM;
	return _HSThreadSendMessage(pQid,HS_QM_MM_FWRD_MEDIA,(WPARAM)0,(LPARAM)pInfo);
}


HS_RESULT PPMedia_ReverseMedia(HS_QID pQid,QmMediaInfo *pInfo)
{
	if( pQid==HS_INVALID_QID ) return HS_ERR_INVALID_PARAM;
	return _HSThreadSendMessage(pQid,HS_QM_MM_RVRS_MEDIA,(WPARAM)0,(LPARAM)pInfo);
}


HS_RESULT PPMedia_StopMedia(HS_QID pQid)
{
	if( pQid==HS_INVALID_QID ) return HS_ERR_INVALID_PARAM;
	return _HSThreadSendMessage(pQid,HS_QM_MM_STOP_MEDIA,(WPARAM)0,(LPARAM)NULL);
}


HS_RESULT PPMedia_HoldResume(HS_QID pQid,PPDirection pDir,PPHold pHold)
{
	if( pQid==HS_INVALID_QID ) return HS_ERR_INVALID_PARAM;
	return _HSThreadSendMessage(pQid,HS_QM_MM_HOLD_RESUME,(WPARAM)pDir,(LPARAM)pHold);
}


HS_RESULT PPMedia_AddDtmfInband(HS_QID pQid,char pDtmf)
{
	if( pQid==HS_INVALID_QID ) return HS_ERR_INVALID_PARAM;
	return _HSThreadSendMessage(pQid,HS_QM_MM_ADD_DTMF,0,(LPARAM)pDtmf);
}


HS_RESULT PPMedia_AddDtmfRfc2833(HS_QID pQid,char pDtmf)
{
	if( pQid==HS_INVALID_QID ) return HS_ERR_INVALID_PARAM;
	return _HSThreadSendMessage(pQid,HS_QM_MM_ADD_DTMF_2833,0,(LPARAM)pDtmf);
}



