/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ppMedia.h>		2006-03-14,21:02

*/

#ifndef __2006_03_14__21_02__PPMEDIA_H__
#define __2006_03_14__21_02__PPMEDIA_H__





#include "ppDefine.h"
#include "RtpDefine.h"
#include "ppQmessage.h"





#define PPMEDIA_TONE_VOL		10





typedef enum
{
	e_PPMediaState_Silence,
	e_PPMediaState_Tone,
	e_PPMediaState_Forward,
	e_PPMediaState_Reverse,
	e_PPMediaState_Both,
	e_PPMediaStateMax
} PPMediaState;

typedef struct
_thread_struct
(
	HS_RTP_HANDLE	mHandle;
	tone_handle		mTone;
	PPMediaState	mState;
) PPMedia;

HS_RESULT new_PPMedia(void *pObject);
PPMedia *newm_PPMedia();
HS_RESULT delete_PPMedia(void *pObject);
HS_RESULT deletem_PPMedia(void *pObject);

HS_QID PPMedia_Start(void *pObject);
/* ! NOTE : DO NOT access PPMedia object after Stop command.
			DO NOT delete PPMedia object, it will be destroied by itself.
*/
HS_RESULT PPMedia_Stop(HS_QID pQid);

HS_RESULT PPMedia_StartTone(HS_QID pQid,DtmfSignal pSignal);
HS_RESULT PPMedia_StopTone(HS_QID pQid);
HS_RESULT PPMedia_ForwardMedia(HS_QID pQid,QmMediaInfo *pInfo);
HS_RESULT PPMedia_ReverseMedia(HS_QID pQid,QmMediaInfo *pInfo);
HS_RESULT PPMedia_StopMedia(HS_QID pQid);
HS_RESULT PPMedia_HoldResume(HS_QID pQid,PPDirection pDir,PPHold pHold);
HS_RESULT PPMedia_AddDtmfInband(HS_QID pQid,char pDtmf);
HS_RESULT PPMedia_AddDtmfRfc2833(HS_QID pQid,char pDtmf);





#endif/*__2006_03_14__21_02__PPMEDIA_H__*/
