// OptionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PlusPhone.h"
#include "OptionDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionDlg dialog


COptionDlg::COptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void COptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionDlg)
	DDX_Control(pDX, IDC_TAB_OPTION, mRccTabOption);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptionDlg, CDialog)
	//{{AFX_MSG_MAP(COptionDlg)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_OPTION, OnSelchangeTabOption)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionDlg message handlers

BOOL COptionDlg::PreTranslateMessage(MSG* pMsg) 
{
	if( pMsg->message != WM_KEYDOWN )
		return CDialog::PreTranslateMessage(pMsg);
		
	/* ENTER, ESC and SPACE to TAP
	*/
	if( pMsg->wParam==13 || pMsg->wParam==27 || pMsg->wParam==32 )
		pMsg->wParam = 9;

	return CDialog::PreTranslateMessage(pMsg);
}

#define TAB_DLG_X	1
#define TAB_DLG_Y	20

BOOL COptionDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	mGeneralDlg.Create(IDD_OPTION_GENERAL,&mRccTabOption);
	mH3231Dlg.Create(IDD_OPTION_H323_1,&mRccTabOption);
	mH3232Dlg.Create(IDD_OPTION_H323_2,&mRccTabOption);
	mSip1Dlg.Create(IDD_OPTION_SIP_1,&mRccTabOption);
	mSip2Dlg.Create(IDD_OPTION_SIP_2,&mRccTabOption);

#if defined(_WIN32_WCE)
	mRccTabOption.InsertItem(0,_T("General"));
	mRccTabOption.InsertItem(1,_T("H.323(M)"));
	mRccTabOption.InsertItem(2,_T("H.323(O)"));
	mRccTabOption.InsertItem(3,_T("SIP(M)"));
	mRccTabOption.InsertItem(4,_T("SIP(O)"));
#else
	mRccTabOption.InsertItem(0,"General");
	mRccTabOption.InsertItem(1,"H.323(M)");
	mRccTabOption.InsertItem(2,"H.323(O)");
	mRccTabOption.InsertItem(3,"SIP(M)");
	mRccTabOption.InsertItem(4,"SIP(O)");
#endif

	mH3231Dlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
		SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_HIDEWINDOW
	);
	mH3232Dlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
		SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_HIDEWINDOW
	);
	mSip1Dlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
		SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_HIDEWINDOW
	);
	mSip2Dlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
		SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_HIDEWINDOW
	);
	mGeneralDlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
		SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_SHOWWINDOW
	);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void COptionDlg::OnSelchangeTabOption(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int tCurSel = mRccTabOption.GetCurSel();

	if( tCurSel >= 5 )
	{
		*pResult = 0;
		return;
	}

	mH3231Dlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
		SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_HIDEWINDOW
	);
	mH3232Dlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
		SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_HIDEWINDOW
	);
	mSip1Dlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
		SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_HIDEWINDOW
	);
	mSip2Dlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
		SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_HIDEWINDOW
	);
	mGeneralDlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
		SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_HIDEWINDOW
	);

	switch(tCurSel)
	{
		case 0:
			mGeneralDlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
				SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_SHOWWINDOW
			);
			break;
		case 1:
			mH3231Dlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
				SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_SHOWWINDOW
			);
			break;
		case 2:
			mH3232Dlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
				SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_SHOWWINDOW
			);
			break;
		case 3:
			mSip1Dlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
				SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_SHOWWINDOW
			);
			break;
		case 4:
			mSip2Dlg.SetWindowPos(&mRccTabOption,TAB_DLG_X,TAB_DLG_Y,0,0,
				SWP_FRAMECHANGED | SWP_NOSIZE | SWP_NOZORDER | SWP_SHOWWINDOW
			);
			break;
		default:
			return;
	}

	*pResult = 0;
}


PPOption *COptionDlg::DoModalEx(PPOption pOption)
{
	PPOption *tOption = NULL;

	mGeneralDlg.mOption = pOption.mGeneral;
	mH3231Dlg.mOption = pOption.mH323;
	mH3232Dlg.mOption = pOption.mH323;
	mSip1Dlg.mOption = pOption.mSip;
	mSip2Dlg.mOption = pOption.mSip;

	if( DoModal()==IDOK )
	{
		if( (tOption=(PPOption*)HSMalloc(sizeof(PPOption)))==NULL )
			return NULL;

		new_PPOption(tOption);
		tOption->mGeneral = mGeneralDlg.mOption;
		
		tOption->mH323 = mH3231Dlg.mOption;
		tOption->mH323.mH245Point = mH3232Dlg.mOption.mH245Point;
		tOption->mH323.mFSPoint = mH3232Dlg.mOption.mFSPoint;
		tOption->mH323.mCanMapAlias = mH3232Dlg.mOption.mCanMapAlias;
		strcpy(tOption->mH323.mCallingPartyNumber,mH3232Dlg.mOption.mCallingPartyNumber);
		strcpy(tOption->mH323.mSecondGk,mH3232Dlg.mOption.mSecondGk);

		tOption->mSip = mSip2Dlg.mOption;
		tOption->mSip.mPrimePort = mSip1Dlg.mOption.mPrimePort;
		tOption->mSip.mLocalTcpPort = mSip1Dlg.mOption.mLocalTcpPort;
		tOption->mSip.mLocalUdpPort = mSip1Dlg.mOption.mLocalUdpPort;
		tOption->mSip.mTtl = mSip1Dlg.mOption.mTtl;
		strcpy(tOption->mSip.mPrimeProxy,mSip1Dlg.mOption.mPrimeProxy);
		strcpy(tOption->mSip.mUserName,mSip1Dlg.mOption.mUserName);

		return tOption;
	}

	return NULL;
}



void COptionDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	mGeneralDlg.UpdateDataEx();
	mH3231Dlg.UpdateDataEx();
	mH3232Dlg.UpdateDataEx();
	mSip1Dlg.UpdateDataEx();
	mSip2Dlg.UpdateDataEx();
}
