/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<UaSample.c>	2005-11-02,23:01

	: SIP UA(User-Agent) sample program with voiper stack.
	  It's a simple console program.

*/

#include "UaSample.h"

#include <conio.h>





HS_STACK_HANDLE	gHStack	= HS_INVALID_STACK_HANDLE;
HS_UA_HANDLE	gHUa	= HS_INVALID_HANDLE;
HS_CALL_HANDLE	gHCall	= HS_INVALID_HANDLE;

HS_RTP_HANDLE	gRtpHandle = HS_INVALID_RTP_HANDLE;





/*
 *
 * callback functions
 *
 */
BOOL AppCallbackReceiveRawData(HS_UCHAR *pRaw, int pLen)
{
	HSPrint( "\n[APP] recv-raw\t" );
#if 1
	HSPrint( "\n====================================\n" );
	HSPrint( "%s", pRaw );
	HSPrint( "====================================" );
#endif
	return TRUE;
}
/* request messages except ACK,PRACK
   return value, SipResponse is selected response about request by programer user
   if it is a e_SipResponseMax, stack do process by his decision
*/
SipResponse AppCallbackReceiveMessageToResponse(
	HS_UA_HANDLE pHUa,
	HS_CALL_HANDLE pHCall,
	SipMessage *pMessage
)
{
	HSPrint( "\n[APP] recv-msg\t" );

	if( pMessage==NULL ) return e_SipResponse_BadRequest;
	if( pMessage->mHeadLine.mMethod==NULL ) return e_SipResponse_BadRequest;

	HSPrint( ":%s", pMessage->mHeadLine.mMethod );
	
	if( !strcmp(pMessage->mHeadLine.mMethod,"INVITE") )
		return e_SipResponse_Ringing;
	return e_SipResponse_Ok;
}
/* response message and ACK,PRACK request message event
*/
BOOL AppCallbackReceiveMessage(HS_UA_HANDLE pHUa, HS_CALL_HANDLE pHCall, SipMessage *pMessage)
{
	HSPrint( "\n[APP] recv-msg\t" );

	if( pMessage==NULL ) return FALSE;

	if( pMessage->mHeadLine.mMethod!=NULL )
		HSPrint( ":%s", pMessage->mHeadLine.mMethod );
	HSPrint( ":%d", pMessage->mHeadLine.mResponseValue );

	return TRUE;
}


BOOL AppCallbackSendMessage(HS_UA_HANDLE pHUa, HS_CALL_HANDLE pHCall, SipMessage *pMessage)
{
	HSPrint( "\n[APP] send-msg\t" );

	if( pMessage==NULL ) return FALSE;

	if( pMessage->mHeadLine.mMethod!=NULL )
		HSPrint( ":%s", pMessage->mHeadLine.mMethod );
	HSPrint( ":%d", pMessage->mHeadLine.mResponseValue );

	return TRUE;
}


BOOL AppCallbackSendRawData(HS_UA_HANDLE pHUa, HS_CALL_HANDLE pHCall, HS_UCHAR *pRaw, int pLen)
{
	HSPrint( "\n[APP] send-raw\t" );
#if 1
	HSPrint( "\n====================================\n" );
	HSPrint( "%s", pRaw );
	HSPrint( "====================================" );
#endif
	return TRUE;
}


void AppCallbackBnfDecodingError(HS_UCHAR* pData, int pLen)
{
	HSPrint( "\n[APP] erro-decode\t" );
	HSPrint( "\n====================================\n" );
	HSPrint( "%s", pData );
	HSPrint( "====================================" );
}


void AppCallbackCallIncoming(HS_STACK_HANDLE pHandle, void* pCall)
{
	HSPrint( "\n[APP] call-incoming\t" );

	if( pCall==NULL ) return;

	gHCall = SapiGetDialogueHandle((IDialogue*)pCall);
#if 0
	SapiAddMediaCapabilityToDialogue(pHandle,pCall,"audio",e_RtpPayloadType_Pcma);
	SapiAddMediaCapabilityToDialogue(pHandle,pCall,"audio",e_RtpPayloadType_Pcmu);
	SapiAddMediaCapabilityToDialogue(pHandle,pCall,"audio",e_RtpPayloadType_Gsm);
	SapiAddMediaCapabilityToDialogue(pHandle,pCall,"audio",e_RtpPayloadType_G729);
#endif
	SapiAddMediaCapabilityToDialogue(pHandle,pCall,"audio",e_RtpPayloadType_iLbc);
}


void AppCallbackCallEnded(HS_UA_HANDLE pHUa, HS_CALL_HANDLE pHCall, SipResponse pResponse)
{
	HSPrint( "\n[APP] call-end(%d)", pResponse );
	if( gHCall==pHCall )
		gHCall = HS_INVALID_HANDLE;
}


void AppCallbackCallRemoved(HS_UA_HANDLE pHUa, HS_CALL_HANDLE pHCall)
{
	HSPrint( "\n[APP] call-removed" );
	if( gHCall==pHCall )
		gHCall = HS_INVALID_HANDLE;
}


BOOL AppCallbackCallToRemove(HS_UA_HANDLE pHUa, HS_CALL_HANDLE pHCall, RemoveReason pReason)
{
	HSPrint( "\n[APP] call-removing" );
	if( gHCall==pHCall )
		gHCall = HS_INVALID_HANDLE;
	return TRUE;
}


void AppCallbackOutbandDtmf(HS_UA_HANDLE pHUa,HS_CALL_HANDLE pHCall,char *pType,char *pBody,HS_UINT pBodyLen)
{
	HSPrint( "\n[APP] msg >outband-dtmf(INFO):%s,%s",
		(pType==NULL)?	"null":pType,
		(pBody==NULL)?  "null":pBody
	);
}


void AppCallbackInstantMessage(HS_UA_HANDLE pHUa,HS_CALL_HANDLE pHCall,char *pType,char *pBody,HS_UINT pBodyLen)
{
	HSPrint( "\n[APP] msg >instant-message:%s,%s",
		(pType==NULL)?	"null":pType,
		(pBody==NULL)?  "null":pBody
	);
}


HS_RESULT AppCallbackCheckSdp(void* pCall, SdpMessage* pSdp)
{
	HSPrint( "\n[APP] sdp -check\t" );
	return HS_ERR;
}


void AppCallbackOpenMedia(HS_CALL_HANDLE pHandle,void* pMediaInfo)
{
	HS_UINT tFpp = 1;
	MediaInfo *tInfo = (MediaInfo*)pMediaInfo;
	HSPrint( "\n[APP] mdia-open\t" );

	if( tInfo==NULL ) return;
	if( tInfo->mType==NULL ) return;
	if( tInfo->mRemoteRtpAddr==NULL ) return;

	HSPrint( "\n     :handle(%u)", pHandle );
	HSPrint( "\n     :codec(%d)", tInfo->mNumber);
	HSPrint( "\n     :remote(%s:%u)", tInfo->mRemoteRtpAddr, tInfo->mRemoteRtpPort );
	HSPrint( "\n     :local(%s:%u)", (tInfo->mLocalRtpAddr==NULL)? "NULL":tInfo->mLocalRtpAddr, tInfo->mLocalRtpPort );

	if( strcmp(tInfo->mType,"audio") ) return;
	if( gRtpHandle!=HS_INVALID_RTP_HANDLE )
	{
		CloseRtp(gRtpHandle);
		gRtpHandle = HS_INVALID_RTP_HANDLE; 
	}

	if( (gRtpHandle=OpenRtp())==HS_INVALID_RTP_HANDLE )
		return;

	switch((RtpPayloadType)(tInfo->mNumber))
	{
		case e_RtpPayloadType_Pcma:
		case e_RtpPayloadType_Pcmu:
			tFpp = 4;
			break;
		case e_RtpPayloadType_G729:
			tFpp = 2;
			break;
		default:
			tFpp = 1;
			break;
	}

	/* hearing
	*/
	if( tInfo->mLocalRtpAddr != NULL )
		StartReverseRtp(gRtpHandle,tInfo->mNumber,tInfo->mLocalRtpPort);
	/* talking
	*/
	if( tInfo->mRemoteRtpAddr!=NULL )
		StartForwardRtp(gRtpHandle,tInfo->mNumber,tInfo->mRemoteRtpAddr,tInfo->mRemoteRtpPort,tFpp);
}


void AppCallbackCloseMedia(HS_CALL_HANDLE pHandle,void* pMediaInfo)
{
	MediaInfo *tInfo = (MediaInfo*)pMediaInfo;
	HSPrint( "\n[APP] mdia-close\t" );

	if( tInfo==NULL ) return;
	printf( "\n     :handle(%u)", pHandle );

	if( tInfo->mType != NULL ) printf( "\n     :codec(%d)", tInfo->mNumber );
	if( tInfo->mRemoteRtpAddr!= NULL ) printf( "\n     :remote(%s:%u)", tInfo->mRemoteRtpAddr, tInfo->mRemoteRtpPort );
	if( tInfo->mLocalRtpAddr != NULL ) printf( "\n     :local(%s:%u)", tInfo->mLocalRtpAddr, tInfo->mLocalRtpPort );
	if( gRtpHandle==HS_INVALID_RTP_HANDLE ) return;

	CloseRtp(gRtpHandle);
	gRtpHandle = HS_INVALID_RTP_HANDLE;
}


void AppCallbackRegisted(HS_UA_HANDLE pHUa)
{
	HSPrint( "\n[APP] regi-success\t:ua(%u)", pHUa );
}


void AppCallbackRegisterFail(HS_UA_HANDLE pHUa)
{
	HSPrint( "\n[APP] regi-fail\t:ua(%u)", pHUa );
	gHUa = HS_INVALID_HANDLE;
}


void AppCallbackUaRemoved(HS_UA_HANDLE pHUa)
{
	HSPrint( "\n[APP] ua  -removed\t:ua(%u)", pHUa );
	gHUa = HS_INVALID_HANDLE;
}


void AppCallbackStackInformation(HS_STACK_HANDLE pHStack)
{
	HSPrint( "\n[APP] info-stack\t" );
}





/*
 *
 * wrapping functions
 *
 */
HS_STACK_HANDLE AppStartSipStack(char *pLocalIp)
{
	IStack *tResult = NULL;

	if( gHStack != HS_INVALID_STACK_HANDLE ) return HS_OK;
	if( pLocalIp==NULL ) return HS_INVALID_STACK_HANDLE;

	if( (tResult=SapiMakeStackHandle(pLocalIp,"cryptack_sip_ua_by_voiper"))==HS_INVALID_STACK_HANDLE )
		return HS_INVALID_STACK_HANDLE;

	tResult->CallbackBnfDecodingError = AppCallbackBnfDecodingError;
	tResult->CallbackCallIncoming = AppCallbackCallIncoming;
	tResult->CallbackCallEnded = AppCallbackCallEnded;
	tResult->CallbackCallRemoved = AppCallbackCallRemoved;
	tResult->CallbackCallToRemove = AppCallbackCallToRemove;
	tResult->CallbackOutbandDtmf = AppCallbackOutbandDtmf;
	tResult->CallbackInstantMessage = AppCallbackInstantMessage;
	tResult->CallbackCheckSdp = AppCallbackCheckSdp;
	tResult->CallbackCloseMedia = AppCallbackCloseMedia;
	tResult->CallbackOpenMedia = AppCallbackOpenMedia;
	tResult->CallbackReceiveMessage = AppCallbackReceiveMessage;
	tResult->CallbackReceiveMessageToResponse = AppCallbackReceiveMessageToResponse;
	tResult->CallbackReceiveRawData = AppCallbackReceiveRawData;
	tResult->CallbackRegisted = AppCallbackRegisted;
	tResult->CallbackRegisterFail = AppCallbackRegisterFail;
	tResult->CallbackSendMessage = AppCallbackSendMessage;
	tResult->CallbackSendRawData = AppCallbackSendRawData;
	tResult->CallbackStackInformation = AppCallbackStackInformation;
	tResult->CallbackUaRemoved = AppCallbackUaRemoved;

	if( SapiStartStack(tResult,5060,5060) != HS_OK )
	{
		SapiRemoveStackHandle(tResult);
		return HS_INVALID_STACK_HANDLE;
	}

	return tResult;
}


HS_RESULT AppStopSipStack()
{
	if( gHStack == HS_INVALID_STACK_HANDLE )
		return HS_OK;

	/* stop stack
	*/
	gHStack = HS_INVALID_STACK_HANDLE;
	return SapiStopStack(gHStack);
}


HS_RESULT AppDirectCall(
	char *pSourceIp,
	char *pDestIp,
	char *pSource,
	char *pDest,
	char *pPassword,
	HS_UA_HANDLE *pUaHandle,
	HS_CALL_HANDLE *pCallHandle
)
{
	IUa *tUa = NULL;
	IDialogue *tDialogue = NULL;
	HS_UA_HANDLE tUaHandle = HS_INVALID_HANDLE;
	HS_CALL_HANDLE tCallHandle = HS_INVALID_HANDLE;

	if( gHStack==HS_INVALID_STACK_HANDLE || pDestIp==NULL || pSource==NULL || pDest==NULL 
		|| pUaHandle==NULL || pCallHandle==NULL ) return HS_ERR_NULL_PARAM;

	if( (tUa=SapiMakeUa(pDestIp,NULL,5060,60))==NULL ) return HS_ERR_MALLOC;

	if( SapiAddContactToUa(gHStack,tUa,NULL,pSource,pSourceIp,5060,HS_UINT_MAX)!=HS_OK )
	{
		SapiRemoveUa(tUa);
		return HS_ERR;
	}
	if( pPassword != NULL )
	{
		if( SapiSetPasswordToUa(tUa,pPassword)!=HS_OK )
		{
			SapiRemoveUa(tUa);
			return HS_ERR;
		}
	}
	if( (tUaHandle=SapiCommandAddUa(gHStack,tUa))==HS_INVALID_HANDLE )
	{
		SapiRemoveUa(tUa);
		return HS_ERR;
	}

	if( (tDialogue=SapiMakeDialogue(NULL,pDest,NULL,HS_INVALID_TSAP_PORT,FALSE))==NULL )
	{
		SapiCommandRemoveUa(gHStack,tUaHandle);
		return HS_ERR_MALLOC;
	}

	if( SapiAddMediaCapabilityToDialogue(gHStack,tDialogue,"audio",e_RtpPayloadType_Pcma) != HS_OK )
	{
		SapiCommandRemoveUa(gHStack,tUaHandle);
		SapiRemoveDialogue(tDialogue);
		return HS_ERR;
	}
	if( SapiAddMediaCapabilityToDialogue(gHStack,tDialogue,"audio",e_RtpPayloadType_Pcmu) != HS_OK )
	{
		SapiCommandRemoveUa(gHStack,tUaHandle);
		SapiRemoveDialogue(tDialogue);
		return HS_ERR;
	}
	if( SapiAddMediaCapabilityToDialogue(gHStack,tDialogue,"audio",e_RtpPayloadType_Gsm) != HS_OK )
	{
		SapiCommandRemoveUa(gHStack,tUaHandle);
		SapiRemoveDialogue(tDialogue);
		return HS_ERR;
	}
	if( SapiAddMediaCapabilityToDialogue(gHStack,tDialogue,"audio",e_RtpPayloadType_G729) != HS_OK )
	{
		SapiCommandRemoveUa(gHStack,tUaHandle);
		SapiRemoveDialogue(tDialogue);
		return HS_ERR;
	}
	if( SapiAddMediaCapabilityToDialogue(gHStack,tDialogue,"audio",e_RtpPayloadType_iLbc) != HS_OK )
	{
		SapiCommandRemoveUa(gHStack,tUaHandle);
		SapiRemoveDialogue(tDialogue);
		return HS_ERR;
	}

	if( (tCallHandle=SapiCommandMakeCall(gHStack,tUaHandle,tDialogue))==HS_INVALID_HANDLE )
	{
		SapiCommandRemoveUa(gHStack,tUaHandle);
		SapiRemoveDialogue(tDialogue);
		return HS_ERR;
	}

	/* when direct call is over,
	   temp UA have to delete on stack.
	*/
	SapiCommandRemoveUa(gHStack,tUaHandle);
	*pUaHandle = tUaHandle;
	*pCallHandle = tCallHandle;
	return HS_OK;
}


HS_UA_HANDLE AppAddUa(
	HS_STACK_HANDLE pHandle,
	char *pProxy, char *pDisplay, char *pUser, char *pLocal, char *pPassword
)
{
	IUa *tUa = NULL;
	HS_UA_HANDLE tResult = HS_INVALID_HANDLE;

	if( pHandle==HS_INVALID_STACK_HANDLE ) return HS_INVALID_HANDLE;
	if( (tUa=SapiMakeUa(pProxy,NULL,5060,200))==NULL ) return HS_INVALID_HANDLE;

	if( SapiAddContactToUa(pHandle,tUa,NULL,pUser,pLocal,5060,HS_UINT_MAX)!=HS_OK )
	{
		SapiRemoveUa(tUa);
		return HS_INVALID_HANDLE;
	}
	if( SapiSetPasswordToUa(tUa,pPassword)!=HS_OK )
	{
		SapiRemoveUa(tUa);
		return HS_INVALID_HANDLE;
	}

	if( (tResult=SapiCommandAddUa(pHandle,tUa))==HS_INVALID_HANDLE )
	{
		SapiRemoveUa(tUa);
		return HS_INVALID_HANDLE;
	}
	return tResult;
}


HS_CALL_HANDLE AppMakeCall(HS_STACK_HANDLE pHStack, HS_UA_HANDLE pHUa, char *pDest)
{
	IDialogue *tDialogue = NULL;
	HS_CALL_HANDLE tResult = HS_INVALID_HANDLE;

	if( pDest==NULL ) return HS_INVALID_HANDLE;
	if( (tDialogue=SapiMakeDialogue(NULL,pDest,NULL,HS_INVALID_TSAP_PORT,FALSE))==NULL )
		return HS_INVALID_HANDLE;

	if( SapiAddMediaCapabilityToDialogue(pHStack,tDialogue,"audio",e_RtpPayloadType_Pcma) != HS_OK )
	{
		SapiRemoveDialogue(tDialogue);
		return HS_INVALID_HANDLE;
	}
	if( SapiAddMediaCapabilityToDialogue(pHStack,tDialogue,"audio",e_RtpPayloadType_Pcmu) != HS_OK )
	{
		SapiRemoveDialogue(tDialogue);
		return HS_INVALID_HANDLE;
	}
	if( SapiAddMediaCapabilityToDialogue(pHStack,tDialogue,"audio",e_RtpPayloadType_Gsm) != HS_OK )
	{
		SapiRemoveDialogue(tDialogue);
		return HS_INVALID_HANDLE;
	}
	if( SapiAddMediaCapabilityToDialogue(pHStack,tDialogue,"audio",e_RtpPayloadType_G729) != HS_OK )
	{
		SapiRemoveDialogue(tDialogue);
		return HS_INVALID_HANDLE;
	}
	if( SapiAddMediaCapabilityToDialogue(pHStack,tDialogue,"audio",e_RtpPayloadType_iLbc) != HS_OK )
	{
		SapiRemoveDialogue(tDialogue);
		return HS_INVALID_HANDLE;
	}

	if( (tResult=SapiCommandMakeCall(pHStack,pHUa,tDialogue))==HS_INVALID_HANDLE )
	{
		SapiRemoveDialogue(tDialogue);
		return HS_INVALID_HANDLE;
	}
	return tResult;
}


/*
 * apply functions
 *
 */
HS_UA_HANDLE ApplyUaRegist(
	HS_STACK_HANDLE pHStack,
	char *pProxy,
	char *pDisplay,
	char *pUser,
	char *pLocalIp,
	char *pPassword
)
{
	HS_UA_HANDLE tResult = HS_INVALID_HANDLE;

	if( (tResult=AppAddUa(pHStack,pProxy,pDisplay,pUser,pLocalIp,pPassword))==HS_INVALID_HANDLE )
		return HS_ERR;
	
	if( SapiCommandRegistUa(pHStack,tResult) != HS_OK )
	{
		SapiCommandRemoveUa(pHStack,tResult);
		return HS_INVALID_HANDLE;
	}

	return tResult;
}





/*
 *
 * main function
 *
 */
#define P_LOCAL_IP		argv[1]
#define P_PROXY_IP		argv[2]
#define P_DISPNAME		argv[3]
#define P_USERNAME		argv[4]
#define P_PASSWORD		argv[5]
#define SHOW_MANUAL									\
	printf(											\
		"\n =========================="				\
		"\n     MiniX-Phone Manual"					\
		"\n =========================="				\
		"\n 'h' : show help"						\
		"\n 'z' : clear screen"						\
		"\n 'e' : exit program"						\
		"\n 's' : show status"						\
		"\n 'r' : try registration"					\
		"\n 'u' : try unregistration"				\
		"\n 'c' : calling"							\
		"\n 'a' : accept call"						\
		"\n 'd' : drop call"						\
		"\n 'm' : instant message"					\
		"\n 't' : call progress tone test"			\
		"\n '/' : Send Dtmf by H245UserInputIndication"\
		"\n =========================="				\
	)



int main(int argc, char **argv)
{
	char tChar;
	char tCommand[256];
	BOOL tStackOut = FALSE;
	tone_handle tTone = NULL;

	/* check arguments
	*/
	if( argc != 6 )
	{
		printf( "Usage: MiniXPhone <local IP> <proxy IP> <display name> <user name> <password>\n" );
		printf( "example> MiniXPhone 192.168.1.1 proxy.cryptack.com Bob 030311112222 pass1234\n" );
		return 0;
	}

	/* load basic resource
	*/
#if 0
	OpenHSPrint(NULL);
#else
	LoadHSResource(10);
	HSPrintToStdOutOn();
#endif

	tTone = OpenToneHandle();

	/* start stack
	*/
	if( (gHStack=AppStartSipStack(P_LOCAL_IP))==HS_INVALID_STACK_HANDLE )
	{
		printf( "SIP Cryptack Starting Error.\n" );
		if( tTone != NULL )
			CloseToneHandle(tTone);
		return 0;
	}

	SHOW_MANUAL;
	/* prompt demon
	*/
	while(tStackOut==FALSE)
	{
		printf( "\nsip> " );

		switch((tChar=getch()))
		{
			case 'r':/*registration*/
				printf( "\n - Registration..." );
				if( gHUa != HS_INVALID_HANDLE )
				{
					SapiCommandRemoveUa(gHStack,gHUa);
					gHUa = HS_INVALID_HANDLE;
				}
				gHUa = ApplyUaRegist(gHStack,P_PROXY_IP,P_DISPNAME,P_USERNAME,P_LOCAL_IP,P_PASSWORD);
				break;

			case 'u':/*unregistration*/
				printf( "\n - Unregistration..." );
				if( gHUa != HS_INVALID_HANDLE )
				{
					SapiCommandRemoveUa(gHStack,gHUa);
					gHUa = HS_INVALID_HANDLE;
				}
				break;

			case 'c':/*calling*/
				if( gHUa == HS_INVALID_HANDLE )
				{
					printf( "\n - there is no ua!" );
					break;
				}
				if( gHCall != HS_INVALID_HANDLE )
				{
					printf( "\n - call is active!" );
					break;
				}

				printf( "\n> Destination : " );
				scanf( "%s", tCommand );
				printf( "\n - calling... (handle=%u)",
					(gHCall=AppMakeCall(gHStack,gHUa,tCommand))
				);
				break;

			case 's':/*show status*/
				printf( "\n> Show What! uhh? ('c':call, 's':skip)" );
				break;

			case 'a':/*accept call*/
				if( gHUa == HS_INVALID_HANDLE )
				{
					printf( "\n - there is no ua!" );
					break;
				}
				if( gHCall == HS_INVALID_HANDLE )
				{
					printf( "\n - there is no call!" );
					break;
				}
				IS_INCOMING_CALL(gHCall)
				{
					printf( "\n - accepting..." );
					SapiCommandAcceptCall(gHStack,gHCall);
				}
				else
				{
					printf( "\n - there is no incoming call!" );
					break;
				}
				break;

			case 'd':/*drop call*/
				if( gHUa == HS_INVALID_HANDLE )
				{
					printf( "\n - there is no ua!" );
					break;
				}
				if( gHCall == HS_INVALID_HANDLE )
				{
					printf( "\n - there is no call!" );
					break;
				}

				printf( "\n - removing..." );
				SapiCommandRemoveCall(gHStack,gHCall,e_SipResponse_NotAcceptable);
				gHCall = HS_INVALID_HANDLE;
				break;

			case 'z':/*clear DOS screen*/
				system("cls");
			case 'h':/*show menual*/
				SHOW_MANUAL;
				break;

			case 'e':/*process ending*/
				printf( "\n - Ending Application..." );
				tStackOut = TRUE;
				break;

			case '/':
				if( gHCall==HS_INVALID_HANDLE )
				{
					printf( " <err> no active call" );
					break;
				}
				if( gRtpHandle==HS_INVALID_RTP_HANDLE )
				{
					printf( " <err> no active media channel" );
					break;
				}

				printf( "Type Dtmf Charactor:" );
				/*RtpCommandAddDtmfRfc2833(gRtpHandle,(char)getche());*/
				/*RtpCommandAddDtmfInband(gRtpHandle,(char)getche(),10);*/
				sprintf(tCommand,"signal=%c\r\n",(char)getch());
				SapiCommandSendINFO(gHStack,gHCall,NULL,tCommand);
				break;

			case 'm':
				if( gHCall==HS_INVALID_HANDLE )
				{
					printf( " <err> no active call" );
					break;
				}
				if( gRtpHandle==HS_INVALID_RTP_HANDLE )
				{
					printf( " <err> no active media channel" );
					break;
				}

				printf( "\n> Message : " );
				scanf( "%s", tCommand );
				strcpy(tCommand+strlen(tCommand),"\r\n");
				SapiCommandSendMESSAGE(gHStack,gHCall,NULL,tCommand);
				break;

			case 't':
			{
				DtmfSignal tDtmfSignal = e_DtmfSignalMax;

				printf("\n> what tone(dial:0,ringback:1,busy:2,reorder:3) ");
				switch(getch())
				{
					case '0':	tDtmfSignal = e_DtmfSignal_Dial;		break;
					case '1':	tDtmfSignal = e_DtmfSignal_Ringback;	break;
					case '2':	tDtmfSignal = e_DtmfSignal_Busy;		break;
					case '3':	tDtmfSignal = e_DtmfSignal_Reorder;		break;
				}

				if( tDtmfSignal==e_DtmfSignalMax ) break;
				if( StartCptTone(tTone,tDtmfSignal,10) != HS_OK ) break;

				printf("\n - press any key to stop tone.");
				getch();
				StopCptTone(tTone);
				break;
			}

			case 'T':
				ShowThreadPool();
				break;

			default:/*any key*/
				printf( "\n - Type 'h' to see the help." );
				break;
		}
	}

	/* stop stack
	*/
	if( tTone != NULL )
		CloseToneHandle(tTone);
	CloseHSPrint();
	AppStopSipStack();

	UnloadHSResource(1000);
	return 0;
}
