// BoardStatusData.cpp: implementation of the CBoardStatusData class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "pocketfreecell.h"
#include "BoardStatusData.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBoardStatusData::CBoardStatusData()
{
}

CBoardStatusData::~CBoardStatusData()
{
}

void CBoardStatusData::Clear()
{
	memset(m_Data, 0x00, BOARDSTATUS_FILESIZE);
}

BYTE* CBoardStatusData::GetDataPointer()
{
	return m_Data;
}

/*
	m_Data[0]	aabbccdd	aa : 4=nNum	(m_Data[0] >> ((nNum - 1) << 1)) & 0x03
							bb : 3
							cc : 2
							dd : 1
*/
BoardStatusType CBoardStatusData::GetStatus(int nNum)
{
	if (nNum < 1 || nNum > 32000)
		return bstError;

	BoardStatusType Result;

	BYTE btTemp = m_Data[(nNum-1) / 4];
	Result = (BoardStatusType)((btTemp >> (((nNum - 1) % 4) << 1)) & 0x03);
	
	return Result;
}

bool CBoardStatusData::SetStatus(int nNum, BoardStatusType status, bool IsSave/*=false*/)
{
	if (nNum < 1 || nNum > 32000)
		return false;

	m_Data[(nNum-1) / 4] &= ~((BYTE)0x03 << (((nNum - 1) % 4) << 1));
	m_Data[(nNum-1) / 4] |= ((BYTE)status << (((nNum - 1) % 4) << 1));

	if (IsSave)
		Save();

	return true;
}

int	CBoardStatusData::GetStatusCount(BoardStatusType status)
{
	int nResult = 0;
	for (int i = 1; i <= 32000; i++)
	{
		if (GetStatus(i) == status)
			nResult++;
	}

	return nResult;
}

void CBoardStatusData::GetCount(int& nNormal, int& nTry, int& nMark, int& nSolved)
{
	nNormal = nTry = nMark = nSolved = 0;
	for (int i = 1; i <= 32000; i++)
	{
		switch(GetStatus(i))
		{
		case bstNormal:	nNormal++;	break;
		case bstTry:	nTry++;		break;
		case bstMark:	nMark++;	break;
		case bstSolved:	nSolved++;	break;
		}
	}
}

bool CBoardStatusData::Load(CString strPath, int nGameNum)
{
	m_strPath = strPath;

	CreateDirectory(strPath, NULL);
	CString strFileName = strPath;
	strFileName += _T("\\") BOARDSTATUS_FILENAME;
	CFile	file(strFileName, CFile::modeCreate | CFile::modeReadWrite | CFile::modeNoTruncate);
	if (file.GetLength() != BOARDSTATUS_FILESIZE)
	{
		file.Close();
		Clear();
		ClearDataFile(nGameNum);

		return true;
	}
	file.Read(m_Data, BOARDSTATUS_FILESIZE);
	file.Close();

	return false;
}

bool CBoardStatusData::Save()
{
	if (m_strPath.IsEmpty())
		return false;

	CreateDirectory(m_strPath, NULL);
	CString strFileName = m_strPath + _T("\\") BOARDSTATUS_FILENAME;

	CFile	file(strFileName, CFile::modeCreate | CFile::modeReadWrite);
	file.Write(m_Data, BOARDSTATUS_FILESIZE);
	file.Close();

	return true;
}

// nNum °  ¿ ԵǸ , Ե  
bool CBoardStatusData::CheckStatus(int nNum, bool bNormal, bool bTry, bool bMark, bool bSolved)
{
	//  ° ̸  
	if (!bNormal && !bTry && !bMark && !bSolved)
		return true;

	BoardStatusType bst = GetStatus(nNum);

	switch (bst)
	{
	case bstNormal:	return bNormal;
	case bstTry:	return bTry;
	case bstMark:	return bMark;
	case bstSolved:	return bSolved;
	}

	return false;
}

bool CBoardStatusData::ClearDataFile(int nExceptNum/*=-1*/)
{
	if (m_strPath.IsEmpty())
		return false;
	
	//  ͸ ȯѴ.
	WIN32_FIND_DATA		find_file_data;
	HANDLE	hFindFile = INVALID_HANDLE_VALUE;
	CString strFind;
	strFind.Format(_T("%s\\*.%s"), m_strPath, EXT_NAME);
	
	hFindFile = FindFirstFile( strFind, &find_file_data );
	if( (hFindFile != INVALID_HANDLE_VALUE) )
	{
		do
		{
			CString strMax( find_file_data.cFileName );
			int nTemp = _ttoi(strMax.Mid(6, strMax.GetLength() - 10));
			int nNum = _ttoi(strMax.Left(5));
			
			/*
						
				N		0		S
				N		1		T
				T		0		S
				T		1		T
				M		0		S
				M		1		M
				S		0		S
				S		1		S
			
			   : 0 -> S
			   : 1 ,  : N, T -> T
			   : 1 ,  : M, S ->  ״
			*/
			
			BoardStatusType status = GetStatus(nNum);
			if (nTemp == 0)
			{
				SetStatus(nNum, bstSolved);
			}
			else
			{
				if (status == bstNormal)
					SetStatus(nNum, bstTry);
			}
			
			if (nNum != nExceptNum)
			{
				CString strFullFileName;
				strFullFileName.Format(_T("%s\\%s"), m_strPath, strMax);
				DeleteFile(strFullFileName);
			}
		} while( FindNextFile(hFindFile, &find_file_data) );
		FindClose( hFindFile );
	}
	CString strFileName = m_strPath + _T("\\") BOARDSTATUS_FILENAME;
	CFile	file(strFileName, CFile::modeCreate | CFile::modeWrite );

	file.Write(m_Data, BOARDSTATUS_FILESIZE);
	file.Close();
	return true;
}