// BoardStatusData.h: interface for the CBoardStatusData class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BOARDSTATUSDATA_H__59DCCFFD_CEFE_43E4_BD5A_D093DE04A455__INCLUDED_)
#define AFX_BOARDSTATUSDATA_H__59DCCFFD_CEFE_43E4_BD5A_D093DE04A455__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define BOARDSTATUS_FILESIZE	(32000/4)
#define BOARDSTATUS_FILENAME	_T("BoardStatus.bsf")

#define BST_NORMAL		0x00
#define BST_TRY			0x01
#define BST_MARK		0x02
#define BST_SOLVE		0x03

enum BoardStatusType { bstNormal = 0x00, bstTry, bstMark, bstSolved, bstError = -1 };

class CBoardStatusData  
{
private:
	BYTE m_Data[BOARDSTATUS_FILESIZE];
	CString m_strPath;

public:
	CBoardStatusData();
	virtual ~CBoardStatusData();

	bool Load(CString strPath, int nGameNum);
	bool Save();
	bool ClearDataFile(int nExceptNum = -1);
	void Clear();
	BYTE* GetDataPointer();
	BoardStatusType GetStatus(int nNum);
	bool SetStatus(int nNum, BoardStatusType status, bool IsSave=false);
	int	GetStatusCount(BoardStatusType status);
	void GetCount(int& nNormal, int& nTry, int& nMark, int& nSolved);
	bool CheckStatus(int nNum, bool bNormal, bool bTry, bool bMark, bool bSolved);
};

#endif // !defined(AFX_BOARDSTATUSDATA_H__59DCCFFD_CEFE_43E4_BD5A_D093DE04A455__INCLUDED_)
