// OptionDlg.cpp : implementation file
//
#include "stdafx.h"
#include "resource.h"
#include "OptionDlg.h"
#include "MainFrm.h"
#include "PocketFreeCell.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionDlg dialog


COptionDlg::COptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionDlg)
	//}}AFX_DATA_INIT
}


void COptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionDlg)
	DDX_Control(pDX, IDC_CHECK_VIEWRATIO, m_CheckViewRatio);
	DDX_Control(pDX, IDC_CHECK_VIEWENDDAY, m_CheckViewEndDate);
	DDX_Control(pDX, IDC_CHECK_VIEWDAYSOLVE, m_CheckViewDaySolve);
	DDX_Control(pDX, IDC_CHECK_VIEWDAYEXPECT, m_CheckViewDayExpect);
	DDX_Control(pDX, IDC_CHECK_GAMETRY, m_CheckNextTry);
	DDX_Control(pDX, IDC_CHECK_GAMESOLVE, m_CheckNextSolve);
	DDX_Control(pDX, IDC_CHECK_GAMENORMAL, m_CheckNextNormal);
	DDX_Control(pDX, IDC_CHECK_GAMEMARK, m_CheckNextMark);
	DDX_Control(pDX, IDC_EDIT_ANI_STEP, m_EditAniStep);
	DDX_Control(pDX, IDC_EDIT_ANI_DELAY, m_EditAniDelay);
	DDX_Control(pDX, IDC_CHECK_MOVEANI, m_CheckMoveAni);
	DDX_Control(pDX, IDC_DATETIMEPICKER_END, m_DateTimeEnd);
	DDX_Control(pDX, IDC_DATETIMEPICKER_START, m_DateTimeStart);
	DDX_Control(pDX, IDC_CHECK_SELECT_ENDDATE, m_CheckSelectEndDate);
	DDX_Control(pDX, IDC_CHECK_SELECT_STARTDATE, m_CheckSelectStartDate);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptionDlg, CDialog)
	//{{AFX_MSG_MAP(COptionDlg)
	ON_BN_CLICKED(IDC_CHECK_MOVEANI, OnCheckMoveani)
	ON_BN_CLICKED(IDC_CHECK_SELECT_STARTDATE, OnCheckSelectStartdate)
	ON_BN_CLICKED(IDC_CHECK_SELECT_ENDDATE, OnCheckSelectEnddate)
	ON_BN_CLICKED(IDC_RADIO_RAND, OnRadioRand)
	ON_BN_CLICKED(IDC_RADIO_SEQ, OnRadioSeq)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionDlg message handlers

void COptionDlg::OnCheckMoveani() 
{
	BOOL bCheck = m_CheckMoveAni.GetCheck();
	m_EditAniDelay.EnableWindow( bCheck );
	m_EditAniStep.EnableWindow( bCheck );
}

BOOL COptionDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_CheckMoveAni.SetCheck( m_Option.bMoveAni );
	CString strTemp;
	strTemp.Format(_T("%d"), m_Option.nMoveDelay);
	m_EditAniDelay.SetWindowText(strTemp);
	strTemp.Format(_T("%d"), m_Option.nMoveStep);
	m_EditAniStep.SetWindowText(strTemp);
	
	m_CheckSelectStartDate.SetCheck( m_Option.bSelectStartDate );
	m_CheckSelectEndDate.SetCheck( m_Option.bSelectEndDate );

	CTime timeTemp(m_Option.nStartDate / 10000, (m_Option.nStartDate % 10000) / 100, (m_Option.nStartDate %100), 0, 0, 0);
	m_DateTimeStart.SetTime(&timeTemp);
	timeTemp = CTime(m_Option.nEndDate / 10000, (m_Option.nEndDate % 10000) / 100, (m_Option.nEndDate %100), 0, 0, 0);
	m_DateTimeEnd.SetTime(&timeTemp);

	if (m_Option.nNextGame == 1)
		((CButton*)GetDlgItem(IDC_RADIO_SEQ))->SetCheck(1);
	else
		((CButton*)GetDlgItem(IDC_RADIO_RAND))->SetCheck(1);

	m_CheckNextNormal.SetCheck( m_Option.bNextNormal ? 1 : 0 );
	m_CheckNextTry.SetCheck( m_Option.bNextTry ? 1 : 0 );
	m_CheckNextMark.SetCheck( m_Option.bNextMark? 1 : 0 );
	m_CheckNextSolve.SetCheck( m_Option.bNextSolved ? 1 : 0 );

	OnCheckMoveani();
	OnCheckSelectStartdate();
	OnCheckSelectEnddate();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void COptionDlg::OnCheckSelectStartdate() 
{
	m_DateTimeStart.EnableWindow( m_CheckSelectStartDate.GetCheck() );
}

void COptionDlg::OnCheckSelectEnddate() 
{
	m_DateTimeEnd.EnableWindow( m_CheckSelectEndDate.GetCheck() );
}

void COptionDlg::OnOK() 
{
	m_Option.bMoveAni = m_CheckMoveAni.GetCheck();
	CString strTemp;
	m_EditAniDelay.GetWindowText(strTemp);
	m_Option.nMoveDelay = _ttoi(strTemp);
	m_EditAniStep.GetWindowText(strTemp);
	m_Option.nMoveStep = _ttoi(strTemp);
	m_Option.bSelectStartDate = m_CheckSelectStartDate.GetCheck();
	m_Option.bSelectEndDate = m_CheckSelectEndDate.GetCheck();
	CTime timeTemp;
	m_DateTimeStart.GetTime(timeTemp);
	m_Option.nStartDate = timeTemp.GetYear() * 10000 + timeTemp.GetMonth() * 100 + timeTemp.GetDay();
	
	m_Option.nNextGame = (((CButton*)GetDlgItem(IDC_RADIO_SEQ))->GetCheck()) ? 1 : 2;
	m_Option.bNextNormal = m_CheckNextNormal.GetCheck();
	m_Option.bNextTry = m_CheckNextTry.GetCheck();
	m_Option.bNextMark = m_CheckNextMark.GetCheck();
	m_Option.bNextSolved = m_CheckNextSolve.GetCheck();

	CDialog::OnOK();
}

void COptionDlg::OnRadioRand() 
{
	m_Option.nNextGame = 2;
}

void COptionDlg::OnRadioSeq() 
{
	m_Option.nNextGame = 1;
}
