/*
 * Decompiled with CFR 0.152.
 */
package org.codemaru;

import java.util.Vector;
import org.codemaru.ForwardAttr;
import org.codemaru.util.Config;
import org.codemaru.util.StringUtil;

public class ConfigFactory {
    static String version = "0.7a";
    static String author = "Programmed by Shin Ryu(kurishin@naver.com)";
    static ConfigFactory instance = null;
    Vector fAttrList = new Vector();
    String fServerHost;
    int fServerPort;
    int fLogLevel;
    boolean fKeepAlive;
    int fTimeout;

    public static String getVersion() {
        return version;
    }

    public static String getAuthor() {
        return author;
    }

    private ConfigFactory() {
        String keys;
        String sLogLevel = Config.getString("log.level");
        this.fLogLevel = "DEBUG".equals(sLogLevel) ? 0 : ("INFO".equals(sLogLevel) ? 1 : ("WARNING".equals(sLogLevel) ? 2 : ("ERROR".equals(sLogLevel) ? 3 : ("FATAL".equals(sLogLevel) ? 4 : 1))));
        this.fKeepAlive = "true".equals(Config.getString("keepalive.enabled"));
        this.fTimeout = Config.getInt("keepalive.timeout");
        if (this.fTimeout <= 0) {
            this.fTimeout = 3600;
        }
        this.fServerHost = Config.getString("server.host");
        this.fServerPort = Config.getInt("server.port");
        if (this.fServerPort == 0) {
            this.fServerPort = 8080;
        }
        if ((keys = Config.getString("service.list")) == null) {
            System.err.println("no service.list found");
            return;
        }
        this.addAttributes(keys);
    }

    public static ConfigFactory getInstance() {
        if (instance == null) {
            instance = new ConfigFactory();
        }
        return instance;
    }

    public String getServerHost() {
        return this.fServerHost;
    }

    public int getServerPort() {
        return this.fServerPort;
    }

    public String getServiceHost(int index) {
        if (this.fAttrList == null || this.fAttrList.size() <= index) {
            return "localhost";
        }
        return ((ForwardAttr)this.fAttrList.get(index)).getServerHost();
    }

    public int getServicePort(int index) {
        if (this.fAttrList == null || this.fAttrList.size() <= index) {
            return 0;
        }
        return ((ForwardAttr)this.fAttrList.get(index)).getServerPort();
    }

    public int getForwardingPort(int index) {
        if (this.fAttrList == null || this.fAttrList.size() <= index) {
            return 0;
        }
        return ((ForwardAttr)this.fAttrList.get(index)).getForwardingPort();
    }

    public int getPortCount() {
        return this.fAttrList.size();
    }

    public int getLogLevel() {
        return this.fLogLevel;
    }

    public boolean getKeepAlive() {
        return this.fKeepAlive;
    }

    public int getTimeout() {
        return this.fTimeout;
    }

    void addAttributes(String keys) {
        String[] list = StringUtil.split(keys, ",");
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            if (!"".equals(list[i].trim())) {
                String serverIp = Config.getString(String.valueOf(list[i]) + ".server.host");
                int serverPort = Config.getInt(String.valueOf(list[i]) + ".server.port");
                if (serverPort != 0) {
                    int forwardingPort = Config.getInt(String.valueOf(list[i]) + ".forwarding.port");
                    if (forwardingPort == 0) {
                        forwardingPort = serverPort;
                    }
                    this.fAttrList.add(new ForwardAttr(serverIp, serverPort, forwardingPort));
                }
            }
            ++i;
        }
    }
}

