/*
 * Decompiled with CFR 0.152.
 */
package org.codemaru;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.codemaru.ConfigFactory;
import org.codemaru.ConsoleLog;
import org.codemaru.ListenerThread;
import org.codemaru.Log;
import org.codemaru.util.StreamUtil;

public class PClient {
    static Log log = ConsoleLog.getInstance();

    public static void main(String[] args) {
        SocketChannel toSockChannel = null;
        ConfigFactory conf = ConfigFactory.getInstance();
        System.out.print("PortForwarder Client ver ");
        System.out.println(ConfigFactory.getVersion());
        System.out.println(ConfigFactory.getAuthor());
        System.out.println();
        int i = 0;
        while (i < conf.getPortCount()) {
            try {
                InetSocketAddress toAddr = new InetSocketAddress(conf.getServerHost(), conf.getServerPort());
                log.info("service.server.host: " + conf.getServiceHost(i));
                log.info("service.server.port: " + conf.getServicePort(i));
                log.info("server.host: " + conf.getServerHost());
                log.info("server.port: " + conf.getServerPort());
                log.info("forwarding.port: " + conf.getForwardingPort(i));
                toSockChannel = SocketChannel.open();
                toSockChannel.connect(toAddr);
                toSockChannel.socket().getOutputStream().write(("N\n" + conf.getForwardingPort(i) + "\n").getBytes());
                String ret = StreamUtil.readLine(toSockChannel.socket());
                if (!"OK".equals(ret)) {
                    log.fatal("Port already in use");
                } else {
                    ListenerThread thread = new ListenerThread(toSockChannel, conf.getServiceHost(i), conf.getServicePort(i));
                    thread.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

