/*
 * Decompiled with CFR 0.152.
 */
package org.codemaru.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class DateUtil {
    private static final int[] MONTHS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static Date sysdate() {
        return new Date();
    }

    public static String getDate() {
        return DateUtil.getSeparatedDate(new Date(), "");
    }

    public static String getDate(Date date) {
        return DateUtil.getSeparatedDate(date, "");
    }

    public static String getSeparatedDate() {
        return DateUtil.getSeparatedDate(new Date(), "/");
    }

    public static String getSeparatedDate(String p) {
        return DateUtil.getSeparatedDate(new Date(), p);
    }

    public static String getSeparatedDate(Date date) {
        return DateUtil.getSeparatedDate(date, "/");
    }

    public static String getSeparatedDate(Date date, String p) {
        if (p == null) {
            p = "";
        }
        return new SimpleDateFormat("yyyy" + p + "MM" + p + "dd", Locale.KOREA).format(date);
    }

    public static String getSeparatedDate(String date, String p) {
        if (date == null || date.length() < 8) {
            return date;
        }
        if (p == null) {
            p = "";
        }
        return String.valueOf(date.substring(0, 4)) + p + date.substring(4, 6) + p + date.substring(6, 8);
    }

    public static String getDateFormat() {
        return DateUtil.getDateFormat(new Date(), null);
    }

    public static String getDateFormat(Date date) {
        return DateUtil.getDateFormat(date, null);
    }

    public static String getDateFormat(String f) {
        return DateUtil.getDateFormat(new Date(), f);
    }

    public static String getDateFormat(Date date, String f) {
        if (f == null) {
            f = "yyyy/MM/dd HH:mm:ss";
        }
        return new SimpleDateFormat(f, Locale.KOREA).format(date);
    }

    public static String getTime() {
        return DateUtil.getSeparatedTime(new Date(), "");
    }

    public static String getTime(Date date) {
        return DateUtil.getSeparatedTime(date, "");
    }

    public static String getSeparatedTime() {
        return DateUtil.getSeparatedTime(new Date(), ":");
    }

    public static String getSeparatedTime(String p) {
        return DateUtil.getSeparatedTime(new Date(), p);
    }

    public static String getSeparatedTime(Date date) {
        return DateUtil.getSeparatedTime(date, "");
    }

    public static String getSeparatedTime(Date date, String p) {
        if (p == null) {
            p = "";
        }
        return new SimpleDateFormat("HH" + p + "mm" + p + "ss", Locale.KOREA).format(date);
    }

    public static String getSeparatedTime(String date, String p) {
        if (date == null || date.length() < 6) {
            return date;
        }
        if (p == null) {
            p = "";
        }
        return String.valueOf(date.substring(0, 2)) + p + date.substring(2, 4) + p + date.substring(4, 6);
    }

    public static long dateToDigit(String date) {
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(4, 6));
        int day = Integer.parseInt(date.substring(6, 8));
        long total = (year - 1) * 365 + (year - 1) / 4 - (year - 1) / 100 + (year - 1) / 400;
        int i = 0;
        while (i < month - 1) {
            total += (long)MONTHS[i];
            ++i;
        }
        if (month > 2 && (year % 4 == 0 && year % 100 != 0 || year % 400 == 0)) {
            ++total;
        }
        return total += (long)day;
    }

    public static String digitToDate(int year, int month, int day) {
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toString(year));
        if (month < 10) {
            sb.append("0");
        }
        sb.append(Integer.toString(month));
        if (day < 10) {
            sb.append("0");
        }
        sb.append(Integer.toString(day));
        return sb.toString();
    }

    public static String digitToDate(long day) {
        boolean isYun;
        int month = 1;
        long sum = day / 365L - 1L;
        int year = (int)(sum + (sum / 4L - sum / 100L + sum / 400L) / 365L);
        boolean bl = isYun = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        if ((day -= sum * 365L + sum / 4L - sum / 100L + sum / 400L) <= 0L) {
            --year;
            day += 365L;
            if (isYun) {
                ++day;
            }
        }
        int i = 0;
        while (i < 12) {
            sum = MONTHS[i];
            if (isYun && i == 1) {
                ++sum;
            }
            if (day - sum <= 0L) break;
            day -= sum;
            ++i;
            ++month;
        }
        return DateUtil.digitToDate(year, month, (int)day);
    }

    public static long dateDiff(String date1, String date2) {
        return DateUtil.dateToDigit(date2) - DateUtil.dateToDigit(date1);
    }

    public static String addDate(String date, int n) {
        long total = DateUtil.dateToDigit(date);
        return DateUtil.digitToDate(total += (long)n);
    }

    public static String addMonths(String date, int n) {
        if (date.length() != 8) {
            return date;
        }
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(4, 6));
        int day = Integer.parseInt(date.substring(6, 8));
        year += n / 12;
        if ((month += n % 12) < 1) {
            --year;
            month += 12;
        } else if (month > 12) {
            ++year;
            month -= 12;
        }
        if (day > 28) {
            switch (month) {
                case 2: {
                    boolean isYun = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
                    day = isYun ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    if (day <= 30) break;
                    day = 30;
                }
            }
        }
        return DateUtil.digitToDate(year, month, day);
    }
}

