'''
'''
import os
import time

import config
import dblib
import bbslib
import users
import emoticons

def formedDate(seconds, form='%Y-%m-%d'):
    return time.strftime(form, time.localtime(seconds))

class Statistic(bbslib.Tree):
    standard_html = 'statistic.teul'
    def __init__(self):
        self.parent = None
        self.today = time.time()
        self.secBoardStartedDate = time.mktime([int(value) for value in config.boardStartedDate.split('-')] + [0]*6) 
        self.formedToday = formedDate(self.today)
        self.formedBoardStartedDate = formedDate(self.secBoardStartedDate)
        
    def getAll(self, topPosterCount=10, topLoginCount=10, topReadCount=10):
        self.elapsedTime = self.getElapsedTime()
        self.sizeOfUsedDb = self.getSizeOfUsedDb()
        self.nPostOfToday = self.getNPostsOfToday()
        self.nPostPerDay = self.getNPostsPerDay()
        self.topPosterList = self.getTopPosterList(topPosterCount)
        self.newestUser = self.getNewestUser()
        self.numOfEmoticons = self.getNumOfEmoticons()
        self.numOfCategories = self.getNumOfCategories()
        self.numOfForums = self.getNumOfForums()
        self.numOfTopics = self.getNumOfTopics()
        self.numOfPosts = self.getNumOfPosts()
        self.latestPostDate, self.latestPoster = self.getLatestPostDateAndPoster()
        self.topLoginCountUserList = self.getTopLoginCountUserList(topLoginCount)
        self.topReadCountThreadList = self.getTopReadCountThreadList(topReadCount)

    def getSizeOfUsedDb(self): 
        cursor = dblib.getCursor()

        sumOfUsedDb = 0
        groups = bbslib.getGroups()
        for category in groups:
            for forum in category:
                cursor.execute('''show table status from %s like '%s%%' ''' % (config.dbname, forum.forumId))
                for tableInfo in cursor.fetchall():
                    sumOfUsedDb += tableInfo[5] + tableInfo[7] # Data_length, Index_length
        self.sizeOfUsedDb = '%.2f' % (sumOfUsedDb / 1024.0)
        return self.sizeOfUsedDb
    
        
    def getElapsedTime(self):
        aDay = 24 * 60 * 60        
        self.elapsedTime = '%.2f' % ((self.today - self.secBoardStartedDate) / aDay)
        return self.elapsedTime
        
    def getNPostsOfToday(self):
        cursor = dblib.getCursor()
        groups = bbslib.getGroups()
        formedDate = time.strftime('%Y-%m-%d')
        count = 0
        for category in groups:
            for forum in category:
                cursor.execute('''SELECT COUNT(*) FROM %s WHERE '%s' < date''' % (forum.forumId, formedDate))
                count += cursor.fetchone()[0]
        self.nPostsOfToday = count
        return self.nPostsOfToday
    
    def getNPostsPerDay(self):
        groups = bbslib.getGroups()
        from math import ceil
        self.nPostsPerDay = '%.2f' % (groups.nTotalPosts / ceil(float(self.elapsedTime)))
        return self.nPostsPerDay
        
    def getNumOfEmoticons(self):
        emo = emoticons.Emoticons()
        self.numOfEmoticons = len(emo.emoticons)
        return self.numOfEmoticons

    def getLatestPostDateAndPoster(self): # FIXME
        groups = bbslib.getGroups()
        self.latestPostDate = '0000-00-00 00:00:00'
        self.latestPoster = ''
        for category in groups:
            for forum in category:
                if self.latestPostDate < forum.lastDate:
                    self.latestPostDate = forum.lastDate
                    self.latestPoster = forum.lastPoster
        return self.latestPostDate, self.latestPoster
        
    def getNumOfCategories(self):
        groups = bbslib.getGroups()
        self.numOfCategories = len(groups)
        return self.numOfCategories
    
    def getNumOfForums(self):                
        groups = bbslib.getGroups()
        self.numOfForums = 0
        for category in groups:
            self.numOfForums += len(category)
        return self.numOfForums

    def getNumOfTopics(self):
        groups = bbslib.getGroups()
        self.numOfTopics = 0
        for category in groups:
            for forum in category:
                self.numOfTopics += forum.nTopics
        return self.numOfTopics

    def getNumOfPosts(self):
        groups = bbslib.getGroups()
        self.numOfPosts = groups.nTotalPosts
        return self.numOfPosts

    def getNewestUser(self):
        self.newestUser = users.getNewestUser()
        return self.newestUser

    def getTopPosterList(self, count=10):
        userList = users.getUserList(page=1, sortBy='totalPosts', order='desc', pagesize=count)
        self.topPosterList = filter(lambda user: user.totalPosts > 0, userList)
        return self.topPosterList

    def getTopLoginCountUserList(self, count=10):
        userList = users.getUserList(page=1, sortBy='loginCount', order='desc', pagesize=count)
        self.topLoginCountUserList = filter(lambda user: user.loginCount > 0, userList)
        return self.topLoginCountUserList

    def getTopReadCountThreadList(self, count=10):
        groups = bbslib.getGroups()
        threadList = []
        for category in groups:
            for forum in category:
                forum.refresh(sortBy='readCount', order='desc', pagesize=count)
                for thread in forum:
                    threadList.append(thread)
        threadList.sort(lambda rhs, lhs: cmp(lhs.readCount, rhs.readCount))
        self.topReadCountThreadList = filter(lambda thread: thread.readCount > 0, threadList[:count])
        return self.topReadCountThreadList[:count]
