import os
import re

import ConfigParser
import pyConfigParser
import users
from config import *
#userGroupConfigFile = 'userGroup.ini'

class UserGroupConfigParser(pyConfigParser.CookedConfigParser):
    def makeNewGroup(self, groupName):
        groupName = groupName.strip()
        if self.has_section(groupName):
            return False
        self.add_section(groupName)
        return True

    def write(self, fp=None):
        if fp:
            pyConfigParser.CookedConfigParser.write(self, fp)
        else:
            pyConfigParser.CookedConfigParser.write(self, open(userGroupConfigFile, 'w'))
        for user, time in users.userCache.values():
            user.getGroupList()
            user.getAccessibleForumList()
            
    def classify(self, line):
        tokens = line.split()
        plainList = filter(lambda s: s[0] != '(' and s[-1] != ')', tokens)
        reList = filter(lambda s: s[0] == '(' and s[-1] == ')', tokens)
        reList = map(lambda s: s[1:-1], reList)
        return plainList, reList

    def isMember(self, groupName, user):
        try:
            if not user:
                return False
            for fieldName in self.options(groupName):
                value = self.get(groupName, fieldName)
                if fieldName.startswith('expr_'):
                    res = eval(value, globals(), user.__dict__)
                    if res: return True
                    continue
                plainList, reList = self.classify(value)
                if not hasattr(user, fieldName):
                    continue
                value = str(getattr(user, fieldName)).strip()
                if value in plainList:
                    return True
                for rexp in reList:
                    if re.match(rexp, value):
                        return True
            return False
        except ConfigParser.NoSectionError, msg:
            return False

    def getGroupsOfUser(self, user):
        L = []
        for groupName in self.sections():
            if self.isMember(groupName, user):
                L.append(groupName)
        return L
    
    def getMembersOfGroups(self, groupNameList=[]):
        if type(groupNameList) == type(''):
            groupNameList = groupNameList.split()
        memberList = []
        userList = users.getUserList(pagesize=users.numberOfUsers())
        for user in userList:
            for groupName in groupNameList:
                if self.isMember(groupName, user) and user not in memberList:
                    memberList.append(user)
        return memberList
        
def getUserGroup(initFileName=userGroupConfigFile):
    userGroup = UserGroupConfigParser()
    userGroup.read([initFileName])
    return userGroup

def getUserGroupList():
    return getUserGroup().sections()

def readUserGroupConfigFile():
    if os.path.exists(userGroupConfigFile):
        return file(userGroupConfigFile, 'rb').read()
    return ''

def writeUserGroupConfigFile(str):
    file(userGroupConfigFile, 'wb').write(str)
