'''
$Log: init.py,v $
Revision 1.19  2003/10/23 06:12:21  gslee
important bug fix - gslee

Revision 1.18  2003/10/08 01:33:56  gslee
no message

Revision 1.17  2003/10/02 03:22:09  pybbs
message added

Revision 1.16  2003/10/01 22:19:06  pybbs
no message

Revision 1.15  2003/10/01 15:12:35  gslee
no message

Revision 1.14  2003/10/01 14:48:06  pybbs
.

Revision 1.13  2003/10/01 14:46:23  pybbs
init.py file updated

Revision 1.12  2003/09/26 11:09:45  pybbs
init2.py change init.py, Forum move over category - jangc, bsh

'''
import os
import sys
import MySQLdb

from bbs import mysqlDBlib
from bbs.pyConfigParser import *

cfg = None

def ok(s=''):
    return True

def dbExist(s=''):
    try:
        MySQLdb.connect(host=getValue('dbhost'), user=getValue('dbuser'),
                 passwd=getValue('dbpassword'), db=s)
    except:
        print 'Now, new DB %s will be created' % s
        reload(mysqlDBlib.config)
        mysqlDBlib.config.dbname = s
        mysqlDBlib.makeDB()
        return True
    print 'WARNING : DB %s is already in the system.' % s
    return True


def isRightPrefix(prefix=''):
    conn = MySQLdb.connect(host=getValue('dbhost'), user=getValue('dbuser'),
             passwd=getValue('dbpassword'), db=getValue('dbname'))
    cursor = conn.cursor()
    cursor.execute('show tables')
    L = cursor.fetchall()
    for tableName, in L:
        if tableName.startswith(prefix+'_'):
            print 'WARNING : Same prefix is being used in the DB-', tableName
    return True

def isPath(skinPath=''):
    return os.path.exists(skinPath)

def isValidDb(passwd=''):
    try:
        MySQLdb.connect(host=getValue('dbhost'), user=getValue('dbuser'),
                 passwd=passwd)
    except:
        print 'ERROR : Cannot connect to the DB. Check the input parameters again.'
        return False
    return True

message = {
    'dbhost':('======== DB SETUP =========\nInput your DB Server host address', ok, True),
    'dbuser':('Input your DB Server user name', ok, True),
    'dbpassword':('Input your DB Server password', isValidDb, False),
    'dbname':('Input DB Name', dbExist, True),
    'tablePrefix':('Input DB Table prefix(Max 15 length)', isRightPrefix, True),
    'skinPath':('======== PYBBS SETUP =========\nInput saved skins path', isPath, True),
    'sessionDir':('Input saved session data path', ok, True),
    'HOST_URL':('======== HTTP SETUP =========\nInput Web server ip or address.',  ok, True),
    'HTTP_PORT':('Input Web server port No.',  ok, True),
    
    'userId':('======== BBS ADMIN SETUP =========\nCreate bbs administrator ID', ok, True),
    'name':('Create bbs administrator name', ok, True),
    'email':('Input bbs administrator E-Mail',  ok, True),
    'password':('Create bbs administrator password', ok, True),
}

def line_input(field, default=''):
    ready = False
    while not ready:
        print message[field][0]
        s = raw_input(field + ' (' + default + ') : ').strip() or default
        checkFunc = message[field][1]
        ready = checkFunc(s)
        if not ready and not message[field][2]:
            sys.exit(1)
    return s
    
def loadConfig():
    global cfg
    if cfg:
        return
    cfg = CookedConfigParser()
    path = os.path.join('.', 'setup.cfg')
    cfg.readfp(open(path))

sectionList = ['DB setup', 'site information', 'paths']

def getValue(key):
    for section in sectionList:
        for option in cfg.options(section):
            if option == key:
                value = cfg.get(section, option)
                return value

userInfo = {}

def updateConfig():
    loadConfig()
    for section in sectionList:
        for option in cfg.options(section):
            if option in message:
                if option == 'tablePrefix':
                    if sys.platform == 'win32':
                        value = line_input(option, cfg.get(section, option))
                    else:
                        value = os.getlogin() + '_' + line_input(option, '01')
                    value = value[:15]
                else:
                    value = line_input(option, cfg.get(section, option))
                cfg.set(section, option, value)
    userInfo['uid'] = line_input('userId', 'admin')
    userInfo['name'] = line_input('name','Administrator')
    userInfo['email'] = line_input('email', cfg.get('site information', 'webmaster'))
    userInfo['passwd'] = line_input('password', 'admin')

    
def show(sections=sectionList):
    for section in sections:
        print '[', section, ']'        
        for option in cfg.options(section):
            if option in message:            
                value = cfg.get(section, option)
                print option, ':', value
        print ''
    print '[ User Information ]'
    for key, value in userInfo.items():
        print key, ':', value

def createDbAndTables():
    cfg.write(open(os.path.join('.', 'setup.cfg'), 'w'))
    file('groupDesc.txt', 'w').write('')
    from bbs import users
    reload(mysqlDBlib.config)
    mysqlDBlib.makeDB()
    mysqlDBlib.makeUserTable()
    mysqlDBlib.makeMemoTable()
    mysqlDBlib.makeEmoticonTable()
    adminLevel = cfg.get('user levels', 'adminLevel')
    admin = users.User(userInfo['uid'], userInfo['name'], userInfo['email'],
                       userInfo['passwd'], adminLevel, '', '',
                       '', '', '', '', 'Administrator', '',
                       'Python rules!', 1, 1, 1)
    try:
        if admin.register() == True:
            print 'admin registrered'
    except:
        print 'couldn\'t register admin (maybe already registered in the system)'
    return True

def addAdminUser():
    import getpass


if __name__ == '__main__':
    answer = 'n'
    while answer.lower() == 'n':
        updateConfig()
        show()
        answer = raw_input('Accept(Y/n)? ')
    createDbAndTables()
    addAdminUser()
