from gl import *
from glu import *
from glut import *

import time

def OnIdle():
	OnDisplay()

	time.sleep(0.1)

rot = 0.0

def OnDisplay():
	global rot
	glClear(GL_COLOR_BUFFER_BIT)
	glMatrixMode(GL_MODELVIEW)
	glLoadIdentity()
	glColor3f(1.0, 1.0, 1.0)
	glTranslatef(0.0, 0.0, -5.0)
	glRotatef(rot, 0.0, 1.0, 0.0)
	glutWireTeapot(1.0)
	glFlush()
	glutSwapBuffers()

	rot += 1.0
	

def OnReshape(hres, vres):
	glViewport(0, 0, hres, vres)
	
	glMatrixMode(GL_PROJECTION)
	glLoadIdentity()
	gluPerspective(90, float(hres)/float(vres), 1.0, 5000.0)

glutInitDisplayMode(GLUT_DOUBLE|GLUT_RGB)
glutInitWindowSize(640, 480)
glutCreateWindow("Embedding Python")
glutIdleFunc(OnIdle)
glutDisplayFunc(OnDisplay)
glutReshapeFunc(OnReshape)

glClearColor(0.0, 0.0, 1.0, 1.0)

glutMainLoop()