// py_ex_opengl.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <eter/py_tinker.h>

#include "glut.h"

#pragma comment(lib, "glut32.lib")

static py_tinker::object gs_idle;
static py_tinker::object gs_display;
static py_tinker::object gs_reshape;

void idle()
{
	gs_idle();
}

void display()
{
	gs_display();
}

void reshape(int hres, int vres)
{
	gs_reshape(hres, vres);
}

void set_idle(PyObject* poIdleFunc)
{
	gs_idle = poIdleFunc;
	glutIdleFunc(idle);
}

void set_display(PyObject* poDisplayFunc)
{
	gs_display = poDisplayFunc;
	glutDisplayFunc(display);
}

void set_reshape(PyObject* poReshapeFunc)
{
	gs_reshape = poReshapeFunc;
	glutReshapeFunc(reshape);
}

void initgl()
{
	py_tinker::module_("gl")
		.STDCALL_DEFV(glClear)
		.STDCALL_DEFV(glClearColor)
		.STDCALL_DEFV(glViewport)
		.STDCALL_DEFV(glMatrixMode)
		.STDCALL_DEFV(glLoadIdentity)		
		.STDCALL_DEFV(glColor3f)
		.STDCALL_DEFV(glTranslatef)
		.STDCALL_DEFV(glRotatef)
		.STDCALL_DEFV(glFlush)				
		.DEFE(GL_COLOR_BUFFER_BIT)
		.DEFE(GL_MODELVIEW)
		.DEFE(GL_PROJECTION)
		;
}

void initglu()
{
	py_tinker::module_("glu")
		.STDCALL_DEFV(gluPerspective)
		;
}

void initglut()
{
	py_tinker::module_("glut")
		.STDCALL_DEFV(glutInitDisplayMode)
		.STDCALL_DEFV(glutInitWindowSize)
		.STDCALL_DEFT(glutCreateWindow)
		.STDCALL_DEFV(glutMainLoop)
		.STDCALL_DEFV(glutSwapBuffers)
		.STDCALL_DEFV(glutWireTeapot)
		.defv("glutIdleFunc",	set_idle)
		.defv("glutReshapeFunc", set_reshape)
		.defv("glutDisplayFunc", set_display)
		.DEFE(GLUT_DOUBLE)
		.DEFE(GLUT_RGB)
		;
}

int main(int argc, char* argv[])
{
	Py_Initialize();
	Py_SetProgramName((char*)"py_test");

	initgl();
	initglu();
	initglut();
	py_tinker::PyEmbed_RunMainFile("ex_opengl.py");
	Py_Finalize();	

	return 0;
}
