# -*- coding: utf8 -*-
import os
import sys

import wx

import Configuration
import WeatherReader
import Changer

def create(parent):
	return PyWall(parent)

[wxID_FRAME1, wxID_FRAME1BUTTON1, wxID_FRAME1BUTTON2, wxID_FRAME1BUTTON3, 
 wxID_FRAME1BUTTON4, wxID_FRAME1LISTBOX1,
 wxID_FRAME1CHOICE1, wxID_FRAME1CHOICE2, wxID_FRAME1CHOICE3, 
 wxID_FRAME1PANEL1, wxID_FRAME1RADIOBUTTON1, wxID_FRAME1RADIOBUTTON2, 
 wxID_FRAME1RADIOBUTTON3, wxID_FRAME1STATICBITMAP1, wxID_FRAME1STATICBOX1, 
 wxID_FRAME1STATICBOX2, wxID_FRAME1STATICTEXT1, wxID_FRAME1STATICTEXT2, 
 wxID_FRAME1STATICTEXT3,
] = [wx.NewId() for _init_ctrls in range(19)]

class PyWall(wx.Frame):	
	TBMENU_SHOW = wx.NewId()
	TBMENU_CLOSE = wx.NewId()
	def __init__(self, parent):
		self._init_ctrls(parent)
		self.conf = Configuration.Configuration()
		self.curWeather = WeatherReader.getWeather('seoul')

	def _init_ctrls(self, prnt):
		# generated method, don't edit
		wx.Frame.__init__(self, id=wxID_FRAME1, name='', parent=prnt, 
		pos=wx.Point(585, 320), size=wx.Size(395, 393), 
		style=wx.DEFAULT_FRAME_STYLE, title='PyWall')
		self.SetClientSize(wx.Size(387, 359))

		self.panel1 = wx.Panel(id=wxID_FRAME1PANEL1, name='PanelWeather', parent=self, 
		pos=wx.Point(0, 0), size=wx.Size(387, 359), 
		style=wx.TAB_TRAVERSAL)

		self.staticBoxLocation = wx.StaticBox(id=wxID_FRAME1STATICBOX1, 
		label='Location', name='staticBoxLocation', parent=self.panel1, 
		pos=wx.Point(16, 16), size=wx.Size(352, 88), style=0)

		self.staticTextCountry = wx.StaticText(id=wxID_FRAME1STATICTEXT1, 
		label='Country', name='staticTextCountry', parent=self.panel1, 
		pos=wx.Point(40, 40), size=wx.Size(50, 16), style=0)

		self.staticTextCity = wx.StaticText(id=wxID_FRAME1STATICTEXT2, 
		label='City', name='staticTextCity', parent=self.panel1, 
		pos=wx.Point(64, 72), size=wx.Size(27, 16), style=0)

		countryNameList = Configuration.getCountryNameList()
		self.choiceCountry = wx.Choice(choices=countryNameList, id=wxID_FRAME1CHOICE1, 
		name='choiceCountry', parent=self.panel1, pos=wx.Point(105, 40), 
		size=wx.Size(200, 22), style=0)
				# FIXME extract method?

		indexOfSelectedCountry = countryNameList.index(Configuration.defaultCountry) 
		self.choiceCountry.SetSelection(indexOfSelectedCountry)
		self.Bind(wx.EVT_CHOICE, self.OnChoiceCountry, self.choiceCountry)

		cityList, defaultCity = Configuration.getCityList(Configuration.defaultCountry)
		self.choiceCity = wx.Choice(choices=cityList, id=wxID_FRAME1CHOICE2, 
			name='choiceCity', parent=self.panel1, pos=wx.Point(105, 72), 
						size=wx.Size(200, 22), style=0)

		self.setDefaultCity(cityList, defaultCity)

		self.staticBox2 = wx.StaticBox(id=wxID_FRAME1STATICBOX2, 
		label='Wallpapers', name='staticBox2', parent=self.panel1, 
		pos=wx.Point(16, 128), size=wx.Size(352, 176), style=0)

		self.choice3 = wx.Choice(choices=Configuration.WEATHERLIST, id=wxID_FRAME1CHOICE3, 
			name='choice3', parent=self.panel1, pos=wx.Point(105, 152), 
			size=wx.Size(112, 22), style=0)
		self.choice3.SetSelection(0)

		self.staticBitmap1 = wx.StaticBitmap(bitmap=wx.NullBitmap, 
			id=wxID_FRAME1STATICBITMAP1, name='staticBitmap1', 
			parent=self.panel1, pos=wx.Point(40, 192), size=wx.Size(128, 96), 
			style=0)

                self.listBoxWeather = wx.ListBox(parent=self.panel1, id=wxID_FRAME1LISTBOX1, pos=wx.Point(240, 192), size=wx.Size(100, 90),
                 choices=Configuration.WEATHERLIST, style=0, validator=wx.DefaultValidator)
                self.Bind(wx.EVT_LISTBOX, self.OnListBoxChoice, self.listBoxWeather)

		self.buttonSearch = wx.Button(id=wxID_FRAME1BUTTON1, label='Search', 
			name='buttonSearch', parent=self.panel1, pos=wx.Point(224, 152), 
			size=wx.Size(75, 24), style=0)
		self.Bind(wx.EVT_BUTTON, self.OnSearch, self.buttonSearch)

		self.buttonAddImage = wx.Button(id=wxID_FRAME1BUTTON4, label='Add', 
			name='buttonAddImage', parent=self.panel1, pos=wx.Point(304, 152), 
			size=wx.Size(55, 24), style=0)
		self.Bind(wx.EVT_BUTTON, self.OnAddImage, self.buttonAddImage)

		self.staticTextWeather = wx.StaticText(id=wxID_FRAME1STATICTEXT3, 
			label='Weather', name='staticTextWeather', parent=self.panel1, 
			pos=wx.Point(32, 152), size=wx.Size(52, 14), style=0)

		#FIXME
		self.button2 = wx.Button(id=wxID_FRAME1BUTTON2, label='Save', 
			name='button2', parent=self.panel1, pos=wx.Point(192, 320), 
			size=wx.Size(75, 24), style=0)

		self.button3 = wx.Button(id=wxID_FRAME1BUTTON3, label='Cancel', 
			name='button3', parent=self.panel1, pos=wx.Point(280, 320), 
			size=wx.Size(75, 24), style=0)
		self.Bind(wx.EVT_BUTTON, self.OnButtonCancel, self.button3)


		self.pyTimer = wx.PyTimer(self.changeWallpaper)
		self.pyTimer.Start(1000*60*15) # FIXME 15 min

		self.icon = wx.Icon("./images/pywall.ico", wx.BITMAP_TYPE_ICO) 
		self.tbicon = wx.TaskBarIcon() 

		wx.EVT_CLOSE(self, self.OnWxFrameClose)
		wx.EVT_TASKBAR_LEFT_DCLICK(self.tbicon, self.OnTaskBarActivate) 
		wx.EVT_TASKBAR_LEFT_UP(self.tbicon, self.OnTaskBarActivate) 
		wx.EVT_TASKBAR_RIGHT_UP(self.tbicon, self.OnTaskBarMenu) 
		wx.EVT_MENU(self.tbicon, self.TBMENU_SHOW, self.OnTaskBarActivate) 
		wx.EVT_MENU(self.tbicon, self.TBMENU_CLOSE, self.OnTaskBarClose) 

	def setDefaultCity(self, cityList, defaultCityName):
		if not defaultCityName in cityList:
			self.choiceCity.SetSelection(0)
		else:
			indexOfSelectedCity = cityList.index(defaultCityName)
			self.choiceCity.SetSelection(indexOfSelectedCity)
			
	def changeWallpaper(self): # FIXME
		weather = WeatherReader.getWeather('seoul')
		if self.curWeather.condition != weather.condition:
			path = os.path.join(self.conf.wallpaperFolder, weather.condition)
			if sys.platform[:3] == 'win':

                                path = path.decode('utf8').encode('mbcs') # FIXME only windows
			self.curWeather = weather
			if os.path.exists(path):
				Changer.changeWallpaper(path)


	def OnChoiceCountry(self, evt):
		cityList, defaultCity = Configuration.getCityList(evt.GetString())
		self.choiceCity.SetItems(cityList)
		self.setDefaultCity(cityList, defaultCity)

	def OnSearch(self, evt):
		wildcard = "Image files (*.jpg;*.gif;*.bmp)|*.jpg;*.gif;*.jpeg;*.bmp;*.JPG;*.GIF;*.JPEG;*.BMP" 

		dlg = wx.FileDialog(self, message="Choose a file", 
                        defaultDir=os.getcwd(), 
                        defaultFile="", 
                        wildcard=wildcard,
                        style=wx.OPEN | wx.CHANGE_DIR)

		if dlg.ShowModal() == wx.ID_OK:
			self.imagePath = dlg.GetPaths()[0]
                        self.changeStaticBitmap1(self.imagePath)
                os.chdir(self.conf.path) # XXX
		dlg.Destroy()

        def changeStaticBitmap1(self, path):
            img = wx.Image(path, wx.BITMAP_TYPE_ANY)
            img.Rescale(128, 96) # FIXME  size..
            self.staticBitmap1.SetBitmap(img.ConvertToBitmap())

	def OnAddImage(self, evt):
            selectedWeather = Configuration.WEATHERLIST[self.choice3.GetSelection()]
            newPath = self.conf.copyWallpaper(selectedWeather, self.imagePath)
            #FIXME ?????? ?????? 
            img = wx.Image(newPath, wx.BITMAP_TYPE_ANY)
            img.SaveFile(newPath, wx.BITMAP_TYPE_BMP)

        def OnListBoxChoice(self, evt):
            path = os.path.join(self.conf.wallpaperFolder, evt.GetString())
            if sys.platform[:3] == 'win':
                try:
                    imagePath = path.decode('utf8').encode('mbcs') # FIXME only windows
                except:
                    imagePath = path
            if not os.path.exists(imagePath):
                imagePath = os.path.join(self.conf.path, 'images', 'NoImage.bmp')
            self.changeStaticBitmap1(imagePath)

	def OnWxFrameClose(self, evt): 
		self.tbicon.SetIcon(self.icon, "PyWall") 
		self.Show(False) 
		#evt.Skip() 

	def OnButtonCancel(self, evt): 
		self.Destroy() 
		evt.Skip() 

	# TaskBarIcon handlers
	def OnTaskBarActivate(self, evt): 
		#if self.IsIconized(): 
		#    self.Iconize(false) 
		#if not self.IsShown(): 
		self.tbicon.RemoveIcon() 
		self.Show(True) 
		wx.GetApp().ProcessIdle() 
		#self.Raise() 

	def OnTaskBarMenu(self, evt): 
		menu = wx.Menu() 
		menu.Append(self.TBMENU_SHOW, "&Show") 
		menu.Append(self.TBMENU_CLOSE,   "&Close") 
		self.tbicon.PopupMenu(menu) 
		menu.Destroy() 
		wx.GetApp().ProcessIdle() 

	def OnTaskBarClose(self, evt): 
		self.Destroy() 
		wx.GetApp().ProcessIdle()# ????  
