// KeyMakingDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psat.h"
#include "KeyMakingDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CKeyMakingDlg dialog

#define MAX_CHAR_SIZE 43

CKeyMakingDlg::CKeyMakingDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CKeyMakingDlg::IDD, pParent)
{
	m_lMaxSize	= 0;
	m_lCurSize	= 0;
	m_nPrevPer	= 0;
	m_strPath	= _T("");
	m_strPer	= _T("");

	//{{AFX_DATA_INIT(CKeyMakingDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CKeyMakingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CKeyMakingDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	DDX_Control(pDX, IDC_STATIC_PATH, m_staticPath);
	DDX_Control(pDX, IDC_STATIC_PER, m_staticPer);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CKeyMakingDlg, CDialog)
	//{{AFX_MSG_MAP(CKeyMakingDlg)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKeyMakingDlg message handlers

void CKeyMakingDlg::SetMaxSize( unsigned long lMaxSize ) 
{
	m_lMaxSize = lMaxSize;
	PrintProgress();
}

void CKeyMakingDlg::SetCurSize( unsigned long lCurSize ) 
{
	m_lCurSize = lCurSize;

	if ( m_lCurSize && m_lMaxSize ) 
	{
		int nTempPer = m_lCurSize * 100 / m_lMaxSize; 
		if ( m_nPrevPer == nTempPer ) 
		{
			m_nPrevPer = nTempPer;
			return;
		}
		m_nPrevPer = nTempPer;
		m_strPer.Format( "%d%%", nTempPer );
	}

	PrintSize();
}

void CKeyMakingDlg::SetCurPath( char* szPath )
{
	m_strPath = "";
	for ( unsigned long i = 0; i < MAX_CHAR_SIZE; i++ ) 
	{
		if ( *(szPath + i) == NULL ) 
		{
			break;
		}
		else 
		{
			if ( i >= MAX_CHAR_SIZE - 3 ) 
			{
				m_strPath.Insert( i, '.' );
			}
			else
			{
				m_strPath.Insert( i, *(szPath + i) );
			}
		}
	}
	PrintPath();
}

void CKeyMakingDlg::PrintProgress()
{	
	PrintPath();
	PrintSize();
}

void CKeyMakingDlg::PrintPath()
{
	m_staticPath.SetWindowText( m_strPath );
}

void CKeyMakingDlg::PrintSize()
{
	if ( m_lCurSize == 0 ) 
	{
		m_staticPer.SetWindowText( "0%" );
	}
	else
	{
		m_staticPer.SetWindowText( m_strPer );
	}
}

void CKeyMakingDlg::SetDefault()
{
	m_lMaxSize	= 0;
	m_lCurSize	= 0;
	m_nPrevPer	= 0;
	m_strPath	= _T("");	 
	m_strPer	= _T("");
}