// RegisterReportDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psat.h"
#include "RegisterReportDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRegisterReportDlg dialog


CRegisterReportDlg::CRegisterReportDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRegisterReportDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRegisterReportDlg)
	m_strContent = _T("");
	//}}AFX_DATA_INIT
}


void CRegisterReportDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRegisterReportDlg)
	DDX_Control(pDX, IDC_EDIT_CONTENTS, m_editContent);
	DDX_Control(pDX, IDC_BUTTON_REGISTER, m_btnRegister);
	DDX_Control(pDX, IDC_BUTTON_CANCEL, m_btnCancel);
	DDX_Text(pDX, IDC_EDIT_CONTENTS, m_strContent);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRegisterReportDlg, CDialog)
	//{{AFX_MSG_MAP(CRegisterReportDlg)
	ON_BN_CLICKED(IDC_BUTTON_CANCEL, OnButtonCancel)
	ON_BN_CLICKED(IDC_BUTTON_REGISTER, OnButtonRegister)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRegisterReportDlg message handlers

void CRegisterReportDlg::OnButtonRegister() 
{
	UpdateData( TRUE );
	CDialog::OnOK();	
}

void CRegisterReportDlg::OnButtonCancel() 
{
	CDialog::OnCancel();	
}

BOOL CRegisterReportDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
/* ColorKey  */
	ModifyStyleEx ( 0 , WS_EX_LAYERED );
//	TRACE ( "%d %d\n" , GetLastError() , GetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE ) );
	HMODULE h_user32_dll = GetModuleHandle("USER32.DLL"); 
    if(h_user32_dll != NULL){ 
		BOOL (WINAPI *fp_set_layered_window_attributes)(HWND, COLORREF, BYTE, DWORD) = 
			(BOOL (WINAPI *)(HWND, COLORREF, BYTE, DWORD))GetProcAddress(h_user32_dll, 
			"SetLayeredWindowAttributes"); 
		if(fp_set_layered_window_attributes != NULL){ 
			(*fp_set_layered_window_attributes)(m_hWnd, RGB(255, 0, 0), 0, LWA_COLORKEY); 
		} 
    } 

	m_bmBackground.LoadBitmap ( IDB_REPORTREG_BACKGROUND );

	m_btnRegister.SetWindowPos ( NULL , 44, 90, 75, 22, NULL );
	m_btnRegister.LoadBitmaps ( IDB_REPORTREG_REG_NORMAL , IDB_REPORTREG_REG_CLICK , IDB_REPORTREG_REG_NORMAL );
	m_btnCancel.SetWindowPos ( NULL , 138, 90, 75, 22, NULL );
	m_btnCancel.LoadBitmaps ( IDB_REPORTREG_CANCLE_NORMAL , IDB_REPORTREG_CANCLE_CLICK , IDB_REPORTREG_CANCLE_NORMAL );
	m_editContent.SetWindowPos ( NULL , 10, 60, 235, 21, NULL );

	SetWindowPos(&wndTop, m_ptPosition.x, m_ptPosition.y, 256, 125, NULL);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CRegisterReportDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	CRect rect;
	GetClientRect ( &rect );
	CDC*	pDC = &dc;
	CDC*	pDrawDC;

	READY_BACKBUFFER ( GetSafeHwnd() , pDC , pDrawDC , RGB ( 255 , 0 , 0 ) );
	{
		DrawBackground ( pDrawDC );
	}
	BLIT_OPAQUE_BACKBUFFER ( pDC , pDrawDC );
}

void CRegisterReportDlg::DrawBackground ( CDC* pDC )
{
	CDC cdc;
	cdc.CreateCompatibleDC ( pDC );

	BITMAP bm;
	CBitmap* pOldBitmap = NULL;

	pOldBitmap = ( CBitmap *)cdc.SelectObject ( &m_bmBackground );
	m_bmBackground.GetBitmap( &bm );
	pDC->BitBlt ( 0 , 0 , bm.bmWidth , bm.bmHeight , &cdc , 0 , 0 , SRCCOPY );
	
	cdc.SelectObject ( pOldBitmap );
}

void CRegisterReportDlg::SetWindowPosition ( CRect rtPosition )
{
	m_ptPosition.x =  ( rtPosition.left + rtPosition.right ) / 2 - 127;
	m_ptPosition.y =  ( rtPosition.top + rtPosition.bottom ) / 2 - 62;
}

