// ShMoButton.cpp : implementation file
//

#include "stdafx.h"
#include "YButton.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_HAND     MAKEINTRESOURCE(32649)
/////////////////////////////////////////////////////////////////////////////
// YButton

//##ModelId=41352B950221
YButton::YButton()
{
	m_uiBitmapResource = 0;
	m_uiBitmapResourceSel = 0;
	m_uiBitmapResourceOver = 0;
	m_uiCurrentBitmap = 0;

	m_nWidth = 0;
	m_nHeight = 0;

	m_bOver = FALSE;

	m_pCursor = IDC_ARROW;
	m_bColorKey = FALSE;

	m_uiBitmapResourceActive = 0;

	m_bActive = FALSE;
}

//##ModelId=41352B950268
YButton::~YButton()
{
}


BEGIN_MESSAGE_MAP(YButton, CButton)
	//{{AFX_MSG_MAP(YButton)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_ERASEBKGND()
	ON_WM_TIMER()
	ON_WM_SETCURSOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// YButton message handlers
//##ModelId=41352B950254
BOOL YButton::LoadBitmaps ( UINT uiBitmapResource , UINT uiBitmapResourceSel , 
								UINT uiBitmapResourceOver , UINT uiBitmapResourceActive )
{
	m_uiCurrentBitmap = m_uiBitmapResource = uiBitmapResource;
	m_uiBitmapResourceSel = uiBitmapResourceSel;
	m_uiBitmapResourceOver = uiBitmapResourceOver;
	m_uiBitmapResourceActive = uiBitmapResourceActive;

	CBitmap bmButton;
	bmButton.LoadBitmap ( uiBitmapResource );

	BITMAP bitmap;
	bmButton.GetBitmap ( &bitmap );

	m_nWidth = bitmap.bmWidth;
	m_nHeight = bitmap.bmHeight;
	
	bmButton.DeleteObject();

	SetWindowPos ( NULL , 0 , 0 , bitmap.bmWidth , bitmap.bmHeight , SWP_NOZORDER | SWP_NOMOVE );

	return TRUE;
}

void YButton::SetColorKey ( COLORREF crColorKey )
{
	m_bColorKey = TRUE;
	m_crColorKey = crColorKey;
//	SetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE , WS_EX_LAYERED );
//	SetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE , GetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE ) | WS_EX_LAYERED );
//	SetLayeredWindowAttributes ( GetSafeHwnd() , RGB ( 255 , 0 , 0 ) , 100 , LWA_COLORKEY );
//	SetLayeredWindowAttributes ( GetSafeHwnd() , crColorKey , 0 , LWA_COLORKEY );
}

void YButton::OnMouseMove(UINT nFlags, CPoint point) 
{
//	TRACE ( "point x = %d , y = %d\n" , point.x , point.y );
	if ( !m_bOver && PtInButtonRect() )
	{
		m_bOver = TRUE;
		RedrawWindow();
		m_pCursor = IDC_HAND;	
		StartTimer();
	}
	
//	m_uiCurrentBitmap = m_uiBitmapResourceOver;
//	RedrawWindow();
//	HCURSOR hCursor = LoadCursor ( NULL , IDC_HAND );
//	SetCursor ( hCursor );
	CButton::OnMouseMove(nFlags, point);
}

void YButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
//	TRACE ( "DrawItem %d %d , SELC = %d ,\n" , lpDrawItemStruct->itemState , 
//				lpDrawItemStruct->itemAction , ODS_SELECTED );
	CDC* pDC = CDC::FromHandle ( lpDrawItemStruct->hDC );
	
	CBitmap bmButton;
	UINT uiBitmap;

	if ( m_uiBitmapResourceActive > 0 && m_bActive )
	{
		uiBitmap = m_uiBitmapResourceActive;
	}
	else
	{
		if ( lpDrawItemStruct->itemState & ODS_SELECTED )
		{
			uiBitmap = m_uiBitmapResourceSel;
		}
		else 
		{
			if ( m_bOver )
			{
	//			TRACE ( "Over\n" );
				uiBitmap = m_uiBitmapResourceOver;
			}
			else
			{
	//			TRACE ( "Not Over\n" );
				uiBitmap = m_uiBitmapResource;
			}
		}
	}
	if ( uiBitmap <= 0 )
	{
		return;
	}

	bmButton.LoadBitmap ( uiBitmap );
	if ( m_bColorKey )
	{
  		CImageList	imageList;
		DRAW_IMAGE_LIST ( 0 , 0 , lpDrawItemStruct->rcItem.right , lpDrawItemStruct->rcItem.bottom , bmButton , m_crColorKey , pDC )
	}
	else
	{
		CDC cdcButton;
		cdcButton.CreateCompatibleDC ( pDC );
		CBitmap* pBitmap = ( CBitmap *)cdcButton.SelectObject ( &bmButton );
		pDC->BitBlt ( 0 , 0 , lpDrawItemStruct->rcItem.right , 
				lpDrawItemStruct->rcItem.bottom , &cdcButton , 0 , 0 , SRCCOPY ); 	
		
		cdcButton.SelectObject ( pBitmap );
	}
	bmButton.DeleteObject();
}

void YButton::OnLButtonDown(UINT nFlags, CPoint point) 
{
//	m_uiCurrentBitmap = m_uiBitmapResourceSel;	
//	RedrawWindow();
	CButton::OnLButtonDown(nFlags, point);
}

BOOL YButton::OnEraseBkgnd(CDC* pDC) 
{	
//	return CButton::OnEraseBkgnd(pDC);
	return TRUE;
}

void YButton::StartTimer()
{
	StopTimer();
	SetTimer ( TIMER_ID_BUTTON_OVER , TIMER_BUTTON_OVER_TIME_OUT , NULL );
}

void YButton::StopTimer()
{
	KillTimer ( TIMER_ID_BUTTON_OVER );
}

void YButton::OnTimer(UINT nIDEvent) 
{
	StopTimer();
	if ( m_bOver && !PtInButtonRect() )
	{
		m_bOver = FALSE;
		m_pCursor = IDC_ARROW;
		HCURSOR hCursor = LoadCursor ( NULL , m_pCursor );
		::SetCursor ( hCursor );
		RedrawWindow();
		return;
	}
	StartTimer();
	CButton::OnTimer(nIDEvent);
}

BOOL YButton::PtInButtonRect()
{
	CRect rect;
	POINT point;
	::GetCursorPos ( &point );
	::GetWindowRect ( GetSafeHwnd() , &rect );
	return rect.PtInRect ( point );
}

BOOL YButton::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	HCURSOR hCursor = LoadCursor ( NULL , m_pCursor );
	::SetCursor ( hCursor );
	return TRUE;
//	return CButton::OnSetCursor(pWnd, nHitTest, message);
}

void YButton::SetActive ( BOOL bActive )
{
	m_bActive = bActive;
	RedrawWindow();
}