// ReplyListDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psat.h"
#include "ReplyListDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CReplyListDlg dialog


CReplyListDlg::CReplyListDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CReplyListDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CReplyListDlg)
	m_strWriteReply = _T("");
	//}}AFX_DATA_INIT
	m_nListNum		= 0;
	m_nListIndex	= 0;
	m_strProgramKey	= _T("");
	m_bIsFirst		= TRUE; 
}


void CReplyListDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CReplyListDlg)
	DDX_Control(pDX, IDC_STATIC_READ_TEXT, m_staticReadReply);
	DDX_Control(pDX, IDC_BUTTON_CLOSE, m_btnClose);
	DDX_Control(pDX, IDC_BUTTON_REGISTER_RELPY, m_btnRegisterReply);
	DDX_Control(pDX, IDC_BUTTON_REMOVE_REPLY, m_btnRemoveReply);
	DDX_Control(pDX, IDC_BUTTON_RIGHT_MOVE, m_btnRightList);
	DDX_Control(pDX, IDC_BUTTON_LEFT_MOVE, m_btnLeftList);
	DDX_Control(pDX, IDC_EDIT_READ_TEXT, m_edtReadReply);
	DDX_Control(pDX, IDC_EDIT_WRITE_TEXT, m_edtWriteReply);
	DDX_Control(pDX, IDC_LIST_REPLY, m_listReplyList);
	DDX_Text(pDX, IDC_EDIT_WRITE_TEXT, m_strWriteReply);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CReplyListDlg, CDialog)
	//{{AFX_MSG_MAP(CReplyListDlg)
	ON_BN_CLICKED(IDC_BUTTON_LEFT_MOVE, OnButtonLeftMove)
	ON_BN_CLICKED(IDC_BUTTON_REGISTER_RELPY, OnButtonRegisterRelpy)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE_REPLY, OnButtonRemoveReply)
	ON_BN_CLICKED(IDC_BUTTON_RIGHT_MOVE, OnButtonRightMove)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, OnButtonClose)
	ON_NOTIFY(NM_CLICK, IDC_LIST_REPLY, OnClickListReply)
	ON_WM_CTLCOLOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CReplyListDlg message handlers

void CReplyListDlg::OnButtonLeftMove() 
{
	
}

void CReplyListDlg::OnButtonRegisterRelpy() 
{
	UpdateData( TRUE );	
	
	if ( m_strWriteReply == "" )
	{
		MessageBox( "  ּ.", " " );
	}
	else
	{
		::SendMessage ( m_pHwnd, WM_OTHER_DLG_RECEIVED_DATA, (WPARAM)0, (LPARAM)0 );
	}
}

void CReplyListDlg::OnButtonRemoveReply() 
{
	int nIndex;
	if ( ( nIndex = m_listReplyList.GetSelectionMark() ) != -1 ) 
	{
		CString strTemp = m_listReplyList.GetItemText(nIndex, 2);
		if ( ( m_strUserId == strTemp ) && ( strTemp != "guest" ))
		{
			strTemp = m_listReplyList.GetItemText(nIndex, 0);
			m_nRemoveReplyId = _ttoi(strTemp);
			
			::SendMessage ( m_pHwnd, WM_OTHER_DLG_RECEIVED_DATA, (WPARAM)0, (LPARAM)1 );
		}
		else
		{
			MessageBox("ڽ   ƴմϴ.", "ۻ" );
		}
	}
	else
	{
		MessageBox("ϰ ϴ  ּ.", "ۻ" );
	}
}

void CReplyListDlg::OnButtonRightMove() 
{
	
}

void CReplyListDlg::SetWnd(HWND hwnd)
{
	m_pHwnd = hwnd;
}

BOOL CReplyListDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

/* ColorKey  */
	ModifyStyleEx ( 0 , WS_EX_LAYERED );
//	TRACE ( "%d %d\n" , GetLastError() , GetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE ) );
	HMODULE h_user32_dll = GetModuleHandle("USER32.DLL"); 
    if(h_user32_dll != NULL){ 
		BOOL (WINAPI *fp_set_layered_window_attributes)(HWND, COLORREF, BYTE, DWORD) = 
			(BOOL (WINAPI *)(HWND, COLORREF, BYTE, DWORD))GetProcAddress(h_user32_dll, 
			"SetLayeredWindowAttributes"); 
		if(fp_set_layered_window_attributes != NULL){ 
			(*fp_set_layered_window_attributes)(m_hWnd, RGB(255, 0, 0), 0, LWA_COLORKEY); 
		} 
    } 

	if ( m_bIsFirst ) 
	{
		m_bmBackground.LoadBitmap ( IDB_REPLYLIST_BACKGROUND );
		m_btnClose.LoadBitmaps ( IDB_SDLG_CLOSE_NORMAL , IDB_SDLG_CLOSE_CLICK , IDB_SDLG_CLOSE_OVER );
		m_btnRegisterReply.LoadBitmaps ( IDB_REPLYLIST_REGISTER_NORMAL , IDB_REPLYLIST_REGISTER_CLICK , IDB_REPLYLIST_REGISTER_NORMAL );
		m_btnRemoveReply.LoadBitmaps ( IDB_REPLYLIST_REMOVE_NORMAL , IDB_REPLYLIST_REMOVE_CLICK , IDB_REPLYLIST_REMOVE_NORMAL );
		m_btnRightList.LoadBitmaps ( IDB_REPLYLIST_RIGHT_CUR_NORMAL , IDB_REPLYLIST_RIGHT_CUR_CLICK , IDB_REPLYLIST_RIGHT_CUR_NORMAL );
		m_btnLeftList.LoadBitmaps ( IDB_REPLYLIST_LEFT_CUR_NORMAL , IDB_REPLYLIST_LEFT_CUR_CLICK , IDB_REPLYLIST_LEFT_CUR_NORMAL );	
		m_bIsFirst = FALSE;
	}
	m_btnClose.SetWindowPos ( NULL , 514, 5, 16, 16, NULL );
	m_btnRegisterReply.SetWindowPos ( NULL , 462, 54, 42, 40, NULL );
	m_btnRemoveReply.SetWindowPos ( NULL , 492, 248, 21, 86, NULL );
	m_btnRightList.SetWindowPos ( NULL , 287, 206, 18, 18, NULL );
	m_btnLeftList.SetWindowPos ( NULL , 218, 206, 18, 18, NULL );
	m_edtWriteReply.SetWindowPos ( NULL , 68, 55, 387, 41, NULL );
	m_listReplyList.SetWindowPos ( NULL , 23, 115, 488, 107, NULL );
	m_staticReadReply.SetWindowPos ( NULL , 26, 253, 460, 80, NULL );
	InitListCtrl();
	SetWindowPos(&wndTop, m_ptPosition.x, m_ptPosition.y, 537, 348, NULL);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CReplyListDlg::SetSocket( CClientSocket* pClientSocket ) 
{
	m_pClientSocket = pClientSocket;
}

void CReplyListDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	CRect rect;
	GetClientRect ( &rect );
	CDC*	pDC = &dc;
	CDC*	pDrawDC;

	READY_BACKBUFFER ( GetSafeHwnd() , pDC , pDrawDC , RGB ( 255 , 0 , 0 ) );
	{
		DrawBackground ( pDrawDC );
	}
	BLIT_OPAQUE_BACKBUFFER ( pDC , pDrawDC );
}

void CReplyListDlg::DrawBackground ( CDC* pDC )
{
	CDC cdc;
	cdc.CreateCompatibleDC ( pDC );

	BITMAP bm;
	CBitmap* pOldBitmap = NULL;

	pOldBitmap = ( CBitmap *)cdc.SelectObject ( &m_bmBackground );
	m_bmBackground.GetBitmap( &bm );
	pDC->BitBlt ( 0 , 0 , bm.bmWidth , bm.bmHeight , &cdc , 0 , 0 , SRCCOPY );
	
	if ( pOldBitmap != NULL ) 
	{
		cdc.SelectObject ( pOldBitmap );
	}
}

void CReplyListDlg::SetWindowPosition ( CRect rtPosition )
{
	m_ptPosition.x =  ( rtPosition.left + rtPosition.right ) / 2 - 268;
	m_ptPosition.y =  ( rtPosition.top + rtPosition.bottom ) / 2 - 174;
}

void CReplyListDlg::OnButtonClose() 
{
	m_btnClose.m_bOver = 0;
	CDialog::OnCancel();	
}

void CReplyListDlg::GivenReceiveData ( KReplyListPacket* pPacket )
{
	int nLine = m_listReplyList.GetItemCount();
	LV_ITEM	lvitem; 
	int iActItem;
	// ȣ , , Ű, ð 
	
	CString strTemp;
	//m_nListNum++;
	strTemp.Format( "%d", pPacket->m_nId );
	lvitem.mask		= LVIF_TEXT;
	lvitem.iItem	= nLine;
	lvitem.iSubItem = 0;
	lvitem.pszText	= (LPSTR)(LPCTSTR)strTemp;	
	iActItem		= m_listReplyList.InsertItem( &lvitem );
		
	lvitem.iItem	= iActItem;
	lvitem.iSubItem = 1;
	lvitem.pszText	= (LPSTR)(LPCTSTR)pPacket->m_szContents;	
	m_listReplyList.SetItem( &lvitem );	

	lvitem.iItem	= iActItem;
	lvitem.iSubItem = 2;
	lvitem.pszText	= (LPSTR)(LPCTSTR)pPacket->m_szRegisterId;	
	m_listReplyList.SetItem( &lvitem );	

	strTemp = ParsingDate( pPacket->m_szRecordTime );
	lvitem.iItem	= iActItem;
	lvitem.iSubItem = 3;
	lvitem.pszText	= (LPSTR)(LPCTSTR)strTemp;	
	m_listReplyList.SetItem( &lvitem );	
}

void CReplyListDlg::InitListCtrl()
{
//	m_listReplyList.
//	unsigned int		m_nId; 
//	char				m_szRegisterId[MAX_ID_LEN];
//	char				m_szContents[MAX_REPORT_CONTENTS_LEN];
//	char				m_szRecordTime[RECORD_LEN];	

	LV_COLUMN lvList;
	CString strList[4] = { "ȣ", "", "", "Ͻð" };
	// ȣ , , Ű, ð 
	lvList.mask		= LVCF_FMT|LVCF_SUBITEM|LVCF_TEXT|LVCF_WIDTH;
	lvList.fmt		= LVCFMT_LEFT;
	lvList.pszText	= (LPSTR)(LPCTSTR)strList[0];
	lvList.iSubItem = 0;
	lvList.cx		= 40;
	m_listReplyList.InsertColumn( 0, &lvList );

	lvList.fmt		= LVCFMT_LEFT;
	lvList.pszText	= (LPSTR)(LPCTSTR)strList[2];		
	lvList.iSubItem = 1;
	lvList.cx		= 225;
	m_listReplyList.InsertColumn( 1, &lvList );

	lvList.fmt		= LVCFMT_CENTER;
	lvList.pszText	= (LPSTR)(LPCTSTR)strList[1];		
	lvList.iSubItem = 1;
	lvList.cx		= 80;
	m_listReplyList.InsertColumn( 2, &lvList );

	lvList.fmt		= LVCFMT_CENTER;
	lvList.pszText	= (LPSTR)(LPCTSTR)strList[3];		
	lvList.iSubItem = 1;
	lvList.cx		= 120;
	m_listReplyList.InsertColumn( 3, &lvList );

}

CString CReplyListDlg::ParsingDate( char* pszDate )
{
	CString strTemp = _T("");
	int nCur = 0;

	for ( int i = 0; i < 19; i++ ) 
	{
		if ( i == 4 || i == 7 )
		{
			strTemp.Insert( i, '-' );
		}
		else if ( i == 10 )
		{
			strTemp.Insert( i, ' ' );
		}
		else if ( i == 13 || i == 16 )
		{
			strTemp.Insert( i, ':' );
		}
		else 
		{
			strTemp.Insert( i, *( pszDate + nCur ) );
			nCur++;
		}
	}
	return strTemp;
}

void CReplyListDlg::OnClickListReply(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int nIndex = m_listReplyList.GetSelectionMark();
	m_staticReadReply.SetWindowText ( m_listReplyList.GetItemText(nIndex, 1) ); 		
	*pResult = 0;
}

void CReplyListDlg::ProcessReplyRegisterAck( int nResult )
{
	if ( nResult == 0 ) 
	{
		MessageBox( "  Ͽϴ.", "۵" );
	}
	else 
	{
		MessageBox( " Ͽ Ͽϴ.", "۵" );
	}
}

void CReplyListDlg::ProcessReplyRemoveAck( int nResult )
{
	if ( nResult == 0 ) 
	{
		MessageBox( "  Ͽϴ.", "ۻ" );
	}
	else 
	{
		MessageBox( "  Ͽϴ.", "ۻ" );
	}
}

HBRUSH CReplyListDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	if ( nCtlColor == CTLCOLOR_STATIC ) 
	{
		pDC->SetBkMode ( TRANSPARENT );
		return (HBRUSH)(::GetStockObject( WHITE_BRUSH ));
	}
	return hbr;
}
