// InfomationDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psat.h"
#include "InfomationDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CInfomationDlg dialog


CInfomationDlg::CInfomationDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CInfomationDlg::IDD, pParent) , m_rtTitleBar ( 1, 1, 254, 25 )
{
	//{{AFX_DATA_INIT(CInfomationDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CInfomationDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInfomationDlg)
	DDX_Control(pDX, IDC_BUTTON_OK, m_btnOk);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInfomationDlg, CDialog)
	//{{AFX_MSG_MAP(CInfomationDlg)
	ON_BN_CLICKED(IDC_BUTTON_OK, OnButtonOk)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInfomationDlg message handlers
void CInfomationDlg::OnButtonOk() 
{
	CDialog::OnOK();	
}

BOOL CInfomationDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
/* ColorKey  */
	ModifyStyleEx ( 0 , WS_EX_LAYERED );
//	TRACE ( "%d %d\n" , GetLastError() , GetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE ) );
	HMODULE h_user32_dll = GetModuleHandle("USER32.DLL"); 
    if(h_user32_dll != NULL){ 
		BOOL (WINAPI *fp_set_layered_window_attributes)(HWND, COLORREF, BYTE, DWORD) = 
			(BOOL (WINAPI *)(HWND, COLORREF, BYTE, DWORD))GetProcAddress(h_user32_dll, 
			"SetLayeredWindowAttributes"); 
		if(fp_set_layered_window_attributes != NULL){ 
			(*fp_set_layered_window_attributes)(m_hWnd, RGB(255, 0, 0), 0, LWA_COLORKEY); 
		} 
    } 

	m_bmBackground.LoadBitmap ( IDB_INFODLG_BACKGROUND );

	m_btnOk.SetWindowPos ( NULL , 232, 5, 16, 16, NULL );
	m_btnOk.LoadBitmaps ( IDB_SDLG_CLOSE_NORMAL , IDB_SDLG_CLOSE_CLICK , IDB_SDLG_CLOSE_OVER );

	SetWindowPos(&wndTop, m_ptPosition.x, m_ptPosition.y, 256, 126, NULL);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CInfomationDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	CRect rect;
	GetClientRect ( &rect );
	CDC*	pDC = &dc;
	CDC*	pDrawDC;

	READY_BACKBUFFER ( GetSafeHwnd() , pDC , pDrawDC , RGB ( 255 , 0 , 0 ) );
	{
		DrawBackground ( pDrawDC );
	}
	BLIT_OPAQUE_BACKBUFFER ( pDC , pDrawDC );
}

void CInfomationDlg::DrawBackground ( CDC* pDC )
{
	CDC cdc;
	cdc.CreateCompatibleDC ( pDC );

	BITMAP bm;
	CBitmap* pOldBitmap = NULL;

	pOldBitmap = ( CBitmap *)cdc.SelectObject ( &m_bmBackground );
	m_bmBackground.GetBitmap( &bm );
	pDC->BitBlt ( 0 , 0 , bm.bmWidth , bm.bmHeight , &cdc , 0 , 0 , SRCCOPY );
	
	cdc.SelectObject ( pOldBitmap );
}

void CInfomationDlg::SetWindowPosition ( CRect rtPosition )
{
	m_ptPosition.x =  ( rtPosition.left + rtPosition.right ) / 2 - 127;
	m_ptPosition.y =  ( rtPosition.top + rtPosition.bottom ) / 2 - 62;
}

void CInfomationDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if ( m_rtTitleBar.PtInRect( point ) )
	{
		WINDOWPLACEMENT WindowPlace;
		GetWindowPlacement( &WindowPlace );
		m_ptWindowPosition.x = WindowPlace.rcNormalPosition.left;
		m_ptWindowPosition.y = WindowPlace.rcNormalPosition.top; 

		m_ptWindowMove.x = point.x;
		m_ptWindowMove.y = point.y;
		m_nMouseState = MOUSE_STATE_LDOWN;
		m_pCursor = IDC_SIZEALL;
		HCURSOR hCursor = LoadCursor ( NULL , m_pCursor );
		::SetCursor ( hCursor );
		SetCapture();
	}	
	
	CDialog::OnLButtonDown(nFlags, point);
}

void CInfomationDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if ( m_nMouseState == MOUSE_STATE_LDOWN ) 
	{
		m_ptWindowPosition.x += ( point.x - m_ptWindowMove.x );
		m_ptWindowPosition.y += ( point.y - m_ptWindowMove.y );
		SetWindowPos( NULL , m_ptWindowPosition.x, m_ptWindowPosition.y, 255, 125, NULL);
		m_nMouseState = MOUSE_STATE_NULL;
		m_ptWindowMove.x = 0;
		m_ptWindowMove.y = 0;
		ReleaseCapture();
	}
	
	CDialog::OnLButtonUp(nFlags, point);
}

void CInfomationDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	if ( m_rtTitleBar.PtInRect( point ) )
	{
		m_pCursor = IDC_SIZEALL;
		HCURSOR hCursor = LoadCursor ( NULL , m_pCursor );
		::SetCursor ( hCursor );
	}

	if ( m_nMouseState == MOUSE_STATE_LDOWN )
	{
		if ( !( ( m_ptWindowMove.x == point.x ) && ( m_ptWindowMove.y == point.y ) ) )
		{				
			m_ptWindowPosition.x += ( point.x - m_ptWindowMove.x );
			m_ptWindowPosition.y += ( point.y - m_ptWindowMove.y );
			MoveWindow( m_ptWindowPosition.x, m_ptWindowPosition.y, 255, 125 );
		}
	}

	CDialog::OnMouseMove(nFlags, point);
}
