// PSATDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PSAT.h"
#include "PSATDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPSATDlg dialog

CPSATDlg::CPSATDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPSATDlg::IDD, pParent) , m_rtTitleBar ( 1, 1, 598, 27 ), m_rtTooltip ( 483, 347, 565, 379 )
{
	//{{AFX_DATA_INIT(CPSATDlg)
	m_strRegPath = _T("");
	m_strRegAddContent = _T("");
	m_strRegCompany = _T("");
	m_strRegProgram = _T("");
	m_strRegVersion = _T("");
	m_strFilePath = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32

	//mk_OrgMain.left				= 0;
	//mk_OrgMain.right			= 0;

	m_hIcon = AfxGetApp()->LoadIcon(IDR_ICON16_16);
	//m_hIcon = AfxGetApp()->LoadIcon(IDR_ICON32_32);

	m_strLoginId				= _T(""); 
	m_strLoginPassword			= _T("");  
	m_strProgramKey 			= _T("");  		
	m_strProgram				= _T("");
	m_strCompany				= _T("");
	m_strVersion				= _T("");
	m_strAddContent				= _T("");
	m_bLoginCheck				= TRUE; 
	m_bLogining					= FALSE;
	m_bWaitLoginPacket			= FALSE;
	m_pWaitPacket				= NULL;
	m_nSubBackgroundState		= SUB_BACKGROUND_STATE_HOME;
	m_nMouseState				= MOUSE_STATE_NULL;
	m_nPaintState				= PAINT_STATE_NULL;
	m_bTooltipView				= FALSE;
	m_nMemberReliability		= -1; 
	m_nGuestReliability			= -1;
	m_nTotalReliability			= -1;
}

void CPSATDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPSATDlg)
	DDX_Control(pDX, IDC_STATIC_VER_MEMBER_PER, m_staticMemberPer);
	DDX_Control(pDX, IDC_STATIC_VER_GUEST_PER, m_staticGuestPer);
	DDX_Control(pDX, IDC_STATIC_VER_MEMBER_STATE, m_staticMemberState);
	DDX_Control(pDX, IDC_STATIC_VER_GUEST_STATE, m_staticGuestState);
	DDX_Control(pDX, IDC_BUTTON_LOGOUT, m_btnLogout);
	DDX_Control(pDX, IDC_BUTTON_LOGIN, m_btnLogin);
	DDX_Control(pDX, IDC_BUTTON_MINIMAM, m_btnMinimam);
	DDX_Control(pDX, IDC_BUTTON_EXIT, m_btnExit);
	DDX_Control(pDX, IDC_BUTTON_MENU_REGISTER, m_btnMainMenuRegister);
	DDX_Control(pDX, IDC_BUTTON_MENU_VERTIFICATION, m_btnMainMenuVertification);
	DDX_Control(pDX, IDC_BUTTON_MENU_HOME, m_btnMainMenuHome);
	DDX_Control(pDX, IDC_BUTTON_INFO, m_btnInfomation);
	DDX_Control(pDX, IDC_BUTTON_REG_SEARCH_PATH, m_btnRegSearchPath);
	DDX_Control(pDX, IDC_BUTTON_REG, m_btnReg);
	DDX_Control(pDX, IDC_BUTTON_REWRITE, m_btnRewrite);
	DDX_Control(pDX, IDC_COMBO_REG_FILEDIRECTORY, m_cbRegFileDirectory);
	DDX_Control(pDX, IDC_EDIT_REG_PATH, m_edtRegPath);
	DDX_Control(pDX, IDC_EDIT_REG_PROGRAM, m_edtRegProgram);
	DDX_Control(pDX, IDC_EDIT_REG_COMPANY, m_edtRegCompany);
	DDX_Control(pDX, IDC_EDIT_REG_VERSION, m_edtRegVersion);
	DDX_Control(pDX, IDC_EDIT_REG_ADD_CONTENT, m_edtRegAddContent);
	DDX_Text(pDX, IDC_EDIT_REG_PATH, m_strRegPath);
	DDX_Text(pDX, IDC_EDIT_REG_ADD_CONTENT, m_strRegAddContent);
	DDX_Text(pDX, IDC_EDIT_REG_COMPANY, m_strRegCompany);
	DDX_Text(pDX, IDC_EDIT_REG_PROGRAM, m_strRegProgram);
	DDX_Text(pDX, IDC_EDIT_REG_VERSION, m_strRegVersion);
	DDX_Control(pDX, IDC_BUTTON_CHECK, m_btnCheck);
	DDX_Control(pDX, IDC_BUTTON_REPORT, m_btnReport);
	DDX_Control(pDX, IDC_BUTTON_SEARCH_PATH, m_btnSearchPath);
	DDX_Control(pDX, IDC_BUTTON_VIEW_REPLY, m_btnViewReply);
	DDX_Control(pDX, IDC_BUTTON_VIEW_REPORT, m_btnViewReport);
	DDX_Control(pDX, IDC_COMBO_FILE_DIR, m_cbFileDirectory);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH, m_edtFilePath);
	DDX_Text(pDX, IDC_EDIT_FILE_PATH, m_strFilePath);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPSATDlg, CDialog)
	//{{AFX_MSG_MAP(CPSATDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_WM_ERASEBKGND()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_TIMER()
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BUTTON_LOGIN, OnButtonLogin)
	ON_BN_CLICKED(IDC_BUTTON_REWRITE, OnButtonRewrite)
	ON_BN_CLICKED(IDC_BUTTON_REG, OnButtonReg)
	ON_BN_CLICKED(IDC_BUTTON_CHECK, OnButtonCheck)
	ON_BN_CLICKED(IDC_BUTTON_REPORT, OnButtonReport)
	ON_BN_CLICKED(IDC_BUTTON_SEARCH_PATH, OnButtonSearchPath)
	ON_BN_CLICKED(IDC_BUTTON_REG_SEARCH_PATH, OnButtonRegSearchPath)
	ON_BN_CLICKED(IDC_BUTTON_VIEW_REPLY, OnButtonViewReply)
	ON_BN_CLICKED(IDC_BUTTON_MENU_HOME, OnButtonMenuHome)
	ON_BN_CLICKED(IDC_BUTTON_MENU_REGISTER, OnButtonMenuRegister)
	ON_BN_CLICKED(IDC_BUTTON_MENU_VERTIFICATION, OnButtonMenuVertification)
	ON_BN_CLICKED(IDC_BUTTON_LOGOUT, OnButtonLogout)
	ON_BN_CLICKED(IDC_BUTTON_VIEW_REPORT, OnButtonViewReport)
	ON_BN_CLICKED(IDC_BUTTON_INFO, OnButtonInfo)
	ON_BN_CLICKED(IDC_BUTTON_EXIT, OnButtonExit)
	ON_BN_CLICKED(IDC_BUTTON_MINIMAM, OnButtonMinimam)
	//}}AFX_MSG_MAP
	ON_MESSAGE ( WM_SOCKET_CONNECTED , OnSocketConnected )
	ON_MESSAGE ( WM_SOCKET_RECEIVED_DATA , OnSocketReceivedData )
	ON_MESSAGE ( WM_SOCKET_DISCONNECTED , OnSocketDisconnected )
	ON_MESSAGE ( WM_KEY_MAKING_PROGRESS_DATA, OnReceivedKeyProgress )
	ON_MESSAGE ( WM_OTHER_DLG_RECEIVED_DATA, OnOtherDlgReceivedData ) 
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPSATDlg message handlers
//////////////////////////////////////////////////////////////////////////////////////
// ü Client Rectangle Bitmap ؼ Bliting Clip Regionŭ ϴ 

BOOL CPSATDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetWindowPos(&wndTop, 0, 0, 600, 420, NULL);

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
/* ColorKey  */
	ModifyStyleEx ( 0 , WS_EX_LAYERED );
//	TRACE ( "%d %d\n" , GetLastError() , GetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE ) );
	HMODULE h_user32_dll = GetModuleHandle("USER32.DLL"); 
    if(h_user32_dll != NULL){ 
		BOOL (WINAPI *fp_set_layered_window_attributes)(HWND, COLORREF, BYTE, DWORD) = 
			(BOOL (WINAPI *)(HWND, COLORREF, BYTE, DWORD))GetProcAddress(h_user32_dll, 
			"SetLayeredWindowAttributes"); 
		if(fp_set_layered_window_attributes != NULL){ 
			(*fp_set_layered_window_attributes)(m_hWnd, RGB(255, 0, 0), 0, LWA_COLORKEY); 
		} 
    } 

	SetWindowText( "PSAT" );
	m_cClientSocket.SetWnd ( GetSafeHwnd() );
	m_cChecker.SetWnd ( GetSafeHwnd() );
	m_cReplyListDlg.SetWnd ( GetSafeHwnd() );
	m_cReportListDlg.SetWnd ( GetSafeHwnd() ); 
	m_cLoginDlg.SetWnd ( GetSafeHwnd() ); 
	m_cLoginDlg.SetSocket ( &m_cClientSocket );
	SetAllResourceHide();
	SetAllResourceEmpty();
	
	m_cTooltip.Create( this );

	// Background ׸° 
	m_bmBackground.LoadBitmap ( IDB_MAIN_BACKGROUND );
	m_bmSubBackHome.LoadBitmap ( IDB_SUB_BACKGROUND_HOME );
	m_bmSubBackVertification.LoadBitmap ( IDB_SUB_BACKGROUND_VERTIFICATION );
	m_bmSubBackRegister.LoadBitmap ( IDB_SUB_BACKGROUND_REGISTER );

	for ( int i = 0; i < 10; i++ )
	{
		m_bmReliabilityCount[i].LoadBitmap ( 289 + i );
	}
	for ( i = 0; i < 3; i++ )
	{
		m_bmReliabilityBar[i].LoadBitmap ( 303 + i );
	}
		
	m_btnInfomation.SetWindowPos ( NULL , 554, 59, 32, 20, NULL );
	m_btnInfomation.LoadBitmaps ( IDB_INFORMATION , IDB_INFORMATION , IDB_INFORMATION );
	m_btnLogin.SetWindowPos ( NULL , 504, 59, 49, 20, NULL );
	m_btnLogin.LoadBitmaps ( IDB_LOGIN , IDB_LOGIN , IDB_LOGIN );
	m_btnLogin.ShowWindow(SW_SHOW);
	m_btnLogout.SetWindowPos ( NULL , 495, 59, 49, 20, NULL );
	m_btnLogout.LoadBitmaps ( IDB_LOGOUT , IDB_LOGOUT , IDB_LOGOUT );
	m_btnLogout.ShowWindow(SW_HIDE);

	m_btnMainMenuHome.SetWindowPos ( NULL , 15, 29, 62, 57, NULL );
	m_btnMainMenuHome.LoadBitmaps ( IDB_MAIN_MENU_HOME_BACK , IDB_MAIN_MENU_HOME_DOWN , IDB_MAIN_MENU_HOME_OVER, IDB_MAIN_MENU_HOME_NORMAL );
	m_btnMainMenuHome.SetActive( TRUE );
	m_btnMainMenuVertification.SetWindowPos ( NULL , 81, 29, 62, 57, NULL );
	m_btnMainMenuVertification.LoadBitmaps ( IDB_MAIN_MENU_VER_BACK , IDB_MAIN_MENU_VER_DOWN , IDB_MAIN_MENU_VER_OVER, IDB_MAIN_MENU_VER_NORMAL );
	m_btnMainMenuRegister.SetWindowPos ( NULL , 145, 29, 62, 57, NULL );
	m_btnMainMenuRegister.LoadBitmaps ( IDB_MAIN_MENU_REG_BACK , IDB_MAIN_MENU_REG_DOWN , IDB_MAIN_MENU_REG_OVER, IDB_MAIN_MENU_REG_NORMAL );

	m_btnExit.SetWindowPos ( NULL , 576, 7, 16, 16, NULL );
	m_btnExit.LoadBitmaps ( IDB_MDLG_CLOSE_NORMAL , IDB_MDLG_CLOSE_CLICK , IDB_MDLG_CLOSE_OVER );
	m_btnMinimam.SetWindowPos ( NULL , 556, 6, 15, 16, NULL );
	m_btnMinimam.LoadBitmaps ( IDB_MDLG_MINIMAM_NORMAL , IDB_MDLG_MINIMAM_CLICK , IDB_MDLG_MINIMAM_OVER );

	m_btnRewrite.SetWindowPos ( NULL , 312, 357, 85, 22, NULL );
	m_btnRewrite.LoadBitmaps ( IDB_REG_RESET_NORMAL , IDB_REG_RESET_OVER , IDB_REG_RESET_NORMAL );
	m_btnReg.SetWindowPos ( NULL , 199, 357, 85, 22, NULL );
	m_btnReg.LoadBitmaps ( IDB_REG_REPORT_NORMAL , IDB_REG_REPORT_OVER , IDB_REG_REPORT_NORMAL );
	m_btnRegSearchPath.SetWindowPos ( NULL , 482, 166, 77, 21, NULL );
	m_btnRegSearchPath.LoadBitmaps ( IDB_REG_SEARCH_NORMAL , IDB_REG_SEARCH_OVER , IDB_REG_SEARCH_NORMAL );
	m_edtRegAddContent.SetWindowPos ( NULL , 110, 316, 448, 21, NULL );
	m_edtRegVersion.SetWindowPos ( NULL , 110, 289, 448, 21, NULL );
	m_edtRegCompany.SetWindowPos ( NULL , 110, 262, 448, 21, NULL );
	m_edtRegProgram.SetWindowPos ( NULL , 110, 236, 448, 21, NULL );
	m_edtRegPath.SetWindowPos ( NULL , 123, 167, 350, 20, NULL );

	m_btnCheck.SetWindowPos ( NULL , 500, 151, 64, 35, NULL );
	m_btnCheck.LoadBitmaps ( IDB_VER_VER_NORMAL , IDB_VER_VER_OVER , IDB_VER_VER_NORMAL );
	m_btnReport.SetWindowPos ( NULL , 95, 351, 87, 24, NULL );
	m_btnReport.LoadBitmaps ( IDB_VER_REPORT_NORMAL , IDB_VER_REPORT_OVER , IDB_VER_REPORT_NORMAL );
	m_btnSearchPath.SetWindowPos ( NULL , 418, 160, 69, 21, NULL );
	m_btnSearchPath.LoadBitmaps ( IDB_VER_SEARCH_NORMAL , IDB_VER_SEARCH_OVER , IDB_VER_SEARCH_NORMAL );
	m_btnViewReply.SetWindowPos ( NULL , 326, 351, 87, 24, NULL );
	m_btnViewReply.LoadBitmaps ( IDB_VER_VIEWREPLY_NORMAL , IDB_VER_VIEWREPLY_OVER , IDB_VER_VIEWREPLY_NORMAL );
	m_btnViewReport.SetWindowPos ( NULL , 212, 351, 87, 24, NULL );
	m_btnViewReport.LoadBitmaps ( IDB_VER_VIEWREPORT_NORMAL , IDB_VER_VIEWREPORT_OVER , IDB_VER_VIEWREPORT_NORMAL );
	m_edtFilePath.SetWindowPos ( NULL , 120, 161, 291, 20, NULL );
	m_staticGuestState.SetWindowPos ( NULL, 481, 234, 85, 15, NULL );
	m_staticMemberState.SetWindowPos ( NULL, 481, 258, 85, 15, NULL );
	m_staticGuestPer.SetWindowPos ( NULL, 400, 234, 75, 15, NULL );
	m_staticMemberPer.SetWindowPos ( NULL, 400, 258, 75, 15, NULL );

	//Ʈ 
	//m_edtFilePath.SetFont( );
	
	SetTimer( WINDOW_POSITION_SET, 1, NULL );

	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CPSATDlg::DrawBackground ( CDC* pDC )
{
	CDC cdc;
	cdc.CreateCompatibleDC ( pDC );

	BITMAP bm;
	CBitmap* pOldBitmap = NULL;

	pOldBitmap = ( CBitmap *)cdc.SelectObject ( &m_bmBackground );
	m_bmBackground.GetBitmap( &bm );
	pDC->BitBlt ( 0 , 0 , bm.bmWidth , bm.bmHeight , &cdc , 0 , 0 , SRCCOPY );
	
	switch ( m_nSubBackgroundState ) 
	{
	case SUB_BACKGROUND_STATE_HOME : 
		( CBitmap *)cdc.SelectObject ( &m_bmSubBackHome );
		m_bmSubBackHome.GetBitmap( &bm );
		pDC->BitBlt ( 7, 92, bm.bmWidth, bm.bmHeight, &cdc , 0 , 0 , SRCCOPY );
		break;
	case SUB_BACKGROUND_STATE_VERTIFICATION : 
		( CBitmap *)cdc.SelectObject ( &m_bmSubBackVertification );
		m_bmBackground.GetBitmap( &bm );
		pDC->BitBlt ( 7, 92, bm.bmWidth, bm.bmHeight, &cdc , 0 , 0 , SRCCOPY );
		break;
	case SUB_BACKGROUND_STATE_REGISTER : 
		( CBitmap *)cdc.SelectObject ( &m_bmSubBackRegister );
		m_bmBackground.GetBitmap( &bm );
		pDC->BitBlt ( 7, 92, bm.bmWidth, bm.bmHeight, &cdc , 0 , 0 , SRCCOPY );
		break;
	default : 
		break;
	}

	if ( pOldBitmap != NULL ) 
	{
		cdc.SelectObject ( pOldBitmap );
	}
	
/*
	if ( ID_ENVIRONMENT != m_nScreenId && ID_DIGITALBROADCAST != m_nScreenId )
	{
		cdc.SelectObject ( &m_bmListBottom );
		m_bmListBottom.GetBitmap ( &bm );
		pDC->BitBlt ( 76 , 431 , bm.bmWidth , bm.bmHeight , &cdc , 0 , 0 , SRCCOPY );
	}
	*/

	/*
	int nOldMode = pDC->SetBkMode ( TRANSPARENT );
	CFont* pOldFont = ( CFont *) pDC->SelectObject ( &m_Font );

	pDC->DrawText ( m_strText , m_rtText , DT_VCENTER );
	pDC->SetBkMode ( nOldMode );

	pDC->SelectObject ( pOldFont );
	*/
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPSATDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	CRect rect;
	GetClientRect ( &rect );
	CDC*	pDC = &dc;
	CDC*	pDrawDC;

	READY_BACKBUFFER ( GetSafeHwnd() , pDC , pDrawDC , RGB ( 255 , 0 , 0 ) );
	{
		DrawBackground ( pDrawDC );

	}
	BLIT_OPAQUE_BACKBUFFER ( pDC , pDrawDC );

	if ( m_nSubBackgroundState == SUB_BACKGROUND_STATE_VERTIFICATION )
	{
		DrawReliability( pDC );
	}
}

void CPSATDlg::DrawReliability ( CDC* pDC )
{
	int nRed, nGreen, nBlue;
	int nRedStep, nGreenStep, nBlueStep;
	int i, nSize;
	CRect rect;
	CDC cdc;
	cdc.CreateCompatibleDC ( pDC );

	CBitmap* pOldBitmap = NULL;

	if ( m_nTotalReliability >= 0 )
	{
		// ۼƮ 
		if ( m_nTotalReliability == 100 ) 
		{
			pOldBitmap = ( CBitmap *)cdc.SelectObject ( &m_bmReliabilityCount[1] );
			pDC->BitBlt ( 483 , 302 , 28 , 37 , &cdc , 0 , 0 , SRCCOPY );
			cdc.SelectObject ( &m_bmReliabilityCount[0] );
			pDC->BitBlt ( 511 , 302 , 28 , 37 , &cdc , 0 , 0 , SRCCOPY );
			pDC->BitBlt ( 539 , 302 , 28 , 37 , &cdc , 0 , 0 , SRCCOPY );
		}
		else if ( m_nTotalReliability < 10 ) 
		{
			cdc.SelectObject ( &m_bmReliabilityCount[m_nTotalReliability % 10] );
			pDC->BitBlt ( 511 , 302 , 28 , 37 , &cdc , 0 , 0 , SRCCOPY );
		}
		else 
		{
			pOldBitmap = ( CBitmap *)cdc.SelectObject ( &m_bmReliabilityCount[m_nTotalReliability / 10] );
			pDC->BitBlt ( 497 , 302 , 28 , 37 , &cdc , 0 , 0 , SRCCOPY );
			cdc.SelectObject ( &m_bmReliabilityCount[m_nTotalReliability % 10] );
			pDC->BitBlt ( 525 , 302 , 28 , 37 , &cdc , 0 , 0 , SRCCOPY );
		}

		int nCur = 35;
		cdc.SelectObject ( &m_bmReliabilityBar[0] );
		pDC->BitBlt ( nCur, 310, 6, 21, &cdc , 0 , 0 , SRCCOPY );
		nCur += 6;
		cdc.SelectObject ( &m_bmReliabilityBar[1] );
		for ( i = 1; i < m_nTotalReliability; i++ ) 
		{
			pDC->BitBlt ( nCur, 310, 2, 21, &cdc , 0 , 0 , SRCCOPY );
			pDC->BitBlt ( nCur + 2, 310, 2, 21, &cdc , 0 , 0 , SRCCOPY );
			nCur += 4;
			if ( i % 6 == 0 )
			{
				pDC->BitBlt ( nCur, 310, 2, 21, &cdc , 0 , 0 , SRCCOPY );
				nCur += 2;
			}
		}
		cdc.SelectObject ( &m_bmReliabilityBar[2] );
		pDC->BitBlt ( nCur, 310, 6, 21, &cdc , 0 , 0 , SRCCOPY );

		pDC->SelectObject ( pOldBitmap );
	}

	// ԽƮ ŷڵ 
	nSize = 345 * m_nGuestReliability / 100;
	nRed = 253, nGreen = 246, nBlue = 0;
	nRedStep = MyRound((double)nSize/2), nGreenStep = MyRound((double)nSize/55), nBlueStep = MyRound((double)nSize/7);
	for (i = 1; i <= nSize; i++ )
	{
		rect = CRect ( 129 + i, 235, 130 + i, 245 );
		if ( nRedStep != 0 && i % nRedStep == 0 ) 
		{
			nRed++;
		}
		if ( nGreenStep != 0 && i % nGreenStep == 0 ) 
		{
			nGreen--;
		}
		if ( nBlueStep != 0 && i % nBlueStep == 0 ) 
		{
			nBlue++;
		}

		pDC->FillSolidRect( &rect, RGB( nRed, nGreen, nBlue ) );//;
	}

	//  ŷڵ 
	nSize = 345 * m_nMemberReliability / 100;
	nRed = 200, nGreen = 232, nBlue = 255;
	nRedStep = MyRound((double)nSize/181), nGreenStep = MyRound((double)nSize/26), nBlueStep = MyRound((double)nSize/7);
	for (i = 1; i <= nSize; i++ )
	{
		rect = CRect ( 129 + i, 259, 130 + i, 269 );
		if ( nRedStep != 0 && i % nRedStep == 0 ) 
		{
			if ( nRed ) 
				nRed--;
		}
		if ( nGreenStep != 0 && i % nGreenStep == 0 ) 
		{
			nGreen--;
		}
		if ( nBlueStep != 0 && i % nBlueStep == 0 ) 
		{
			nBlue--;
		}

		pDC->FillSolidRect( &rect, RGB( nRed, nGreen, nBlue ) );
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPSATDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CPSATDlg::OnCancel() 
{
	m_cClientSocket.Disconnect();
	CDialog::OnCancel();
}

void CPSATDlg::SetAllResourceHide() 
{
	m_btnReport.ShowWindow(SW_HIDE);
	m_edtFilePath.ShowWindow(SW_HIDE);
	m_staticMemberPer.ShowWindow(SW_HIDE);
	m_staticGuestPer.ShowWindow(SW_HIDE);
	m_staticGuestState.ShowWindow(SW_HIDE);
	m_staticMemberState.ShowWindow(SW_HIDE);
	m_btnViewReply.ShowWindow(SW_HIDE);
	m_btnViewReport.ShowWindow(SW_HIDE);
	m_btnCheck.ShowWindow(SW_HIDE);
	m_btnSearchPath.ShowWindow(SW_HIDE);
	m_cbFileDirectory.ShowWindow(SW_HIDE);
	m_btnReg.ShowWindow(SW_HIDE);
	m_btnRewrite.ShowWindow(SW_HIDE);
	m_edtRegVersion.ShowWindow(SW_HIDE);
	m_edtRegProgram.ShowWindow(SW_HIDE);
	m_edtRegPath.ShowWindow(SW_HIDE);
	m_edtRegCompany.ShowWindow(SW_HIDE);
	m_edtRegAddContent.ShowWindow(SW_HIDE);
	m_btnRegSearchPath.ShowWindow(SW_HIDE);
	m_cbRegFileDirectory.ShowWindow(SW_HIDE);
}

void CPSATDlg::SetAllResourceEmpty() 
{
	m_strRegPath		= _T("");
	m_strRegProgram		= _T("");
	m_strRegCompany		= _T("");
	m_strRegVersion		= _T("");
	m_strRegAddContent	= _T("");	
	m_strFilePath		= _T("");	
	m_strProgram		= _T("");
	m_strCompany		= _T("");
	m_strVersion		= _T("");
	m_strAddContent		= _T("");
	m_staticGuestState.SetWindowText ( "" );
	m_staticMemberState.SetWindowText ( "" );
	m_staticMemberPer.SetWindowText ( "" );
	m_staticGuestPer.SetWindowText ( "" );
	m_cbRegFileDirectory.SendMessage(CB_SETCURSEL, 0, 0);
	m_cbFileDirectory.SendMessage(CB_SETCURSEL, 0, 0);
	m_nMemberReliability = -1; 
	m_nGuestReliability	 = -1;
	m_nTotalReliability = -1;
	UpdateData( FALSE );
}

LONG CPSATDlg::OnSocketReceivedData(UINT wParam, LONG lParam)
{
	KPacket* pPacket = (KPacket *)wParam;
	switch ( pPacket->m_nPacketType )
	{
	case MESSAGE_TYPE_MEMBER_JOIN_ACK :
		ProcessJoinMemberAck( (KJoinMemberAck*)pPacket ); 
		break;
	case MESSAGE_TYPE_MEMBER_LOGIN_ACK :
		ProcessLoginAck( (KLoginAck*)pPacket ); 
		break;
	case MESSAGE_TYPE_VERIFICATION_ACK :
		ProcessVerificationAck( (KVerificationAck*)pPacket ); 
		break;
	case MESSAGE_TYPE_PROGRAM_REGISTER_ACK :
		ProcessProgramRegisterAck( (KProgramRegisterAck*)pPacket ); 
		break;
	case MESSAGE_TYPE_REPORT_LIST :
		ProcessReportList( (KReportListPacket*)pPacket ); 
		break;
	case MESSAGE_TYPE_REPORT_REGISTER_ACK :
		ProcessReportRegisterAck( (KReportRegisterAck*)pPacket ); 
		break;
	case MESSAGE_TYPE_REPORT_REMOVE_ACK :
		ProcessReportRemoveAck( (KReportRemoveAck*)pPacket ); 
		break;
	case MESSAGE_TYPE_REPLY_LIST :
		ProcessReplytList( (KReplyListPacket*)pPacket ); 
		break;
	case MESSAGE_TYPE_REPLY_REGISTER_ACK :
		ProcessReplyRegisterAck( (KReplyRegisterAck*)pPacket ); 
		break;
	case MESSAGE_TYPE_REPLY_REMOVE_ACK :
		ProcessReplyRemoveAck( (KReplyRemoveAck*)pPacket ); 
		break;
	}

	return 0;
}

void CPSATDlg::OnButtonLogin() 
{
	WINDOWPLACEMENT WindowPlace;
	GetWindowPlacement( &WindowPlace );
	m_cLoginDlg.SetWindowPosition( WindowPlace.rcNormalPosition );

	if ( m_cLoginDlg.DoModal() == IDOK )
	{
		m_strLoginId = m_cLoginDlg.m_strId;
		m_strLoginPassword = m_cLoginDlg.m_strPass;

		memset ( &m_LoginPacket.m_szId, 0, sizeof ( m_LoginPacket.m_szId ) );
		memset ( &m_LoginPacket.m_szPassword, 0, sizeof ( m_LoginPacket.m_szPassword ) );

		strncpy ( m_LoginPacket.m_szId, (LPSTR)(LPCSTR)m_cLoginDlg.m_strId, m_cLoginDlg.m_strId.GetLength() );
		strncpy ( m_LoginPacket.m_szPassword, (LPSTR)(LPCSTR)m_cLoginDlg.m_strPass, m_cLoginDlg.m_strPass.GetLength() );
		
		if ( m_cClientSocket.IsConnected() )
		{
			m_cClientSocket.SendData ( &m_LoginPacket );
		}
		else
		{
			m_bWaitLoginPacket = TRUE;
			ConnectServer();
		}
	}
}

/***********/
/*   */ 
/***********/

void CPSATDlg::OnButtonRewrite() 
{
	SetAllResourceEmpty();
	m_edtRegProgram.SetFocus();
}

void CPSATDlg::OnButtonReg() 
{
	UpdateData(TRUE);

	if ( m_strRegProgram == "" ) 
	{
		KMessageBox("α׷ Էּ.","");
		m_edtRegProgram.SetFocus();
		return; 
	}
	if ( m_strRegPath == "" )
	{
		KMessageBox("θ ּ.","");
		return; 
	}
	CString strKey;
	if ( ( strKey = ImportKeyValue ( m_strRegPath, m_cbRegFileDirectory.GetCurSel() ) ) == "" ) 
	{
		return;
	}

	KProgramRegisterPacket Packet;
	strncpy ( Packet.m_szProgramCompany, (LPSTR)(LPCSTR)m_strRegCompany, m_strRegCompany.GetLength() );
	strncpy ( Packet.m_szProgramDescription, (LPSTR)(LPCSTR)m_strRegAddContent, m_strRegAddContent.GetLength() );
	strncpy ( Packet.m_szProgramKey, (LPSTR)(LPCSTR)strKey, strKey.GetLength() );
	strncpy ( Packet.m_szProgramName, (LPSTR)(LPCSTR)m_strRegProgram, m_strRegProgram.GetLength() );
	strncpy ( Packet.m_szProgramVersion, (LPSTR)(LPCSTR)m_strRegVersion, m_strRegVersion.GetLength() );

	SendData( &Packet );
}

void CPSATDlg::SearchPathRegDirectory() 
{
    ITEMIDLIST *pidlBrowse; 
    char pszPathname[1000]; 
    BROWSEINFO BrInfo;
    BrInfo.hwndOwner = GetSafeHwnd(); 
    BrInfo.pidlRoot = NULL;
    
    memset(&BrInfo, 0, sizeof(BrInfo));
    BrInfo.pszDisplayName = pszPathname;
    BrInfo.lpszTitle = " ";
    BrInfo.ulFlags = BIF_RETURNONLYFSDIRS;

    pidlBrowse = ::SHBrowseForFolder(&BrInfo);

    if( pidlBrowse != NULL)
    {
        ::SHGetPathFromIDList(pidlBrowse, pszPathname);
        m_strRegPath = pszPathname;  
		UpdateData(FALSE);
    }
}

void CPSATDlg::SearchPathRegFile() 
{
	CFileDialog dlg(TRUE);
	
	if ( dlg.DoModal() == IDOK)
	{
		m_strRegPath = dlg.GetPathName();
		UpdateData(FALSE);
	}
}

/***********/
/* ˻  */ 
/***********/

void CPSATDlg::OnButtonSearchPath() 
{
	int nIndex = m_cbFileDirectory.GetCurSel();
	if ( nIndex == 1 ) 
	{
		SearchPathDirectory();
	}
	else if ( nIndex == 0 ) 
	{
		SearchPathFile();
	}
}

void CPSATDlg::SearchPathDirectory() 
{
    ITEMIDLIST *pidlBrowse; 
    char pszPathname[1000]; 
    BROWSEINFO BrInfo;
    BrInfo.hwndOwner = GetSafeHwnd(); 
    BrInfo.pidlRoot = NULL;
    
    memset(&BrInfo, 0, sizeof(BrInfo));
    BrInfo.pszDisplayName = pszPathname;
    BrInfo.lpszTitle = " ";
    BrInfo.ulFlags = BIF_RETURNONLYFSDIRS;

    pidlBrowse = ::SHBrowseForFolder(&BrInfo);

    if( pidlBrowse != NULL)
    {
        ::SHGetPathFromIDList(pidlBrowse, pszPathname);
        m_strFilePath = pszPathname;  //  
		UpdateData(FALSE);
    }
}

void CPSATDlg::SearchPathFile() 
{
	CFileDialog dlg(TRUE);
	
	if ( dlg.DoModal() == IDOK)
	{
		m_strFilePath = dlg.GetPathName();
		UpdateData(FALSE);
	}
}

void CPSATDlg::OnButtonCheck() 
{
	UpdateData(TRUE);

	if ( m_strFilePath.Compare( "" ) == 0 ) 
	{
		KMessageBox("θ Ȯּ", "˻");
		return;
	}

	CString strReturn = ImportKeyValue ( m_strFilePath, m_cbFileDirectory.GetCurSel(), TRUE );
	if ( strReturn.Compare( "" ) == 0 ) 
	{
		return;
	}
	else 
	{
		m_strProgramKey = strReturn;
	}

	KVerificationPacket Packet;
	strncpy ( Packet.m_szProgramKey, (LPSTR)(LPCSTR)m_strProgramKey, m_strProgramKey.GetLength() );

	SendData( &Packet );
}

CString CPSATDlg::ImportKeyValue( CString strPath, int nFlag, BOOL bFlag )
{
	if ( m_strPrevPath == strPath ) 
	{
		if ( bFlag ) 
		{
			KMessageBox( "̹ ˻   մϴ.", "˻" );
			return ""; 		
		}
		else
		{
			return m_strProgramKey;
		}
	}

	m_strPrevPath = strPath;

	CString strKey = _T("");
	CString strBuffer = _T("");
	unsigned char szKeyBuffer[32];
	memset( szKeyBuffer, 0, sizeof ( szKeyBuffer ) );

	if ( nFlag == FILE_PATH_TYPE_FILE )
	{
		if ( !m_cChecker.GetHashValueFromFile( LPSTR(LPCTSTR(strPath)), szKeyBuffer ) )
		{
			KMessageBox( " θ Ȯּ.", "ãƺ" );
			return ""; 
		}
	}
	else if ( nFlag == FILE_PATH_TYPE_DIRECTORY ) 
	{
		if ( !m_cChecker.GetHashValueFromDirectory( LPSTR(LPCTSTR(strPath)), szKeyBuffer ) ) 
		{
			KMessageBox( " θ Ȯּ.", "ãƺ" );
			return ""; 
		}
	}
	else
	{
		KMessageBox( " θ Ȯּ.", "ãƺ" );	
		return ""; 
	}

	for ( int i = 0; i < 32; i++ )
	{
		strBuffer.Format("%02X", szKeyBuffer[i]);
		strKey += strBuffer; 
	}

	return strKey; 
}

/*   */
BOOL CPSATDlg::ConnectServer()
{
	if ( !m_cClientSocket.Connect ( IP_ADDR, PORT_NUM ) )
	{
		return TRUE; 
	}
	else 
	{
		KMessageBox( " ӿ  ߽ϴ.", "" );
//		OnSocketDisconnected();
		return FALSE; 
	}
}

void CPSATDlg::ProcessJoinMemberAck( KJoinMemberAck* pPacket )
{
	m_cLoginDlg.GiveJoinMemberAck( pPacket->m_nResult );
}

void CPSATDlg::ProcessLoginAck( KLoginAck* pPacket )
{
	if ( pPacket->m_nResult == MEMBER_LOGIN_ERROR ) 
	{
		m_bLogining = FALSE;
		m_strLoginId = _T("");
		m_strLoginId = _T("");
		KMessageBox( "ID, Password \r\nٽ Էּ.", "α" );
		OnButtonLogin();
	}
	else
	{
		m_bLogining = TRUE;
		m_bLoginCheck = FALSE;
		m_btnLogin.ShowWindow(SW_HIDE);
		m_btnLogout.ShowWindow(SW_SHOW);

		m_btnMainMenuVertification.ShowWindow( TRUE );
		if ( m_strLoginId != "guest" ) 
		{
			m_btnMainMenuRegister.ShowWindow( TRUE );
		}

		if ( m_pWaitPacket )
		{
			m_cClientSocket.SendData ( m_pWaitPacket );
			delete m_pWaitPacket;
			m_pWaitPacket = NULL;
		}
	}

}
void CPSATDlg::ProcessVerificationAck( KVerificationAck* pPacket )
{
	if ( pPacket->m_nResult == 0 ) 
	{
		m_strProgram = pPacket->m_szProgramName;
		m_strCompany = pPacket->m_szProgramCompany;
		m_strVersion = pPacket->m_szProgramVersion;
		m_strAddContent = pPacket->m_szProgramDescription;

		m_nMemberReliability 
			= m_cReliabilityCheck.GetReliability
			( pPacket->m_nMemberAccessCount, pPacket->m_nMemberReportCount, pPacket->m_nTotalMemberCount );
		m_nGuestReliability
			= m_cReliabilityCheck.GetReliability( pPacket->m_nGuestAccessCount, pPacket->m_nGuestReportCount, pPacket->m_nTotalMemberCount );
		m_nTotalReliability
			= m_cReliabilityCheck.GetTotalReliability( m_nMemberReliability, m_nGuestReliability );

//		m_nPaintState = PAINT_STATE_GUEST_DRAWING;
		//InvalidateRect( CRect ( 130, 235, 480, 270 ) );
		Invalidate();
		CString strTemp;
		strTemp.Format( "ŷڵ %03d%%", m_nMemberReliability );
		m_staticMemberPer.SetWindowText( strTemp );
		strTemp.Format( "ŷڵ %03d%%", m_nGuestReliability );
		m_staticGuestPer.SetWindowText( strTemp );

		m_staticGuestState.SetWindowText 
			( m_cReliabilityCheck.GetCombinedString( pPacket->m_nGuestAccessCount, pPacket->m_nGuestReportCount ) );
		m_staticMemberState.SetWindowText 
			( m_cReliabilityCheck.GetCombinedString( pPacket->m_nMemberAccessCount, pPacket->m_nMemberReportCount ) );

		if ( ( strcmp ( pPacket->m_szProgramCompany, "" ) == 0 ||
			 strcmp ( pPacket->m_szProgramVersion, "" ) == 0 || 
			 strcmp ( pPacket->m_szProgramDescription, "" ) == 0 ||
			 strcmp ( m_strProgram = pPacket->m_szProgramName, "" ) == 0 )
			 && ( m_strLoginId != "guest" ) )
		{

			if ( KMessageBox( "ϵ  ϴ.\r\n  Ͻðڽϱ?", "˻", MB_YESNO ) == IDOK )
			{
				m_strRegPath = m_strFilePath;
				m_strRegProgram = m_strProgram;
				m_strRegCompany = m_strCompany;
				m_strRegVersion = m_strVersion;
				m_strRegAddContent = m_strAddContent;

				UpdateData( FALSE );
				OnButtonMenuRegister();
			}
		}
	}
}

void CPSATDlg::ProcessProgramRegisterAck( KProgramRegisterAck* pPacket ) 
{
	if ( pPacket->m_nResult == 0 ) 
	{
		KMessageBox( " Ǿϴ.", "" );
		KVerificationPacket Packet;
		strncpy ( Packet.m_szProgramKey, (LPSTR)(LPCSTR)m_strProgramKey, m_strProgramKey.GetLength() );

		SendData(  &Packet );
		OnButtonMenuVertification();
	}
	else 
	{
		KMessageBox( "Ͽ  Ͽϴ.", "" );
	}
}
void CPSATDlg::ProcessReportList( KReportListPacket* pPacket )
{
//	TRACE ( "ProcessReportList, %d, %s, %s, %s\n", pPacket->m_nId, pPacket->m_szProgramKey, pPacket->m_szRegisterId, pPacket->m_szContents );
	m_cReportListDlg.GivenReceiveData ( pPacket );
}

void CPSATDlg::ProcessReportRegisterAck( KReportRegisterAck* pPacket )
{
	if ( pPacket->m_nResult == 0 ) 
	{
		KMessageBox( "Ű Ǿϴ.", "Ű" );
		KVerificationPacket Packet;
		strncpy ( Packet.m_szProgramKey, (LPSTR)(LPCSTR)m_strProgramKey, m_strProgramKey.GetLength() );

		SendData(  &Packet );
	}
	else 
	{
		KMessageBox( "Ű  Ͽϴ.", "Ű" );
	}
}

void CPSATDlg::ProcessReportRemoveAck( KReportRemoveAck* pPacket )
{
//	m_cReplyListDlg.ProcessReplyRemoveAck( pPacket->m_nResult );
}

void CPSATDlg::ProcessReplytList( KReplyListPacket* pPacket )
{
	m_cReplyListDlg.GivenReceiveData ( pPacket );

//	TRACE ( "ProcessReplytList, %d, %s, %s, %s\n", pPacket->m_nId, pPacket->m_szProgramKey, pPacket->m_szRegisterId, pPacket->m_szContents );
}
void CPSATDlg::ProcessReplyRegisterAck( KReplyRegisterAck* pPacket )
{
	m_cReplyListDlg.ProcessReplyRegisterAck( pPacket->m_nResult );
}

void CPSATDlg::ProcessReplyRemoveAck( KReplyRemoveAck* pPacket )
{
	m_cReplyListDlg.ProcessReplyRemoveAck( pPacket->m_nResult );
	/*if ( pPacket->m_nResult == 0 ) 
	{
		KMessageBox( "  ߽ϴ.", "" );
	}
	else 
	{
		KMessageBox( " ſ  ߽ϴ.", "" );
	}*/
}

void CPSATDlg::OnClose() 
{
	if ( KMessageBox( "Ͻðٽϱ?", "", MB_YESNO ) == IDOK )
	{
		m_cClientSocket.Disconnect();
		CDialog::OnCancel();
	}
}

void CPSATDlg::ReportRegister( CString strKey, CString strContents ) 
{
	KReportRegisterPacket Packet;
	strncpy ( Packet.m_szProgramKey , (LPSTR)(LPCSTR)strKey , strKey.GetLength() );
	strncpy ( Packet.m_szContents , (LPSTR)(LPCSTR)strContents , strContents.GetLength() );

	SendData ( &Packet );
}

void CPSATDlg::ReportList( CString strKey ) 
{
	KRequestReportPacket Packet;
	strncpy ( Packet.m_szProgramKey , (LPSTR)(LPCSTR)strKey , strKey.GetLength() );

	SendData( &Packet );
}

void CPSATDlg::ReportRemove( unsigned int nId ) 
{
	KReportRemovePacket Packet;
	Packet.m_nId = nId;

	SendData( &Packet );
}

void CPSATDlg::ReplyRegister( CString strKey, CString strContents ) 
{
	KReplyRegisterPacket Packet;
	strncpy ( Packet.m_szProgramKey , (LPSTR)(LPCSTR)strKey , strKey.GetLength() );
	strncpy ( Packet.m_szContents , (LPSTR)(LPCSTR)strContents , strContents.GetLength() );

	SendData( &Packet );
}

void CPSATDlg::ReplyList( CString strKey ) 
{
	KRequestReplyPacket	Packet;
	strncpy ( Packet.m_szProgramKey , (LPSTR)(LPCSTR)strKey , strKey.GetLength() );

	SendData( &Packet );
}

void CPSATDlg::ReplyRemove( unsigned int nId ) 
{
	KReplyRemovePacket Packet;
	Packet.m_nId = nId;

	SendData( &Packet );
}


#define			SET_PACKET(a,b,c)		a = new c;\
										*((c *)a) = *((c *)b);\

void CPSATDlg::SendData ( KPacket* pPacket ) 
{
	if ( m_cClientSocket.IsConnected() )
	{
		m_cClientSocket.SendData ( pPacket );
	}
	else
	{
		if ( m_pWaitPacket )
		{
			KMessageBox ( " ۾ ó߿ ֽϴ.  Ŀ ٽ õ ֽʽÿ.", "" );
			return;
		}
		ConnectServer();

		switch ( pPacket->m_nPacketType )
		{
		case MESSAGE_TYPE_MEMBER_JOIN: 		SET_PACKET ( m_pWaitPacket , pPacket , KJoinMemberPacket )		break;
		case MESSAGE_TYPE_MEMBER_LOGIN:		SET_PACKET ( m_pWaitPacket , pPacket , KLoginPacket )			break;
		case MESSAGE_TYPE_VERIFICATION:		SET_PACKET ( m_pWaitPacket , pPacket , KVerificationPacket )	break;
		case MESSAGE_TYPE_PROGRAM_REGISTER:	SET_PACKET ( m_pWaitPacket , pPacket , KProgramRegisterPacket )	break;
		case MESSAGE_TYPE_REPORT_REQUEST:	SET_PACKET ( m_pWaitPacket , pPacket , KReportRegisterPacket )	break;
		case MESSAGE_TYPE_REPORT_REMOVE:	SET_PACKET ( m_pWaitPacket , pPacket , KReportRemovePacket )	break;
		case MESSAGE_TYPE_REPORT_REGISTER:	SET_PACKET ( m_pWaitPacket , pPacket , KRequestReportPacket )	break;
		case MESSAGE_TYPE_REPLY_REQUEST:	SET_PACKET ( m_pWaitPacket , pPacket , KRequestReplyPacket )	break;
		case MESSAGE_TYPE_REPLY_REGISTER:	SET_PACKET ( m_pWaitPacket , pPacket , KReplyRegisterPacket )	break;
		case MESSAGE_TYPE_REPLY_REMOVE:		SET_PACKET ( m_pWaitPacket , pPacket , KReplyRemovePacket )		break;
		default:
			{
				ASSERT ( FALSE );
			}
		}
	}
}
/*
void CPSATDlg::OnSocketDisconnected() 
{
	m_cClientSocket.Disconnect();
}
*/
void CPSATDlg::OnButtonReport() 
{
	if ( m_strProgramKey.Compare( "" ) == 0 ) 
	{
		KMessageBox("˻  ϴ.", "Ű");
	}
	else
	{
		CRegisterReportDlg dlg; 
		int nResult;
		WINDOWPLACEMENT WindowPlace;
		GetWindowPlacement( &WindowPlace );
		dlg.SetWindowPosition( WindowPlace.rcNormalPosition );
		
		while ( ( nResult = dlg.DoModal() ) == IDOK && dlg.m_strContent == "" ) 
		{
			KMessageBox( "Ű  ϴ.", "Ű" );
		}
		if ( nResult == IDOK ) 
		{
			ReportRegister ( m_strProgramKey, dlg.m_strContent );
		}
	}
}

long CPSATDlg::OnSocketConnected ( WPARAM wParam , LPARAM lParam )
{
	if ( m_bWaitLoginPacket || m_bLogining )
	{
		m_cClientSocket.SendData ( &m_LoginPacket );
		m_bWaitLoginPacket = FALSE;	
	}
	

	return 0;
}

long CPSATDlg::OnSocketDisconnected ( WPARAM wParam , LPARAM lParam )
{
	return 0;
}

BOOL CPSATDlg::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;	
//	return CDialog::OnEraseBkgnd(pDC);
}


void CPSATDlg::OnButtonRegSearchPath() 
{
	int nIndex = m_cbRegFileDirectory.GetCurSel();
	if ( nIndex == 1 ) 
	{
		SearchPathRegDirectory();
	}
	else if ( nIndex == 0 ) 
	{
		SearchPathRegFile();
	}
	m_edtRegPath;
}

void CPSATDlg::KeyMakingDlgMake()
{
	if( !IsWindow( m_cKeyMakingDlg.GetSafeHwnd() ) )
	{
		WINDOWPLACEMENT WindowPlace;
		GetWindowPlacement( &WindowPlace );
		m_cKeyMakingDlg.SetWindowPosition( WindowPlace.rcNormalPosition );

		m_cKeyMakingDlg.SetOwner( this );
		m_cKeyMakingDlg.Create( IDD_KEY_MAKING_DIALOG, GetDesktopWindow() );
		m_cKeyMakingDlg.ShowWindow ( SW_SHOW );
	}
	else
	{
		CWnd* pWnd = m_cKeyMakingDlg.FromHandle( m_cKeyMakingDlg.GetSafeHwnd() );
		pWnd->SetWindowPos( &wndTop , 0 , 0 , 0 , 0 , SWP_NOMOVE | SWP_NOSIZE );
	}
}

void CPSATDlg::KeyMakingDlgDestory()
{
	m_cKeyMakingDlg.DestroyWindow();
}

void CPSATDlg::OnReceivedKeyProgress( WPARAM wParam , LPARAM lParam )
{
	switch ( lParam ) 
	{
	case KEY_MAKING_START : 
		KeyMakingDlgMake();
		m_cKeyMakingDlg.SetDefault();
		break;
	case KEY_MAKING_SET_PATH : 
		m_cKeyMakingDlg.SetCurPath( (char*)wParam );
		break;
	case KEY_MAKING_SET_TOTAL : 
		m_cKeyMakingDlg.SetMaxSize( (unsigned long)wParam );
		break;
	case KEY_MAKING_SET_CUR: 
		m_cKeyMakingDlg.SetCurSize( (unsigned long)wParam );
		break;
	case KEY_MAKING_END : 
		m_cKeyMakingDlg.SetDefault();
		KeyMakingDlgDestory();
		break;
	}
}

void CPSATDlg::OnOtherDlgReceivedData (WPARAM wParam, LPARAM lParam ) 
{
	switch ( lParam ) 
	{
	case 0 :
		{
			KReplyRegisterPacket Packet;
			strncpy ( Packet.m_szProgramKey, (LPSTR)(LPCSTR)m_strProgramKey, m_strProgramKey.GetLength() );
			strncpy ( Packet.m_szContents, (LPSTR)(LPCSTR)m_cReplyListDlg.m_strWriteReply, m_cReplyListDlg.m_strWriteReply.GetLength() );

			SendData( &Packet );
		}
		break;
	case 1:
		{
			KReplyRemovePacket Packet;
			Packet.m_nId = m_cReplyListDlg.m_nRemoveReplyId;
			SendData( &Packet );
		}
		break;
	case 2 : 
		{
			KRequestReplyPacket Packet; 
			strncpy ( Packet.m_szProgramKey, (LPSTR)(LPCSTR)m_strProgramKey, m_strProgramKey.GetLength() );
			SendData ( &Packet );
		}
		break; 
	}

}

void CPSATDlg::OnButtonViewReply() 
{
	WINDOWPLACEMENT WindowPlace;
	GetWindowPlacement( &WindowPlace );
	m_cReplyListDlg.SetWindowPosition( WindowPlace.rcNormalPosition );

	if ( m_strProgramKey != "" ) 
	{
		m_cReplyListDlg.m_strUserId = m_strLoginId;
		m_cReplyListDlg.m_strProgramKey = m_strProgramKey;
		
		KRequestReplyPacket Packet; 
		strncpy ( Packet.m_szProgramKey, (LPSTR)(LPCSTR)m_strProgramKey, m_strProgramKey.GetLength() );
		SendData ( &Packet );

		m_cReplyListDlg.DoModal();
	}
	else
	{
		KMessageBox("˻  ϴ.", "Ű");
	}
}

void CPSATDlg::OnButtonMenuHome() 
{
	if ( m_nSubBackgroundState == SUB_BACKGROUND_STATE_HOME )
	{
		return;
	}

	m_nSubBackgroundState = SUB_BACKGROUND_STATE_HOME;
	SetAllResourceHide();
	m_btnMainMenuHome.SetActive( TRUE );
	m_btnMainMenuRegister.SetActive( FALSE );
	m_btnMainMenuVertification.SetActive( FALSE );
	Invalidate();
}

void CPSATDlg::OnButtonMenuRegister() 
{
	if ( m_nSubBackgroundState == SUB_BACKGROUND_STATE_REGISTER )
	{
		return;
	}
	m_nSubBackgroundState = SUB_BACKGROUND_STATE_REGISTER;

	SetAllResourceHide();
	m_btnReg.ShowWindow(SW_SHOW);
	m_btnRewrite.ShowWindow(SW_SHOW);
	m_edtRegVersion.ShowWindow(SW_SHOW);
	m_edtRegProgram.ShowWindow(SW_SHOW);
	m_edtRegPath.ShowWindow(SW_SHOW);
	m_edtRegCompany.ShowWindow(SW_SHOW);
	m_edtRegAddContent.ShowWindow(SW_SHOW);
	m_btnRegSearchPath.ShowWindow(SW_SHOW);
	m_cbRegFileDirectory.ShowWindow(SW_SHOW);
	m_edtRegProgram.SetFocus();

	m_btnMainMenuHome.SetActive( FALSE );
	m_btnMainMenuRegister.SetActive( TRUE );
	m_btnMainMenuVertification.SetActive( FALSE );
	Invalidate();
}

void CPSATDlg::OnButtonMenuVertification() 
{
	if ( m_nSubBackgroundState == SUB_BACKGROUND_STATE_VERTIFICATION )
	{
		return;
	}

	m_nSubBackgroundState = SUB_BACKGROUND_STATE_VERTIFICATION;
	
	SetAllResourceHide();
	m_btnCheck.ShowWindow(SW_SHOW);
	m_btnReport.ShowWindow(SW_SHOW);
	m_btnViewReply.ShowWindow(SW_SHOW);
	m_btnViewReport.ShowWindow(SW_SHOW);
	m_btnSearchPath.ShowWindow(SW_SHOW);
	m_edtFilePath.ShowWindow(SW_SHOW);
	m_staticGuestState.ShowWindow(SW_SHOW);
	m_staticMemberState.ShowWindow(SW_SHOW);
	m_staticMemberPer.ShowWindow(SW_SHOW);
	m_staticGuestPer.ShowWindow(SW_SHOW);
	m_cbFileDirectory.ShowWindow(SW_SHOW);

	m_btnMainMenuHome.SetActive( FALSE );
	m_btnMainMenuRegister.SetActive( FALSE );
	m_btnMainMenuVertification.SetActive( TRUE );
	Invalidate();
}

void CPSATDlg::OnButtonLogout() 
{
	m_bLogining = FALSE;

	m_bLoginCheck = TRUE;
	m_strLoginId = _T("");
	m_btnLogin.SetWindowText("α");
	
	KLogoutPacket Packet;
	m_cClientSocket.SendData ( &Packet );

	m_btnLogin.ShowWindow(SW_SHOW);
	m_btnLogout.ShowWindow(SW_HIDE);

	m_btnMainMenuVertification.ShowWindow( FALSE );
	m_btnMainMenuRegister.ShowWindow( FALSE );
	OnButtonMenuHome();
	SetAllResourceEmpty();
}

void CPSATDlg::OnButtonExit() 
{
	OnClose();
}


void CPSATDlg::OnButtonMinimam() 
{
	WINDOWPLACEMENT WindowPlace;
	if ( GetWindowPlacement( &WindowPlace ) )
	{
		WindowPlace.showCmd = SW_MINIMIZE;
		SetWindowPlacement ( &WindowPlace );
	}
}


void CPSATDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	if ( m_rtTitleBar.PtInRect( point ) )
	{
		m_pCursor = IDC_SIZEALL;
		HCURSOR hCursor = LoadCursor ( NULL , m_pCursor );
		::SetCursor ( hCursor );
	}

	if ( m_nSubBackgroundState == SUB_BACKGROUND_STATE_VERTIFICATION ) 
	{
		if ( m_rtTooltip.PtInRect( point ) )
		{
			m_pCursor = IDC_HAND;
			HCURSOR hCursor = LoadCursor ( NULL , IDC_HAND );
			::SetCursor ( hCursor );
			
			if ( !m_bTooltipView )
			{
				CPoint pt = point;
				ClientToScreen(&pt);
				CString strTooltip;
				
				strTooltip.Format ( "<hr color=blue /><br><center><font size=16 weight=bold color=#126EE4>   </font></center><p><br><hr color=blue /><br /><font weight=bold>α׷ : </font>%s<br /><font weight=bold>ȸ : </font>%s<br><font weight=bold> : </font>%s<br /><font weight=bold>߰ : </font>%s</p></p><br><hr color=blue />"
					, m_strProgram, m_strCompany, m_strVersion, m_strAddContent );

				m_cTooltip.SetColorBk( RGB( 255, 255, 255 ) ); 
				m_cTooltip.ShowHelpTooltip ( &pt , strTooltip );

			}
			m_bTooltipView = TRUE; 
		}
		else 
		{
			m_cTooltip.HideTooltip(); 
			m_bTooltipView = FALSE; 
		}
	}

	if ( m_nMouseState == MOUSE_STATE_LDOWN )
	{
		if ( !( ( m_ptWindowMove.x == point.x ) && ( m_ptWindowMove.y == point.y ) ) )
		{				
			m_ptWindowPosition.x += ( point.x - m_ptWindowMove.x );
			m_ptWindowPosition.y += ( point.y - m_ptWindowMove.y );
			MoveWindow( m_ptWindowPosition.x, m_ptWindowPosition.y, 600, 420 );
		}
	}

	CDialog::OnMouseMove(nFlags, point);
}

void CPSATDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if ( m_rtTitleBar.PtInRect( point ) )
	{
		m_ptWindowMove.x = point.x;
		m_ptWindowMove.y = point.y;
		m_nMouseState = MOUSE_STATE_LDOWN;
		m_pCursor = IDC_SIZEALL;
		HCURSOR hCursor = LoadCursor ( NULL , m_pCursor );
		::SetCursor ( hCursor );
		SetCapture();
	}	
	CDialog::OnLButtonDown(nFlags, point);
}

void CPSATDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if ( m_nMouseState == MOUSE_STATE_LDOWN ) 
	{
		m_ptWindowPosition.x += ( point.x - m_ptWindowMove.x );
		m_ptWindowPosition.y += ( point.y - m_ptWindowMove.y );
		SetWindowPos( NULL , m_ptWindowPosition.x, m_ptWindowPosition.y, 600, 420, NULL);
		m_nMouseState = MOUSE_STATE_NULL;
		m_ptWindowMove.x = 0;
		m_ptWindowMove.y = 0;
		ReleaseCapture();
	}

	CDialog::OnLButtonUp(nFlags, point);
}

void CPSATDlg::OnTimer(UINT nIDEvent) 
{
	WINDOWPLACEMENT WindowPlace;

	switch ( nIDEvent ) 
	{
	case WINDOW_POSITION_SET : 
		GetWindowPlacement( &WindowPlace );
		m_ptWindowPosition.x = WindowPlace.rcNormalPosition.left;
		m_ptWindowPosition.y = WindowPlace.rcNormalPosition.top; 
		KillTimer( WINDOW_POSITION_SET );
		break;
	}
	
	CDialog::OnTimer(nIDEvent);
}

int	CPSATDlg::KMessageBox( CString strMessage, CString strTitle, UINT nType )
{
	KMessageBoxDlg dlg;
	CPoint ptPosition; 
	WINDOWPLACEMENT WindowPlace;
	GetWindowPlacement( &WindowPlace );
	ptPosition.x = ( WindowPlace.rcNormalPosition.left + WindowPlace.rcNormalPosition.right ) / 2 - 127;
	ptPosition.y = ( WindowPlace.rcNormalPosition.top + WindowPlace.rcNormalPosition.bottom ) / 2 - 62;

	dlg.SetWindowPosition( ptPosition );
	dlg.SetData( strMessage, strTitle, nType );

	return dlg.DoModal();
}

void CPSATDlg::OnButtonInfo() 
{
	CInfomationDlg dlg;
	WINDOWPLACEMENT WindowPlace;
	GetWindowPlacement( &WindowPlace );
	dlg.SetWindowPosition( WindowPlace.rcNormalPosition );

	dlg.DoModal();
}

void CPSATDlg::OnButtonViewReport() 
{
	WINDOWPLACEMENT WindowPlace;
	GetWindowPlacement( &WindowPlace );
	m_cReportListDlg.SetWindowPosition( WindowPlace.rcNormalPosition );

	if ( m_strProgramKey != "" ) 
	{
		KRequestReportPacket Packet; 
		strncpy ( Packet.m_szProgramKey, (LPSTR)(LPCSTR)m_strProgramKey, m_strProgramKey.GetLength() );
		SendData ( &Packet );

		m_cReportListDlg.DoModal();
	}
	else
	{
		KMessageBox("˻  ϴ.", "Ű");
	}
}

int CPSATDlg::MyRound( double i )
{
	return floor ( i + 0.5 );
}

BOOL CPSATDlg::PreTranslateMessage(MSG* pMsg) 
{
	m_cTooltip.RelayEvent( pMsg );
	
	return CDialog::PreTranslateMessage(pMsg);
}


HBRUSH CPSATDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	if ( nCtlColor == CTLCOLOR_STATIC ) 
	{
		pDC->SetBkMode ( TRANSPARENT );
		return (HBRUSH)(::GetStockObject( NULL_BRUSH ));
	}
	// TODO: Return a different brush if the default is not desired
	return hbr;
}
